/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHBlock;
import bsh.BSHFormalParameters;
import bsh.BSHReturnType;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.UtilEvalError;

class BSHMethodDeclaration
extends SimpleNode {
    public String name;
    BSHReturnType returnTypeNode;
    BSHFormalParameters paramsNode;
    BSHBlock blockNode;
    int firstThrowsClause;
    public Modifiers modifiers;
    Class returnType;
    int numThrows = 0;

    BSHMethodDeclaration(int n) {
        super(n);
    }

    synchronized void insureNodesParsed() {
        if (this.paramsNode != null) {
            return;
        }
        Node node = this.jjtGetChild(0);
        this.firstThrowsClause = 1;
        if (node instanceof BSHReturnType) {
            this.returnTypeNode = (BSHReturnType)node;
            this.paramsNode = (BSHFormalParameters)this.jjtGetChild(1);
            if (this.jjtGetNumChildren() > 2 + this.numThrows) {
                this.blockNode = (BSHBlock)this.jjtGetChild(2 + this.numThrows);
            }
            ++this.firstThrowsClause;
        } else {
            this.paramsNode = (BSHFormalParameters)this.jjtGetChild(0);
            this.blockNode = (BSHBlock)this.jjtGetChild(1 + this.numThrows);
        }
    }

    Class evalReturnType(CallStack callStack, Interpreter interpreter) throws EvalError {
        this.insureNodesParsed();
        if (this.returnTypeNode != null) {
            return this.returnTypeNode.evalReturnType(callStack, interpreter);
        }
        return null;
    }

    String getReturnTypeDescriptor(CallStack callStack, Interpreter interpreter, String string) {
        this.insureNodesParsed();
        if (this.returnTypeNode == null) {
            return null;
        }
        return this.returnTypeNode.getTypeDescriptor(callStack, interpreter, string);
    }

    BSHReturnType getReturnTypeNode() {
        this.insureNodesParsed();
        return this.returnTypeNode;
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        this.returnType = this.evalReturnType(callStack, interpreter);
        this.evalNodes(callStack, interpreter);
        NameSpace nameSpace = callStack.top();
        BshMethod bshMethod = new BshMethod(this, nameSpace, this.modifiers);
        try {
            nameSpace.setMethod(this.name, bshMethod);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
        return Primitive.VOID;
    }

    private void evalNodes(CallStack callStack, Interpreter interpreter) throws EvalError {
        int n;
        this.insureNodesParsed();
        for (n = this.firstThrowsClause; n < this.numThrows + this.firstThrowsClause; ++n) {
            ((BSHAmbiguousName)this.jjtGetChild(n)).toClass(callStack, interpreter);
        }
        this.paramsNode.eval(callStack, interpreter);
        if (interpreter.getStrictJava()) {
            for (n = 0; n < this.paramsNode.paramTypes.length; ++n) {
                if (this.paramsNode.paramTypes[n] != null) continue;
                throw new EvalError("(Strict Java Mode) Undeclared argument type, parameter: " + this.paramsNode.getParamNames()[n] + " in method: " + this.name, this, null);
            }
            if (this.returnType == null) {
                throw new EvalError("(Strict Java Mode) Undeclared return type for method: " + this.name, this, null);
            }
        }
    }

    public String toString() {
        return "MethodDeclaration: " + this.name;
    }
}

