/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import virtuoso.javax.OPLMessage_x;

public abstract class BaseRowSet
implements RowSet,
Serializable {
    private static final long serialVersionUID = 5374661472998522423L;
    protected static final int ev_CursorMoved = 1;
    protected static final int ev_RowChanged = 2;
    protected static final int ev_RowSetChanged = 3;
    private String command;
    private String url;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rsType = 1004;
    private int rsConcurrency = 1008;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private boolean readOnly = true;
    private boolean escapeProcessing = true;
    private int txn_isolation = 2;
    private int fetchDir = 1000;
    private int fetchSize = 0;
    protected Map<String, Class<?>> map = null;
    private LinkedList<RowSetListener> listeners = new LinkedList();
    private ArrayList<Parameter> params = new ArrayList();

    @Override
    public void close() throws SQLException {
        this.clearParameters();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRowSetListener(RowSetListener rowSetListener) {
        LinkedList<RowSetListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(rowSetListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRowSetListener(RowSetListener rowSetListener) {
        LinkedList<RowSetListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(rowSetListener);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSource;
    }

    @Override
    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public Object[] getParams() throws SQLException {
        return this.params.toArray();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public int getTransactionIsolation() {
        return this.txn_isolation;
    }

    @Override
    public int getType() throws SQLException {
        return this.rsType;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.map;
    }

    @Override
    public String getUrl() throws SQLException {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setArray(int n, Array array) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = array;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = inputStream;
        parameter.jType = 3;
        parameter.length = n2;
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = bigDecimal;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = inputStream;
        parameter.jType = 4;
        parameter.length = n2;
    }

    @Override
    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = blob;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = inputStream;
        parameter.jType = 4;
        parameter.length = (int)l;
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBlob(parameterIndex, inputStream)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBlob(parameterName, inputStream, length)");
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBlob (parameterName, x)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBlob(parameterName, inputStream)");
    }

    @Override
    public synchronized void setClob(int n, Reader reader, long l) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = reader;
        parameter.jType = 6;
        parameter.length = (int)l;
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setClob(parameterIndex, reader)");
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setClob(parameterName, reader, length)");
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setClob (String parameterName, Clob x)");
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setClob(parameterName, reader)");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setSQLXML(parameterIndex, xmlObject)");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setSQLXML(parameterName, xmlObject)");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setRowId(parameterIndex, x)");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setRowId(parameterName, x)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.setString(n, string);
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNString(parameterName, value)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, (int)l);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNCharacterStream(parameterName, value, length)");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNCharacterStream(parameterName, value)");
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNClob(parameterName, value)");
    }

    @Override
    public synchronized void setNClob(String string, Reader reader, long l) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNClob(parameterName, value)");
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNClob(parameterName, reader)");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = reader;
        parameter.jType = 6;
        parameter.length = (int)l;
    }

    @Override
    public synchronized void setNClob(int n, NClob nClob) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = nClob;
        parameter.jType = 0;
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNClob(parameterIndex, reader)");
    }

    @Override
    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Boolean(bl);
        parameter.jType = 0;
    }

    @Override
    public synchronized void setByte(int n, byte by) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Byte(by);
        parameter.jType = 0;
    }

    @Override
    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = byArray;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = reader;
        parameter.jType = 6;
        parameter.length = n2;
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setAsciiStream(parameterIndex, x)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setAsciiStream(parameterName, x)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBinaryStream(parameterIndex, x)");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBinaryStream(parameterName, x)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setCharacterStream(parameterIndex, reader)");
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setCharacterStream(parameterName, reader)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNCharacterStream(parameterIndex, value)");
    }

    @Override
    public synchronized void setClob(int n, Clob clob) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = clob;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setDate(int n, Date date) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = date;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = date;
        parameter.jType = 7;
        parameter.cal = calendar;
    }

    @Override
    public synchronized void setDouble(int n, double d) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Double(d);
        parameter.jType = 0;
    }

    @Override
    public synchronized void setFloat(int n, float f) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Float(f);
        parameter.jType = 0;
    }

    @Override
    public synchronized void setInt(int n, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Integer(n2);
        parameter.jType = 0;
    }

    @Override
    public synchronized void setLong(int n, long l) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Long(l);
        parameter.jType = 0;
    }

    @Override
    public synchronized void setRef(int n, Ref ref) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = ref;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setShort(int n, short s) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = new Short(s);
        parameter.jType = 0;
    }

    @Override
    public synchronized void setString(int n, String string) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = string;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setURL(int n, URL uRL) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = uRL;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setTime(int n, Time time) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = time;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = time;
        parameter.jType = 8;
        parameter.cal = calendar;
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = timestamp;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = timestamp;
        parameter.jType = 0;
        parameter.cal = calendar;
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = inputStream;
        parameter.jType = 5;
        parameter.length = n2;
    }

    @Override
    public synchronized void setNull(int n, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = null;
        parameter.jType = 10;
        parameter.sqlType = n2;
    }

    @Override
    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = null;
        parameter.jType = 11;
        parameter.sqlType = n2;
        parameter.typeName = string;
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = object;
        parameter.jType = 0;
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = object;
        parameter.jType = 0;
        parameter.sqlType = n2;
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        Parameter parameter = this.getParam(n);
        parameter.value = object;
        parameter.jType = 0;
        parameter.sqlType = n2;
        parameter.scale = n3;
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNull(parameterName, sqlType)");
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setNull (parameterName, sqlType, typeName)");
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBoolean(parameterName, x)");
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setByte(parameterName, x)");
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setShort(parameterName, x)");
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setInt(parameterName, x)");
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setLong(parameterName, x)");
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setFloat(parameterName, x)");
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setDouble(parameterName, x)");
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBigDecimal(parameterName, x)");
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setString(parameterName, x)");
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBytes(parameterName, x[])");
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setTimestamp(parameterName, x)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setAsciiStream(parameterName, x, length)");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setBinaryStream(parameterName, x, length)");
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setCharacterStream(parameterName, reader, length)");
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setObject(parameterName, x, targetSqlType, scale)");
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setObject(parameterName, x, targetSqlType)");
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setObject(parameterName, x)");
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setDate(parameterName, x)");
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setDate(parameterName, x, cal)");
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setTime(parameterName, x)");
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setTime(parameterName, x, cal)");
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw OPLMessage_x.makeFExceptionV(35, "setTimestamp(parameterName, x, cal)");
    }

    @Override
    public synchronized void setCommand(String string) throws SQLException {
        this.command = new String(string);
        this.params.clear();
    }

    @Override
    public void setConcurrency(int n) throws SQLException {
        this.rsConcurrency = n;
    }

    @Override
    public void setDataSourceName(String string) throws SQLException {
        this.dataSource = string != null ? new String(string) : null;
        this.url = null;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.fetchDir = n;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    @Override
    public void setPassword(String string) throws SQLException {
        this.password = string != null ? new String(string) : null;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.txn_isolation = n;
    }

    @Override
    public void setType(int n) throws SQLException {
        this.rsType = n;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.map = map;
    }

    @Override
    public void setUrl(String string) throws SQLException {
        this.url = string != null ? new String(string) : null;
        this.dataSource = null;
    }

    @Override
    public void setUsername(String string) throws SQLException {
        this.username = string != null ? new String(string) : null;
    }

    protected void notifyListener(int n) {
        if (!this.listeners.isEmpty()) {
            LinkedList linkedList = (LinkedList)this.listeners.clone();
            RowSetEvent rowSetEvent = new RowSetEvent(this);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                switch (n) {
                    case 1: {
                        ((RowSetListener)iterator.next()).cursorMoved(rowSetEvent);
                        break;
                    }
                    case 2: {
                        ((RowSetListener)iterator.next()).rowChanged(rowSetEvent);
                        break;
                    }
                    case 3: {
                        ((RowSetListener)iterator.next()).rowSetChanged(rowSetEvent);
                    }
                }
            }
            linkedList.clear();
        }
    }

    protected Parameter getParam(int n) throws SQLException {
        if (n < 1) {
            throw OPLMessage_x.makeExceptionV(12, String.valueOf(n));
        }
        int n2 = this.params.size();
        if (--n < n2) {
            return this.params.get(n);
        }
        while (n2 < n) {
            this.params.add(new Parameter());
            ++n2;
        }
        Parameter parameter = new Parameter();
        this.params.add(parameter);
        return parameter;
    }

    protected class Parameter {
        protected Object value;
        protected int sqlType = 12;
        protected String typeName;
        protected int scale;
        protected int length;
        protected Calendar cal;
        protected int jType = 0;
        protected static final int jObject = 0;
        protected static final int jObject_1 = 1;
        protected static final int jObject_2 = 2;
        protected static final int jAsciiStream = 3;
        protected static final int jBinaryStream = 4;
        protected static final int jUnicodeStream = 5;
        protected static final int jCharacterStream = 6;
        protected static final int jDateWithCalendar = 7;
        protected static final int jTimeWithCalendar = 8;
        protected static final int jTimestampWithCalendar = 9;
        protected static final int jNull_1 = 10;
        protected static final int jNull_2 = 11;

        protected Parameter() {
        }
    }
}

