;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; msp430 include file generated by make_include.py
;; part of the naken430asm msp430 assembler
;;
;; Generated by: agrikolaPIRgmxARRde
;;   Input File: naken430asm-include_msp430x14x.txt
;;         Date: 2011-08-14 22:18
;;        Parts: msp430x13x, msp430x14x, msp430x14x1
;;               (according to SLAS272F.pdf)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Watchdog - Word Access

WDTCTL equ 0x0120         ; Watchdog Timer control
WDTPW    equ 0x5a00    ; WDT password
WDTHOLD  equ 0x0080    ; WDT hold
WDTNMIES equ 0x0040    ; WDT NMI edge select
WDTNMI   equ 0x0020    ; WDT NMI select
WDTTMSEL equ 0x0010    ; WDT mode select
WDTCNTCL equ 0x0008    ; WDT counter clear
WDTSSEL  equ 0x0004    ; WDT clock source select
WDTIS0   equ 0x0000    ; WDTSSEL / 32768
WDTIS1   equ 0x0001    ; WDTSSEL / 8192
WDTIS2   equ 0x0002    ; WDTSSEL / 512
WDTIS3   equ 0x0003    ; WDTSSEL / 64

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Timer_B7/Timer_B3 - Word Access

TBIV equ 0x011e           ; Timer_B interrupt vector
TBCTL equ 0x0180          ; Timer_B control
TBCCTL0 equ 0x0182        ; Capture/compare control 0
TBCCTL1 equ 0x0184        ; Capture/compare control 1
TBCCTL2 equ 0x0186        ; Capture/compare control 2
TBCCTL3 equ 0x0188        ; Capture/compare control 3
TBCCTL4 equ 0x018a        ; Capture/compare control 4
TBCCTL5 equ 0x018c        ; Capture/compare control 5
TBCCTL6 equ 0x018e        ; Capture/compare control 6
TBR equ 0x0190            ; Timer_B register
TBCCR0 equ 0x0192         ; Capture/compare register 0
TBCCR1 equ 0x0194         ; Capture/compare register 1
TBCCR2 equ 0x0196         ; Capture/compare register 2
TBCCR3 equ 0x0198         ; Capture/compare register 3
TBCCR4 equ 0x019a         ; Capture/compare register 4
TBCCR5 equ 0x019c         ; Capture/compare register 5
TBCCR6 equ 0x019e         ; Capture/compare register 6

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Timer_A3  - Word Access

TACCR2 equ 0x0176         ; Capture/compare register 2
TACCR1 equ 0x0174         ; Capture/compare register 1
TACCR0 equ 0x0172         ; Capture/compare register 0

TAR equ 0x0170            ; Timer_A register

TACCTL2 equ 0x0166        ; Capture/compare control 2
TACCTL1 equ 0x0164        ; Capture/compare control 1
TACCTL0 equ 0x0162        ; Capture/compare control 0
CM_3     equ 0xC000    ; Capture on both
CM_2     equ 0x8000    ; Capture on falling edge
CM_1     equ 0x4000    ; Capture on rising edge
CM_0     equ 0x0000    ; No capture
CCIS_3   equ 0x3000    ; Capture/compare input select Vcc
CCIS_2   equ 0x2000    ; Capture/compare input select GND
CCIS_1   equ 0x1000    ; Capture/compare input select CCIxB
CCIS_0   equ 0x0000    ; Capture/compare input select CCIxA
SCS      equ 0x0800    ; Synchronous capture
SCCI     equ 0x0400    ; Synchronized capture/compare input
CAP      equ 0x01000   ; Capture mode
OUTMOD_7 equ 0x00E0    ; Reset/set
OUTMOD_6 equ 0x00C0    ; Toggle/set
OUTMOD_5 equ 0x00A0    ; Reset
OUTMOD_4 equ 0x0080    ; Toggle
OUTMOD_3 equ 0x0060    ; Set/reset
OUTMOD_2 equ 0x0040    ; Toggle/reset
OUTMOD_1 equ 0x0020    ; Set
OUTMOD_0 equ 0x0000    ; OUT bit value
CCIE     equ 0x0010    ; Capture/compare interrupt enable 
CCI      equ 0x0008    ; Capture/compare input
OUT      equ 0x0004    ; Output high
COV      equ 0x0002    ; Capture overflow occurred
CCIFG    equ 0x0001    ; Capture/compare interrupt flag

TACTL equ 0x0160          ; Timer_A control
TASSEL_3 equ 0x0300    ; INCLK
TASSEL_2 equ 0x0200    ; SMCLK
TASSEL_1 equ 0x0100    ; ACLK
TASSEL_0 equ 0x0000    ; TACLK
ID_3     equ 0x00C0    ; CLK / 8
ID_2     equ 0x0080    ; CLK / 4
ID_1     equ 0x0040    ; CLK / 2
ID_0     equ 0x0000    ; CLK / 1
MC_3     equ 0x0030    ; Up/down mode
MC_2     equ 0x0020    ; Continuous mode
MC_1     equ 0x0010    ; Up mode
MC_0     equ 0x0000    ; Stop mode
TACLR    equ 0x0004    ; Timer_A clear
TAIE     equ 0x0002    ; Timer_A interrupt enable
TAIFG    equ 0x0001    ; Timer_A interrupt flag

TAIV equ 0x012e           ; Timer_A interrupt vector
TAIV_2   equ 0x02      ; Capture/compare 1
TAIV_4   equ 0x04      ; Capture/compare 2
TAIV_a   equ 0x0a      ; Timer overflow

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Hardware Multiplier  - Word Access

SUMEXT equ 0x013e         ; Sum extend
RESHI equ 0x013c          ; Result high word
RESLO equ 0x013a          ; Result low word
OP2 equ 0x0138            ; Second operand
MACS equ 0x0136           ; Multiply signed +accumulate/operand1
MAC equ 0x0134            ; Multiply+accumulate/operand1
MPYS equ 0x0132           ; Multiply signed/operand1
MPY equ 0x0130            ; Multiply unsigned/operand1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Flash  - Word Access

FCTL3 equ 0x012c          ; Flash control 3
FCTL2 equ 0x012a          ; Flash control 2
FCTL1 equ 0x0128          ; Flash control 1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ADC12  - Word Access

ADC12MEM15 equ 0x015e     ; Conversion memory 15
ADC12MEM14 equ 0x015c     ; Conversion memory 14
ADC12MEM13 equ 0x015a     ; Conversion memory 13
ADC12MEM12 equ 0x0158     ; Conversion memory 12
ADC12MEM11 equ 0x0156     ; Conversion memory 11
ADC12MEM10 equ 0x0154     ; Conversion memory 10
ADC12MEM9 equ 0x0152      ; Conversion memory 9
ADC12MEM8 equ 0x0150      ; Conversion memory 8
ADC12MEM7 equ 0x014e      ; Conversion memory 7
ADC12MEM6 equ 0x014c      ; Conversion memory 6
ADC12MEM5 equ 0x014a      ; Conversion memory 5
ADC12MEM4 equ 0x0148      ; Conversion memory 4
ADC12MEM3 equ 0x0146      ; Conversion memory 3
ADC12MEM2 equ 0x0144      ; Conversion memory 2
ADC12MEM1 equ 0x0142      ; Conversion memory 1
ADC12MEM0 equ 0x0140      ; Conversion memory 0
ADC12IV equ 0x01a8        ; Interrupt-vector-word register
ADC12IE equ 0x01a6        ; Inerrupt-enable register
ADC12IFG equ 0x01a4       ; Inerrupt-flag register
ADC12CTL1 equ 0x01a2      ; Control register 1
ADC12CTL0 equ 0x01a0      ; Control register 0
ADC12MCTL15 equ 0x008f    ; ADC memory-control register15
ADC12MCTL14 equ 0x008e    ; ADC memory-control register14
ADC12MCTL13 equ 0x008d    ; ADC memory-control register13
ADC12MCTL12 equ 0x008c    ; ADC memory-control register12
ADC12MCTL11 equ 0x008b    ; ADC memory-control register11
ADC12MCTL10 equ 0x008a    ; ADC memory-control register10
ADC12MCTL9 equ 0x0089     ; ADC memory-control register9
ADC12MCTL8 equ 0x0088     ; ADC memory-control register8
ADC12MCTL7 equ 0x0087     ; ADC memory-control register7
ADC12MCTL6 equ 0x0086     ; ADC memory-control register6
ADC12MCTL5 equ 0x0085     ; ADC memory-control register5
ADC12MCTL4 equ 0x0084     ; ADC memory-control register4
ADC12MCTL3 equ 0x0083     ; ADC memory-control register3
ADC12MCTL2 equ 0x0082     ; ADC memory-control register2
ADC12MCTL1 equ 0x0081     ; ADC memory-control register1
ADC12MCTL0 equ 0x0080     ; ADC memory-control register0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; USART1 - Byte Access

U1TXBUF equ 0x007f        ; Transmit buffer
U1RXBUF equ 0x007e        ; Receive buffer
U1BR1 equ 0x007d          ; Baud rate
U1BR0 equ 0x007c          ; Baud rate
U1MCTL equ 0x007b         ; Modulation control
U1RCTL equ 0x007a         ; Receive control
U1TCTL equ 0x0079         ; Transmit control
U1CTL equ 0x0078          ; USART control

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; USART0  - Byte Access

U0TXBUF equ 0x0077        ; Transmit buffer
U0RXBUF equ 0x0076        ; Receive buffer
U0BR1 equ 0x0075          ; Baud rate
U0BR0 equ 0x0074          ; Baud rate
U0MCTL equ 0x0073         ; Modulation control
U0RCTL equ 0x0072         ; Receive control
U0TCTL equ 0x0071         ; Transmit control
U0CTL equ 0x0070          ; USART control

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Comparator_A - Byte Access

CAPD equ 0x005b           ; Comparator_A port disable
CAPD_7   equ 0x80      ; Comparator_A port disable
CAPD_6   equ 0x40
CAPD_5   equ 0x20
CAPD_4   equ 0x10
CAPD_3   equ 0x08
CAPD_2   equ 0x04
CAPD_1   equ 0x02
CAPD_0   equ 0x01

CACTL2 equ 0x005a         ; Comparator_A control2
P2CA1    equ 0x08      ; The pin is connected to CA1
P2CA0    equ 0x04      ; The pin is connected to CA0
CAF      equ 0x02      ; Comparator_A output is filtered

CACTL1 equ 0x0059         ; Comparator_A control1
CAEX     equ 0x80      ; Comparator_A exchange
CARSEL   equ 0x40      ; Comparator_A reference select
CAREF_3  equ 0x30      ; Diode reference
CAREF_2  equ 0x20      ; 0.5 * Vcc
CAREF_1  equ 0x10      ; 0.25 * Vcc
CAREF_0  equ 0x00      ; Internal reference off
CAON     equ 0x08      ; Comparator_A on
CAIES    equ 0x04      ; Comparator_A interrupt edge select
CAIE     equ 0x02      ; Comparator_A interrupt enable
CAIFG    equ 0x01      ; The Comparator_A interrupt flag

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Basic Clock - Byte Access

BCSCTL2 equ 0x0058        ; Basic clock system control2
SELM_3   equ 0xc0      ; MCLK is LFX1CLK
SELM_2   equ 0x80      ; MCLK is XT2CLK if present, otherwise LFXT1CLK
SELM_1   equ 0x40      ; MCLK is DCOCLK
SELM_0   equ 0x00      ; MCLK is DCOCLK
DIVM_3   equ 0x30      ; /8 for MCLK
DIVM_2   equ 0x20      ; /4 for MCLK
DIVM_1   equ 0x10      ; /2 for MCLK
DIVM_0   equ 0x00      ; /1 for MCLK
SELS     equ 0x08      ; XT2CLK if present, otherwise LFX1CLK
DIVS_3   equ 0x06      ; /8 for SMCLK
DIVS_2   equ 0x04      ; /4 for SMCLK
DIVS_1   equ 0x02      ; /2 for SMCLK
DIVS_0   equ 0x00      ; /1 for SMCLK
DCOR     equ 0x01      ; external resistor

BCSCTL1 equ 0x0057        ; Basic clock system control1
XT2OFF   equ 0x80      ; turn off XT2 oscillator
XTS      equ 0x40      ; high freq mode
DIVA_3   equ 0x30      ; /8 for ACLK
DIVA_2   equ 0x20      ; /4 for ACLK
DIVA_1   equ 0x10      ; /2 for ACLK
DIVA_0   equ 0x00      ; /1 for ACLK
RSEL_7   equ 0x07      ; internal Resistor select
RSEL_6   equ 0x06
RSEL_5   equ 0x05
RSEL_4   equ 0x04
RSEL_3   equ 0x03
RSEL_2   equ 0x02
RSEL_1   equ 0x01
RSEL_0   equ 0x00

DCOCTL equ 0x0056         ; DCO clock frequency control
DCO_7    equ 0xe0      ; DCO frequencie select
DCO_6    equ 0xc0
DCO_5    equ 0xa0
DCO_4    equ 0x80
DCO_3    equ 0x60
DCO_2    equ 0x40
DCO_1    equ 0x20
DCO_0    equ 0x00
MOD_31   equ 0x1f      ; Modulator selection
MOD_30   equ 0x1e
MOD_29   equ 0x1d
MOD_28   equ 0x1c
MOD_27   equ 0x1b
MOD_26   equ 0x1a
MOD_25   equ 0x19
MOD_24   equ 0x18
MOD_23   equ 0x17
MOD_22   equ 0x16
MOD_21   equ 0x15
MOD_20   equ 0x14
MOD_19   equ 0x13
MOD_18   equ 0x12
MOD_17   equ 0x11
MOD_16   equ 0x10
MOD_15   equ 0x0f
MOD_14   equ 0x0e
MOD_13   equ 0x0d
MOD_12   equ 0x0c
MOD_11   equ 0x0b
MOD_10   equ 0x0a
MOD_9    equ 0x09
MOD_8    equ 0x08
MOD_7    equ 0x07
MOD_6    equ 0x06
MOD_5    equ 0x05
MOD_4    equ 0x04
MOD_3    equ 0x03
MOD_2    equ 0x02
MOD_1    equ 0x01
MOD_0    equ 0x00

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Port P6 - Byte Access

P6SEL equ 0x0037          ; Port P6 selection
P6DIR equ 0x0036          ; Port P6 direction
P6OUT equ 0x0035          ; Port P6 output
P6IN equ 0x0034           ; Port P6 input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Port P5 - Byte Access

P5SEL equ 0x0033          ; Port P5 selection
P5DIR equ 0x0032          ; Port P5 direction
P5OUT equ 0x0031          ; Port P5 output
P5IN equ 0x0030           ; Port P5 input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Port P4 - Byte Access

P4SEL equ 0x001f          ; Port P4 selection
P4DIR equ 0x001e          ; Port P4 direction
P4OUT equ 0x001d          ; Port P4 output
P4IN equ 0x001c           ; Port P4 input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Port P3 - Byte Access

P3SEL equ 0x001b          ; Port P3 selection
P3DIR equ 0x001a          ; Port P3 direction
P3OUT equ 0x0019          ; Port P3 output
P3IN equ 0x0018           ; Port P3 input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Port P2 - Byte Access

P2SEL equ 0x002e          ; Port P2 selection
P2IE equ 0x002d           ; Port P2 interrupt enable
P2IES equ 0x002c          ; Port P2 interrupt-edge select
P2IFG equ 0x002b          ; Port P2 interrupt flag
P2DIR equ 0x002a          ; Port P2 direction
P2OUT equ 0x0029          ; Port P2 output
P2IN equ 0x0028           ; Port P2 input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Port P1 - Byte Access

P1SEL equ 0x0026          ; Port P1 selection
P1IE equ 0x0025           ; Port P1 interrupt enable
P1IES equ 0x0024          ; Port P1 interrupt-edge select
P1IFG equ 0x0023          ; Port P1 interrupt flag
P1DIR equ 0x0022          ; Port P1 direction
P1OUT equ 0x0021          ; Port P1 output
P1IN equ 0x0020           ; Port P1 input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Special Functions - Word Access

ME2 equ 0x0005            ; SFR module enable 2
USPIE1   equ 0x20      ; USART1: SPI transmit and receive enable
URXE1    equ 0x10      ; USART1: UART receive enable
UTXE1    equ 0x10      ; USART1: UART transmit enable

ME1 equ 0x0004            ; SFR module enable 1
USPIE0   equ 0x80      ; USART0: SPI transmit and receive enable
URXE0    equ 0x40      ; USART0: UART receive enable
UTXE0    equ 0x40      ; USART0: UART transmit enable

IFG2 equ 0x0003           ; SFR interrupt flag2
UTXIFG1  equ 0x20      ; USART1: UART and SPI transmit flag
URXIFG1  equ 0x10      ; USART1: UART and SPI receive flag

IFG1 equ 0x0002           ; SFR interrupt flag1
UTXIFG0  equ 0x80      ; USART0: UART and SPI transmit flag
URXIFG0  equ 0x40      ; USART0: UART and SPI receive flag
NMIFG    equ 0x10      ; Non-maskable interupt flag
OFIFG    equ 0x02      ; Flag set on oscillator fault
WDTIFG   equ 0x01      ; WDT interrupt flag

IE2 equ 0x0001            ; SFR interrupt enable2
UTXIE1   equ 0x20      ; USART1: UART and SPI transmit-interrupt enable
URXIE1   equ 0x10      ; USART1: UART and SPI receive-interrupt enable

IE1 equ 0x0000            ; SFR interrupt enable1
UTXIE0   equ 0x80      ; USART0: UART and SPI transmit-interrupt enable
URXIE0   equ 0x40      ; USART0: UART and SPI receive-interrupt enable
ACCVIE   equ 0x20      ; Flash access violation interrupt enable
NMIIE    equ 0x10      ; Non-maskable interupt enable
OFIE     equ 0x02      ; OSC fault interrupt enable
WDTIE    equ 0x01      ; WDT interrup enable

                          ; SR Status register
SCG1     equ 0x0080    ; System clock generator 1 (turn off SMCLK)
SCG0     equ 0x0040    ; System clock generator 0 (turn off DCO)
OSCOFF   equ 0x0020    ; Oscillator Off (LFXT1)
CPUOFF   equ 0x0010    ; CPU off
GIE      equ 0x0008    ; General interrupt enable
N        equ 0x0004    ; Negative bit
Z        equ 0x0002    ; Zero bit
C        equ 0x0001    ; Carry bit
V        equ 0x0100    ; Overflow bit
