/**
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
**
* Map of Argentina
*
* @author eldie
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps : {
				argentina : {
					width : 1600, 
					height : 2500,
					getCoords: function(lat,lon){ 
						var xfactor = 59.66752357;
						var xoffset = 4545.874983;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -67.84481668;
						var yoffset = -1431.931678;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
						"tierradelfuego":"m 466.03125,2150.25 c -0.43311,5.4175 0.32375,48.7221 -0.0625,49.25 0.12109,0.5244 0.1875,38.8125 0.1875,38.8125 -0.41748,2.5532 -0.20508,16.5195 -0.21875,19.2187 -0.0659,12.9172 -0.31982,25.9146 -0.1875,38.8438 0.28711,0.1733 0.56494,0.3149 0.78125,0.5 0.61573,0.5254 0.84473,1.351 1.4375,1.8438 2.79786,2.3233 8.08203,1.0209 11.40625,0.5 0.92285,-0.145 3.34424,0.2802 3.875,-0.2188 1.00098,-0.9424 0.0415,-1.709 0.375,-2.75 l 0.1875,-0.1875 c 0.40185,-0.4036 1.10303,-0.3149 1.5625,-0.062 0.72412,0.3975 1.33643,1.0927 2.09375,1.4375 1.34912,0.6142 3.21289,0.2119 4.6875,0.4687 2.86719,0.5 5.33594,1.6187 8.125,2.25 1.63526,0.3705 3.3374,0.2125 5,0.4063 1.9043,0.2222 3.78809,0.622 5.6875,0.875 1.34375,0.18 2.69727,-0.031 4.03125,0.125 1.49267,0.1738 3.03467,0.6109 4.53125,0.6563 1.87549,0.056 3.99609,-0.017 5.84375,-0.3438 1.28369,-0.227 2.52051,-0.6597 3.84375,-0.7188 2.14551,-0.096 4.04834,1.0953 6.0625,1.1563 1.80908,0.055 3.61914,-0.2415 5.4375,-0.1875 2.42627,0.073 4.65967,0.7225 7.03125,0.9062 1.34082,0.1042 2.68555,-0.1347 4.03125,-0.094 1.88721,0.057 7.47705,0.4639 9.1875,0.7813 1.48584,0.2752 3.29687,1.8881 4.65625,2 2.57764,0.2111 4.8584,-0.4577 7.4375,0.4374 1.60108,0.5562 3.83643,1.5899 5.15625,2.6563 0.73584,0.5943 1.26855,1.3608 2.03125,1.9375 2.47509,1.873 9.64551,2.4278 12.78125,2.625 5.1919,0.3272 2.32666,-4.543 6.28125,-4.7188 8.4502,-0.3739 11.08838,1.5694 20,-1.7812 1.35254,-0.5083 2.13867,-1.8149 3.46875,-2.4062 l 0.25,-0.3126 c -0.2876,-0.3886 -0.8447,-0.7558 -0.875,-1.2812 0.76075,-0.2587 1.56787,0.149 2.34375,0.125 0.95019,-0.03 1.87158,-0.5613 2.78125,-0.5312 0.93652,0.031 1.92871,0.3622 2.875,0.4062 2.24122,0.1045 5.08447,-0.7062 6.8125,1.2812 1.40576,1.6168 -0.34521,2.0669 0.5,3.4063 1.24024,0.6391 4.08789,0.7027 5,-0.5313 0.0898,-0.393 0.003,-0.8628 0.21875,-1.2187 1.44873,-2.3907 10.3584,1.9306 7.78125,-2.5937 0.0581,-2.1297 3.72412,-1.0139 4.8125,-0.25 l 0.1875,0.375 c -0.16113,0.5423 -0.0342,1.1406 0.34375,1.5624 1.89014,0.4849 4.30225,-0.3034 4.8125,-2.4374 0.1865,-0.7819 -0.354,-1.1726 0.25,-2 0.80029,-1.098 3.04834,-2.1978 4.21875,-3.2813 -0.21093,-0.3423 -0.56055,-0.566 -0.84375,-0.8437 l -0.0937,-0.4376 c 0.43701,-0.7006 2.04297,-0.6782 2.4375,-2.0937 -0.0986,-0.3994 -0.25586,-0.7876 -0.4375,-1.1563 0.25488,-1.7572 0.63379,-1.0019 1.09375,-2.0312 0.25928,-0.5796 0.0889,-1.2867 0.4375,-1.9688 0.74609,-0.8577 3.19971,-1.2812 3.3125,-2.4687 l -0.25,-0.3125 c -1,-0.334 -1.89111,-0.1744 -2.875,-0.375 -0.48144,-0.098 -0.9126,-0.3587 -1.375,-0.4688 -0.12988,-0.03 -6.51709,0.01 -6.875,0.063 -1.67773,0.2514 -3.33887,0.811 -5.03125,0.9374 -1.04003,0.078 -2.10303,-0.372 -3.125,-0.2187 -1.25684,0.1885 -2.40527,0.765 -3.71875,0.8437 -1.43652,0.086 -2.95117,-0.074 -4.375,0.063 -1.93506,0.1853 -3.30371,1.1103 -5.34375,0.9062 -1.50391,-0.1504 -2.59277,-1.1391 -3.96875,-1.5 -1.4629,-0.3838 -1.94971,0.8238 -3.78125,0.3438 -1.09278,-0.2873 -1.95361,-1.3399 -3.09375,-1.6563 -3.26025,-0.9048 -6.68506,-1.5063 -9.90625,-2.625 -1.93603,-0.6724 -3.79102,-1.5183 -5.75,-2.1563 -2.49268,-0.8112 -5.06641,-1.1904 -7.5,-2.2187 -1.24756,-0.5274 -2.89893,-1.1997 -3.96875,-2.0313 -0.7959,-0.6183 -1.49805,-1.7046 -2.4375,-2.0937 -0.64844,-0.2685 -2.22412,-0.2665 -2.96875,-0.3125 -1.99267,-1.8735 -4.52881,-2.042 -6.84375,-3.3125 -3.4038,-1.8682 -5.99365,-6.7818 -9.28125,-8.5 -2.64941,-1.3853 -5.46387,-2.7109 -8.28125,-3.75 -1.47754,-0.5449 -3.2583,-0.3706 -4.71875,-1 -0.37793,-0.1631 -3.80371,-2.0225 -4.15625,-2.25 -0.75244,-0.4853 -1.15771,-1.4264 -2.03125,-1.9063 -3.99902,-2.1947 -8.75293,-3.2226 -12.84375,-5.2812 -1.36621,-0.6875 -6.10547,-2.9682 -7.03125,-3.6875 -1.0542,-0.8193 -2.04736,-1.8423 -3.21875,-2.5 -1.02783,-0.5776 -2.15527,-0.8438 -3.15625,-1.4063 -0.76123,-0.4274 -1.2207,-1.0092 -1.875,-1.5312 -0.8877,-0.7095 -2.06885,-1.0984 -3.0625,-1.6562 -0.33935,-0.1913 -0.74609,-0.4085 -0.96875,-0.75 -1.60157,-2.4552 -0.47119,-3.1577 -0.59375,-5.2188 -1.21728,-1.6977 -5.7666,-3.7832 -7.71875,-2.7812 l -0.28125,-0.125 c 0.0273,-0.3523 -0.0362,-0.6861 -0.0937,-1.0313 -0.1084,-0.6548 -0.33838,-1.1626 -0.8125,-1.625 -1.53906,-1.502 -3.76904,-2.6748 -5.65625,-3.6875 -0.22119,-0.1192 -7.89893,-5.6729 -8.28125,-6 -1.81934,-1.5542 -2.9751,-4.7768 -4.3125,-5.8438 -0.15381,-2.0996 -1.65332,-4.0542 -2.15625,-6.0312 -0.25,-0.9819 -0.0664,-2.0103 -0.40625,-3 -0.44433,-1.2949 -1.33496,-1.7798 -2.09375,-2.7812 -1.02051,-1.348 -1.4502,-3.8233 -3.40625,-4.2813 -2.2959,-0.5372 -4.2417,0.8083 -6.40625,1.0313 -4.85596,0.5 -11.92334,-0.6886 -15.09375,-4.875 -1.63232,-2.1557 -2.01367,-4.8707 0,-6.9688 1.04541,-1.0894 3.12988,-1.5331 4.40625,-2.5938 3.48633,-2.895 2.97705,-5.5502 8.375,-6.4062 4.30713,-0.6831 3.40186,7.7424 5.5,8.7188 l 0.53125,-0.094 c 0.1211,-0.2046 0.12115,-0.4338 0.0937,-0.6562 -0.1294,-1.0402 -0.81445,-2.1133 -1.09375,-3.1563 -0.35254,-1.3188 -0.62451,-2.7051 -0.84375,-4.0625 -0.0635,-0.3906 -0.14111,-0.7931 -0.3125,-1.1562 -0.55176,-1.1695 -1.14014,-2.7627 -1.9375,-3.7813 -3.0581,-3.9077 -4.91553,-4.0889 -8.25,-6.9375 -1.30811,-1.1177 -2.06348,-3.008 -3.25,-4.2812 -1.34863,-1.4478 -2.93457,-2.5047 -4.15625,-4.125 -0.84668,-1.1241 -1.27832,-3.5533 -2.90625,-3.8438 z M 465.75,2296.375 c -0.53613,-0.3232 -1.13037,-0.6567 -1.46875,-1 -1.09424,-0.1621 -3.3833,-1.4373 -4.375,-1.0938 -0.11377,1.2399 3.1919,1.6793 4.15625,2.125 0.82195,0.4595 1.32568,0.9963 1.71875,1.5626 z m -1.4375,6.0312 c 0.41124,0.075 0.96607,0.051 1.5625,0 -0.59839,0.051 -1.14799,0.08 -1.5625,0 z",
						"santacruz":"m 545.9375,1669.5625 c -0.47417,0.2698 -0.93349,0.5481 -1.375,0.8437 0.44213,-0.2961 0.9002,-0.5735 1.375,-0.8437 z m -2.84375,2 c -0.16053,0.1653 -0.29786,0.3491 -0.4375,0.5313 0.13888,-0.181 0.27803,-0.367 0.4375,-0.5313 z m -255.875,27.0313 c -0.34262,0.2081 -0.66672,0.4307 -0.9375,0.6562 -3.20996,2.6748 -3.11499,5.293 -7.28125,7.5 -2.05908,1.0909 -4.91724,0.6319 -6.65625,1.625 l -0.1875,0.3438 0.0312,0.2187 c 0.41455,0.3433 2.90625,2.875 2.90625,2.875 1.38721,-0.053 3.81323,-1.0373 4.6875,0.4063 -0.0623,0.6692 -0.0515,1.398 0.0625,2.0624 2.39575,1.9084 1.375,7.5012 2.15625,10.3438 0.90234,3.2842 1.83521,5.4778 3.53125,8.4688 -0.0276,0.079 -0.10175,0.2607 -0.0937,0.3437 0.13428,1.4185 -0.70557,4.6529 -0.53125,5.125 0.46802,1.2676 1.97388,3.5596 1.4375,4.875 0.19584,0.4073 0.44165,1.5703 0.21875,2 -0.30225,0.3809 -0.96216,0.4326 -1.375,0.625 -0.28393,0.1324 -3.39575,2.0757 -3.5,2.1875 -0.44214,0.4742 -0.50293,0.9841 -1.125,1.4688 -0.90942,0.7871 -2.98242,2.217 -4.15625,2.5624 -1.9021,0.5613 -5.62939,-0.4931 -6.59375,1.4688 0.17553,1.1016 0.70508,1.9685 0.875,3.0312 -0.68115,2.0823 -2.16626,2.1773 -1.71875,5.5313 0.0962,0.7207 0.50732,0.7867 0.90625,1.3125 0.11963,0.1573 1.13452,3.7595 0.96875,4.0312 -1.31934,0.526 -4.51245,2.2664 -4.1875,4 2.29077,1.8509 7.81445,1.1952 8.3125,6.3126 -0.81128,0.5818 -1.65063,1.1527 -2.375,1.8437 l -0.15625,0.5625 c 0.0674,0.5532 1.21069,1.4766 1.59375,1.875 -1.47974,1.8638 -6.625,-1.5849 -8.75,-2.0625 l -0.8125,0.375 c -0.0244,0.1656 -0.11523,0.4765 -0.28125,0.5625 -0.1731,0.5708 0.86206,2.4841 1.0625,3.2812 -0.59888,2.1736 -1.91992,2.3599 -2.75,4.0313 -0.8938,-0.024 -2.27588,-0.1753 -3,0.5 -0.16992,0.9111 -0.50415,1.8228 -0.90625,2.8125 -0.0972,0.6113 -0.56958,1.2652 -0.84375,1.8125 -1.19849,2.3911 -2.5686,0.7607 -4.03125,0.5625 -0.77099,-0.1045 -1.7334,0.285 -2.53125,0.375 -2.17602,0.2456 -4.1582,1.7683 -5.28125,3.5312 -0.1005,0.1574 -0.0333,0.636 -0.0312,0.8126 0.18994,0.6515 2.06177,0.7637 2.5625,1.3437 0.98829,1.1441 -0.15015,3.8478 -0.59375,5.0937 0.2334,1.0355 0.21777,1.4529 0.90625,2.25 0.17529,0.2039 0.4465,0.4499 0.4375,0.75 l -0.40625,0.2813 c -1.48755,-0.016 -2.94482,0.7465 -3.75,2 -0.98584,-0.2354 -2.39551,-0.356 -2.71875,0.875 0.12401,0.3252 0.2481,0.7405 0.1875,1.0937 -0.43677,0.045 -1.24097,0.3241 -1.53125,0.6876 l -0.15625,0.5312 c 0.005,0.3721 0.43652,0.9803 0.6875,1.2188 l 1.03125,-0.063 0.21875,0.4376 c -0.56788,1.0257 -0.4646,0.9936 -1.28125,1.8124 -1.29004,-0.2364 -3.42065,-0.555 -4.59375,-1.125 l -0.59375,0.2813 0.0937,0.625 c 1.19922,0.9761 1.99927,3.1993 2.59375,4.5937 -0.15552,0.4509 -0.99605,2.4285 -0.90625,2.6876 -1.26611,2.1677 -3.36597,2.0029 -3,5.1562 1.11645,1.2217 2.78906,0.9375 3.9375,2 1.17359,1.0854 0.69336,3.6267 2.375,3.7812 0.98877,1.0223 0.57813,2.8082 1.46875,3.5313 0.96802,0.7867 2.16919,0.1011 3.15625,0.8125 0.374,0.7471 0.125,2.5303 0.125,3.4062 0,1.3137 1.10937,2.598 1.21875,4 0.063,0.8029 0.62036,4.3933 0,5.2813 0.94238,1.8429 2.30835,3.851 1.71875,6.0313 l -0.375,0.5 c -0.14917,0.06 -0.56715,0.1489 -0.65625,0.2812 -0.55274,0.1348 -3.00488,-0.3805 -3.375,-0.4375 -0.14136,0.1314 -0.41577,0.314 -0.625,0.2813 -0.24439,0.1639 -0.78223,0.6953 -0.78125,1.0312 l 0.28125,0.4375 c 0.43262,0.048 1.07422,0.4598 1.28125,0.8437 -0.19921,0.3041 -2.96558,0.7242 -4.15625,1.9063 l 0.125,0.4687 c 0.66773,0.356 1.41113,0.8945 1.90625,1.4688 l -0.375,0.3438 c -3.55371,2.7069 -2.98218,2.9207 -7.15625,2.8437 -0.35425,-0.663 -0.24902,-1.7439 -0.96875,-2.1563 -1.23218,0.1051 -2.61182,0.7266 -3.71875,1.2188 -0.17944,2.9522 1.26221,5.1319 2.0625,7.8125 0.45386,1.5204 0.989,3.7823 0.9375,5.375 -0.03,0.9326 -0.31955,1.8179 -0.28125,2.75 0.0471,1.1368 0.3501,2.2217 0.46875,3.3437 0.27051,2.5607 -3.52808,4.7392 -5.3125,6.0626 -2.99682,2.2228 -5.68726,4.3637 -9.25,5.4687 -1.3396,0.4156 -2.69849,0.935 -4.125,0.9063 -1.16748,-0.024 -2.95435,-0.7633 -4,-0.25 -0.5769,0.5236 -0.93701,1.4472 -1.5625,1.8437 -0.6626,0.4205 -1.36377,0.679 -2,1.1563 -0.4392,0.329 -0.17383,0.253 -0.40625,0.5624 -1.2876,1.7156 -2.44849,3.628 -4.125,4.9688 -0.48169,0.3853 -1.06348,0.7079 -1.21875,1.3438 -0.18677,0.763 0.7402,1.4184 0.6875,2.1874 -0.66431,1.098 -8.01807,2.8281 -9.5,2.4688 -0.65161,-0.1578 -1.20215,-0.997 -1.71875,-1.4375 -1.30078,-0.4101 -5.71143,-0.092 -7,0.094 -4.56909,0.6579 -6.668,0.1446 -6.6875,5.2188 -0.004,1.1602 -0.0461,3.0942 0.59375,4.125 0.55591,0.8955 1.75854,1.1076 2,2.2812 l -0.1875,0.6876 c -1.77074,0.9367 0.71362,3.0214 0.0937,4.4062 -1.28931,2.8789 -4.82495,1.9697 -3.84375,5.875 0.17749,0.7055 0.98096,1.2399 1.28125,1.9062 l -0.28125,0.8126 c -1.07007,0.8324 -3.97339,-0.5079 -4.8125,0.7187 -0.0388,0.4238 0.17822,0.8637 0.3125,1.25 0.0955,0.2749 0.0513,0.5682 0.28125,0.8437 0.69507,0.8333 5.5166,3.1072 4.4375,6.25 -0.1355,0.046 -0.25315,0.2124 -0.28125,0.3438 -0.56689,0.1919 -1.39087,0.9841 -1.59375,1.5312 -1.02637,2.7687 3.37964,2.8168 4.5625,3.9376 0.42471,0.9051 -0.46606,2.2084 0,3.3437 0.28052,0.6831 0.83203,1.1887 1.0625,1.9687 -0.22339,0.5984 -0.33008,1.2547 -0.46875,1.875 -1.09131,1.1847 -4.42896,5.0161 -5.9375,5.5938 l -0.15625,0.2812 c -0.0178,0.2645 0.0876,0.3829 0.15625,0.5938 0.60962,1.8706 0.56104,3.7157 1.15625,5.5938 0.41015,1.2938 1.31982,1.415 1.53125,2.1562 -0.0894,1.5327 -1.79395,1.0303 -2.59375,2.0625 -0.10132,0.771 0.9292,1.8688 1.15625,2.7187 -0.38746,0.384 -0.501,1.3726 -0.5625,1.9063 -0.156,1.3584 -1.39893,2.5703 -1.9375,3.8125 -0.17334,0.3999 0.0535,0.9677 0,1.375 -0.11231,0.8569 -0.6279,1.7881 -0.6875,2.625 -0.0137,0.1958 0.1526,1.0689 0.1875,1.3125 0.78173,1.292 2.19653,1.2881 2.59375,1.875 l 0.0312,0.2813 c -0.31714,0.346 -0.61792,0.7226 -0.90625,1.0937 0.0657,0.097 0.13325,0.2325 0.21875,0.3125 2.23852,2.1026 3.94287,4.4453 6.03125,6.6875 0.97924,1.0513 2.33691,1.709 3.34375,2.6875 0.71557,0.6958 1.14063,1.697 1.96875,2.4062 1.93677,1.6598 3.99585,3.0154 5.875,4.8126 0.38135,0.3646 0.63306,1.3669 1.09375,1.875 1.37598,1.5159 3.89624,2.1655 4.0625,4.4062 0.88452,0.1275 1.91333,0.1182 2.46875,0.9375 0.0464,0.2529 -0.0227,0.606 -0.1875,0.8125 -0.67627,0.4111 -1.66992,0.5913 -2.4375,0.75 -0.42947,1.7964 -0.23267,1.9197 -0.0312,3.5938 0.71826,0.8624 1.93286,1.1318 2.96875,1.375 4.82763,1.1328 11.20361,-6.8225 14.75,-8.375 2.4397,-1.0686 5.11133,-1.3881 7.4375,-2.6876 1.05762,-0 4.09277,2.6074 5.40625,3.2188 3.00293,1.3974 2.99023,1.1465 5.1875,-1.5625 0.98413,-1.2134 4.2312,-2.777 5.6875,-2.5937 0.96265,0.1203 1.875,0.9934 2.90625,1.25 3.09912,0.7703 1.45215,-1.6407 5.125,1.0937 1.53662,0.069 1.83569,0.1802 2.875,1.1875 0.0571,0.6454 -2.48315,4.164 -2.90625,6.125 0.0679,0.6933 5.54614,7.3604 5.65625,7.5 0.12623,2.0337 -0.80322,9.913 -1.15625,11.5625 -0.0732,0.3432 -0.51636,0.9147 -0.84375,1.0625 -0.75683,-0.1107 -4.22949,-0.087 -4.5625,0.25 -0.95239,3.0181 -3.10986,2.507 -3.34375,3.9062 0.033,0.3581 -0.0791,0.7588 -0.1875,1.0938 2.00561,7.3163 6.77197,5.6054 8.34375,7.875 1.09619,3.7734 -4.53833,1.6255 -3.96875,8.625 0.32324,3.977 -1.396,4.4448 -1.375,5.3125 0.0205,0.8607 0.3457,1.7191 0.21875,2.5937 -0.37109,2.5539 -4.06006,1.618 -5.34375,6.1876 0.0762,0.6455 0.53931,1.3225 1.0625,1.6874 2.98804,0.1096 3.8479,-1.4292 5.15625,1.5938 l 2.3125,5.5625 c 2.11646,1.1279 4.78149,0.7178 6.9375,1.75 4.29639,2.0567 7.56445,5.2695 11.21875,8.2187 0.60425,0.4878 1.35938,0.8336 1.8125,1.5 0.39453,0.5807 0.6025,1.4357 0.6875,2.125 0.25268,2.049 -4.37134,3.0656 -4.53125,3.875 0.59423,1.812 2.0188,1.4786 3.375,0.9063 0.34448,0.376 1.42065,1.5171 1.875,1.75 0.8225,0.4211 12.86938,0.3385 14.25,0.3125 1.42432,-0.032 2.89062,-0.013 4.3125,0 12.3667,0.1191 24.79858,0.1636 37.15625,-0.125 8.74218,-0.2036 17.58618,0.135 26.34375,0.125 10.29834,-0.01 20.53979,0.017 30.84375,-0.125 0.6521,-0.01 17.46021,5.5601 20.3125,6.4688 3.22924,1.0291 10.2627,3.8134 13.28125,4.0937 4.47461,0.4155 9.19653,-0.6079 13.6875,-0.3125 2.43115,0.1597 5.10742,1.5593 7.4375,2.3438 0.66015,0.222 1.37061,0.5513 2,0.75 0.37989,0.1194 5.40674,1.2953 5.53125,1.4062 1.43994,0.6455 2.85596,1.3857 4.28125,2.0625 4.39307,2.0869 2.45654,1.9925 7.5625,2.6563 3.39062,0.4407 7.2998,0.6186 10.59375,1.5937 0.2832,0.535 2.60742,0.4008 3.25,0.4687 0.28173,-0.2334 4.92041,1.1236 6.125,1.3438 0.13965,0.1538 -0.78125,3.3438 -0.78125,3.3438 1.00928,-0.6227 3.61525,-2.7129 3.53125,-4 -0.0425,-0.6578 -2.36377,-3.8253 -2.875,-4.5 -0.34326,-0.4539 -5.68405,-6.7825 -5.71875,-6.8126 -1.02734,-0.8775 -2.28516,-1.4989 -3.28125,-2.375 -1.48389,-1.3051 -5.07324,-5.3032 -6.28125,-6.9062 -0.90723,-1.2036 -1.52881,-2.6793 -2.4375,-3.9062 -0.25244,-0.341 -0.75635,-0.6172 -1.0625,-0.9688 -1.29248,-1.4868 -2.92822,-3.5215 -3.75,-5.3125 -0.92773,-2.0215 -2.20069,-3.7612 -3.125,-5.7187 -0.57275,-1.2133 -0.54395,-2.5406 -1.375,-3.6876 -1.28223,-1.7689 -5.19922,-4.7138 -5.46875,-6.8437 -0.4126,-0.3462 -0.66748,-0.8041 -1.21875,-0.9687 -3.34717,-0.9982 -10.67749,5.5585 -12.90625,4.75 l -0.125,-0.3438 c 0.94531,-0.7739 2.86304,-1.0376 3.46875,-2.2188 L 433.3125,2082 c -0.69653,-0.8536 -4.14405,-1.7178 -5.5,-2.5 -0.65869,0.045 -1.25488,0.175 -1.84375,0.125 -2.12207,-0.1797 -3.6355,-1.3924 -6.28125,-1.2188 -0.78711,0.052 -6,0.7476 -6.5625,0.9063 -2.04492,0.5772 -4.24072,1.5548 -6.4375,1.4063 l 0.1875,-0.25 c 0.98047,-0.3705 2.10914,-0.269 3.09375,-0.5626 1.38989,-0.4146 2.69678,-1.6474 3.96875,-2.3437 0.30933,-0.1694 0.71558,-0.2775 1.0625,-0.3125 0.90845,-0.092 1.80908,-0.021 2.71875,-0.2188 1.05811,-0.2309 1.97144,-0.9082 3.09375,-1.0312 0.38379,-0.042 4.67017,0.036 4.90625,0.094 3.12231,0.7687 5.89087,3.6606 9.5,3.5312 2.18701,-0.079 2.19531,-2.0606 4.03125,-2.75 3.70898,-1.3926 3.53515,0.5547 4.8125,0.7188 0.65234,-0.045 0.68994,-0.4674 0.9375,-0.9063 1.24365,-2.2105 0.0601,-4.8203 -0.96875,-7 -1.26221,-2.6739 -3.76855,-7.1337 -4.65625,-9.7187 -0.74902,-2.183 -1.08642,-4.8643 -2,-6.9063 -1.12109,-2.5068 -3.03125,-4.6084 -3.03125,-7.5625 0,-1.2153 0.28985,-2.4334 0.21875,-3.6562 -0.041,-0.7089 -2.21167,-5.4507 -2.71875,-5.9063 l -0.46875,-0.1563 c -0.75024,0.051 -0.86646,0.9651 -1.5,1.25 -1.34302,0.6042 -2.96435,0.9112 -4.3125,1.5313 -2.0957,0.9639 -4.69849,3.5829 -6.28125,5.2813 l -0.53125,0.125 c -0.1731,-0.9703 4.81177,-5.1612 5.78125,-5.7188 0.74731,-0.4297 1.61328,-0.5714 2.34375,-1.0938 0.42969,-0.3067 7.18848,-6.4559 7.46875,-6.8124 0.86797,-1.1051 0.0519,-4.4708 -0.0312,-5.9063 -0.0628,-1.0791 -0.23216,-3.0849 0.0312,-4.0937 0.2605,-0.9999 1.10938,-1.8306 1.28125,-2.8438 0.56348,-3.3198 1.0791,-7.3628 2.53125,-10.4375 1.30566,-2.7657 4.30225,-4.79 6.15625,-7.25 0.80029,-1.0615 0.96973,-2.2373 2.09375,-3.1875 0.72021,-0.6094 2.37939,-1.4772 2.84375,-2.0938 0.61963,-0.822 0.72217,-1.461 1.71875,-2.0624 3.43408,-2.074 10.44922,-4.5013 14.40625,-5.75 3.63428,-1.1473 8.17823,-1.4205 11.59375,-3.1563 1.28955,-0.6553 3.80762,-2.3827 3.03125,-4.1563 -1.89111,-0.9733 -6.91504,-2.9695 -8.25,-4.3124 -1.73145,-1.7428 -1.19531,-5.6236 -4.25,-6.2188 -1.90479,-0.3711 -2.42529,0.519 -3.90625,0.75 -2.0625,0.322 -5.70068,0.1894 -7.8125,-0.031 -1.49316,-0.1558 -2.62451,-0.7119 -4.21875,-0.4376 -1.16064,0.2002 -2.167,1.0016 -3.25,1.3438 -0.49707,0.1568 -5.90332,1.0394 -6.1875,0.9688 0.65479,-2.1436 4.98535,-2.1045 6.6875,-2.5313 1.27588,-0.3203 2.64697,-0.8855 3.96875,-0.8125 0.7417,0.041 1.4585,0.2696 2.21875,0.2812 0.96973,0.015 1.93261,-0.2913 2.90625,-0.1874 0.87158,0.093 1.77685,0.4062 2.65625,0.4062 1.12451,0 2.17334,-0.5765 3.21875,-0.9062 0.68066,-0.2151 1.71826,-0.2754 2.3125,-0.625 1.04785,-0.6176 1.11621,-3.0308 0.75,-4.0313 -0.75488,-2.0615 -2.81934,-3.5386 -3.4375,-5.5625 -0.24605,-0.8062 -0.0264,-1.7671 -0.28125,-2.5625 -0.32178,-1.0035 -3.70996,-2.2876 -4.75,-3.0313 l 0.25,-0.125 c 1.12109,0.1464 4.51367,1.6441 5.3125,2.5313 0.84082,0.9336 0.90136,4.1044 2.21875,5.8437 1.36768,1.8059 3.28076,3.196 4.375,4.6876 0.67822,0.924 0.1538,2.2612 0.78125,3.1562 0.80371,1.146 2.15674,1.8315 3.03125,2.9062 0.86621,1.0655 1.29151,2.4117 2.0625,3.4688 0.91162,1.2495 1.85108,0.8247 2.96875,1.5312 0.88867,0.5623 1.75684,2.0758 2.46875,2.4376 1.4541,0.7384 6.61865,0.206 8.3125,-0.2188 1.73779,-0.4361 3.17822,-1.499 4.84375,-2.0625 1.07617,-0.3637 2.26953,-0.375 3.34375,-0.8125 1.77979,-0.7247 9.64209,-5.5874 10.96875,-6.875 0.4668,-0.4526 0.87549,-0.9165 1.40625,-1.3125 1.01807,-0.7597 3.16504,-2.2174 3.78125,-3.2813 2.23779,-3.8596 3.70898,-13.9208 4.0625,-18.5 0.0903,-1.1662 -0.0449,-2.6974 0.3125,-3.8124 2.02539,-6.3225 2.93506,-4.553 3.375,-12.3126 0.083,-1.4616 3.57421,-8.4641 3.0625,-9.1874 L 525,1919.75 c -3.0879,-1.3491 -2.44922,1.3516 -3.1875,2.625 -0.37158,0.6411 -1.10645,1.0485 -1.40625,1.7188 -0.42139,0.942 -0.38476,2.6118 -1.125,3.4062 -0.91406,0.9815 -3.68457,1.3102 -5.03125,1.5312 -0.82324,0.1356 -1.78418,0.6612 -2.40625,-0.2812 -0.26709,-1.1171 1.40186,-1.1943 2.0625,-1.7188 0.1079,-0.5688 10e-4,-1.2666 0.125,-1.7812 0.56592,-2.3667 4.74804,-1.063 5.21875,-1.5312 l 0.28125,-0.7188 -0.125,-0.4062 c -0.36426,-0.2259 -1.32324,-0.8538 -1.4375,-1.25 0.28711,-0.587 1.10938,-0.8623 1.5625,-1.1563 2.51855,-1.6338 1.79639,-2.8034 3.5,-4.4063 0.45654,-0.4293 1.28174,-0.647 1.625,-1.1562 0.98584,-1.4649 -1.7749,-2.9781 -1.34375,-4.625 1.49512,-1.254 1.96973,-3.5593 3.25,-5.0312 0.21826,-0.252 6.41796,-5.647 6.625,-5.7813 0.55566,-0.3604 1.24805,-0.5913 1.78125,-1 0.49463,-0.3794 1.15039,-2.168 1.875,-2.7813 0.75195,-0.6354 1.65478,-0.8891 2.46875,-1.4062 1.72949,-1.0991 2.78809,-2.2456 4.90625,-2.8438 0.68799,-0.1938 2.17529,-0.2595 2.65625,-0.8124 0.58691,-0.6752 0.56543,-1.7093 0.96875,-2.4376 0.17822,-0.3221 0.5039,-0.7162 0.75,-1 1.16113,-1.3346 2.35693,-2.8295 3.375,-4.2812 0.49072,-0.6997 0.75732,-1.62 1.3125,-2.2812 0.66846,-0.7967 1.96533,-2.0272 2.875,-2.5 1.40234,-0.7299 2.87598,-0.9142 4.34375,-1.4063 1.6792,-0.5635 2.93066,-1.6689 4.78125,-2.0937 0.96777,-0.2232 5.69141,-0.898 6,-1.0938 0.85059,-0.541 1.11279,-1.6348 1.84375,-2.3125 1.15088,-1.0674 2.65869,-1.6445 3.8125,-2.75 1.25244,-1.2002 2.29883,-2.7528 3.75,-3.7187 0.43701,-0.2908 1.1206,-0.5422 1.625,-0.6876 0.79102,-0.2267 1.63428,-0.2862 2.4375,-0.5 2.4585,-0.6517 2.87988,-1.1958 5.8125,-1.4062 0.66113,-0.048 1.71485,-0.057 2.21875,-0.5312 0.16797,-0.9144 0.18018,-1.9505 0.5,-2.8126 2.56201,-1.8306 4.84082,-0.2621 7.46875,-0.5937 l 0.0937,-0.375 c -0.4624,-0.75 -1.05615,-1.5411 -1.15625,-2.4375 -0.22998,-2.0616 7.66407,-6.5113 9.4375,-7.2812 0.84473,-0.3676 1.78028,-0.4928 2.625,-0.8438 0.73926,-0.7925 0.34131,-1.0127 0.5,-1.8438 0.25098,-1.3143 3.12158,-3.8318 4.4375,-4.0624 1.13184,-0.199 2.32911,0.021 3.46875,0 0.68799,-0.012 1.37598,-0.3178 2.03125,-0.3438 0.87109,-0.035 3.63281,1.9698 4.125,0.1562 0.0195,-1.496 -3.67725,-2.147 -3.125,-4.0937 0.22559,-0.2901 0.47656,-0.5732 0.6875,-0.875 0.24365,-1.3755 -2.2603,-2.0796 -2.3125,-3.375 -0.0347,-0.8628 0.73388,-1.2387 1.46875,-1.3437 0.69385,-0.1003 1.31299,-0.4113 2.03125,-0.4376 1.78809,-0.066 3.23486,1.4279 4.875,1.8126 0.31201,0.073 2.35938,-0.1392 2.625,-0.2813 l 0.0937,-0.4063 -0.1875,-0.3124 -0.75,-0.3438 c 0.0542,-0.7569 0.71435,-0.6602 0.9375,-1.1562 -0.23242,-1.726 -3.87647,-1.1363 -4.90625,-2.2813 -1.25732,-1.3979 -0.0117,-4.5273 -1.84375,-6.1875 -0.65967,-0.5976 -3.39355,-1.9117 -4.25,-1.8438 -1.08887,0.086 -6.68066,2.6739 -8,3.2813 -1.43408,0.6595 -3.8457,0.335 -5.5,0.6875 -0.48047,0.1026 -1.64746,0.8025 -1.8125,0.8125 -0.68896,0.2417 -1.37988,0.8775 -2.09375,1.1875 -1.99854,0.8682 -5.52783,1.292 -7.09375,-0.625 l 0.34375,-0.1875 c 1.22656,0.3955 2.25097,1.0553 3.59375,0.9063 2.61377,-0.2914 5.45411,-2.4112 8.0625,-3.2188 1.3335,-0.4126 3.14258,0.033 4.34375,-0.625 l 0.21875,-0.125 c 1.91602,-1.0747 2.8413,-3.0145 5.03125,-3.6562 2.70508,-0.793 6.86768,1.5446 8.65625,0.094 0.12891,-0.1045 2.53516,-5.9282 2.8125,-6.625 0.51172,-1.2881 1.96143,-2.3803 2.5625,-3.625 0.11035,-0.2275 0.14695,-0.4787 0.21875,-0.7187 0.40967,-1.379 1.40429,-3.6223 1.625,-4.75 0.22949,-1.1718 -0.37356,-2.275 -0.0625,-3.4063 0.13232,-0.4824 0.5298,-0.8272 0.625,-1.375 0.16211,-0.9326 -0.24465,-1.6871 -0.15625,-2.5625 0.0654,-0.6446 0.48731,-1.2617 0.65625,-1.875 0.1035,-0.375 0.2612,-3.9795 0.1875,-4.375 -0.31396,-1.6875 -1.79736,-2.477 -1.9375,-3.6875 -0.19092,-1.646 0.36816,-4.564 -0.8125,-5.875 -1.27344,-1.4141 -3.1455,-1.917 -4.5,-3.0625 -0.96387,-0.815 -0.84619,-2.0683 -2.25,-2.9375 -0.55469,-0.343 -1.25537,-0.2715 -1.875,-0.375 -1.32764,-0.2217 -2.30176,-1.5231 -3.53125,-1.9063 -0.39746,-0.1237 -1.27197,-0.1167 -1.6875,-0.062 -2.26367,0.2934 -3.61425,1.5282 -5.03125,1.75 -1.22705,0.1911 -2.32764,-0.8833 -3.53125,-0.9063 -1.00391,-0.02 -1.54151,0.75 -2.4375,0.9375 -0.39209,0.082 -0.8584,0.034 -1.25,-0.031 -0.86963,-0.1431 -1.67383,-0.5235 -2.53125,-0.625 -1.41016,-0.1676 -2.99121,0.081 -4.4375,0 -0.42383,-0.024 -0.84717,-0.2099 -1.15625,-0.5 -0.63477,-2.1966 -2.95948,-0.6888 -4.5,-0.7188 -0.72998,-0.015 -1.19776,-0.6944 -1.90625,-0.8125 -0.90576,-0.1519 -1.51318,0.1336 -2.28125,-0.5313 -3.57666,-0.059 -8.63281,0.9215 -12.03125,-0.2187 -1.27197,-0.4263 -1.95752,-1.3296 -3.03125,-1.875 -1.11377,-0.5664 -2.34815,-0.6932 -3.3125,-1.5937 -1.24805,-1.1667 -1.63818,-3.1929 -2.875,-4.2813 -0.48047,-0.4219 -1.16406,-0.6655 -1.65625,-1.125 -0.43555,-0.4072 -0.77295,-1.0146 -1.25,-1.375 -0.70752,-0.5347 -1.62598,-0.7964 -2.3125,-1.4375 -1.13916,-1.0644 -2.03515,-2.6489 -3.4375,-3.375 -0.23779,-0.023 -0.68555,0.047 -0.84375,0.25 -1.92627,-0.2227 -2.45606,-2.6173 -3.46875,-3.7812 -0.47363,-0.5453 -1.24024,-0.9351 -1.59375,-1.5938 -0.42188,-0.7852 -0.0967,-0.9209 -1.03125,-1.5 -1.48828,-0.9214 -3.72314,-0.8619 -5.1875,-1.9688 -0.9043,-0.6826 -0.76172,-2.2007 -1.875,-2.75 -1.7334,-0.8537 -3.88378,-0.875 -5.53125,-2.1562 -0.94727,-0.7373 -1.33301,-1.7193 -2.09375,-2.5625 -0.41162,-0.4566 -1.10596,-0.6845 -1.5625,-1.125 -0.66455,-0.6411 -7.52637,-9.6021 -7.78125,-10.1875 -0.3418,-0.7862 -0.0996,-1.6912 -0.4375,-2.4688 -0.74023,-1.7016 -1.82032,-3.4492 -2.21875,-5.2812 -0.17773,-0.8179 -0.0498,-1.7945 -0.3125,-2.5938 -1.48047,-4.4979 -2.53027,-7.9247 -1.9375,-12.8124 0.12256,-1.0075 0.87305,-1.3481 1.375,-2.125 0.68589,-1.0631 0.27654,-1.9353 0.71875,-3.0626 l -0.0312,0 c -3.56445,-0.1398 -210.92212,0.2533 -239.15625,-0.062 z",
						"chubut":"m 674.8125,1426.4688 c 0.13198,0.3122 0.29736,0.6213 0.5,0.9687 -0.20138,-0.3445 -0.36794,-0.659 -0.5,-0.9687 z m -3.53125,0.4687 c -130.50847,0.107 -261.02498,0.2611 -391.53125,0.031 -0.18559,0.9958 0.061,1.903 1.875,2.75 l 0.25,0.5312 c -0.0444,1.0229 -1.63477,1.1489 -0.0937,4.5625 l -0.21875,0.4063 c -0.45679,0.2112 -1.34131,0.8677 -1.78125,0.8124 -0.3269,0.2864 -0.60205,0.6422 -0.84375,1 -0.55298,0.3089 -1.19824,0.3353 -1.8125,0.25 -0.56176,0.1966 -0.89014,0.5682 -1.5,0.75 -1.63037,0.4866 -1.04468,-1.707 -3.71875,1.2813 -0.28736,0.3211 -0.98071,0.3963 -1.375,0.4063 -2.17041,-1.0579 -0.1416,-3.0626 -4.6875,-3.0626 -0.58716,-9e-4 -1.16479,-0.01 -1.75,-0.062 -0.24268,0.1361 -1.7317,2.1856 -1.75,2.4374 0.0383,0.799 1.36426,1.4083 0.75,2.1563 -0.75146,0.5571 -1.6853,1.0252 -2.25,1.7813 -0.56054,0.7502 -0.4978,1.3137 -0.78125,2.125 -0.23169,0.6624 -1.00513,1.3865 -1.375,2 0,0 -0.36205,0.9329 -0.28125,1.125 0.85254,0.5584 1.41626,1.395 2.09375,2.0312 1.5708,1.4756 3.8457,2.8655 1.3125,4.6562 -0.37232,0.8678 0.32202,1.8443 0.21875,2.1876 0.52588,0.7522 0.99438,1.3293 1.71875,1.9374 0.13157,0.388 0.41357,1.6134 0.15625,2 -1.73389,1.3517 -4.42505,2.2154 -5.375,4.4688 -0.30029,0.7129 -0.34644,1.5774 -0.65625,2.2188 0.12695,0.7817 0.87965,0.9652 0.96875,2.1562 0.0627,0.8374 -0.8916,1.5217 -0.625,3.0938 0.36767,2.1686 1.4839,4.0268 1.5625,6.3437 0.0457,1.3506 -0.8232,2.6149 -0.75,3.9687 0.0977,1.8097 0.55688,4.0228 0.21875,5.8126 1.3169,2.9601 4.24292,5.0053 6.5,7.2187 2.02783,1.9878 0.70044,1.6457 0.9375,3.9063 0.65601,1.5666 6.53979,0.6706 5.5,3.375 0.87012,0.3644 1.76416,0.3876 2.53125,0.6562 0.86231,0.3022 2.05566,0.5734 2.84375,1.0312 0.74244,0.432 1.23584,1.2958 2.1875,0.6876 0.36108,-0.043 0.93677,0.4697 1.375,0.5624 0.0259,0.8793 0.39941,1.8736 0.65625,2.7188 -0.63842,1.6709 -1.02881,2.7595 0.15625,4.2188 0.051,0.4489 -0.17334,2.7055 -0.46875,2.9687 l -0.28125,0.031 c -1.75585,-1.9192 -1.90576,-0.6394 -3.71875,-0.5 -2.22412,3.1123 -4.3396,0.755 -5.09375,1.0624 -1.00562,0.3899 -0.67334,2.2405 -0.3125,2.9376 -0.62354,0.5603 -1.51611,1.1947 -2.1875,1.75 0.0298,0.2663 0.32959,0.5942 0.5,0.7812 0.35596,0.081 0.72656,0.2907 1,0.5312 l 0.0937,0.25 c -0.2561,0.8274 -1.92383,1.6817 -1.75,2.6563 0.19946,0.4038 3.20752,0.1756 4.375,1.0313 0.11523,0.3611 0.53174,0.5681 0.75,0.875 0.42505,1.4368 -1.76123,3.2991 -1.125,4.3124 1.05005,1.3953 4.74414,-0.7757 5.5625,-0.125 0.56714,0.6692 0.80762,3.2517 2.21875,2.75 0.15161,-0.1817 1.125,-0.1562 1.125,-0.1562 l 0.96875,1.4375 0.0312,1.3125 0.25,0.3125 c 2.18238,0.4638 4.3418,-1.0991 6.125,1.25 0.40136,0.5288 0.53149,1.0928 0.28125,1.7187 -0.24023,0.6012 -0.85449,1.2868 -0.59375,1.3438 l -0.0937,0.5625 c -1.67505,0.1641 -3.45947,1.0615 -5.03125,1.625 -1.28784,0.461 -3.56299,3.8642 -4.125,5.125 -0.31131,0.6977 -0.20044,1.354 -0.375,2.0625 0.22632,0.5166 0.54395,1.0869 1,1.4375 0.82715,0.2507 1.71167,0.1236 2.5625,0.3125 -0.0438,0.9702 -0.35034,2.0044 -0.0312,2.9375 3.41382,0.9009 2.46948,3.1389 1.1875,5.3437 -0.31201,0.5369 -0.42236,1.3289 -0.875,1.75 -0.72461,0.6742 -1.81616,1.0347 -2.375,1.9063 -0.8606,1.3423 -1.45093,3.002 -2.9375,3.875 -1.09131,0.6406 -2.47705,0.3945 -3.625,1.0313 l -0.34375,1.125 c 0.20849,1.4112 3.52525,5.324 3.53125,6.125 0.006,0.8646 -0.55127,1.499 -1,2.1874 -1.33276,2.0451 -0.27271,2.0914 0.8125,3.7188 -0.71557,4.0405 -0.28101,1.6189 -2.90625,3.5312 -0.22656,0.5299 0.0991,1.0162 0.25,1.5313 0.88086,3.0108 2.97754,2.2771 5.21875,1.5313 0.31567,-0.5051 1.43359,-0.8118 1.96875,-0.8438 1.12109,-0.068 2.48096,1.313 3.75,1.375 0.96973,0.047 1.83105,-0.1926 2.8125,-0.2188 1.30713,-0.034 2.63672,0.1703 3.9375,0.125 2.38647,-0.082 4.91528,-0.5732 7.28125,-0.5312 2.76806,0.049 3.75732,1.7353 5.1875,1.875 2.06104,0.2007 4.95508,-0.4158 6.875,0.3438 2.32446,0.9191 2.96143,2.0282 3.90625,4.0937 0.26245,0.5736 1.12231,0.8778 1.53125,1.375 0.24829,0.3018 0.33521,0.8456 0.53125,1.0313 -0.24169,0.551 -0.91699,3.5771 -1.21875,3.8437 -0.71166,0.3954 -1.97754,0.3827 -2.78125,0.5313 -1.14942,0.2121 -1.14331,0.8531 -1.875,1.25 -0.31299,1.2893 -0.99438,1.5378 -1.375,2.5624 -0.62134,1.6751 0.7583,3.6072 0.96875,5.25 0.0554,0.4334 -0.24365,0.9227 -0.15625,1.25 -1.80224,2.8684 -2.9624,4.9624 -6.75,4.7813 -0.79981,-0.038 -2.05029,-0.1755 -2.78125,-0.5937 -1.13696,-0.651 -1.79736,-1.86 -2.78125,-2.7188 -0.4143,-0.3618 -2.2124,-1.4438 -2.34375,-1.625 -3.09107,-0.8862 -6.62256,2.8945 -9.71875,3.2188 -3.1333,0.3272 -6.07251,-2.2381 -8.1875,-2.125 -1.29785,0.069 -2.10889,1.0542 -2.53125,2.2187 -1.36133,1.2329 -3.20728,-0.067 -4.625,-0.4063 -1.03223,-0.2469 -1.86963,0.6548 -3.46875,0.2813 -1.66724,-0.3892 -3.27246,-1.1094 -4.6875,-1.9375 -0.34473,-0.2022 -0.60791,-0.518 -1.0625,-0.5 -0.6333,0.026 -1.13843,0.8213 -1.28125,1.375 0.0859,1.7158 0.96704,3.7071 0.84375,5.375 -0.051,0.6885 -0.46675,1.4137 -0.53125,2.125 -0.16504,1.8208 2.68604,1.9254 3.78125,1.7812 2.54639,-0.3348 4.40405,0.7949 6.25,2.3126 2.00268,0.2386 2.92773,-0.7766 4.71875,-1.125 0.52685,-0.1023 1.08154,0.3974 1.625,0.2812 0.60816,-0.1299 1.23438,-0.476 1.875,-0.3438 0.71826,0.2072 1.41235,1.6653 2.28125,2.125 0.50317,0.2667 1.11304,0.2089 1.65625,0.3126 0.48193,0.091 0.83252,0.4742 1.34375,0.5312 3.83277,0.4243 4.30029,-1.5202 7.3125,2.3438 0.92236,1.1828 1.4834,2.7299 2.46875,3.9687 0.11353,0.1431 0.7481,0.8724 0.8125,1.0625 0.28858,0.8496 -0.0964,1.8797 0.125,2.3438 0.41822,0.8743 1.3208,1.1169 1.84375,1.875 0.30249,0.4384 0.39111,1.0132 0.84375,1.3437 0.79565,0.1368 2.95459,1.2361 3.5625,1.1563 1.33447,0.7545 5.1731,7.0753 4.78125,8.6562 -0.88965,0.9947 -1.63232,1.3449 -2.53125,2.1562 -0.41894,0.3787 -0.69312,1.0374 -1.09375,1.375 -1.99682,1.6857 -6.91162,1.6956 -8.625,3.125 0.32692,2.5263 5.88525,4.6948 0.25,8.0626 -0.96436,0.5759 -3.85254,0.6922 -4.71875,0.7812 -0.61328,0.063 -2.15381,-0.74 -3.25,-0.75 -0.77417,-0.01 -6.93896,2.2347 -7.21875,3.0312 l 0.40625,0.4063 c 0.37671,-0.01 1.71875,0.9375 1.71875,0.9375 -0.16162,1.6669 -2.70581,3.1631 -2.53125,4.25 0.65698,4.0938 -0.4036,2.4433 -0.5,4.5625 -0.0263,0.5786 0.21191,1.1631 0.0937,1.75 0.57006,0.4092 1.8206,2.1301 1.875,2.1563 0.356,0.9036 0.78101,2.5195 0.375,3.4687 -2.71045,2.0547 3.6897,2.4882 6.125,4.625 0.4812,1.6724 2.45435,4.6817 1.6875,6.375 -0.62387,0.3552 -1.40089,0.7354 -2.09375,1.1563 l 0.125,0 c 28.23413,0.3158 235.5918,-0.078 239.15625,0.062 l 0.0312,0 c 0.15277,-0.3894 0.40757,-0.8143 0.84375,-1.2812 0.49268,-0.5274 1.82129,-1.1729 2.09375,-1.625 l -0.0625,-0.3125 c -0.30078,-0.2519 -0.48975,-0.6327 -0.46875,-1.0313 0.20166,-0.4672 0.54834,-0.7925 0.90625,-1.125 1.15332,-1.0697 3.55078,-3.2963 4.5625,-4.3437 0.67773,-0.7011 1.04346,-1.7887 1.6875,-2.4063 0.80127,-0.7681 1.64795,-0.9604 2.4375,-1.7812 1.14697,-0.6513 0.60693,0.5561 2.34375,-1.125 0.20996,-0.8799 -1.13916,-1.298 -0.8125,-2.5938 0.19434,-0.3156 0.55078,-0.5252 0.875,-0.6874 0.24902,-0.3432 -0.20996,-4.7603 1.25,-7.5313 2.06689,-3.9218 8.92529,-3.9624 9.21875,-9.375 0.33887,-0.4506 0.81153,-0.5556 1.15625,-0.9375 0.65332,-0.7241 1.05811,-1.6938 1.71875,-2.375 0.25439,-0.2622 0.61328,-0.4038 0.78125,-0.75 0.24219,-0.4981 0.28467,-1.2515 0.75,-1.625 0.64307,-0.5151 1.48633,-0.9775 1.9375,-1.7188 0.43945,-0.7219 0.59424,-1.6259 1.0625,-2.375 0.4209,-0.6735 1.10059,-0.9166 1.53125,-1.5624 1.85303,-2.7799 0.36377,-1.8018 3.6875,-4.0313 0.87891,-0.5898 2.11572,-0.7116 3.03125,-1.2813 0.81934,-0.5083 2.1206,-1.6063 3.03125,-1.7812 1.38184,-0.2646 2.5747,0.2935 3.9375,0.3438 2.12158,0.077 4.06397,-1.0728 6.09375,-1.2188 1.25244,-0.09 2.37695,0.273 3.5625,0.25 0.89258,-0.017 1.7124,-0.319 2.625,-0.25 0.72119,0.055 1.28271,0.585 2,0.5 0.69287,-0.082 1.30425,-0.7232 1.28125,-1.4375 -0.67236,-1.6455 -2.9292,-1.5331 -4.21875,-2.6563 l -0.0312,-0.375 c 1.01416,-1.4449 5.78174,1.7945 7.59375,0.3126 0.0205,-1.2078 -3.29541,-1.0624 -4.4375,-1.875 -1.64209,-2.6482 5.58691,-3.2039 6.375,-3.5626 0.69336,-0.3152 1.28271,-0.9775 2.03125,-1.1562 0.45996,-0.1098 1.08692,0.018 1.5,-0.2188 0.51172,-0.2934 0.50488,-0.8288 1.25,-0.875 1.05469,-0.065 2.28809,0.3828 3.3125,0.1563 0.24023,-0.053 0.45215,-0.1059 0.65625,-0.25 0.42676,-0.2998 0.63526,-0.7481 1,-1.0625 1.31689,-1.1357 1.85743,-1.0435 2.90625,-2.6875 0.19922,-0.3125 0.34229,-0.6404 0.6875,-0.8437 0.25488,-0.1513 0.59326,-0.1688 0.875,-0.094 l 0.1875,0.3125 0.40625,0.125 c 0.97461,-0.1362 3.46485,-0.4584 4.375,-0.3437 0.52686,0.066 5.78907,1.048 5.9375,1.125 2.24902,1.1632 -0.22266,3.4492 5.625,2.9687 0.74463,-0.061 0.95605,0.3134 1.8125,-0.1563 l 0.1875,-0.3437 c -0.11279,-0.21 -0.25927,-0.4038 -0.4375,-0.5625 -0.2915,-1.2055 1.85303,-1.5059 2.625,-1.1875 0.29932,0.5342 0.51856,1.1545 0.84375,1.6563 l 0.34375,0.094 c 0.84717,-0.9306 1.42578,-0.2793 2.28125,-0.062 2.48535,-0.6777 1.68408,0.4647 3.0625,0.7812 0.47363,0.1093 0.86133,-0.018 1.3125,0.2813 0.27295,0.436 0.39746,0.9101 1,0.9687 l 0.3125,-0.25 0.0937,-0.375 c -0.12065,-0.2056 -0.18405,-0.5123 -0.15625,-0.75 l 0.3125,-0.2187 c 0.3125,0.2124 0.45606,0.542 0.84375,0.6563 1.19482,0.3505 4.02344,-0.2945 3.5,-2.0626 -0.2915,-0.25 -0.507,-0.608 -0.5,-1 0.46094,-0.4067 1.2539,-0.059 1.6875,-0.5 l 0.0312,-0.3437 c -0.37451,-0.3096 -0.7876,-0.5137 -1.15625,-0.8125 0.0757,-0.4116 0.49512,-0.4924 0.65625,-0.8438 0.21973,-0.4768 0.007,-1.1571 0.34375,-1.5624 1.86768,-0.4886 1.85108,-0.095 3.15625,-1.6563 l 0.0312,-0.3437 c -0.67334,-0.4796 -1.96582,-1.2134 -2.75,-1.4688 -0.42236,-0.1367 -0.89209,-0.064 -1.3125,-0.2812 -0.43994,-0.2278 -0.76953,-0.6914 -1.25,-0.875 -0.91553,-0.3516 -1.59277,-0.033 -2.46875,-0.1563 -0.22412,-0.032 -3.02535,-1.5416 -3.09375,-1.6563 -0.53564,-0.8951 -0.29835,-2.6047 -0.28125,-3.625 0.37744,-0.5425 1.0249,-0.7099 1.40625,-1.2187 0.65723,-0.8765 -0.039,-1.9468 0.21875,-2.8125 0.37158,-1.2505 1.60449,-1.8003 2.3125,-2.75 1.2793,-1.7163 -0.086,-1.7316 3.15625,-3.9688 0.63525,-0.4376 1.52783,-0.2916 2.21875,-0.5624 0.88623,-0.3483 1.73144,-1.5714 2.71875,-2.0313 0.86865,-0.4043 4.86914,-0.3257 3.875,-2.375 l 0.15625,-0.3125 c 1.39551,-0.8042 2.55323,0.9235 3.46875,0.8438 0.5752,-0.4398 1.41993,-0.2836 1.90625,-0.8126 l -0.125,-0.375 -0.3125,-0.2187 c -0.42627,-0.013 -0.95655,-0.015 -1.3125,-0.2813 L 656.25,1598.25 c 0.29443,-0.6552 1.3169,-0.875 1.375,-1.6875 -0.1074,-0.2158 -0.1152,-0.5214 -0.0625,-0.75 l 0.375,-0.1875 c 1.72852,0.2437 1.65234,0.4873 3.15625,1.0625 0.28076,-0.074 1.62405,-1.0524 1.71875,-1.2813 l -0.0937,-0.375 c -0.82715,-0.8273 -1.98047,-0.3144 -2.8125,-0.9687 -0.0537,-0.2588 -0.0968,-0.5164 -0.0937,-0.7813 -0.21143,-0.3307 -0.60742,-0.4148 -0.875,-0.6874 -0.0356,-0.4497 0.83545,-1.9292 1.15625,-2.2813 0.3916,-0.2415 0.96582,-0.2665 1.40625,-0.1875 0.56982,-0.3222 0.34668,-0.8701 0.75,-1.2188 0.88525,-0.7628 4.19921,-1.4804 3.375,-4.5312 l -0.34375,-0.1875 c -0.25977,0.06 -0.64502,0.019 -0.875,-0.125 -0.3252,-0.3833 -0.4126,-0.9693 -0.5625,-1.4375 -2.0376,-1.2017 -0.18798,-2.0796 -0.4375,-3.2812 -0.48486,-0.7586 -2.02734,-1.1373 -2.34375,-1.8438 -0.53613,-1.1993 -0.27345,-2.1787 0,-3.375 0.11333,-0.4941 -0.15088,-0.9619 -0.0312,-1.4375 0.48535,-1.9282 3.33692,-1.4461 4.71875,-2.2187 l 0.15625,-0.3438 c -0.0557,-0.8002 -0.7373,-1.0664 -0.75,-2.2812 0.36035,-0.4853 1.57812,-2.831 1.4375,-3.375 l -0.25,-0.3126 c -0.25,-0.055 -0.50244,-0.144 -0.71875,-0.2812 -0.77734,-1.5879 0.24609,-2.5391 1.125,-3.7188 l -0.0312,-0.375 c -0.85498,0.3613 -1.93652,0.8609 -2.84375,0.9688 -1.19434,-0.3428 -0.49219,-3.1235 -0.84375,-4.4375 -0.47607,-1.7788 -2.71535,-5.2451 -2.78125,-5.75 -0.10742,-0.8242 0.90771,-2.2563 0.59375,-3.0625 -0.40381,-0.6055 -1.10742,-0.9087 -1.375,-1.6875 -0.47217,-1.3765 -0.12988,-5.3003 0.625,-6.5625 0.5415,-0.9063 1.3584,-1.6329 1.90625,-2.5625 0.50342,-0.8545 0.83887,-1.7236 1.53125,-2.4375 1.19238,-1.2295 3.12793,-1.7617 4.21875,-3.0625 1.30176,-1.5522 2.44238,-4.5294 4.46875,-5.9687 1.00684,-0.7152 4.1875,-2.7013 4.71875,-3.5626 0.64697,-1.0485 -0.4614,-2.7749 -0.4375,-4 0.0215,-1.0969 0.95415,-1.8818 0.96875,-2.0937 0.87598,-0.3032 5.18359,-4.206 6.25,-5 0.71777,-0.5342 1.66552,-0.7525 2.375,-1.2813 1.63574,-1.2169 2.99658,-2.5058 4.84375,-3.4374 4.51416,-2.2786 8.3418,-1.7847 12.34375,-3.0313 3.4126,-1.0625 15.28369,-6.0294 17.5,-8.4687 l -0.0625,-0.2188 c -1.625,-1.2276 -0.44824,-1.1363 -0.90625,-2.4062 l -0.25,-0.25 c -1.74512,0.5219 -3.75293,1.9768 -5.59375,1.9374 -0.51953,-0.01 -3.57813,-0.8788 -4,-1.1874 -0.66797,-0.4893 -0.88623,-1.625 -1.96875,-1.625 -0.64697,0 -1.37793,0.3282 -2.03125,0.4062 -6.07471,0.7222 -7.62255,-3.3658 -11.375,-4.9062 -1.31006,-0.5385 -2.3374,-0.7652 -3.5,-1.6563 -0.19629,-0.1504 -0.40625,-0.315 -0.65625,-0.375 -0.87598,-0.2094 -1.83936,-0.085 -2.71875,-0.4375 -0.58008,-0.233 -1.01367,-0.7405 -1.59375,-0.9688 -0.68262,-0.2672 -1.4458,-0.227 -2.125,-0.5 -0.70605,-0.2828 -1.34716,-0.8036 -2.03125,-1.0312 -1.0332,-0.3428 -2.13477,0.2715 -2.96875,-0.6875 -0.50732,-0.5835 -1.27002,-2.5073 -0.9375,-3.25 0.31494,-0.7036 1.75097,-1.2202 2.1875,-1.875 1.15186,-1.727 0.21875,-2.9502 2.75,-4.1875 2.21191,-1.081 5.01367,-0.3847 7.0625,-1.625 0.99365,-0.6015 2.13721,-1.2407 2.90625,-2.125 0.65869,-0.7578 1.01464,-2.0923 2.03125,-2.5 1.27783,-0.5132 2.73975,-0.794 4.0625,-1.3125 0.67822,-0.2657 1.23194,-0.7925 1.90625,-1.0625 0.30176,-0.1207 0.61425,-0.2565 0.9375,-0.3125 3.90723,-0.6782 8.93164,-1.311 12.78125,-0.1563 0.79785,0.2397 1.64551,0.8385 2.4375,1.1563 1.08936,0.437 2.10937,0.7295 2.84375,1.75 0.52344,0.7271 0.38965,1.5566 0.625,2.3437 1.00195,0.7736 3.24315,-0.3759 3.15625,1.875 l 0.21875,0.25 c 0.85889,0.089 1.18799,0.086 1.46875,0.1876 0.27295,0.1 0.52148,0.311 1.1875,0.7812 0.0147,0.9009 -1.54248,1.5578 -1.75,2.2188 -0.13042,0.4152 0.067,0.9253 0.0312,1.3437 -0.14648,1.73 -2.38525,4.0894 -1.4375,5.75 0.38721,0.6782 2.5669,1.6299 3.3125,2.3437 1.99268,1.9108 2.49073,4.8663 5.78125,5.375 2.36426,0.3663 2.97949,-1.5217 4.625,-1.75 1.50195,-0.2092 3.08642,0.1282 4.65625,-0.094 3.63037,-0.5132 7.42724,-1.5134 11.03125,-2.2813 1.0835,-0.2306 2.42774,-0.068 3.4375,-0.5 0.18066,-0.077 0.35791,-0.2436 0.5,-0.375 0.56006,-0.5148 0.85693,-1.2254 1.46875,-1.6874 0.30908,-0.2342 0.80127,-0.4463 1.0625,-0.6876 l 0.40625,-0.4062 c 1.581,-1.8882 -0.0747,-2.164 0.0312,-3.875 0.0855,-1.373 2.78222,-4.6345 3.1875,-6.4062 0.71875,-3.1409 -1.09034,-10.9596 -0.9375,-14.75 0.0762,-1.8748 0.97656,-3.8203 0.46875,-5.7188 -1.01709,-3.7988 -2.80859,-3.7706 -4.25,-5.8438 -1.25977,-1.8102 -3.09228,-7.0756 -4.4375,-9.5937 -1.75098,-0.5894 -2.34033,-0.2124 -4.09375,0 -4.23975,0.5132 -4.81885,0.4877 -8.3125,2.9687 -0.85791,0.6101 -1.64209,1.1837 -2.65625,1.5313 -2.39355,0.8199 -4.93946,1.5061 -7.375,2.2813 -1.66895,0.5304 -3.27344,1.4815 -4.9375,2 -0.91943,0.2862 -6.52685,0.6536 -7.65625,0.625 -0.21094,0.082 -0.44095,0.2916 -0.53125,0.5 0.8418,2.9289 12.3706,-0.012 15.375,1.9062 0.90186,0.5761 1.01318,0.9764 1.53125,1.8438 1.17627,1.9653 0.54102,1.7045 -0.53125,2.9062 l -0.0312,0.3125 c 1.97021,1.5362 0.52539,3.3991 -1.09375,4.4063 -0.80811,0.5022 -1.48877,1.397 -2.3125,1.75 -0.76123,0.3253 -7.62988,-0.2999 -8.625,-0.5626 -0.75586,-0.1989 -2.01905,-0.849 -2.75,-0.6874 -0.87158,0.1916 -1.55908,1.2676 -2.5625,1.5937 -0.66113,0.2149 -5.63574,0.5478 -6.1875,0.375 -1.03467,-0.3247 -1.042,-0.774 -2.40625,-0.7187 -1.36182,0.055 -4.69726,0.4269 -5.875,0 -1.46289,-1.3021 1.06738,-3.3257 1.84375,-4.2188 0.78369,-0.9013 1.22608,-2.3135 2.0625,-3.3125 0.93457,-1.1162 3.96875,-3.0063 4.375,-3.75 -0.21924,-0.6128 -1.16504,-0.803 -1.71875,-0.9687 -4.13916,-1.2428 -4.18994,0.6327 -6.8125,0.2187 -1.35938,-0.2144 -2.57617,-1.6152 -3.78125,-1.875 -1.13281,-0.2441 -2.4961,0.188 -3.6875,0 -1.86914,-0.2949 -3.14453,-1.8697 -5.0625,-2.1563 -1.27197,-0.1893 -2.81299,2e-4 -3.9375,-0.7187 -1.84033,-1.1757 -6.73584,-4.6284 -7.71875,-6.4375 -0.54688,-1.0054 -0.58545,-2.1484 -1.28125,-3.1562 -0.72044,-1.0447 -1.29318,-1.8734 -1.71875,-2.5938 l -0.375,0.062 c -1.08496,-0.1855 -2.61133,-0.625 -3.6875,-0.625 z",
						"sanluis":"M 540.8125 737.4375 C 540.53467 737.4507 540.20361 737.45291 539.9375 737.5625 C 538.65479 738.09155 539.17334 740.00757 539.46875 741.34375 C 539.7417 742.57983 540.15918 743.84228 539.875 745.125 C 541.34766 747.94141 538.59961 749.8479 539 752.625 C 539.45312 755.77051 539.76073 755.69751 539.09375 759.0625 C 539.66797 761.79175 539.7793 760.23243 539.28125 763.46875 C 538.72949 767.05859 539.67823 770.32373 540.59375 773.6875 C 541.95898 774.44531 542.76758 775.25586 543.125 776.8125 L 543.21875 777.40625 C 543.7168 779.94824 544.80273 779.92139 544.8125 783.125 C 544.8175 784.89697 546.13965 784.92187 546.5 787.8125 C 546.70459 789.45605 546.75538 791.3628 547.28125 792.9375 C 548.59033 793.74438 549.63671 794.4458 549.78125 796.0625 L 549.8125 796.53125 C 549.8467 796.81689 549.91602 797.19507 550.125 797.75 L 550.53125 798.28125 C 552.17871 800.49243 549.57178 801.97974 549.53125 802.6875 C 549.45505 804.021 550.25 805.59888 550.5 806.9375 L 550.53125 807.25 C 550.48485 808.90845 549 809.927 549 810.6875 C 549 812.36133 551.64063 812.87085 550.65625 816.53125 C 550.53564 816.97998 550.37402 817.40869 550.3125 817.84375 C 550.98389 819.87646 551.64942 819.82861 551.28125 822.46875 C 550.81348 825.81982 552.54834 826.72022 551.15625 830.03125 C 550.67041 831.18701 551.89014 832.96363 551.875 835.09375 C 551.856 837.70776 553.9043 837.95312 553.21875 842.5 C 552.89307 844.65918 553.16695 844.21241 554.09375 846.09375 C 555.83887 849.63721 557.65235 852.71289 560.15625 855.75 C 562.94287 859.12988 561.7627 861.0896 562.875 862.8125 L 563.125 863.1875 C 565.5083 867.04736 564.08448 870.72876 568.1875 873.28125 C 574.32275 877.09839 570.87109 878.85034 573.96875 881.71875 C 574.44971 882.16406 575.07471 882.74219 575.96875 883.6875 L 576.21875 884.0625 C 576.375 884.41455 576.42626 885.01806 576.25 885.59375 L 576.125 885.90625 C 578.01221 887.97949 577.31738 889.27344 576.96875 891.53125 C 576.61719 893.80518 576.83887 894.06934 576.84375 896.0625 C 576.84675 897.4292 576.08447 898.80957 573.96875 898.75 L 573.6875 898.53125 C 573.53223 899.10498 573.2544 899.74072 572.75 899.96875 C 572.8315 901.68066 574.59912 900.93701 573.6875 904.71875 C 573.5898 905.12354 573.26562 906.19727 573.3125 906.59375 C 574.15527 908.36133 574.31055 908.03418 573.5625 909.90625 C 575.07764 912.21167 575.99024 912.03784 575.96875 915.5 C 575.96375 916.27539 575.91065 917.05322 575.90625 917.84375 C 575.90525 918.15137 577.36035 924.09522 577.40625 924.1875 C 578.06543 925.50488 579.58447 925.65869 580.6875 928.4375 C 581.70996 931.01221 583.63477 935.28564 585.65625 937.09375 C 586.96631 938.26465 589.59375 946.90283 589.59375 948.28125 C 589.59375 949.47705 588.8833 951.05811 589.09375 952.09375 C 589.88477 955.98682 592.18115 959.05517 591.03125 963.09375 C 590.83789 963.77295 590.59033 964.44336 590.5625 965.15625 C 590.5947 965.22215 590.67773 965.40576 590.71875 965.46875 L 590.9375 965.75 L 591.1875 966.125 C 591.55469 966.67432 591.8125 967.29395 591.8125 967.96875 C 591.8125 969.16699 591.35547 969.90283 590.84375 970.40625 L 590.625 970.59375 L 590.71875 970.9375 C 591.17236 972.80713 591.90869 975.03027 591.25 976.9375 C 590.96387 977.76611 590.8125 978.22949 590.8125 978.84375 C 590.8125 982.83545 591.24463 986.70704 589 990.21875 C 587.63623 992.35303 588.49121 995.37793 588.1875 997.8125 C 587.76025 1001.2368 586.64551 1004.5222 585.5625 1007.7812 C 585.43994 1008.1504 585.43654 1008.4814 585.5 1008.9688 L 585.625 1009.8438 C 585.96729 1012.4561 584.67871 1012.539 584.78125 1013.9062 L 584.8125 1014.3438 C 584.856 1015.793 584.19043 1016.0459 583.75 1017.125 C 583.773 1017.2519 584.979 1019.2602 585.09375 1019.4375 L 583.625 1019.5 C 594.06006 1019.518 673.67089 1019.5054 673.96875 1019.6562 C 674.02585 1002.7153 674.37156 957.3584 674.03125 951.71875 C 674.11765 935.36182 674.03285 919.01245 674.09375 902.65625 C 674.12065 895.52075 674.41354 888.25512 674 881.125 C 673.28516 868.79492 672.68359 856.45508 671.96875 844.125 L 671.53125 835.8125 C 671.22559 830.25537 670.5542 830.8706 673.0625 826.375 C 673.30859 825.93481 673.43604 825.43408 673.75 825.03125 C 674.54443 824.01172 676.77099 824.69482 677.375 823.65625 C 677.83691 822.43799 675.75147 820.81128 676.65625 819.4375 C 681.42383 812.20044 676.35059 815.79345 678.8125 811.21875 L 680.21875 808.59375 C 681.65771 805.91919 680.4873 806.06202 680.9375 804.03125 C 681.18896 802.896 682.04443 802.28906 682.3125 801.34375 C 682.56104 800.46533 682.01657 799.23267 682.21875 798.65625 C 682.47412 797.92725 683.11768 797.63526 683.71875 797.21875 C 684.16504 796.90967 684.34277 795.56885 684.40625 795.0625 C 684.49075 792.59082 685.33496 792.57569 685.9375 790.71875 C 686.46484 789.09521 686.05127 789.03784 686.125 787.59375 C 686.1699 786.71655 686.73975 786.12451 686.59375 785.15625 C 686.47607 784.37988 686.05518 783.89648 685.875 783.1875 C 685.66797 782.37012 685.87059 780.97583 685.375 780.3125 C 685.05371 779.88208 683.76953 778.36377 683.71875 777.78125 C 683.40527 774.1853 686.99902 766.18139 680.5625 767.96875 C 678.22363 768.61816 676.34619 769.4419 673.84375 769.65625 C 673.7041 769.66825 673.54639 769.6171 673.40625 769.625 C 672.33447 769.6853 668.52832 770.60571 667.625 770.15625 C 666.47607 768.93066 667.91162 765.81445 666.96875 764.53125 C 663.93945 760.40796 665.70703 757.31665 664.3125 755.40625 C 663.84814 754.77075 662.90479 754.51562 662.375 753.90625 C 661.17969 752.53198 661.4956 752.2749 659.71875 751.21875 C 653.67871 747.6272 647.62891 744.07007 641.59375 740.46875 C 640.52588 739.83154 635.35938 740.10132 634.28125 740.0625 C 632.73975 739.90088 629.18555 740.89477 627.78125 741.4375 C 627.60156 741.24194 624.79443 740.9868 624.3125 741 C 620.88379 738.18799 618.74609 738.66259 614.59375 739.625 C 610.74121 740.51807 610.36572 742.47754 604.65625 743.21875 C 603.37451 743.38525 601.91064 742.43457 600.875 742.65625 C 599.94824 742.85474 599.78418 743.7019 598.25 743.5625 C 597.21533 743.4688 595.95996 742.0681 595.21875 742 C 593.83838 741.87305 592.47852 742.5837 591.09375 742.5625 C 590.01172 742.5464 589.54883 741.22657 588.46875 741.125 C 587.28809 741.0144 586.60596 742.69995 585.21875 742.3125 C 583.63135 741.8689 582.22558 740.41309 580.59375 739.875 C 579.25146 739.43315 578.1084 739.7395 576.9375 739.46875 C 576.49157 739.45417 576.13011 739.56364 575.71875 739.65625 C 573.33203 740.19458 571.15625 740.11231 568.71875 740.21875 C 565.28809 740.36938 562.8501 740.64722 559.625 739.875 C 558.33301 739.56519 558.25781 738.03076 555.3125 737.71875 C 554.00098 737.57959 552.40723 738.43506 551.09375 738.71875 C 550.01123 738.95215 548.41748 738.90918 547.28125 738.875 C 544.99365 738.8062 543.00098 737.33227 540.8125 737.4375 z ",
						"neuquen":"m 359.8125,1024.8125 c -0.10674,0.3724 -0.16479,0.7414 -0.21875,1.0937 0.0524,-0.3526 0.11203,-0.7214 0.21875,-1.0937 z m -0.21875,1.0937 c -0.14306,0.9342 -0.16921,1.786 -0.34375,2.625 0.17176,-0.8378 0.20504,-1.6918 0.34375,-2.625 z m -9.25,2.0313 c -0.20361,0.083 -0.41797,0.209 -0.5625,0.375 -0.14206,0.4302 0.12965,2.4708 0.0312,2.5937 -1.40478,1.7556 -1.50464,1.4158 -2.5,2.4376 -1.42798,1.4655 0.40454,1.9936 -2.90625,2.2812 l -0.15625,0.031 c -0.36474,0.3626 -1.58225,0.5308 -1.65625,1.1563 -0.1001,0.7012 0.60547,1.5342 0.5,2.6875 -0.0544,0.5977 -1.45337,1.6145 -0.84375,2.5312 0.2771,0.4167 1.31299,2.0029 1.6875,2.1563 0.82983,2.9707 -2.75024,4.4375 -4.625,2.375 l -0.9375,-0.094 c -0.20777,0.3333 -0.8103,0.676 -1.09375,1 l -0.4375,-0.125 c -0.20898,-0.3234 -0.71265,-0.9183 -1.09375,-1.0626 -0.70971,-0.096 -3.90625,-0.8124 -3.90625,-0.8124 -0.18653,-0.01 -0.40527,0.1076 -0.53125,0.25 l -0.15625,0.4687 c 1.80786,3.3467 -1.21143,4.743 -3.71875,6.1563 -1.76709,-0.2435 -2.89087,-2.2581 -4.65625,-1.25 -0.0483,0.092 -0.20485,0.3132 -0.21875,0.4062 -0.27612,1.8155 -0.94604,6.921 -0.75,8.6562 0.12158,1.0793 1.16772,2.5662 1.6875,3.5 0.32105,0.5774 -1.09131,2.1873 -1.4375,2.5 -0.63404,0.071 -0.7478,0.8384 -1.59375,0.4063 -0.67847,-0.73 -0.61646,-1.8125 -1.125,-2.25 -0.32251,-0.1805 -0.81104,-0.2956 -1.125,-0.031 -0.38657,0.2668 -0.40025,3.4048 -0.40625,3.9688 -0.0115,1.0224 -1.03735,4.5663 -0.625,5.0938 -0.6853,2.4556 -3.52173,2.6922 -2.15625,4.75 0.66577,0.05 1.18359,-0.3884 1.875,-0.3126 L 317.25,1078 l 0.0937,0.4688 c -0.36548,0.7786 -0.8572,1.726 -0.9375,2.5937 -0.0935,1.0073 3.67627,1.5199 2.03125,3.6563 -0.24072,0.3127 -0.48486,0.707 -0.84375,0.9062 -1.34571,0.165 -3.24829,-1.3935 -4.59375,-0.25 l -0.15625,0.3438 0.15625,0.375 c 0.68018,0.4607 1.85254,1.0424 2.625,1.3437 2.198,3.5742 -0.52051,4.1189 3.21875,6.4063 0.21777,0.133 0.55985,0.2724 0.53125,0.5937 -0.5979,1.1362 -2.64111,1.3773 -2.96875,2.4063 -0.82251,2.5833 1.91431,1.868 -1.9375,7.625 -0.52319,0.7817 -1.46533,1.2031 -2,1.9687 -0.83204,1.1904 0.38647,2.4656 0.71875,3.4687 0.2959,0.8939 0.45435,1.8909 0.6875,2.8126 l -0.0312,0.1874 c 0.60766,1.0837 2.83203,2.7545 3.125,3.4063 0.52343,1.1651 1.3313,2.4266 0.90625,3.7813 -0.35571,1.1322 -2.15259,1.8229 -1.875,3.1874 0.36573,0.7444 0.97095,1.251 1.25,2.0626 0.91113,2.6472 -2.10962,2.4804 -2.90625,3.6562 -0.34644,0.5107 -0.63477,1.145 -0.9375,1.6875 -0.0554,0.1 -0.1008,0.2632 -0.125,0.375 -0.0884,0.4106 -0.52975,2.2017 -0.46875,2.5625 0.14526,0.8614 2.42773,4.5926 2.9375,5.2188 0.0222,0.6132 -0.24976,1.1567 -0.125,1.7812 0.1626,0.813 0.92676,1.4651 1.125,2.4062 -0.60693,0.5329 -3.19605,2.6285 -3.21875,3.0313 l 3.25,1.5937 c 1.86621,0.909 0.90625,3.0606 1.71875,4.4688 0.32813,0.5683 2.44385,2.8217 2.5625,3.2188 0.40894,1.366 0.78516,3.0208 1.53125,4.25 0.38794,0.6389 2.3852,1.8686 2.375,2.4374 -0.0698,1.0139 -2.17065,0.9034 -2.625,1.8438 -0.42822,1.5435 1.50295,1.6898 1.53125,2.8438 0.0461,1.8763 -1.11865,3.7034 -1.15625,5.625 -0.0308,1.5607 1.04295,3.2968 1.09375,5.0312 0.0891,3.0527 0.20044,5.688 2.40625,7.9688 0.53394,0.5519 1.57642,0.6951 2.0625,1.25 0.75976,0.8668 1.03711,1.8419 2,2.5624 1.74805,1.3089 3.6084,1.781 4.4375,4.0626 0.84937,2.3361 -3.396,4.9038 -4.125,6.7187 -0.33154,0.8247 0.68335,1.2758 0.4375,2.3437 -1.18604,1.7526 -3.35107,4.7435 -5.78125,4.5 -0.47363,-0.047 -0.95776,-0.3777 -1.5625,-0.625 -0.35742,-0.064 -0.91064,-0.1922 -1.15625,-0.5 -1.83007,-0.2643 -4.34082,1.7647 -5.84375,2.6563 -0.8623,0.5118 -2.75098,1.7 -3.40625,2.2813 -0.65796,0.2443 -1.80835,-0.6263 -2.71875,-0.5313 -0.39868,0.3433 0.24512,1.8238 -1.53125,3.0937 -1.5791,1.1292 -8.7146,4.0904 -9.46875,5.3438 -0.23242,0.3862 0.54541,1.7041 0.71875,2 -0.156,0.2032 -0.5493,0.8139 -0.5,1.0938 0.14477,0.3034 0.62455,0.8183 0.65625,1.0937 -0.12081,0.2314 -0.007,0.7094 0.0625,0.9375 -0.38135,0.8618 -1.0459,1.1865 -1.5,1.9375 -0.25904,1.0508 0.97485,2.6128 1.21875,3.6875 0.23486,1.0337 -0.4104,2.3252 -0.1875,3.5 0.42651,2.2452 1.39136,2.9795 1.875,4.5625 0.2793,0.914 -0.41211,2.2011 -0.59375,3.125 -0.1582,0.8047 0.7312,1.2305 0.6875,2.125 -0.10059,2.0645 -2.13184,5.0957 -4.03125,5.9375 -0.16897,0.1821 -0.2588,0.5698 -0.1875,0.8125 -0.36499,0.4419 -1.14551,1.3141 -0.84375,1.9687 0.54101,0.4968 2.03491,0.9962 1.28125,2 -0.21363,0.2854 -0.53931,0.3895 -0.65625,0.75 -0.27466,0.85 0.003,1.8565 -0.59375,2.5938 -0.27978,0.3457 -4.86792,1.1191 -3.5625,3.1562 0.1919,0.1936 2.00732,1.2084 2.25,1.1876 1.22485,1.0447 0.83179,4.0366 -0.4375,4.7187 -0.99951,-0.056 -1.79761,-0.4017 -2.75,-0.4687 -1.08813,-0.076 -2.4939,0.7893 -3.59375,0.5 l -0.3125,-0.1563 c -1.27344,-1.878 -1.50464,-3.1572 -4,-3.5313 -1.3086,-0.1964 -1.35575,2.5789 -1.40625,3.25 -0.12378,0.181 -0.44214,0.6388 -0.65625,0.7188 -0.78198,1.8203 2.10695,2.0326 2.09375,3.5938 -0.44898,0.7871 -1.85275,1.9311 -1.84375,2.7187 0.0557,0.6646 1.20435,1.6084 1.46875,2.375 0.50684,1.4702 -0.80957,5.2639 0.28125,6.2813 0.13184,0.1229 0.24976,0.2537 0.40625,0.3437 0.12085,0.07 0.20532,0.1563 0.34375,0.1563 0.47437,0.01 1.78198,-0.523 2.09375,-0.094 0.0625,0.3393 0.031,0.73 -0.0625,1.0625 l 0.125,0.2813 c 0.62939,0.2649 2.47266,0.957 2.625,1.4687 0.0251,0.7641 -0.37231,1.7296 -0.5625,2.4687 -0.0464,0.181 -0.948,2.1031 -1.125,2.2188 -0.14258,0.093 -0.76245,0.3475 -0.84375,0.4375 -0.89697,0.9926 -1.14648,1.7901 -2.28125,2.625 -0.24244,0.1782 -0.53735,0.7234 -0.8125,0.9687 -0.5498,1.2985 1.23295,2.4859 1.15625,3.7813 -0.23926,0.4756 -0.24878,1.0204 -0.375,1.5313 -0.57886,0.2468 -1.09155,0.6787 -1.75,0.7187 -0.84717,0.051 -1.60742,-0.6871 -2.28125,-1.0625 -0.5708,-0.3184 -1.37964,-0.2521 -1.875,-0.5312 -0.32544,-0.1839 -0.73877,-0.6248 -1.03125,-0.875 -0.97607,-0.1526 -2.10083,0.6932 -1.84375,1.75 l 0.28125,0.1562 c 0.1814,-0.172 0.57861,-0.2295 0.8125,-0.1875 l 0.25,0.1563 c 0.62256,1.6717 -1.12185,3.3749 -1.15625,4.4062 0.14234,0.4072 1.03975,1.2527 0.96875,1.4688 -0.24243,0.761 -1.46533,1.2828 -1.8125,2.0624 l 0.0625,0.25 c 0.37232,0.362 1.54468,1.0058 2.03125,1.0938 0.33008,0.5088 0.5437,1.1101 0.875,1.5938 0.25512,0.3719 0.85449,0.4238 1.125,0.8437 0.28296,0.439 0.16479,1.1389 0.375,1.6563 0.36792,0.4748 1.2417,0.5722 1.6875,0.1562 0.27906,-0.3379 0.4604,-1.1158 0.5,-1.5312 l 0.3125,-0.063 c 3.00728,1.8741 2.05103,1.7432 3.09375,4.6563 0.14892,0.415 0.4619,0.7759 0.375,1.25 -0.28662,0.7774 -1.52026,0.9648 -1.65625,1.3125 l -0.1875,0.9375 c -0.63281,0.6133 -1.65723,2.2991 -2,2.4687 -2.49829,0.3802 -4.08789,-5.0344 -5.75,-0.25 -0.20044,0.5774 -0.39087,1.0743 -0.5625,1.6563 -0.63379,2.1479 -0.84863,4.1414 -1.28125,6.2813 -0.0383,0.1897 -0.0625,0.7073 -0.28125,0.8124 -0.51197,-0.1916 -1.04687,-0.3688 -1.53125,-0.625 l -0.25,0.2813 c 0.7085,0.9648 2.04541,1.6263 2.625,2.5937 2.04126,3.4081 -4.46118,6.8455 -6.34375,9.0626 -0.27002,1.7429 1.39868,3.2499 2.15625,4.7187 0.39392,0.7641 0.04,1.6889 0.375,2.4375 0.89136,1.9926 3.55933,6.0653 2.96875,8.2188 -0.56739,0.8982 -1.66797,0.5146 -2.375,1.1562 l -0.0625,0.375 c 0.13376,0.5385 0.89023,1.3573 1.6875,2.2188 l 0.125,0 c 2.57178,-0.2639 6.12451,0.2184 8.65625,0.5 1.08301,0.1199 1.97217,0.9398 3.03125,1 1.80396,0.1014 3.64209,-0.5069 5.4375,-0.2813 4.33765,0.5449 7.29004,2.9033 11.0625,3.75 2.75537,0.6186 5.47656,1.0586 8.28125,0.4375 1.30005,-0.288 2.5,-2.1562 2.5,-2.1562 1.00049,-1.2615 2.18555,-0.9963 3.21875,-2.5 2.28076,-3.3196 6.18774,-3.9322 5.125,-8.9063 -1.12061,-5.2461 -6.20166,-3.0566 -3.6875,-10.625 0.4541,-1.3662 2.23975,-1.5937 3.46875,-1.5937 0.71436,-0 1.20508,-0.1107 1.75,-0.5626 1.03345,-1.6374 0.96387,-3.8665 3.21875,-4.625 3.23633,-1.0886 5.84619,-3.2895 9.1875,-4.2812 0.1294,-0.038 0.14258,0.012 0.25,-0.031 l 1,-0.375 c 3.07666,0.046 2.4917,-0.5782 4.1875,-0.7813 0.30762,-0.037 0.62402,-0.017 0.9375,0.062 l 0.65625,0.4375 c 0.58398,0.1284 3.02124,-0.2842 3.6875,-0.625 2.3877,-2.7437 7.09814,-6.222 10.9375,-4.6563 6.55884,2.6745 2.93286,0.6364 7.90625,-0.25 2.36304,-0.4207 4.97754,-0.4151 7.21875,-1.3124 l 0.3125,-0.125 c 0.27588,-1.9085 -0.4519,-4.6704 2.28125,-5.1563 6.24829,-1.1108 4.61743,-5.227 5.15625,-10 0.29175,-2.5854 3.64648,-3.9709 5.3125,-5.4687 l -0.21875,-0.4063 c -0.79053,-1.5229 -2.03906,-2.542 -2.78125,-4.125 L 381.875,1297 c -0.25733,-0.814 -0.10767,-2.2509 0.15625,-2.9375 2.39819,-6.2397 3.5249,-8.4445 9.9375,-10.7187 1.48071,-0.5254 2.86548,-1.3216 4.34375,-1.875 3.35376,-1.2557 7.03516,-1.9193 10.1875,-3.625 2.66162,-1.4407 6.06079,-0.9025 8.21875,-2.5 1.31836,-0.9769 2.45386,-2.1993 3.875,-3.0313 6.2644,-3.666 3.89087,-9.3088 11.90625,-11.7187 2.64209,-0.7942 1.77124,-3.0443 6.3125,-3.0313 3.90674,0.012 2.01172,-0.126 4.78125,-1.1875 3.55469,-1.3628 4.01611,-1.1587 5.3125,-5.125 0.93066,-2.8462 4.99023,-2.6787 5.28125,-4.3125 1.0166,-5.7119 1.40771,-4.7112 6.59375,-8.0937 4.42334,-2.8859 3.25977,-6.3737 7.1875,-9.375 2.01953,-1.5435 2.87354,-2.7252 5.59375,-3.2813 1.15674,-0.2363 2.021,-0.5052 3.03125,-1.1563 l 0.28125,-0.125 4.84375,-1.8124 c 2.56347,-0.9524 1.22607,-2.7363 7.15625,-2.7813 0.36573,-0.9654 0.1977,-10.926 0.1875,-12.7187 -0.0977,-17.3514 0.24365,-34.7102 0.125,-52.0626 -0.0518,-7.5027 0.0732,-15 0.0312,-22.5 -0.011,-1.9125 -0.0919,-3.8836 -0.0312,-5.8124 -1.2694,-0.019 -2.29667,-0.6337 -3.5,-0.75 -1.63184,-0.1596 -3.27979,-0.3215 -4.90625,-0.5626 l -0.34375,0.063 c -4.52198,0.6251 -5.25293,-4.5728 -7.28125,-7.0313 -0.44971,-0.1983 -2.50684,0.25 -3.15625,0.25 -0.94629,0 -1.61865,-0.3042 -2.125,-0.625 l -0.5625,-0.375 c -0.15088,-0.097 -0.2959,-0.1609 -0.4375,-0.2187 -4.19091,-0.4155 -3.43506,1.5517 -6.90625,-2.9063 -0.50879,-0.6533 -1.14746,-1.1005 -2.21875,-1.1875 -2.4082,0.3282 -3.06787,1.5234 -5.875,1.0625 -2.26416,-0.3721 -4.5498,-0.9243 -6.75,-1.5625 -5.11182,-1.4834 -3.33496,-7.2733 -5.25,-9.5312 -1.72022,-2.0281 -7.48291,-3.1296 -10.1875,-4.5626 -2.17627,-1.1525 -7.43091,0.7203 -9.65625,1.2813 l -0.46875,0.094 c -3.04638,0.5716 -9.85742,-0.4723 -12.5,-1.5624 -2.66089,-1.0981 -7.01514,-4.209 -8.625,-6.7813 -0.44726,-0.7148 -2.71069,-3.6421 -2.875,-4.1875 -0.41333,-1.3706 0.87183,-3.0103 1.53125,-4.0625 0.37231,-0.5938 0.13452,-5.0102 -0.28125,-6.4687 l -0.28125,-0.625 c -1.55005,-0.2437 -3.07642,-1.2379 -3.78125,-2.7813 -1.16162,-0.3345 -2.29761,-1.1049 -2.78125,-2.25 0.0967,-1.1093 -0.18677,-2.0556 -0.625,-3.0625 -1.63574,-3.7622 -5.45312,-3.0732 -5.125,-5.6875 l -0.125,-0.1875 c -0.20874,-0.2803 -1.48413,-1.0639 -2.15625,-1.9688 -1.6897,-0.7471 -3.93848,-0.79 -5.46875,-1.75 -0.80908,-0.5073 -3.17603,-4.4465 -3.5,-5.4374 -0.1709,-0.5238 -1.04688,-4.5537 -1.25,-5.5313 l -0.34375,-1.7187 c -0.34888,-1.68 -1.42847,-3.1473 -3.3125,-2.6876 -0.5,0.1223 -0.74097,1.1802 -1.53125,1.4688 -2.01709,-0.1856 -2.48267,-2.5008 -3.09375,-4.0312 -1.33007,-3.3335 0.9209,-3.3292 1.125,-4.2188 0.49927,-2.1763 0.48169,-5.0483 -1.25,-6.6875 -0.56592,-0.5361 -1.3147,-1.3936 -2.125,-1.5625 -0.15877,0.5942 -0.43622,1.1711 -0.90625,1.75 l -0.0937,0.1875 c -2.54956,1.7754 -5.30859,-2.7198 -7.84375,-2.875 z",
						"rionegro":"m 489.28125,1127.0625 c -0.67031,0.042 -1.35342,0.1658 -2.03125,0.1563 -0.0216,0 -0.0411,0 -0.0625,0 -0.0607,1.9284 0.0202,3.9003 0.0312,5.8124 0.042,7.5 -0.0831,14.9973 -0.0312,22.5 0.11865,17.3524 -0.2227,34.7107 -0.125,52.0626 0.0102,1.7922 0.17823,11.7533 -0.1875,12.7187 -5.93018,0.045 -4.59278,1.8285 -7.15625,2.7813 l -4.84375,1.8124 -0.28125,0.125 c -1.01025,0.6513 -1.87451,0.92 -3.03125,1.1563 -2.72021,0.5561 -3.57422,1.7378 -5.59375,3.2813 -3.92773,3.0009 -2.76416,6.4891 -7.1875,9.375 -5.18604,3.3822 -5.57715,2.3818 -6.59375,8.0937 -0.29102,1.6338 -4.35059,1.4663 -5.28125,4.3125 -1.29639,3.9663 -1.75781,3.7622 -5.3125,5.125 -2.76953,1.0615 -0.87451,1.1995 -4.78125,1.1875 -4.54126,-0.013 -3.67041,2.2369 -6.3125,3.0313 -8.01538,2.4094 -5.64185,8.0527 -11.90625,11.7187 -1.42114,0.832 -2.55664,2.054 -3.875,3.0313 -2.15796,1.5971 -5.55713,1.0588 -8.21875,2.5 -3.15234,1.7056 -6.83374,2.3689 -10.1875,3.625 -1.47827,0.5534 -2.86304,1.3496 -4.34375,1.875 -6.4126,2.2737 -7.53931,4.479 -9.9375,10.7187 -0.26392,0.6866 -0.41358,2.1235 -0.15625,2.9375 l 0.0625,0.1875 c 0.74219,1.583 1.99072,2.6021 2.78125,4.125 l 0.21875,0.4063 c -1.66602,1.4973 -5.02075,2.8833 -5.3125,5.4687 -0.53882,4.773 1.09204,8.8892 -5.15625,10 -2.73315,0.4859 -2.00537,3.2473 -2.28125,5.1563 l -0.3125,0.125 c -2.24121,0.8969 -4.85571,0.8922 -7.21875,1.3124 -4.97339,0.8868 -1.34741,2.925 -7.90625,0.25 -3.83936,-1.5652 -8.5498,1.9126 -10.9375,4.6563 -0.66626,0.3408 -3.10352,0.7534 -3.6875,0.625 l -0.65625,-0.4375 c -0.31348,-0.079 -0.62988,-0.1 -0.9375,-0.062 -1.6958,0.2031 -1.11084,0.8269 -4.1875,0.7813 l -1,0.375 c -0.10742,0.042 -0.1206,-0.01 -0.25,0.031 -3.34131,0.9917 -5.95117,3.193 -9.1875,4.2812 -2.25488,0.7589 -2.1853,2.988 -3.21875,4.625 -0.54492,0.452 -1.03564,0.5626 -1.75,0.5626 -1.229,0 -3.01465,0.2275 -3.46875,1.5937 -2.51416,7.5684 2.56689,5.3789 3.6875,10.625 1.06274,4.9741 -2.84424,5.5862 -5.125,8.9063 -1.0332,1.5036 -2.21826,1.2382 -3.21875,2.5 0,0 -1.19995,1.8682 -2.5,2.1562 -2.80469,0.6211 -5.52588,0.1811 -8.28125,-0.4375 -3.77246,-0.8467 -6.72485,-3.2051 -11.0625,-3.75 -1.79541,-0.2256 -3.63354,0.3827 -5.4375,0.2813 -1.05908,-0.061 -1.94824,-0.8806 -3.03125,-1 -2.53174,-0.2821 -6.08447,-0.7643 -8.65625,-0.5 l -0.125,0 c 1.07856,1.1653 2.2466,2.4293 2.1875,3.375 -1.24268,1.9441 -0.96265,1.0825 -0.59375,3.2812 0.0305,0.1817 -0.14355,3.572 -0.28125,3.9062 0,0 -1.14282,0.012 -1.5,-0.1562 l -0.4375,0.094 -0.15625,0.375 c 0.009,1.2156 1.76538,3.4505 2.125,5.25 0.26783,1.3405 -1.5498,3.4948 -1.5,4.9374 -0.63793,0.6311 -1.42554,1.3282 -2.15625,1.8438 l -0.125,0.8125 c 2.00855,2.2319 1.33325,0.834 2.25,3.6875 0.16822,0.5239 0.50757,0.98 0.6875,1.5 0.64673,1.8706 -0.54858,3.9009 0.1875,6.125 0.40283,1.2178 1.84912,1.8022 2.0625,3 -0.0811,0.2919 -1.73901,1.6499 -2.125,2.125 -0.045,0.2006 -0.053,0.4248 -0.0312,0.625 0.15308,1.4121 1.28247,1.535 1.625,2.9062 0.26587,1.0663 -0.21045,2.815 0.0937,3.5938 0,0 1.09961,-0.412 1.6875,-0.5 0.93896,1.3614 1.26538,4.8407 2.0625,6.5938 0.30371,0.6678 0.9292,1.128 1,2.0624 -1.32886,1.7307 -0.90259,2.7584 -0.6875,4.7813 l 0.375,3.4375 c 0.13793,1.296 -0.52531,2.4308 -0.71875,3.4688 130.50627,0.2299 261.02278,0.076 391.53125,-0.031 1.07617,0 2.60254,0.4395 3.6875,0.625 l 0.375,-0.062 c -1.31916,-2.2331 -1.21076,-3.453 0.40625,-7.0625 0.81348,-1.8159 1.62988,-3.6582 2.5,-5.4375 0.37793,-0.7725 1.491,-2.7163 1.5,-3.5 -0.32031,-0.6518 -0.84814,-1.2061 -1.15625,-1.875 -1.08838,-2.3633 -1.67773,-5.8545 -0.75,-8.3438 0.28955,-0.7768 0.88818,-1.419 1.15625,-2.25 0.34277,-1.0612 0.31348,-2.1139 0.5,-3.1874 0.1386,-0.7953 0.28423,-1.6947 0.0937,-2.5 -0.29297,-0.2319 -0.37988,-0.5657 -0.6875,-0.8126 -1.59521,-1.2778 -3.61865,-2.2392 -4.09375,-4.5312 -0.24121,-1.1655 -0.13672,-2.5438 -0.59375,-3.6562 -0.70166,-1.7096 -1.35888,-2.7222 -1.46875,-4.6563 -0.1499,-2.6445 -1.73388,-4.9937 -2.375,-7.5 -0.49854,-1.9512 -1.80025,-11.3372 -1.84375,-13.3437 -0.0952,-4.3696 2.18848,-5.7519 2.65625,-8.3126 -0.10943,-0.3737 -0.20896,-1.3735 0.0312,-1.7812 0.25635,-0.4356 6.53662,-5.0381 7.1875,-5.1875 1.64697,-0.3789 5.28711,0.5095 6.28125,-0.2187 l 0.0937,-0.375 C 684.09668,1342.6454 683.6919,1342.822 683,1342.75 l -0.1875,-0.2188 c -0.0967,-0.9266 0.77,-1.0017 0.8125,-1.5624 l -0.125,-0.3126 -0.375,-0.2187 c -1.02734,0.014 -2.11768,0.8555 -3.09375,0.5937 l -0.21875,-0.25 c 0.20752,-0.9299 1.1958,-0.5914 1.84375,-0.5624 0.89844,-0.4088 1.27246,-0.9029 2.34375,-1.0313 2.1084,-0.2525 3.01367,0.8057 4.75,1.125 0.89941,0.1655 3.38134,-0.5726 3.8125,0.9063 -0.12744,0.2418 -0.83545,0.8242 -1.09375,0.9374 -0.14307,0.3817 -0.39695,0.6861 -0.46875,1.0938 l 0.0937,0.3438 c 0.82666,0.2905 3.69629,-0.2921 3.34375,1.5312 -1.61182,2.2114 -4.00781,-0.6599 -5.8125,1.4062 l -0.375,0 -0.28125,-0.2187 c 0.0127,-0.272 0.11475,-0.5933 0.28125,-0.8125 l -0.0312,-0.375 c -0.79199,-0.3306 -4.34424,0.1987 -3.84375,1.75 0.19141,0.2558 0.44238,0.4554 0.6875,0.6562 0.93896,1.8687 5.37939,-0.049 6.96875,-0.1562 1.62598,-0.1099 3.78173,0.292 5.34375,0.75 3.59473,1.0537 7.14307,2.6216 10.71875,3.75 2.125,0.6709 4.33301,0.333 6.4375,1.3125 1.09912,0.5118 2.06152,1.5937 3.1875,2.0937 1.3833,0.6153 2.75489,0.8916 4.15625,1.4063 2.07666,0.7622 4.24756,1.9175 6.21875,2.9375 0.5918,0.3061 0.98243,0.8023 1.71875,0.9375 2.34912,0.4321 3.68018,-1.8039 5.25,-1.5313 l 0.25,0.2188 0.0625,0.375 c -0.125,0.1977 -0.292,0.4096 -0.46875,0.5625 0.009,0.29 -0.0557,0.5943 -0.125,0.875 l -0.3125,0.1875 c -0.11084,0.2798 0.0586,0.6929 0.28125,0.875 1.85107,0.7451 3.88623,0.2334 5.8125,1.3125 3.36621,1.8862 4.65283,5.2613 9,6.4375 5.61865,1.521 12.94287,-0.1531 18.71875,-0.2812 1.89844,-0.042 3.70898,0.6182 5.5625,0.6562 1.86963,0.039 3.43603,-1.2265 5.15625,-1.1562 1.05078,0.043 2.13965,0.6743 3.21875,0.7812 3.30225,0.3277 8.91846,0.026 12.25,-0.5 1.60596,-0.2534 1.69971,-0.9664 2.84375,-1.7188 1.53369,-1.0075 5.51221,-1.4634 6.90625,-2.4062 1.84766,-0.5684 4.70845,-3.233 4.78125,-3.25 0.7538,-0.1693 2.31812,0.4002 3.5625,0.4062 l -1.625,-0.6874 c -0.0869,-0.073 -1.269,-3.2498 -1.3125,-3.3438 -1.12305,-2.4116 -2.30713,-3.6347 -3.875,-5.75 -2.91943,-3.9385 -6.82422,-7.2016 -11.125,-9.75 -1.11279,-0.6596 -2.25439,-1.4306 -3.40625,-1.9688 -4.01074,-1.8725 -8.83252,-0.7836 -11.4375,-1.9687 -1.27685,-0.581 -4.49219,0.4121 -5.5,-0.9063 -0.22107,-5.9755 0.29036,-82.777 0.0625,-91.25 l -0.0937,0 c -0.9834,-0.053 -1.99219,0.1015 -2.96875,0.1876 -3.58398,0.3143 -6.54297,-2.2726 -8.25,-4.3438 -4.41699,-1.5826 -8.86865,-3.8534 -11.25,-8.0312 -1.98682,-3.4864 -5.91894,-1.8214 -8.4375,-3.9063 l -0.46875,-0.375 -1.375,-1.1875 c -1.67334,-1.4414 -3.1084,-2.3902 -4.125,-4.4375 -3.62305,0.074 -4.50782,-1.2202 -7.6875,-3.0937 -4.08691,-2.4092 -8.53174,-3.0517 -12.6875,-5.0626 -2.48584,-1.2019 -1.70948,-0.2552 -3.78125,-0.2812 l -0.40625,-0.062 c -0.88086,-0.2652 -1.3291,-0.5849 -1.96875,-1.2187 -0.25684,-0.059 -0.75244,-0.1363 -1.6875,-0.1563 -2.88379,-0.06 -12.53272,-1.0894 -15.5625,-1.875 -4.67969,-1.2135 -9.59863,0.1152 -13.375,-1.3125 -0.99023,-0.3742 -2.19189,-0.1948 -3.21875,-0.4062 l -0.5625,0.125 c -2.95264,0.6214 -5.47168,-0.4942 -8.5,0.5937 -2.12695,0.7641 -3.0166,1.0639 -5.34375,0.9063 -3.06006,-0.2081 -5.45654,2.5254 -7.9375,-0.5938 -0.625,-0.7866 -8.37012,-3.3198 -10.625,-2.1562 -2.57129,1.3256 -3.97998,3.5335 -6.75,1.5 -1.53027,-1.1241 -3.4292,0.1431 -5,-1 -3.95459,-2.881 -2.39404,-0.6783 -5.09375,-1.5313 -0.39258,-0.1241 -0.73486,-0.3528 -1.0625,-0.5937 l -0.28125,-0.1876 c -1.89453,-0.5922 -2.05762,0 -4.65625,-1.1874 -1.5,-0.6886 -14.1499,-1.895 -16.4375,-1.0626 -2.16895,0.7899 -4.38916,0.3199 -6.59375,1.0313 -1.19043,0.3848 -3.51758,-0.8764 -5.125,-1.0625 -1.46045,-0.1694 -2.24805,-0.6472 -3.5,-1.2188 -1.77979,0.1466 -2.64844,0.4776 -3.9375,-1.0312 -1.59473,-1.8672 -1.05371,-3.0444 -1.15625,-5.125 -0.062,-1.2558 -3.21289,-4.2578 -4.75,-4.9375 -3.37549,-0.1572 -3.17334,-0.1748 -6.15625,-2.5625 -2.28809,-1.8311 -6.75586,0.1465 -7.96875,-2.9375 -3.38965,-0.5844 -2.41504,-0.4629 -5.59375,-2.0625 -3.61523,-1.8193 -4.30908,-1.0307 -5.9375,-4.8438 -0.18994,-0.2021 -0.27635,-0.2967 -0.34375,-0.3437 -2.40186,0.055 -2.35986,-4.4423 -3.125,-5.9375 -1.01229,-1.9785 -0.95946,-1.7171 -0.75,-3.25 -1.38163,-0.3752 -3.90919,-0.6055 -4.75,-0.031 -7.15674,4.8827 -6.44336,0.4859 -12.9375,2.8124 -4.85645,1.7413 -11.06738,-3.7134 -12.40625,-8.2187 -1.09131,-3.6714 -2.6792,-5.4932 -6.75,-4.7187 -2.16699,0.413 -2.70605,-0.8814 -3.5,-2.5626 -1.66846,-0.7509 -1.2847,-2.8535 -1.375,-4.3437 -0.42236,-6.9844 0.57861,-3.9746 3.625,-8.0625 1.15527,-1.5503 3.19775,-0.9102 4.34375,-2.4688 3.0332,-4.1229 1.58448,-6.3594 -0.46875,-10.1874 -1.89355,-3.5299 -5.65186,-4.9683 -9.5,-5.375 -0.77881,-0.083 -1.54541,0.1212 -2.34375,-0.031 -2.69141,-0.5161 -5.1958,-0.9891 -7.9375,-0.9063 -2.05029,0.063 -3.8706,-0.5107 -5.875,-0.5937 -0.22447,-0.01 -0.43281,-0.014 -0.65625,0 z m 323.28125,235.3437 c 0.13828,7e-4 0.27779,-0.016 0.40625,-0.031 -0.12613,0.013 -0.2722,0.031 -0.40625,0.031 z M 838.125,1241.5 c 0.0722,0.022 0.14609,0.042 0.21875,0.062 l 0,-0.031 c -0.071,-0.02 -0.14786,-0.01 -0.21875,-0.031 z m 1.8125,4.5312 c 0.064,0.1689 0.13162,0.303 0.21875,0.4063 -0.0851,-0.1021 -0.15619,-0.2412 -0.21875,-0.4063 z m 0.21875,0.4063 c 0.0823,0.098 0.18283,0.1669 0.28125,0.2187 -0.10262,-0.053 -0.19616,-0.1166 -0.28125,-0.2187 z m 0.28125,0.2187 c 0.1025,0.054 0.22861,0.076 0.34375,0.094 -0.11516,-0.017 -0.24113,-0.041 -0.34375,-0.094 z m 0.34375,0.094 c 0.0819,0.013 0.16382,0.031 0.25,0.031 -0.0884,-2e-4 -0.16599,-0.018 -0.25,-0.031 z m -568.75,110.875 c 0.0334,0.1345 0.11842,0.2741 0.21875,0.4375 -0.10219,-0.1659 -0.18531,-0.3029 -0.21875,-0.4375 z m 0.21875,0.4375 c 0.0787,0.1282 0.17071,0.2947 0.28125,0.4375 -0.10976,-0.1423 -0.20265,-0.3099 -0.28125,-0.4375 z",
						"lapampa":"m 693.8125,951.46875 c -9.87845,0.0238 -17.36181,0.10743 -19.78125,0.25 0.34031,5.63965 -0.005,50.99655 -0.0625,67.93745 -0.29786,-0.1508 -79.90869,-0.1382 -90.34375,-0.1562 -32.91016,0.05 -65.83643,0.2066 -98.75,-0.062 0.0913,3.6602 -0.11963,7.4698 -0.3125,11.125 l 2.78125,0 c 0.24464,31.7441 -0.26123,63.5014 -0.0937,95.25 l 0,1.4063 c 0.90377,0.013 1.7896,-0.1939 2.6875,-0.1563 2.0044,0.083 3.82471,0.6561 5.875,0.5937 2.7417,-0.083 5.24609,0.3902 7.9375,0.9063 0.79834,0.1525 1.56494,-0.052 2.34375,0.031 3.84814,0.4067 7.60645,1.8451 9.5,5.375 2.05323,3.8283 3.50195,6.0642 0.46875,10.1874 -1.146,1.5584 -3.18848,0.9185 -4.34375,2.4688 -3.04639,4.0879 -4.04736,1.0781 -3.625,8.0625 0.0903,1.4902 -0.29346,3.5926 1.375,4.3437 0.79395,1.681 1.33301,2.9756 3.5,2.5626 4.0708,-0.7745 5.65869,1.0473 6.75,4.7187 1.33887,4.5053 7.5498,9.9597 12.40625,8.2187 6.49414,-2.3267 5.78076,2.0705 12.9375,-2.8124 0.84081,-0.5742 3.36837,-0.3442 4.75,0.031 -0.20946,1.5329 -0.26229,1.2715 0.75,3.25 0.76514,1.4952 0.72314,5.9925 3.125,5.9375 0.0674,0.047 0.15381,0.1413 0.34375,0.3437 1.62842,3.8129 2.32227,3.0245 5.9375,4.8438 3.17871,1.5996 2.2041,1.4781 5.59375,2.0625 1.21289,3.084 5.68066,1.1064 7.96875,2.9375 2.98291,2.3877 2.78076,2.4053 6.15625,2.5625 1.53711,0.6797 4.688,3.6817 4.75,4.9375 0.10254,2.0806 -0.43848,3.2578 1.15625,5.125 1.28906,1.5088 2.15771,1.1775 3.9375,1.0312 1.25195,0.5716 2.03955,1.0494 3.5,1.2188 1.60742,0.1861 3.93457,1.4473 5.125,1.0625 2.20459,-0.7114 4.4248,-0.2414 6.59375,-1.0313 2.2876,-0.8324 14.9375,0.3743 16.4375,1.0626 2.59863,1.192 2.76172,0.5949 4.65625,1.1874 l 0.28125,0.1876 c 0.32764,0.2409 0.66992,0.4696 1.0625,0.5937 2.69971,0.853 1.13916,-1.3494 5.09375,1.5313 1.5708,1.1432 3.46973,-0.1241 5,1 2.77002,2.0338 4.17871,-0.1742 6.75,-1.5 2.25488,-1.1634 10,1.3696 10.625,2.1562 2.48096,3.1192 4.87744,0.386 7.9375,0.5938 2.32715,0.1576 3.2168,-0.1422 5.34375,-0.9063 3.02832,-1.0879 5.54736,0.028 8.5,-0.5937 l 0.5625,-0.125 c 1.02686,0.2116 2.22852,0.032 3.21875,0.4062 3.77637,1.4277 8.69531,0.099 13.375,1.3125 3.02978,0.7856 12.67871,1.815 15.5625,1.875 0.93506,0.02 1.43066,0.098 1.6875,0.1563 0.63965,0.634 1.08789,0.9535 1.96875,1.2187 l 0.40625,0.062 c 2.07177,0.026 1.29541,-0.921 3.78125,0.2812 4.15576,2.0109 8.60059,2.6536 12.6875,5.0626 3.17968,1.8737 4.06445,3.1677 7.6875,3.0937 1.0166,2.0473 2.45166,2.9961 4.125,4.4375 l 1.375,1.1875 0.46875,0.375 c 2.51856,2.0849 6.45068,0.4202 8.4375,3.9063 2.38135,4.178 6.83301,6.4486 11.25,8.0312 1.70703,2.0712 4.66602,4.6581 8.25,4.3438 0.97656,-0.086 1.98535,-0.2412 2.96875,-0.1876 l 0.0937,0 c -0.009,-0.3442 -0.0194,-1.2995 -0.0312,-1.4062 0.53272,-3.0576 -0.0396,-278.8584 0.25,-293.625 0,0 -51.11465,-0.35266 -80.75,-0.28125 z M 583.625,1019.5 l 1.46875,-0.062 c -0.0405,-0.063 -0.28735,-0.4878 -0.5,-0.8437 -0.11038,0.1037 -0.96875,0.9062 -0.96875,0.9062 z",
						"mendoza":"m 432.34375,744.8125 c -0.92476,0.002 -1.12579,0.59717 -1.9375,2.03125 -0.53271,0.94116 -1.8811,0.16895 -2.53125,1.09375 -0.60034,0.85352 -0.66919,2.0752 -1.28125,2.875 -1.60547,2.09863 -2.75586,0.87183 -4.625,0.4375 -0.78906,-0.18333 -1.63574,-0.0937 -2.4375,-0.0937 -4.67432,0 -3.6521,1.19995 -7.28125,3 -2.16357,1.07275 -4.7019,0.6875 -6.15625,2.90625 -1.40601,2.14502 1.84937,8.3374 -3.25,8.53125 l -2,0.0937 c -3.344,0.12744 -6.47705,0.36914 -9.78125,1.09375 -1.74658,0.3833 -3.12183,1.3584 -4.9375,1.71875 -2.7754,0.55029 -4.49829,-1.38623 -6.84375,-1.625 -2.06446,-0.21069 -3.73901,0.85303 -5.65625,1.21875 l -4.15625,0.8125 c 3.10283,2.17903 0.17146,5.21424 0.21875,7.15625 0.005,0.21924 0.41284,1.31982 0.625,1.46875 0.65088,0.45605 1.61206,0.47705 2.34375,0.75 3.3291,1.24365 2.51123,2.67041 3.4375,5.34375 0.30811,0.88892 0.49268,2.63965 -0.34375,3.3125 -3.73193,3.00098 -0.80396,3.1377 -0.65625,6.6875 0.0454,1.08813 -0.1958,2.87158 0.1875,3.90625 0.61939,1.67285 1.99683,2.63623 2.21875,4.5 0.95507,0.81298 0.70508,-0.0186 1.21875,1.40625 0.34449,0.24951 1.06104,0.72285 1.5,0.78125 0.47241,0.31665 0.15771,1.74805 0.65625,2.3125 1.25513,1.42138 3.6377,1.01343 3,3.625 -0.22045,0.90283 -1.26855,2.52368 -1.78125,3.28125 0.0361,0.22998 0.13795,1.59082 0.21875,1.71875 -0.76734,1.90772 -0.9978,1.771 -2.78125,2.59375 -0.22534,0.104 -1.18995,0.52124 -1.15625,0.875 0.95386,1.86011 1.29321,3.92725 1.53125,5.96875 0.064,0.54883 -0.40845,1.21143 -0.1875,1.78125 0.50879,1.31152 1.39136,2.29053 1.71875,3.78125 0.30298,1.37842 0.0979,8.4248 2.59375,8.0625 4.59643,-0.66699 4.23657,-6.23193 5.59375,-7.21875 1.54712,-1.12475 3.85132,2.95117 4.5625,3.8125 1.17896,1.42871 3.65674,3.86133 3.125,5.90625 0.7854,1.1167 2.16235,3.00098 1.59375,4.46875 -1.04248,2.69189 -4.98022,2.63916 -5.53125,4.53125 -0.4419,1.51611 -1.72949,3.01147 -1.90625,4.53125 -0.13184,1.13306 0.1945,2.33765 0.1875,3.46875 -0.008,1.3103 -0.76611,2.90527 -1,4.21875 -0.27222,1.52881 1.83862,3.24072 1.5625,5.21875 -0.38672,2.77051 -3.70508,0.16113 -0.625,9.0625 0.21381,0.61718 -0.0691,2.46997 0.1875,3.46875 0.30884,1.20215 1.99655,2.09521 2.09375,2.65625 0.4541,2.61743 -1.4375,3.82397 -1.4375,4.78125 0,0.62476 0.6387,1.53076 0.625,2 -0.0142,0.46973 -1.58716,1.95483 -1.84375,3.09375 2.30298,2.01587 3.88843,2.67725 3.15625,5.90625 0.15308,0.15943 0.41845,0.50903 0.40625,0.75 -0.31177,1.50098 -3.59375,2.71509 -4.75,3.5 l -0.53125,1.21875 -0.5625,0.25 c -0.43384,0.0288 -2.76367,-2.60913 -3.25,-2.9375 l -0.40625,-0.0625 c -0.66968,0.20972 -2.18042,2.0752 -2.5,2.0625 -0.29273,-0.011 -0.9209,-0.11845 -1.1875,-0.0312 l -0.21875,0.3125 c 0.0349,0.10449 0.0691,0.2197 0.125,0.3125 2.55957,4.24634 0.6089,3.68652 0.625,5.09375 0.005,0.45947 0.84229,1.77002 1.0625,2.375 -0.27661,0.68701 -1.53125,1.84885 -2.53125,1.90625 -0.72632,2.60962 -2.47974,2.52856 -4.3125,3.9375 -0.53002,0.40747 -0.72266,1.55273 -0.9375,2.15625 -0.63061,1.77051 -1.88965,2.93115 -3,4.40625 -0.53271,0.70801 -1.82397,2.54834 -1.96875,3.3125 -0.1172,0.61914 0.65479,2.9209 -0.125,3.25 -3.36524,1.4209 -0.9375,1.81396 -2.375,3.25 -1.18091,0.22949 -3.34082,0.86768 -2.625,2.53125 0.1499,0.23193 2.43799,1.5564 2.96875,1.8125 0.23777,0.31616 0.0693,0.89136 0,1.21875 -0.74488,3.52246 -4.32568,7.43262 -4.5,8.28125 -0.31323,1.52539 -0.0945,2.84131 -0.75,4.3125 l -0.125,0.25 c -2.1211,4.16407 0.69897,7.91602 -0.4375,9.6875 -0.28467,0.44433 -0.86328,0.57666 -1.15625,0.9375 -0.52563,0.64697 -0.69751,1.3291 -1.375,1.90625 -3.2583,2.77588 -7.20679,-0.36523 -8.90625,1.90625 -0.40601,0.54248 -0.26929,1.20605 -0.4375,1.8125 -0.18799,0.67822 -1.24438,1.31201 -0.875,2.21875 0.26172,0.64258 0.88379,1.11426 1.375,1.5625 2.99536,2.73144 6.28638,-0.48828 8.0625,4.25 0.0889,0.23633 -0.50245,1.35352 -0.59375,1.5625 -0.67359,1.54541 -1.1582,2.9541 -0.8125,4.6875 0.42431,2.12744 3.40674,3.43066 3.15625,5.03125 -0.93213,1.25 -0.66211,1.20068 -1.1875,2.09375 0.36108,0.68848 1.22705,2.36182 1.34375,3.125 l -0.15625,0.46875 c -0.24317,0.0581 -0.37895,0.47363 -0.46875,0.65625 -0.90405,1.83593 0.19873,3.46533 1.0625,5 1.49682,2.6597 0.94653,4.7148 1.71875,6.25 0.30347,0.603 0.91138,1.105 1.28125,1.6875 0.0867,0.1367 0.20095,0.3482 0.15625,0.5313 -0.10059,0.4026 -0.45557,0.498 -0.59375,0.8437 -2.32104,0.4209 -2.37646,1.4698 -3.5,3.0937 -0.48584,0.7018 -1.49438,1.63 -1.65625,2.5 0.009,0.1334 0.0469,0.3395 0.15625,0.4376 0.56689,0.2856 2.04272,0.1317 2.28125,0.4374 0.48755,0.8859 -1.46704,1.3829 -1.3125,2.6563 0.20214,1.6675 2.05811,3.207 1.875,4.8437 -0.0728,0.6514 -1.83154,2.1168 -2.09375,3.0313 -0.4269,1.4893 -0.28987,2.8082 -0.625,4.0625 0.8103,0.1689 1.55908,1.0264 2.125,1.5625 1.73169,1.6392 1.74927,4.5112 1.25,6.6875 -0.2041,0.8896 -2.45507,0.8855 -1.125,4.2188 0.61108,1.5305 1.07666,3.8456 3.09375,4.0312 0.79028,-0.2886 1.03125,-1.3465 1.53125,-1.4688 1.88403,-0.4598 2.96362,1.0077 3.3125,2.6876 l 0.34375,1.7187 c 0.20312,0.9776 1.0791,5.0077 1.25,5.5313 0.32397,0.9909 2.69092,4.9299 3.5,5.4374 1.53027,0.9598 3.77905,1.0028 5.46875,1.75 0.67212,0.9049 1.94751,1.6885 2.15625,1.9688 l 0.125,0.1875 c -0.32812,2.6143 3.48926,1.9253 5.125,5.6875 0.43823,1.0069 0.72168,1.9532 0.625,3.0625 0.48364,1.1451 1.61963,1.9155 2.78125,2.25 0.70483,1.5434 2.2312,2.5376 3.78125,2.7813 l 0.28125,0.625 c 0.41577,1.4587 0.65356,5.8749 0.28125,6.4687 -0.65942,1.0522 -1.94458,2.6919 -1.53125,4.0625 0.16431,0.5454 2.42774,3.4727 2.875,4.1875 1.60986,2.5723 5.96411,5.6834 8.625,6.7813 2.64258,1.0902 9.45362,2.134 12.5,1.5624 l 0.46875,-0.094 c 2.22534,-0.561 7.47998,-2.434 9.65625,-1.2813 2.70459,1.4328 8.46728,2.5345 10.1875,4.5626 1.91504,2.258 0.13818,8.0478 5.25,9.5312 2.2002,0.6382 4.48584,1.1904 6.75,1.5625 2.80713,0.4609 3.4668,-0.7343 5.875,-1.0625 1.07129,0.087 1.70996,0.5342 2.21875,1.1875 3.47119,4.458 2.71534,2.491 6.90625,2.9063 0.1416,0.058 0.28662,0.122 0.4375,0.2187 l 0.5625,0.375 c 0.50635,0.3208 1.17871,0.625 2.125,0.625 0.64941,0 2.70654,-0.4483 3.15625,-0.25 2.02832,2.4585 2.75927,7.6566 7.28125,7.0313 l 0.34375,-0.063 c 1.62646,0.241 3.27441,0.4031 4.90625,0.5626 1.22363,0.1184 2.26318,0.7518 3.5625,0.75 l 0,-1.4063 c -0.16748,-31.7486 0.33839,-63.5059 0.0937,-95.25 l -2.78125,0 c 0.19287,-3.6552 0.40381,-7.4648 0.3125,-11.125 32.91357,0.2691 65.83984,0.1128 98.75,0.062 0,0 0.85837,-0.8025 0.96875,-0.9062 -0.38929,-0.6518 -0.82888,-1.3867 -0.84375,-1.4688 0.44043,-1.0791 1.106,-1.332 1.0625,-2.7812 l -0.0312,-0.4376 c -0.10254,-1.3672 1.18604,-1.4501 0.84375,-4.0624 l -0.125,-0.875 c -0.0635,-0.4874 -0.0601,-0.8184 0.0625,-1.1876 1.08301,-3.259 2.19775,-6.5444 2.625,-9.9687 0.30371,-2.43457 -0.55127,-5.45947 0.8125,-7.59375 2.24463,-3.51171 1.8125,-7.3833 1.8125,-11.375 0,-0.61426 0.15137,-1.07764 0.4375,-1.90625 0.65869,-1.90723 -0.0776,-4.13037 -0.53125,-6 l -0.0937,-0.34375 0.21875,-0.1875 c 0.51172,-0.50342 0.96875,-1.23926 0.96875,-2.4375 0,-0.6748 -0.25781,-1.29443 -0.625,-1.84375 l -0.25,-0.375 -0.21875,-0.28125 c -0.041,-0.063 -0.12405,-0.2466 -0.15625,-0.3125 0.0278,-0.71289 0.27539,-1.3833 0.46875,-2.0625 1.1499,-4.03858 -1.14648,-7.10693 -1.9375,-11 -0.21045,-1.03564 0.5,-2.6167 0.5,-3.8125 0,-1.37842 -2.62744,-10.0166 -3.9375,-11.1875 -2.02148,-1.80811 -3.94629,-6.08154 -4.96875,-8.65625 -1.10303,-2.77881 -2.62207,-2.93262 -3.28125,-4.25 -0.0459,-0.0923 -1.501,-6.03613 -1.5,-6.34375 0.004,-0.79053 0.0575,-1.56836 0.0625,-2.34375 0.0215,-3.46216 -0.89111,-3.28833 -2.40625,-5.59375 0.74805,-1.87207 0.59277,-1.54492 -0.25,-3.3125 -0.0469,-0.39648 0.2773,-1.47021 0.375,-1.875 0.91162,-3.78174 -0.856,-3.03809 -0.9375,-4.75 0.5044,-0.22803 0.78223,-0.86377 0.9375,-1.4375 l 0.28125,0.21875 c 2.11572,0.0596 2.878,-1.3208 2.875,-2.6875 -0.005,-1.99316 -0.22656,-2.25732 0.125,-4.53125 0.34863,-2.25781 1.04346,-3.55176 -0.84375,-5.625 l 0.125,-0.3125 c 0.17626,-0.57569 0.125,-1.1792 -0.0312,-1.53125 l -0.25,-0.375 c -0.89404,-0.94531 -1.51904,-1.52344 -2,-1.96875 -3.09766,-2.86841 0.354,-4.62036 -5.78125,-8.4375 -4.10302,-2.55249 -2.6792,-6.23389 -5.0625,-10.09375 l -0.25,-0.375 c -1.1123,-1.7229 0.0679,-3.68262 -2.71875,-7.0625 -2.5039,-3.03711 -4.31738,-6.11279 -6.0625,-9.65625 -0.9268,-1.88134 -1.20068,-1.43457 -0.875,-3.59375 0.68555,-4.54688 -1.36275,-4.79224 -1.34375,-7.40625 0.0151,-2.13012 -1.20459,-3.90674 -0.71875,-5.0625 1.39209,-3.31103 -0.34277,-4.21143 0.125,-7.5625 0.36817,-2.64014 -0.29736,-2.59229 -0.96875,-4.625 0.0615,-0.43506 0.22314,-0.86377 0.34375,-1.3125 C 551.64063,812.87085 549,812.36133 549,810.6875 c 0,-0.7605 1.48485,-1.77905 1.53125,-3.4375 L 550.5,806.9375 c -0.25,-1.33862 -1.04495,-2.9165 -0.96875,-4.25 0.0405,-0.70776 2.64746,-2.19507 1,-4.40625 L 550.125,797.75 c -0.20898,-0.55493 -0.2783,-0.93311 -0.3125,-1.21875 l -0.0312,-0.46875 c -0.14454,-1.6167 -1.19092,-2.31812 -2.5,-3.125 -0.52587,-1.5747 -0.57666,-3.48145 -0.78125,-5.125 -0.36035,-2.89063 -1.6825,-2.91553 -1.6875,-4.6875 -0.01,-3.20361 -1.0957,-3.17676 -1.59375,-5.71875 l -0.0937,-0.59375 c -0.35742,-1.55664 -1.16602,-2.36719 -2.53125,-3.125 l -2,1.90625 c -0.29151,-0.51416 -5.71924,-6.9705 -6.09375,-7 -1.65966,-0.12964 -3.35693,0.27148 -4.53125,-1.25 l -0.375,-0.5 c -1.15869,-1.02881 -5.81201,1.7666 -8.75,-0.8125 -4.23438,0.29736 -7.5498,1.0769 -9.90625,-3.375 -0.4082,-0.77076 -0.48926,-0.91357 -1.3125,-1.1875 l -0.84375,-0.28125 c -3.55762,-1.19385 -2.49561,-4.12793 -4.90625,-6.4375 -2.14941,-2.06031 -4.02832,-0.32544 -6.375,0.28125 -1.76904,0.45727 -3.54883,0.47534 -5.3125,1.03125 -2.43994,0.76905 -4.65674,0.86768 -6.40625,-1.53125 0,0 0.16797,-0.24975 -0.28125,-0.15625 -0.90332,0.18901 -2.29395,0.16187 -3.21875,-0.0937 -1.67236,-0.46314 -3.54785,-3.12769 -5.375,-1.3125 -1.1274,1.12036 -1.1382,1.62378 -1.1875,3.15625 -0.24024,7.48242 -5.4585,3.98926 -10.5,3.03125 -4.39697,-0.83545 -8.43994,-1.81665 -11.75,-5.03125 -1.59082,-1.54541 -4.58691,-1.59009 -6.59375,-1.125 -1.00293,0.23266 -2.34961,0.72778 -3.375,0.34375 -3.37305,-1.26391 -3.51367,-7.30176 -7.9375,-8.34375 -0.51684,-0.12176 -0.9105,-0.18814 -1.21875,-0.1875 z",
						"sanjuan":"M 406.34375 504.03125 C 406.3554 504.05489 406.36443 504.10307 406.375 504.125 C 405.90332 504.68384 405.20483 505.16235 404.78125 505.71875 C 404.17505 506.51441 405.5767 510.29028 405.5 511.5 C 404.7583 512.80981 404.20581 514.28296 403.375 515.53125 C 403.24121 515.73242 402.93213 515.85352 402.8125 516.0625 C 402.7561 516.16114 401.21175 522.4126 401.21875 522.59375 C 401.24707 523.33545 402.81982 526.86841 403.21875 528.6875 C 402.48389 530.56324 401.45557 532.79346 400.46875 534.5625 C 400.01636 535.37427 399.03979 536.25342 398.46875 537.03125 L 397.65625 536.78125 C 397.61792 537.60474 398.1746 538.323 398.125 539.03125 C 398.05664 540.01172 397.90625 542.28125 397.90625 542.28125 C 395.72558 544.18115 397.20264 548.85327 396.5625 551.5 L 395.90625 552.25 C 394.77832 552.71383 393.56421 552.24465 392.4375 552.28125 C 391.66846 552.30615 388.67969 554.68018 387.90625 555.28125 C 387.58642 555.22192 387.09009 555.39575 386.84375 555.59375 C 386.81494 556.03833 387.27271 557.05005 387.40625 557.5 C 387.03516 558.68555 386.78809 560.02759 386.5625 561.25 C 385.67749 561.57422 384.71582 561.95557 383.875 562.375 C 383.15772 564.66894 382.9058 565.76904 382.875 568.125 L 383.40625 568.90625 C 384.79882 569.18994 385.71875 571.49658 385.03125 572.6875 C 385.63769 574.22803 385.74463 576.67847 386.625 577.96875 C 386.4065 578.15454 386.24995 578.50635 386.21875 578.78125 C 386.43701 579.28711 386.83765 579.77002 387.1875 580.1875 C 387.31079 581.2312 386.76294 582.25024 386.90625 583.34375 C 387.00878 584.12426 387.39255 584.78491 387.40625 585.59375 C 388.01514 586.32251 390.881 590.35278 390.875 591.125 C 390.4646 591.40503 390.22534 591.55811 389.9375 591.9375 C 390.03491 592.37696 390.46855 592.89697 390.40625 593.3125 C 390.04737 594.0962 389.09595 595.27905 388.5625 596 L 388.5 596.8125 C 388.82959 597.41601 389.49365 597.73193 389.78125 598.375 C 389.86255 599.07202 389.47681 599.95801 389.75 600.625 C 390.28906 601.94141 391.96045 602.5083 390.5 604.09375 C 390.69632 604.354 390.77225 604.94116 390.78125 605.25 C 390.63403 605.68676 389.6892 606.91382 389.75 607.25 C 388.79639 608.33936 388.64673 610.57812 388.375 611.9375 C 388.36132 612.00586 388.91255 614.23779 388.96875 614.46875 C 388.36134 616.10107 386.19116 617.98633 388.375 619.34375 C 392.71583 619.5293 395.75122 619.56836 395.28125 624.71875 C 395.24366 625.13086 394.76733 626.87598 394.1875 627.1875 L 393.9375 627.15625 C 393.91723 627.21192 393.16797 627.26735 393.0625 627.28125 C 391.95679 629.13428 391.44043 630.43848 390.6875 632.40625 C 390.60864 632.42603 390.26225 632.7866 390.21875 632.875 C 389.77197 633.7876 389.72339 634.99609 389.15625 635.8125 C 388.53516 636.70678 385.93555 639.229 384.65625 639.34375 C 382.90014 639.50171 377.2627 636.66504 375.53125 635.59375 L 374.78125 635.75 L 374.53125 636.28125 C 374.96827 637.38477 376.18262 639.05078 376.375 640.0625 C 376.46626 640.54151 376.42822 641.0127 376.5625 641.5 C 376.38843 641.82032 376.2056 642.7041 376.25 643.0625 C 374.21728 644.64869 373.01367 648.1001 372.15625 650.46875 C 371.51538 652.23901 370.70337 654.06201 370.5625 655.96875 C 370.45117 657.47778 371.4856 658.97144 370.90625 660.46875 C 370.21436 661.17749 369.0542 662.28369 368.625 663.21875 C 367.14087 666.45214 367.23096 668.87573 366.0625 672.28125 C 366.03271 672.36816 365.9292 672.4878 365.875 672.5625 C 365.51636 675.89648 367.23315 675.64575 366.1875 680.34375 L 366.40625 680.71875 C 366.82251 681.04277 367.41772 680.7605 367.75 681.03125 L 368.09375 681.5625 C 367.93457 682.15967 366.28271 682.87427 365.8125 683.21875 C 364.88428 683.89893 365.1814 685.45313 364.34375 686.34375 C 361.92846 686.69873 362.3728 687.25 362.09375 689.0625 C 362.01636 689.56592 361.52441 689.95679 361.3125 690.375 C 361.13819 690.71826 361.14917 691.34229 360.78125 691.5625 L 360.46875 691.5625 C 360.06839 691.19678 360.2356 690.53442 360.0625 690.09375 C 359.55347 688.79981 358.76929 687.2417 357.90625 686.125 L 357.625 686.03125 L 357.1875 686.1875 C 354.20972 691.28223 353.85767 686.70068 353.53125 695.15625 C 353.42065 698.01587 351.8479 700.78955 352.09375 703.5625 C 352.43018 707.35547 352.78979 709.59326 350.6875 712.6875 C 350.46118 713.90625 351.03076 714.30957 351.15625 715.21875 C 351.27785 716.10205 350.97534 717.04492 351.1875 717.96875 C 351.77343 720.52099 352.34644 721.21191 353.625 723.375 C 354.19238 724.33545 354.13379 725.74487 354.5625 726.8125 L 354.90625 726.9375 C 355.43042 726.8134 355.49341 726.73999 355.96875 726.875 C 357.9138 728.80688 356.68335 735.90527 357.875 737.5625 C 358.4419 738.35107 359.79346 738.99316 360.59375 739.4375 C 360.9375 739.62842 362.4353 740.3699 363.03125 740.4375 C 367.97436 740.15503 367.22363 739.82227 370.46875 743.3125 C 373.98853 747.0979 370.5127 746.9209 369.0625 748.75 C 368.66187 749.25537 368.19214 750.6377 367.46875 750.84375 C 364.04419 751.81909 364.71729 750.88135 363.875 750.96875 C 362.92846 749.96386 362.27734 749.66553 361.25 750.8125 L 361.09375 751.3125 L 361.1875 751.65625 C 361.29541 751.84082 363.23877 752.70312 363.78125 753.375 C 363.76636 753.65771 363.64551 753.96533 363.53125 754.21875 C 363.68531 755.25146 364.64795 757.01074 365.875 757.125 C 367.06226 758.44971 365.59375 759.65186 365.59375 760.78125 C 365.59375 761.84912 365.76392 763.29102 365.34375 764.34375 C 365.19531 764.71582 364.83665 765.13477 364.90625 765.5625 C 364.89307 765.90381 368.91528 768.54346 369.4375 768.90625 C 369.44478 768.91131 369.46154 768.90118 369.46875 768.90625 L 373.625 768.09375 C 375.54224 767.72803 377.21679 766.66431 379.28125 766.875 C 381.62671 767.11377 383.3496 769.05029 386.125 768.5 C 387.94067 768.13965 389.31592 767.16455 391.0625 766.78125 C 394.3667 766.05664 397.49975 765.81494 400.84375 765.6875 L 402.84375 765.59375 C 407.94312 765.3999 404.68774 759.20752 406.09375 757.0625 C 407.5481 754.84375 410.08643 755.229 412.25 754.15625 C 415.87915 752.3562 414.85693 751.15625 419.53125 751.15625 C 420.33301 751.15625 421.17969 751.06667 421.96875 751.25 C 423.83789 751.68433 424.98828 752.91113 426.59375 750.8125 C 427.20581 750.0127 427.27466 748.79102 427.875 747.9375 C 428.52515 747.0127 429.87354 747.78491 430.40625 746.84375 C 431.48853 744.93164 431.49512 744.51294 433.5625 745 C 437.98633 746.04199 438.12695 752.07984 441.5 753.34375 C 442.52539 753.72778 443.87207 753.23266 444.875 753 C 446.88184 752.53491 449.87793 752.57959 451.46875 754.125 C 454.77881 757.3396 458.82178 758.3208 463.21875 759.15625 C 468.26025 760.11426 473.47851 763.60742 473.71875 756.125 C 473.76805 754.59253 473.77885 754.08911 474.90625 752.96875 C 476.7334 751.15356 478.60889 753.81811 480.28125 754.28125 C 481.20605 754.53687 482.59668 754.56401 483.5 754.375 C 483.94922 754.2815 483.78125 754.53125 483.78125 754.53125 C 485.53076 756.93018 487.74756 756.83155 490.1875 756.0625 C 491.95117 755.50659 493.73096 755.48852 495.5 755.03125 C 497.84668 754.42456 499.72559 752.68969 501.875 754.75 C 504.28564 757.05957 503.22363 759.99365 506.78125 761.1875 L 507.625 761.46875 C 508.44824 761.74268 508.5293 761.88549 508.9375 762.65625 C 511.29395 767.10815 514.60937 766.32861 518.84375 766.03125 C 521.78174 768.61035 526.43506 765.81494 527.59375 766.84375 L 527.96875 767.34375 C 529.14307 768.86523 530.84034 768.46411 532.5 768.59375 C 532.87451 768.62325 538.30224 775.07959 538.59375 775.59375 L 540.59375 773.6875 C 539.67823 770.32373 538.72949 767.05859 539.28125 763.46875 C 539.7793 760.23243 539.66797 761.79175 539.09375 759.0625 C 539.76073 755.69751 539.45312 755.77051 539 752.625 C 538.59961 749.8479 541.34766 747.94141 539.875 745.125 C 540.15918 743.84228 539.7417 742.57983 539.46875 741.34375 C 539.17334 740.00757 538.65479 738.09155 539.9375 737.5625 C 540.20361 737.45291 540.53467 737.4507 540.8125 737.4375 C 543.00098 737.33227 544.99365 738.8062 547.28125 738.875 C 548.41748 738.90918 550.01123 738.95215 551.09375 738.71875 C 552.40723 738.43506 554.00098 737.57959 555.3125 737.71875 C 558.25781 738.03076 558.33301 739.56519 559.625 739.875 C 562.8501 740.64722 565.28809 740.36938 568.71875 740.21875 C 571.15625 740.11231 573.33203 740.19458 575.71875 739.65625 C 576.13011 739.56364 576.49157 739.45417 576.9375 739.46875 C 575.94727 737.5105 575.67188 735.49317 574.5 733.53125 L 569.78125 725.65625 C 569.47515 725.14404 570.32808 723.1875 569.75 722.71875 C 569.15967 722.38818 565.98828 722.71357 564.28125 721.78125 C 563.3125 721.25244 562.81738 720.36865 562.0625 719.65625 C 560.66113 718.33496 557.99605 716.90674 558.03125 714.75 C 558.15332 707.14722 557.37207 709.76782 554.65625 704.25 C 554.80762 703.63208 557.5234 685.5732 557.5 685.5 L 553.4375 682.46875 C 554.05908 680.56226 555.69385 674.50489 556.53125 673.09375 L 556.21875 672.875 C 556.17875 672.7827 556.15135 672.67555 556.09375 672.59375 C 555.04883 671.11719 552.78222 667.75488 552.15625 666.03125 C 551.89014 665.29907 551.7837 664.44385 551.46875 663.71875 C 550.99268 662.62354 550.0503 660.33106 548.875 659.8125 C 547.78223 659.33057 546.28907 658.98754 545.375 658.21875 C 545.26758 657.87915 545.01758 657.55225 544.875 657.21875 L 544.53125 656.40625 C 543.84277 655.15747 542.72071 654.1648 541.96875 652.9375 C 541.63525 652.39453 541.65234 651.78736 541.28125 651.25 L 540.78125 650.53125 C 540.44336 650.146 539.95654 649.67382 539.5625 649.34375 C 538.08105 648.10205 536.42725 647.60009 535.1875 645.9375 C 534.29492 644.74023 533.56006 642.01563 532.53125 641.25 C 531.146 640.21948 529.04395 639.68213 527.90625 638.40625 C 526.87207 637.24634 526.95019 633.17456 525.625 631.09375 C 524.92969 630.00293 523.51758 628.81274 522.59375 627.9375 C 522.27051 627.63135 515.13135 622.26025 515.03125 622.21875 C 512.73779 616.62769 509.76807 618.67066 506.59375 615.15625 C 505.71924 614.18823 505.22461 612.052 504.1875 611.53125 C 498.61963 608.73511 501.89502 608.0542 499.65625 605.90625 C 499.29736 605.56201 498.62012 605.56763 498.34375 605.21875 C 497.76221 604.4856 497.41552 603.65967 496.53125 603.21875 C 495.49316 602.70142 494.11768 602.80225 493.1875 602.28125 C 492.19873 601.72729 492.33838 599.6355 491.4375 598.65625 C 491.03906 598.2229 490.67237 598.13917 490.125 597.96875 C 488.39404 597.43066 487.79981 596.14405 486.34375 595.34375 C 486.04248 595.17822 485.62452 595.09375 485.34375 594.90625 C 483.80127 593.87646 483.50147 591.60474 482.53125 590.75 C 482.4126 590.7102 482.28027 590.6382 482.15625 590.625 C 480.1875 590.41748 479.11133 590.12207 477.25 589.46875 C 474.9873 588.67432 473.26513 587.8428 470.84375 587.75 C 469.38965 587.6938 467.75782 588.57226 466.3125 588.09375 C 464.4209 587.46826 462.95898 584.96875 460.96875 584.96875 C 457.67871 584.96875 455.63428 587.09864 453 587.28125 C 451.39209 587.39233 450.86963 585.82299 449.34375 586.0625 C 446.23682 586.55078 440.72656 590.04492 441.34375 583.03125 C 441.47217 581.57373 441.55273 579.7063 442.125 578.34375 C 442.55176 577.32813 444.18555 575.86914 444.28125 575.0625 C 444.3833 574.19971 443.647 573.33496 443.5625 572.375 C 443.5107 571.78101 444.10255 570.6289 444.15625 569.875 C 444.20995 569.1211 444.00147 567.70166 444.34375 567 C 445.16211 566.41602 446.25781 566.8645 446.53125 565.5 C 446.51025 564.72949 445.64892 564.22143 445.40625 563.46875 C 445.23633 562.94409 445.5186 558.95849 445.5625 558.21875 C 445.5874 557.80835 445.5581 557.42334 445.625 557 L 445.84375 556.75 C 446.4043 556.666 446.81494 557.24095 447.375 557.15625 C 449.05078 556.698 448.47075 554.40991 448.40625 553.21875 C 449.22217 551.48413 449.76464 552.05811 448.875 549.90625 C 446.97266 545.30566 448.93994 543.22974 447.84375 538.875 C 444.02002 535.50073 440.19922 532.10035 436.4375 528.65625 C 436.3848 527.42114 435.94091 524.03466 435.46875 523.0625 C 435.0166 522.13013 434.3147 521.55005 433.9375 520.53125 C 433.6748 519.82153 433.85789 518.98389 433.6875 518.25 C 429.93262 515.43311 426.3147 511.91065 422.78125 508.8125 C 422.65747 508.7041 421.88184 508.5862 421.65625 508.625 C 419.68384 508.96387 417.45947 509.45777 416.5625 507.1875 C 415.75024 505.13208 415.64087 504.80932 413.6875 505.5 C 409.84717 506.85864 409.85425 504.62256 406.34375 504.03125 z ",				
						"bsas":"m 958.375,832.5625 -0.0937,0.125 0.15625,2.0625 c -0.68897,1.58838 0.0591,2.26147 -1.5,3.46875 -0.76416,0.59156 -2.01318,0.0737 -2.6875,1.03125 -0.92139,2.24195 0.13623,3.57422 -0.375,4.65625 -0.60986,1.29101 -2.91992,1.85327 -3.9375,3.21875 -0.44288,1.61792 -0.17969,3.43848 -0.65625,5.15625 -0.0967,0.34742 -3.1123,6.1987 -3.1875,6.25 -0.64014,0.43778 -1.58545,0.20679 -2.3125,0.4375 -1.21924,0.38672 -2.26123,0.78394 -3.59375,0.25 -1.64307,-0.65869 -3.2085,-3.24268 -5.0625,-4.15625 -1.59228,-0.78467 -4.09521,0.47168 -6.125,0 -0.86132,-0.2002 -1.85791,-0.98218 -2.625,-1.40625 -2.30762,-1.27587 -8.26074,0.0644 -7.25,3.4375 0.23388,0.78027 0.58375,1.64258 0.59375,2.46875 -15.35254,16.65284 -30.77734,33.23633 -46.3125,49.71875 -22.49658,0.36495 -45.03125,0.37305 -67.53125,0.34375 0,0 -13.75977,-0.0784 -19.96875,-0.0625 -3.57031,0.009 -7.67969,0.39966 -11.21875,-0.125 0.36377,6.44751 -0.0566,34.71044 -0.125,42.3125 -0.2896,14.7666 0.28272,290.5674 -0.25,293.625 0.30224,2.7324 -0.26126,86.4377 -0.0312,92.6562 1.00781,1.3183 4.22315,0.3253 5.5,0.9063 2.60498,1.1851 7.42676,0.096 11.4375,1.9687 1.15186,0.538 2.29346,1.3092 3.40625,1.9688 4.30078,2.5484 8.20557,5.8115 11.125,9.75 1.56787,2.1153 2.75195,3.3384 3.875,5.75 0.0435,0.094 1.22559,3.2708 1.3125,3.3438 l 1.625,0.6874 c 0.5362,0 1.02394,-0.088 1.34375,-0.4062 0.2251,-0.332 0.1499,-0.7305 0.375,-1.0625 1.67627,-0.3076 4.02734,-1.0175 5.53125,-1.8125 1.02148,-0.5395 1.77978,-1.5631 2.8125,-2.1562 2.91846,-1.6789 13.49561,-5.3599 15,-7.1563 0.4458,-0.5327 0.60498,-1.1772 0.75,-1.8437 0.61279,-2.8199 2.37402,-4.5103 3.25,-7.0626 0.47168,-1.375 0.45996,-2.9225 0.96875,-4.3124 0.53076,-1.4493 2.9731,-0.897 2.875,-2.6876 l -0.25,-0.2187 c -0.88232,-0.1577 -1.20899,0.3755 -1.90625,0.6563 -0.95117,0.3823 -1.91797,0.3685 -2.875,0.875 -0.92627,0.4891 -1.72558,1.4018 -2.65625,1.8124 -0.30615,0.1365 -0.91357,0.2294 -1.21875,0.094 -0.3045,-0.2217 -0.3809,-0.6843 -0.3125,-1.0312 0.17188,-0.3825 0.68213,-0.6436 0.9375,-1.0313 l -0.0312,-0.3125 c -0.55029,-0.4502 -1.41225,-1.5992 -1.40625,-2.3438 l 0.25,-0.25 c 1.17725,-0.324 1.31299,1.6397 2.25,2.0313 1.82324,0.7627 4.2163,-0.3779 3.46875,-2.625 -0.30225,-0.9092 -0.61621,-1.3442 -0.78125,-2.375 l -0.28125,-0.2187 -0.375,0 c -0.24707,0.2468 -0.48243,0.5498 -0.8125,0.6874 l -0.34375,-0.062 c -0.71484,-0.6051 -0.97559,-1.8452 -1.9375,-2.4376 -0.11768,-0.6295 -0.0811,-1.2846 -0.21875,-1.875 -0.78906,-1.0549 -3.99072,-1.6436 -5.3125,-2.6874 -1.19092,-0.9427 -2.05127,-6.1925 -2.6875,-7.6563 -0.4126,-0.9488 -1.54935,-2.0322 -1.59375,-3.0313 -0.0225,-0.4977 0.63769,-1.6352 0.96875,-2.0312 0.40381,-0.4819 1.05273,-0.5892 1.4375,-1.0312 0.54053,-0.6223 0.43115,-1.2579 1.3125,-1.75 2.17725,-1.2183 2.65918,0.067 4.0625,-2.9063 0.44141,-0.9356 0.52979,-1.7791 0.71875,-2.7813 0.10742,-0.5679 0.43115,-1.2231 0.46875,-1.7812 0.11865,-1.7793 -1.78906,-3.1626 -1.53125,-4.7188 0.16992,-1.0252 0.98926,-1.8149 1.3125,-2.7812 0.48096,-1.4389 0.83057,-3.2466 1.0625,-4.75 0.0835,-1.0254 0.77002,-1.8105 0.90625,-2.75 0.1377,-0.9512 -0.6113,-1.4851 -0.6875,-2.4062 0.34033,-0.5196 1.14795,-0.25 1.65625,-0.25 0.15869,-0.1848 0.26855,-0.4249 0.34375,-0.6563 l -0.0625,-0.4063 c -0.47559,-0.5866 -1.49365,-1.207 -1.1875,-2.0624 l 0.34375,-0.125 c 1.37988,0.1234 1.33252,1.6639 2.5,2 1.00586,0.4199 6.5459,1.876 6.4375,-0.063 0.56592,-0.4058 1.56982,0.2828 2,-0.4062 0.15381,-0.7734 -0.0806,-1.6534 0,-2.4688 l 0.5625,-5.75 c 0.10059,-1.0148 0.45703,-2.0215 0.625,-3.0312 0.19287,-1.1587 0.0645,-2.3579 0.3125,-3.5 0.36768,-1.6899 0.87451,-3.3439 1.25,-5.0312 0.186,-0.8379 -0.15381,-2.2837 0.125,-2.9063 0.22412,-0.5014 0.96093,-0.6955 1.15625,-1.3437 -0.0391,-0.2119 -0.18067,-0.4508 -0.34375,-0.5938 l -0.0312,-0.375 c 0.14255,-0.2081 0.18995,-0.5336 0.15625,-0.7812 l -0.15625,-0.3126 c -1.68359,-1.0337 -4.04639,-0.521 -5.96875,-1.75 -0.54541,-0.3487 -3.39941,-3.2651 -3.5625,-3.7812 -0.20312,-0.6436 -0.26075,-1.4766 -1,-1.8125 -0.82324,-0.3745 -2.12451,0.5391 -2.625,-0.7813 l 0.21875,-0.3124 c -0.0376,-0.3531 -0.33691,-0.6263 -0.5625,-0.875 l 0.125,-0.4063 c 0.79883,-0.033 2.12012,0.13 2.65625,-0.4687 l 0.40625,0.094 c 0.22314,0.3652 0.56836,0.5765 1,0.5625 0.271,-0.2559 0.66407,-0.3995 1.03125,-0.4375 l 0.375,0.125 c 0.4292,0.7046 0.62256,1.5215 1.0625,2.1875 0.64062,0.9721 5.8086,4.8907 6.84375,4.9062 0.96875,-0.4275 2.52246,-2.0307 1.90625,-3.1874 -0.23193,-0.4355 -1.05127,-0.7412 -1.4375,-1.0938 -0.50684,-0.4619 -0.81592,-1.1206 -1.375,-1.5625 -0.80273,-0.6347 -1.55274,-0.7954 -2.46875,-1.1875 -1.88232,-0.8052 -3.13428,-1.809 -5.25,-2.1562 -2.5415,-0.4184 -5.02783,0.059 -7.4375,-1.1563 l -0.125,-0.3125 c 0.78271,-1.6404 2.98096,0.3213 4.09375,0.094 0.0332,-0.9982 -3.39258,-2.6392 -4.1875,-3.7813 -2.3042,-3.313 0.15918,-4.5 -0.34375,-5.9375 -0.38525,-0.1953 -0.89063,-0.077 -1.21875,-0.3438 -0.42773,-1.5266 0.77002,-1.4682 1.15625,-2.1874 0.13721,-0.256 1.30175,-3.0626 1.28125,-3.1876 -0.2168,-0.084 -0.43359,-0.2031 -0.59375,-0.375 l 0,-0.3437 c 0.73438,-0.9399 2.07226,-0.4751 2.5,-1.375 -0.17969,-0.4507 -0.65284,-0.7119 -0.4375,-1.2813 l 0.5,-0.5 c 0.38818,0.053 0.76123,-0.2061 0.90625,-0.5624 -0.0244,-0.2106 -0.14942,-0.4566 -0.3125,-0.5938 -1.52881,-0.7525 -2.16797,0.7188 -2.8125,0.5938 -0.17432,-0.2861 -0.27539,-0.6527 -0.59375,-0.8126 -0.0312,-0.051 -0.31397,-0.1349 -0.53125,-0.1874 -0.0946,-0.208 -0.0879,-0.5 -0.0312,-0.7188 0.38086,-0.3247 0.68164,-0.693 0.875,-1.1562 -0.0571,-0.4937 -0.53173,-0.7428 -0.78125,-1.125 -0.25146,-0.3859 -0.21973,-0.9224 -0.46875,-1.3438 -0.36133,-0.016 -1.18897,0.6626 -1.53125,0.875 0.0142,-0.3325 0.2764,-0.6332 0.3125,-0.9688 0.12061,-1.1099 -1.37989,-1.1977 -0.96875,-4.0937 -0.25244,0.034 -0.60792,-0.02 -0.8125,-0.1875 0.18457,-0.749 0.59717,-1.0615 0.875,-1.6875 3.271,-1.0664 1.23486,-0.2583 3.53125,0.1563 0.4707,0.084 0.80811,-0.1418 1.21875,-0.094 0.56104,0.067 0.78467,0.6735 1.40625,0.6875 2.0083,-0.7305 2.11572,0.5131 4.0625,0.4687 0.86572,-0.02 2.07129,-0.6454 2.875,-0.2187 0.7915,0.4199 1.58642,1.6323 2.375,2.2187 0.1543,0.1156 0.30517,0.2383 0.40625,0.4063 0.12549,0.6084 -0.25928,1.1448 -0.125,1.5937 0.0986,0.3321 0.44238,0.5122 0.59375,0.8126 0.26807,0.5297 0.37842,1.4164 0.75,1.8437 0.58105,0.4848 1.42919,0.4457 2.03125,0.7187 0.68945,0.314 1.20215,0.8863 1.90625,1.1876 2.48291,1.0593 5.44629,0.9088 8,1.6874 1.40234,0.4282 2.79834,1.0425 4.25,1.2813 1.14307,0.1875 2.21533,0.039 3.25,-0.4375 0.47705,-0.2192 1.3208,-0.5668 1.84375,-0.5312 0.98291,0.065 2.26318,1.1427 3.1875,1.5624 2.22314,1.0109 7.79981,1.4986 10.1875,0.9376 2.69678,-0.6348 3.74659,-1.813 7.1875,-1.9688 1.24121,-0.056 1.82226,0.6164 2.90625,0.8438 1.24072,0.2585 2.58154,-0.452 3.875,-0.375 2.11182,0.1259 4.10645,0.909 6.28125,0.8124 1.43896,-0.063 3.51904,0.074 4.875,-0.2812 1.50439,-0.3936 1.86182,-1.5938 3.71875,-1.5938 0.98389,0 1.85889,0.3551 2.8125,0.4376 2.69189,0.2285 5.75537,0.043 8.4375,-0.3126 1.89844,-0.2518 3.80371,-0.7478 5.6875,-1.125 3.49658,-0.698 7.08691,-1.1983 10.59375,-1.8124 1.86963,-0.3277 3.93018,0.1436 5.78125,-0.2188 2.30713,-0.4516 4.58545,-0.8118 6.90625,-1.2188 1.12793,-0.1968 2.20215,-0.7348 3.34375,-0.9687 2.39648,-0.4897 4.84814,-0.4008 7.25,-0.8125 1.18066,-0.2021 2.21875,-0.738 3.34375,-1.0312 1.07568,-0.2814 2.50098,0.15 3.6875,-0.031 2.52734,-0.3877 5.06397,-1.0935 7.5625,-1.5313 2.30566,-0.4025 4.73437,-0.044 7.0625,-0.5 1.6748,-0.3271 5.68067,-1.6621 7.25,-2.375 0.73486,-0.3333 1.47022,-0.9356 2.21875,-1.1874 1.0459,-0.3524 2.20899,-0.4772 3.28125,-0.625 5.1005,-0.7037 10.0234,-1.693 15.0937,-2.5626 1.6782,-0.2871 3.3265,-0.9203 5.0313,-1.2187 3.6462,-0.6377 8.0401,-0.7949 11.5001,-1.8125 2.1821,-0.6421 4.1659,-2.1376 6.2811,-2.9688 2.2637,-0.8885 6.2269,-2.1002 8.7189,-2.9374 1.3025,-0.4396 2.7424,-1.5923 4,-1.8438 2.2228,-0.4448 4.513,-0.3588 6.7811,-0.8125 3.2281,-0.646 6.1133,-2.3709 9.1875,-3.4063 2.0347,-0.6843 3.9571,-0.8037 6.0314,-1.2187 2.1868,-0.4375 3.6025,-1.9562 5.5936,-2.7187 1.0981,-0.4212 2.4047,-0.3706 3.5314,-0.7813 3.0147,-1.0996 5.5628,-3.5281 8.4061,-4.9063 1.5156,-0.7327 3.1455,-0.8311 4.5939,-1.6874 0.9974,-0.5904 1.6271,-1.7237 2.8124,-2.1563 1.2407,-0.4521 2.65,-0.4894 3.8438,-0.9687 1.8608,-0.7491 1.4019,-1.6006 2.2188,-2.1876 0.8979,-0.6449 2.2993,-0.9955 3.2812,-1.5937 1.9321,-1.1762 3.9404,-2.1456 5.8125,-3.4375 2.1352,-1.4727 7.0947,-5.0849 7.8125,-7.5625 0.2864,-0.9887 -0.1318,-1.5733 -0.094,-2.4375 0.024,-0.5469 0.5135,-0.8852 0.5,-1.5 -0.014,-0.7524 -0.845,-1.3726 -0.9374,-2.25 -0.1297,-1.2129 1.248,-7.0239 1.8436,-8.25 2.0887,-4.2969 5.4669,-7.2271 8.4687,-10.8125 1.086,-1.2959 2.1177,-2.9971 3.3438,-4.125 2.401,-2.209 5.0778,-4.1289 7.4375,-6.375 0.8874,-0.8442 1.579,-2.0786 2.3125,-3.0625 0.7592,-1.0186 1.9511,-1.6952 2.6875,-2.7188 0.7662,-1.0643 1.3651,-2.2802 2.125,-3.3437 0.4673,-0.6543 1.1425,-1.2474 1.5625,-1.9063 0.8315,-1.3035 0.5018,-3.0898 1.375,-4.0937 0.6014,-0.6919 1.3915,-1.2163 1.9375,-2 1.4527,-2.0883 2.2709,-4.6167 3.75,-6.6875 1.2401,-1.7358 2.5694,-3.3356 3.7814,-5.0938 0.4944,-0.7167 0.7641,-1.5699 1.1874,-2.3124 0.9895,-1.7319 2.295,-3.8171 3.4688,-5.4376 0.4756,-0.6554 1.1928,-1.0215 1.6875,-1.6562 1.1352,-1.4566 4.4418,-4.9081 4.9063,-6.4688 0.2039,-0.6884 0.194,-2.0707 0.062,-2.7812 -0.046,-0.2573 -0.084,-0.52 -0.094,-0.7812 l 0,-0.3438 c -0.584,-2.3442 0.06,-4.3194 -0.125,-6.5 -0.1275,-1.5 -0.088,-3.0445 -0.25,-4.5312 -0.066,-0.6095 -0.4432,-1.181 -0.4687,-1.8126 -0.062,-1.4764 0.5991,-3.0009 0.4687,-4.5 -0.1582,-1.8197 -1.4825,-3.0254 -1.7813,-4.6562 -0.3051,-1.67 0.7225,-4.2388 0.25,-6.8125 -0.2409,-1.3184 -0.9003,-1.936 -1.4374,-3.0625 -0.7464,-1.5644 -0.4654,-4.2212 -2.6564,-4.6875 -0.4331,-0.092 -0.8067,0.066 -1.0625,0.4375 l 0,0.375 c 0.3449,0.5361 0.5962,1.3423 1.0625,1.75 l -0.1563,0.3438 -0.4062,0.094 c -3.8245,-1.6348 -6.6143,0.3465 -9.625,2.4063 l -0.2188,-0.063 0.063,-0.4062 c 0.5037,-0.3755 0.913,-1.5303 0.4062,-2.0312 -1.5874,-0.5998 -3.4151,-0.7246 -5.0625,-1.2188 -2.0298,-0.6089 -5.79,-3.5358 -7.4687,-4.9688 -0.5328,-0.4531 -0.7827,-1.1697 -1.2813,-1.625 -1.5976,-1.4565 -3.418,-2.2423 -4.7187,-4.0624 -0.622,-0.8705 -0.5494,-2.0816 -1.1563,-2.9376 -0.6103,-0.8608 -1.7657,-1.2143 -2.375,-2.0312 -1.0655,-1.4292 -0.8262,-3.6562 -1.5625,-5.25 -0.7022,-1.52 -2.003,-2.0092 -2.5312,-4 -0.7705,-2.8974 -1.0154,-8.7341 -0.25,-11.5938 0.5045,-1.8867 2.6059,-4.4165 3.6874,-6.0937 0.654,-1.01367 0.9297,-2.24072 1.6564,-3.25 0.54,-0.75049 1.3438,-1.26172 1.875,-2 0.749,-1.04102 1.2927,-2.33593 2.0313,-3.40625 0.6902,-1.00098 1.9235,-1.71973 2.8124,-2.53125 0.4133,-0.37598 0.5416,-1.09522 0.875,-1.5625 1.3741,-1.92334 2.8115,-4.20019 2.1876,-6.625 -0.4611,-1.14209 -1.169,-1.9165 -1.7813,-2.9375 -0.6914,-1.15283 -1.1345,-2.57617 -1.9687,-3.65625 -1.8963,-2.45215 -4.1675,-4.771 -5.9688,-7.3125 -0.9502,-1.3418 -1.4338,-2.7041 -2.7189,-3.875 -0.9882,-0.90186 -2.4746,-1.05371 -3.4686,-2 -2.0356,-1.9375 -2.8151,-2.57813 -4.9687,-4.28125 -0.4303,-0.34033 -0.7271,-0.88916 -1.2188,-1.1875 -2.6565,-1.6123 -4.5578,-2.14356 -7.3125,-4.125 -0.5605,-0.2749 -1.0996,-0.93018 -1.75,-1.40625 -1.9385,-1.41895 -3.9977,-2.57911 -5.9687,-3.875 -1.2642,-0.83008 -2.3355,-2.00635 -3.5626,-2.8125 -0.8442,-0.55469 -3.0443,-1.22363 -4.0624,-1.4375 -6.7399,-0.75977 -3.8985,-2.08887 -7.0313,-3.375 -0.8154,-0.33496 -1.6138,-0.41821 -2.4064,-0.6875 -1.7265,-0.58691 -3.3443,-1.52563 -5.1561,-1.96875 -1.062,-0.26001 -2.3158,-0.4707 -3.3439,-0.8125 -1.0219,-0.33936 -7.3724,-5.19116 -8.5936,-6.15625 -0.4323,-0.4173 -0.7503,-0.96894 -1,-1.5625 L 1071.25,927.5 c -2.7714,1.78418 -3.082,-0.8125 -6.2188,2.90625 l -3.9687,-2.25 c -0.5576,-2.01953 0.7647,-5.5166 1.9375,-7.09375 l 1.8125,-0.75 c -0.3509,-1.01131 0.2341,-2.67472 -0.5625,-3.75 -0.7447,-1.00537 -2.2529,-1.31787 -2.6875,-2.625 -0.5767,-1.73438 1.3951,-2.23315 1.8125,-3.3125 0.202,-0.52344 0.067,-1.10425 0.25,-1.625 0.1211,-0.34399 0.436,-0.63135 0.5,-1 0.3579,-2.05859 -3.3629,-3.14966 -5,-4.21875 l -0.062,-0.375 c 0.2549,-0.0266 0.5024,-0.0564 0.75,-0.125 L 1060.0312,903 c -0.014,-0.24023 0.077,-0.60009 0.25,-0.78125 l 0.3438,-0.0937 c 0.3994,0.05 0.7555,0.30765 1.1562,0.28125 0.9607,-0.6272 1.6582,0.003 2.4688,0.46875 l 0.4062,-0.0937 c 1.0615,-1.21975 1.1182,-0.573 2.0938,-1.21875 0.6826,-0.4519 1.8033,-2.71802 1.7188,-3.5625 0.4627,-1.00903 1.5507,-0.6709 1.7812,-1.53125 0.2436,-0.91064 -0.6153,-1.59571 -0.75,-2.4375 -0.336,-2.09473 1.6059,-7.47705 -1,-8.5 -0.5957,-0.38672 -2.101,-0.73633 -2.4688,-1.09375 -0.069,-0.45494 0.1811,-0.97285 0.375,-1.5 l -0.1874,0.0625 -4.4688,0.65625 c -3.7676,0.53272 -2.4868,3.15771 -7.3125,2.1875 -0.8902,-0.38086 -5.6802,-4.72656 -6.125,-5.3125 l -0.3437,-0.4375 c -1.1316,-1.51806 -2.2564,-1.7285 -4.0313,-1.8125 -3.1367,-0.14892 -4.0602,-2.78735 -6.4687,-4.3125 -7.3762,-4.67016 -5.5889,-2.43994 -13.2188,-3.0625 l -0.1875,-0.3125 c -0.9258,-1.62698 -1.8302,-2.31128 -3.7813,-1.65625 -0.913,-0.42725 -0.4658,-1.16846 -0.3437,-2.03125 0.4345,-3.08179 -2.0473,-5.0918 -4.6875,-2.5 l -0.3438,0.375 -0.2187,0.21875 c -1.4423,-0.11282 -2.9008,-0.0513 -4.3437,-0.15625 -2.8696,-0.20801 -3.9204,-4.53833 -6.625,-5.96875 l -0.3438,-0.125 c -1.8403,-0.37574 -3.9917,0.97363 -5.375,2.0625 -0.0967,10e-4 -0.18845,0.0915 -0.28125,0.0625 -0.9541,-0.2998 -9.78906,-4.94751 -10.0625,-5.625 -1.5586,-3.85938 -5.40918,-5.59302 -9.09375,-6.78125 -1.14063,-0.36816 -2.08838,-1.79614 -3.53125,-2.3125 -1.29932,-0.46484 -6.15381,-4.07275 -7.25,-5.40625 -2.77336,-3.37488 -5.84095,-6.34038 -9.40625,-8.1875 z",
						"larioja":"m 472.4375,458.25 c -0.51184,-0.008 -1.01074,0.0341 -1.28125,0.21875 -1.52393,1.03979 -0.98632,2.04248 -3.46875,2.4375 -1.54053,0.24512 -2.66553,-1.59253 -4.21875,-1.71875 -2.68018,1.02661 -3.18213,0.33057 -5.3125,0.78125 -0.91113,0.19287 -1.55224,0.79761 -2.375,1.125 -0.86279,0.34302 -1.99023,0.60205 -2.90625,0.875 -3.30762,0.98535 -7.20069,-0.41211 -10.5625,-0.71875 -1.23521,-0.11269 -2.4758,-0.23989 -3.71875,-0.21875 -0.53814,2.17288 -1.26648,4.36199 -1.71875,6.40625 -0.0798,0.36109 0.0137,0.87378 -0.0937,1.21875 -0.40625,1.30786 -2.00757,2.48682 -3.03125,3.28125 -0.16601,0.68506 -0.24609,1.42139 -0.625,2.03125 -0.5332,0.57568 -1.97192,0.4661 -2.6875,0.375 -2.46777,1.09448 -1.94092,2.823 -2.65625,4.8125 l -1.125,0.75 c -0.13211,0.82324 -0.20875,1.66626 -0.21875,2.5 -0.47315,0.39258 -1.27612,2.47729 -1.84375,3.1875 -0.88232,1.104 -1.34741,0.85815 -2.28125,1.53125 -0.219,0.81396 -0.84692,1.95215 -1.21875,2.75 L 420.5,490.09375 c -0.90332,-0.56372 -2.43579,-2.22975 -3.375,-2.21875 -0.91042,0.96094 -1.85156,2.5271 -0.9375,3.8125 -0.96753,1.79981 -0.0918,5.29956 -2.4375,6.15625 -0.69775,-0.0422 -1.49634,-0.0767 -2.1875,0.0625 -1.22168,1.07324 -1.91772,2.46289 -2.96875,3.65625 -0.83984,0.094 -1.79419,0.12476 -2.625,-0.0312 l -0.34375,0.3125 c -0.14831,0.57135 0.40208,1.60952 0.6875,2.1875 l 0.0312,0 c 3.5105,0.59131 3.50342,2.82739 7.34375,1.46875 1.95337,-0.69068 2.06274,-0.36792 2.875,1.6875 0.89697,2.27027 3.12134,1.77637 5.09375,1.4375 0.22559,-0.0388 1.00122,0.0791 1.125,0.1875 3.53345,3.09815 7.15137,6.62061 10.90625,9.4375 0.17039,0.73389 -0.0127,1.57153 0.25,2.28125 0.3772,1.0188 1.0791,1.59888 1.53125,2.53125 0.47216,0.97216 0.91605,4.35864 0.96875,5.59375 3.76172,3.4441 7.58252,6.84448 11.40625,10.21875 1.09619,4.35474 -0.87109,6.43066 1.03125,11.03125 0.88964,2.15186 0.34717,1.57788 -0.46875,3.3125 0.0645,1.19116 0.64453,3.47925 -1.03125,3.9375 -0.56006,0.0847 -0.9707,-0.49025 -1.53125,-0.40625 L 445.625,557 c -0.0669,0.42334 -0.0376,0.80835 -0.0625,1.21875 -0.0439,0.73974 -0.32617,4.72534 -0.15625,5.25 0.24267,0.75268 1.104,1.26074 1.125,2.03125 -0.27344,1.3645 -1.36914,0.91602 -2.1875,1.5 -0.34228,0.70166 -0.1338,2.1211 -0.1875,2.875 -0.0537,0.7539 -0.64555,1.90601 -0.59375,2.5 0.0845,0.95996 0.8208,1.82471 0.71875,2.6875 -0.0957,0.80664 -1.72949,2.26563 -2.15625,3.28125 -0.57227,1.36255 -0.65283,3.22998 -0.78125,4.6875 -0.61719,7.01367 4.89307,3.51953 8,3.03125 1.52588,-0.23951 2.04834,1.32983 3.65625,1.21875 2.63428,-0.18261 4.67871,-2.3125 7.96875,-2.3125 1.99023,0 3.45215,2.49951 5.34375,3.125 1.44532,0.47851 3.07715,-0.39995 4.53125,-0.34375 2.42138,0.0928 4.14355,0.92432 6.40625,1.71875 1.86133,0.65332 2.9375,0.94873 4.90625,1.15625 0.12402,0.0132 0.25635,0.0852 0.375,0.125 0.97022,0.85474 1.27002,3.12646 2.8125,4.15625 0.28077,0.1875 0.69873,0.27197 1,0.4375 1.45606,0.8003 2.05029,2.08691 3.78125,2.625 0.54737,0.17042 0.91406,0.25415 1.3125,0.6875 0.90088,0.97925 0.76123,3.07104 1.75,3.625 0.93018,0.521 2.30566,0.42017 3.34375,0.9375 0.88427,0.44092 1.23096,1.26685 1.8125,2 0.27637,0.34888 0.95361,0.34326 1.3125,0.6875 2.23877,2.14795 -1.03662,2.82886 4.53125,5.625 1.03711,0.52075 1.53174,2.65698 2.40625,3.625 3.17432,3.51441 6.14404,1.47144 8.4375,7.0625 0.1001,0.0415 7.23926,5.4126 7.5625,5.71875 0.92383,0.87524 2.33594,2.06543 3.03125,3.15625 1.32519,2.08081 1.24707,6.15259 2.28125,7.3125 1.1377,1.27588 3.23975,1.81323 4.625,2.84375 1.02881,0.76563 1.76367,3.49023 2.65625,4.6875 1.23975,1.66259 2.89355,2.16455 4.375,3.40625 0.39404,0.33007 0.88086,0.80225 1.21875,1.1875 l 0.5,0.71875 c 0.37109,0.53736 0.354,1.14453 0.6875,1.6875 0.75196,1.2273 1.87402,2.21997 2.5625,3.46875 l 0.34375,0.8125 c 0.14258,0.3335 0.39258,0.6604 0.5,1 0.91407,0.76879 2.40723,1.11182 3.5,1.59375 1.1753,0.51856 2.11768,2.81104 2.59375,3.90625 0.31495,0.7251 0.42139,1.58032 0.6875,2.3125 0.62597,1.72363 2.89258,5.08594 3.9375,6.5625 0.0576,0.0818 0.085,0.18895 0.125,0.28125 l 0.3125,0.21875 c -0.8374,1.41114 -2.47217,7.46851 -3.09375,9.375 L 557.5,685.5 c 0.0234,0.0732 -2.69238,18.13208 -2.84375,18.75 2.71582,5.51782 3.49707,2.89722 3.375,10.5 -0.0352,2.15674 2.62988,3.58496 4.03125,4.90625 0.75488,0.7124 1.25,1.59619 2.21875,2.125 1.70703,0.93232 4.87842,0.60693 5.46875,0.9375 0.57808,0.46875 -0.2749,2.42529 0.0312,2.9375 l 4.71875,7.875 c 1.17188,1.96192 1.44727,3.97925 2.4375,5.9375 1.1709,0.27075 2.31396,-0.0356 3.65625,0.40625 1.63183,0.53809 3.0376,1.9939 4.625,2.4375 1.38721,0.38745 2.06934,-1.2981 3.25,-1.1875 1.08008,0.10157 1.54297,1.4214 2.625,1.4375 1.38477,0.0212 2.74463,-0.68945 4.125,-0.5625 0.74121,0.0681 1.99658,1.4688 3.03125,1.5625 1.53418,0.1394 1.69824,-0.70776 2.625,-0.90625 1.03564,-0.22168 2.49951,0.729 3.78125,0.5625 5.70947,-0.74121 6.08496,-2.70068 9.9375,-3.59375 4.15234,-0.96241 6.29004,-1.43701 9.71875,1.375 0.48193,-0.0132 3.28906,0.24194 3.46875,0.4375 1.4043,-0.54273 4.9585,-1.53662 6.5,-1.375 l -0.0625,-0.25 -0.0625,-10.65625 -0.0312,-1.1875 0,-4.75 -0.0312,-1.1875 -0.0312,-8.28125 -0.0625,-1.1875 0.0312,-2.375 L 634,709 l -0.0625,-8.28125 -0.0312,-1.1875 0.0312,-2.375 -0.0625,-3.5625 -0.0312,-9.46875 0.75,-2.1875 0.4375,-1.125 3.84375,-11.1875 1.21875,-3.3125 8.15625,-27.125 1.78125,-1.96875 0.46875,-1.125 4.90625,-14.53125 3.90625,-1.15625 1.21875,-0.3125 10,-2.84375 1.09375,-1.1875 -3.40625,-4.03125 c -0.10645,-0.12622 -0.0806,-0.62622 -0.1875,-0.75 -11.35156,-13.11816 -22.6333,-26.38086 -33.5,-39.90625 -0.22217,-2.76514 0.6543,-4.07325 -0.40625,-7.1875 l -0.34375,-0.59375 c -0.81445,-1.24316 -1.55029,-3.19751 -2.53125,-4.25 -1.80908,-1.94165 -4.05224,-3.65747 -6,-5.46875 -0.97217,-0.9043 -1.6167,-2.12769 -2.65625,-2.96875 -1.16943,-0.94556 -2.51269,-1.1167 -3.625,-2.28125 -1.42334,-1.49023 -2.60596,-3.2295 -4.125,-4.65625 L 613.875,543.0625 c -5.41846,-5.09009 -12.771,-5.33545 -16.09375,-10.09375 -1.54834,-2.21729 3.80029,-4.28198 2.5,-6.90625 -0.95361,-0.78784 -2.52686,-0.85083 -3.4375,-1.84375 -0.86328,-0.94092 -2.09082,-1.86914 -2.875,-2.8125 -2.71631,-3.27051 -1.74902,-5.43725 -2.59375,-9 -0.20215,-0.85181 -0.30518,-1.9209 -0.75,-2.6875 -0.94385,-1.62695 -3.64453,-4.14258 -5.46875,-4.59375 -1.05176,-0.26001 -2.40088,-0.3291 -3.375,-0.8125 -1.06201,-0.52686 -1.7085,-1.65455 -2.84375,-2 -0.96484,-0.29346 -1.94287,0.0308 -2.90625,-0.71875 -2.58008,-1.94043 -3.26026,-0.83399 -5.40625,-1.65625 -1.19482,-0.45801 -1.92822,-1.68701 -3.09375,-2.28125 -1.84912,-0.94287 -6.62256,-3.11499 -8.78125,-2.34375 -1.14697,0.40942 -2.15479,3.8816 -4.09375,4.40625 -3.96875,1.07397 -10.20703,-0.23535 -14.59375,-0.53125 -1.23145,-0.0833 -1.35058,-2.43506 -2.59375,-2.90625 -0.70557,-0.26758 -1.47706,-0.4685 -2.0625,-0.96875 -0.9917,-0.8479 -4.54053,-4.71094 -5.9375,-2.59375 -0.48242,0.73193 -0.67481,2.92603 -0.9375,3.125 -1.11377,0.44678 -1.43115,-0.3584 -2.21875,1.375 -1.60254,3.52637 -2.82081,6.39966 -7.3125,4.5 -1.02832,-0.43481 -1.98047,-1.15088 -3.03125,-1.59375 -2.50098,0.0957 -1.41748,1.19775 -2.875,2.1875 -1.50635,0.42139 -1.44092,-2.30566 -1.71875,-3.03125 -0.54053,-1.4126 -3.52148,-4.17285 -4.34375,-6.15625 -0.78662,-1.89844 -0.69092,-4.0398 -1.125,-6 -0.13672,-0.61719 0.40137,-1.54981 0.3125,-2.21875 -0.0757,-0.56592 -1.33057,-1.03492 -1.78125,-1.09375 -0.56006,0.32251 -0.99755,0.8169 -1.5625,1.15625 -0.58301,0.064 -1.4336,-0.12627 -1.9375,0.0625 -1.46436,0.54932 -2.66894,1.64795 -4.28125,1.8125 -1.78955,0.18286 -2.18555,-3.14136 -4.25,-3.84375 -0.90967,-0.30933 -2.33447,-0.73926 -3.28125,-0.90625 -1.30078,-0.229 -2.44483,0.56885 -3.875,-0.0625 -2.41797,-1.06738 -1.14404,-5.24219 -6.875,-5.03125 -0.37646,0.0137 -1.14697,0.22709 -1.5,0.0937 -1.25732,-0.47461 -1.47168,-2.04614 -1.21875,-3.1875 l 0.5,-2.21875 c 0.14844,-0.67017 0.50781,-1.33911 0.46875,-2.0625 -0.12549,-2.33569 -2.1582,-1.00098 -0.5,-6.46875 1.0083,-3.32471 1.26465,-4.47607 -2.34375,-4.8125 -0.30713,-0.0285 -0.83191,-0.086 -1.34375,-0.0937 z",
						"catamarca":"m 472.09375,283.09375 c -3.3e-4,0.18755 0.002,0.37519 0,0.5625 -0.7754,0.42505 -1.91699,1.11719 -2.375,1.875 l 0.34375,1.6875 -0.625,0.71875 c -0.64404,2.20044 2.8457,3.85352 0.3125,8.09375 -0.49121,0.82275 -1.30811,1.6084 -2.28125,1.84375 -0.3374,0.34033 -0.84375,1.17261 -0.78125,1.6875 1.82472,3.50073 2.7124,1.66528 1.75,6.09375 0.71337,1.16674 1.80273,2.021 2.5625,3.15625 -0.5542,0.44702 -0.9873,2.60498 -1.09375,3.3125 0.34912,1.52002 2.99512,3.25513 3.3125,4.96875 0.22412,1.2102 0.25781,2.57959 0.375,3.8125 0.0483,0.50879 0.19235,1.1106 0.28125,1.625 1.77002,10.24609 3.46484,20.51978 5.03125,30.78125 l -0.15625,0.25 c -0.62354,0.13477 -10.3457,7.4873 -10.46875,7.65625 -0.65039,4.48462 -0.75732,9.22534 -1,13.75 5.18213,9.02759 10.89697,17.69971 16.6875,26.34375 0.60108,0.22559 1.63721,0.7124 1.9375,1.34375 -1.09668,1.48267 -3.271,3.1416 -3.1875,5.0625 l 0.875,1.28125 c -0.41064,0.76294 -0.84326,2.65771 -1.46875,3.03125 -2.81445,0.50468 -5.04199,-0.5813 -8.53125,0.59375 -1.46045,1.82886 -3.05176,4.20361 -3.46875,6.53125 -0.11621,0.64672 -0.0439,1.26831 -0.28125,1.90625 l -1.15625,0 c 0,0 -1.41895,-1.10034 -1.84375,-0.96875 -2.06495,-0.1958 -3.85791,-3.91235 -4.0625,-5.6875 l -1.21875,-0.4375 c -1.48145,0.85425 -3.47705,0.54932 -5,1.375 -1.71729,2.64135 -5.4668,5.89575 -4.84375,9.34375 0.19873,1.1018 1.36768,2.26978 1.84375,3.34375 -0.32959,0.78882 -1.6582,1.19751 -2.125,2 -0.35205,0.60571 -1.86719,4.38354 -2.375,5.46875 -1.44043,3.07666 -3.97021,9.51172 -5.71875,12.0625 -1.49121,0.46801 -3.33594,3.00854 -4.0625,4.34375 0.19091,1.12402 0.46195,2.19092 0.40625,3.34375 l 0.4375,0.625 -0.0937,1.03125 -0.8125,0.65625 c -0.0769,1.12545 -0.33523,2.29874 -0.625,3.46875 1.24295,-0.0211 2.48354,0.10606 3.71875,0.21875 3.36181,0.30664 7.25488,1.7041 10.5625,0.71875 0.91602,-0.27295 2.04346,-0.53198 2.90625,-0.875 0.82276,-0.32739 1.46387,-0.93213 2.375,-1.125 2.13037,-0.45068 2.63232,0.24536 5.3125,-0.78125 1.55322,0.12622 2.67822,1.96387 4.21875,1.71875 2.48243,-0.39502 1.94482,-1.39771 3.46875,-2.4375 0.54101,-0.36938 2.01074,-0.1821 2.625,-0.125 3.6084,0.33643 3.35205,1.48779 2.34375,4.8125 -1.6582,5.46777 0.37451,4.13306 0.5,6.46875 0.0391,0.72339 -0.32031,1.39233 -0.46875,2.0625 l -0.5,2.21875 c -0.25293,1.14136 -0.0386,2.71289 1.21875,3.1875 0.35303,0.13334 1.12354,-0.0801 1.5,-0.0937 5.73096,-0.21094 4.45703,3.96387 6.875,5.03125 1.43017,0.63135 2.57422,-0.1665 3.875,0.0625 0.94678,0.16699 2.37158,0.59692 3.28125,0.90625 2.06445,0.70239 2.46045,4.02661 4.25,3.84375 1.61231,-0.16455 2.81689,-1.26318 4.28125,-1.8125 0.5039,-0.18877 1.35449,0.002 1.9375,-0.0625 0.56495,-0.33935 1.00244,-0.83374 1.5625,-1.15625 0.45068,0.0588 1.70555,0.52783 1.78125,1.09375 0.0889,0.66894 -0.44922,1.60156 -0.3125,2.21875 0.43408,1.9602 0.33838,4.10156 1.125,6 0.82227,1.9834 3.80322,4.74365 4.34375,6.15625 0.27783,0.72559 0.2124,3.45264 1.71875,3.03125 1.45752,-0.98975 0.37402,-2.0918 2.875,-2.1875 1.05078,0.44287 2.00293,1.15894 3.03125,1.59375 4.49169,1.89966 5.70996,-0.97363 7.3125,-4.5 0.7876,-1.7334 1.10498,-0.92822 2.21875,-1.375 0.26269,-0.19897 0.45508,-2.39307 0.9375,-3.125 1.39697,-2.11719 4.9458,1.74585 5.9375,2.59375 0.58544,0.50025 1.35693,0.70117 2.0625,0.96875 1.24317,0.47119 1.3623,2.82295 2.59375,2.90625 4.38672,0.2959 10.625,1.60522 14.59375,0.53125 1.93896,-0.52465 2.94678,-3.99683 4.09375,-4.40625 2.15869,-0.77124 6.93213,1.40088 8.78125,2.34375 1.16553,0.59424 1.89893,1.82324 3.09375,2.28125 2.14599,0.82226 2.82617,-0.28418 5.40625,1.65625 0.96338,0.74954 1.94141,0.42529 2.90625,0.71875 1.13525,0.34545 1.78174,1.47314 2.84375,2 0.97412,0.4834 2.32324,0.55249 3.375,0.8125 1.82422,0.45117 4.5249,2.9668 5.46875,4.59375 0.44482,0.7666 0.54785,1.83569 0.75,2.6875 0.84473,3.56275 -0.12256,5.72949 2.59375,9 0.78418,0.94336 2.01172,1.87158 2.875,2.8125 0.91064,0.99292 2.48389,1.05591 3.4375,1.84375 1.30029,2.62427 -4.04834,4.68896 -2.5,6.90625 3.32275,4.7583 10.67529,5.00366 16.09375,10.09375 l 0.96875,0.90625 c 1.51904,1.42675 2.70166,3.16602 4.125,4.65625 1.11231,1.16455 2.45557,1.33569 3.625,2.28125 1.03955,0.84106 1.68408,2.06445 2.65625,2.96875 1.94776,1.81128 4.19092,3.5271 6,5.46875 0.98096,1.05249 1.7168,3.00684 2.53125,4.25 l 0.34375,0.59375 c 1.06055,3.11425 0.18408,4.42236 0.40625,7.1875 10.8667,13.52539 22.14844,26.78809 33.5,39.90625 0.10692,0.12378 0.0811,0.62378 0.1875,0.75 l 3.40625,4.03125 c 3.92871,-4.36719 8.21582,-8.70264 11.84375,-13.28125 -0.30029,-0.81788 -2.10693,-17.58228 -2.34375,-19.59375 1.61865,-0.49853 3.31836,-0.84521 4.96875,-1.21875 -0.87403,-0.87597 -3.42383,-6.02051 -4.0625,-7.4375 -0.91943,-2.04151 -2.1123,-3.80737 -3.03125,-5.84375 -0.5122,-1.13574 -0.90088,-2.34766 -1.40625,-3.46875 -0.8501,-1.88769 -1.42529,-4.08105 -1.59375,-6.15625 -0.2793,-3.43872 -0.57959,-6.84668 -0.875,-10.28125 -0.15137,-1.75561 -0.7217,-2.99756 -0.625,-4.84375 0.29785,-5.70215 -0.20166,-11.22729 -0.6875,-16.90625 -0.0855,-1 -0.0552,-1.9668 -0.34375,-2.96875 -0.4961,-1.72217 -3.20703,-3.15381 -4.84375,-3.3125 -0.17186,-0.37207 -0.23735,-3.40576 -0.15625,-3.9375 0.28564,-0.33964 1.33643,-0.37255 1.71875,-0.40625 0.46827,-0.70679 0.74512,-2.10864 1.125,-2.9375 0.40039,-0.87182 1.47266,-1.43506 2.0625,-2.1875 1.83789,-2.34521 1.56735,-6.61865 1.46875,-9.46875 -0.10742,-3.08374 -0.18994,-6.41406 -0.90625,-9.40625 -0.57861,-2.41944 -3.82813,-21.36621 -4.78125,-22.34375 -4.86426,3.46924 -7.01807,-2.28223 -9.6875,-3.53125 -0.21045,-0.0103 -0.48243,0.0598 -0.65625,0.1875 -1.59961,1.17285 -3.77295,2.07593 -5.25,3.3125 -0.6543,0.5481 -1.12646,1.36376 -1.78125,1.9375 -0.71289,0.62427 -1.70264,1.10279 -2.28125,1.875 -1.24414,1.66016 -3.01367,5.7749 -3.3125,6.0625 -1.08545,0.30371 -2.39258,-2.86426 -3.1875,-3.625 -1.88525,-1.80371 -2.46777,-2.0813 -3.3125,-4.4375 -0.47266,-1.31812 -0.92432,-2.70117 -1.0625,-4.09375 -0.32324,-3.25928 -0.0723,-3.33765 -2.625,-5.09375 -0.5874,-0.40454 -1.31983,-1.06836 -2.0625,-1.1875 -0.30518,0.0596 -0.3291,0.22998 -0.53125,0.375 -5.36719,3.8562 -4.51611,-2.79077 -5.71875,-5.9375 -0.67188,-1.75854 -3.35986,0.32202 -3.8125,-5.71875 -0.0776,-1.03638 -0.72119,-1.89014 -1.0625,-2.84375 -0.18945,-0.52881 -1.72607,-8.03051 -1.90625,-9.09375 -0.24707,-1.45801 0.86768,-1.88769 0.71875,-2.84375 -0.0977,-0.18555 -0.23779,-0.37598 -0.40625,-0.5 -1.43604,-0.25293 -3.07276,-0.0606 -4.3125,-1 -0.82422,-0.62524 -1.66016,-1.85059 -2.75,-2.09375 -3.44287,-0.76929 -7.45118,0.45459 -4.375,-3.96875 0.9248,-1.32959 1.11328,-3.1438 2.09375,-4.34375 0.9668,-1.18311 2.29004,-1.66308 3.25,-2.78125 1.70508,-1.9856 1.59131,-4.58594 4.09375,-7.28125 2.68945,-2.89722 6.43604,-5.73169 7.9375,-9.53125 1.47949,-3.74438 0.20215,-6.14697 1.5,-10.84375 1.61523,-5.84473 -2.73584,-5.13501 -6.0625,-8.375 -2.77148,-2.69922 -3.69385,-4.67286 -7.96875,-5.375 -10.05029,-1.65015 -6.28125,0.66186 -6.84375,-6.84375 -0.13965,-1.86719 -0.98584,-3.81713 -0.5,-5.6875 0.5459,-2.10352 2.64649,-2.70678 3.21875,-4.40625 0.51074,-1.51782 -0.36426,-5.24341 0.5625,-6.375 -1.34717,-0.0647 -2.68408,0.1257 -4.03125,0.0625 -2.64062,-0.12354 -3.81543,-0.80225 -5.21875,1.8125 -0.86426,1.60938 -1.50781,3.44409 -2.0625,5.1875 -0.39941,1.25659 -0.92724,3.02759 -2.125,3.71875 -2.1665,0.36963 -4.13037,-2.8479 -5.40625,-4.1875 -1.11328,-1.1687 -2.26416,-2.31811 -3.1875,-3.6875 -0.94043,-1.39502 -1.41602,-3.34888 -2.03125,-4.9375 -1.26709,-3.271 -2.34473,-2.03344 -3.375,-6.71875 -0.14209,-0.64551 -0.94971,-0.96118 -1.34375,-1.46875 -0.97363,-1.25439 -0.99365,-2.25806 -2.21875,-3.625 -1.36816,-1.5271 -2.15528,-3.11938 -3.3125,-4.84375 -0.71484,-1.06494 -1.72901,-1.97583 -2.4375,-3.03125 -1.04248,-1.55298 -1.63135,-3.08691 -2.03125,-4.90625 -0.35449,-1.61133 -0.90429,-6.2334 0.125,-7.6875 0.55078,-0.77856 2.59912,-2.22534 3.375,-3.0625 0.10596,-0.1145 0.74515,-0.4405 0.84375,-0.4375 3.15039,0.11279 3.51806,-0.13159 6.28125,-0.375 2.57227,-0.22632 2.2124,0.95459 4.78125,-0.90625 5.35693,-3.88037 2.38525,-2.52881 3.03125,-6.15625 0.16016,-0.90039 0.88282,-1.52441 1.09375,-2.34375 1.22949,-4.77905 0.39746,-3.93359 -2.3125,-8.03125 -1.19092,-1.80029 0.0899,-7.63769 -2.65625,-9.625 l -1.125,-0.0312 c -18.09766,0.38281 -36.18164,0.57715 -54.28125,0.78125 -3.75,0.0422 -14.92578,0.58691 -18.0625,0.1875 -4.45166,-0.56689 -6.88233,-1.36475 -11.28125,-2.25 l -22.5625,-4.53125 c -2.43213,-0.48901 -5.13525,-0.84326 -7.4375,-1.8125 z m 174.125,64.03125 c -0.0974,0.003 -0.18883,0.0229 -0.28125,0.0312 0.26359,-0.0227 0.54416,-0.0484 0.84375,-0.0312 -0.19105,-0.01 -0.38491,-0.006 -0.5625,0 z",
						"tucuman":"M 659.71875 345.25 C 657.62549 345.35357 654.97439 349.2549 652.84375 348.59375 C 651.18848 348.07984 646.83887 346.54102 645.03125 347.34375 C 644.70118 347.12817 644.41455 347.10205 644.0625 347 C 643.23535 346.76025 640.0957 345.29395 639.84375 345.28125 C 637.82812 346.17798 639.01025 350.30811 638.71875 351.875 C 638.25977 354.34327 637.68018 353.87378 637.875 356.90625 C 638.00585 358.94385 638.14258 358.93506 636.90625 360.75 C 636.39942 361.49414 631.43848 360.06104 630.5625 359.9375 C 626.11328 359.31055 621.70508 358.51025 617.28125 357.71875 L 611.0625 356 C 610.13574 357.13159 611.01074 360.85718 610.5 362.375 C 609.92774 364.07447 607.82715 364.67773 607.28125 366.78125 C 606.79541 368.65162 607.6416 370.60156 607.78125 372.46875 C 608.34375 379.97436 604.57471 377.66235 614.625 379.3125 C 618.8999 380.01464 619.82227 381.98828 622.59375 384.6875 C 625.92041 387.92749 630.27148 387.21777 628.65625 393.0625 C 627.3584 397.75928 628.63574 400.16187 627.15625 403.90625 C 625.65479 407.70581 621.9082 410.54028 619.21875 413.4375 C 616.71631 416.13281 616.83008 418.73315 615.125 420.71875 C 614.16504 421.83692 612.8418 422.31689 611.875 423.5 C 610.89453 424.69995 610.70605 426.51416 609.78125 427.84375 C 606.70507 432.26709 610.71338 431.04321 614.15625 431.8125 C 615.24609 432.05566 616.08203 433.28101 616.90625 433.90625 C 618.14599 434.84566 619.78271 434.65332 621.21875 434.90625 C 621.38721 435.03027 621.5273 435.2207 621.625 435.40625 C 621.77393 436.36231 620.65918 436.79199 620.90625 438.25 C 621.08643 439.31324 622.62305 446.81494 622.8125 447.34375 C 623.15381 448.29736 623.7974 449.15112 623.875 450.1875 C 624.32764 456.22827 627.01562 454.14771 627.6875 455.90625 C 628.89014 459.05298 628.03906 465.69995 633.40625 461.84375 C 633.6084 461.69873 633.63232 461.52835 633.9375 461.46875 C 634.68017 461.58789 635.4126 462.25171 636 462.65625 C 638.55273 464.41235 638.30176 464.49072 638.625 467.75 C 638.76318 469.14258 639.21484 470.52563 639.6875 471.84375 C 640.53223 474.19995 641.11475 474.47754 643 476.28125 C 643.79492 477.04199 645.10205 480.20996 646.1875 479.90625 C 646.48633 479.61865 648.25586 475.50391 649.5 473.84375 C 650.07861 473.07154 651.06836 472.59302 651.78125 471.96875 C 652.43604 471.39501 652.9082 470.57935 653.5625 470.03125 C 655.03955 468.79468 657.21289 467.8916 658.8125 466.71875 C 658.98632 466.59103 659.2583 466.52095 659.46875 466.53125 C 662.13818 467.78027 664.29199 473.53174 669.15625 470.0625 L 669.15625 469.96875 C 671.04199 468.36865 674.56592 470.72021 675.5 467.875 C 676.23389 465.64014 676.61377 463.95215 676.9375 461.625 C 676.95264 461.51368 677.05075 461.35449 677.09375 461.25 C 677.63281 460.62622 678.69287 461.56104 679.3125 461.09375 C 679.56885 460.84912 679.54883 460.37305 679.4375 460.0625 C 679.14795 459.25293 678.5293 458.51855 678.09375 457.78125 C 677.04883 456.01294 676.19922 453.93628 675.375 452.0625 C 674.83299 450.83057 674.8999 448.35547 675.40625 447.03125 C 676.30176 446.08936 679.40283 448.77148 681.125 443.40625 L 680.9375 442.875 C 680.10449 442.2053 678.89258 442.56885 678.125 442.15625 L 675.28125 440.625 L 675.375 440.375 L 675.5 440.125 L 675.59375 439.875 L 675.8125 439.46875 C 676.07666 438.97046 676.23535 438.67188 676.625 438.25 C 677.60498 437.18824 679.2627 436.2312 680.09375 435.125 C 681.06983 433.8252 681.76074 432.10327 683 430.78125 C 683.97559 430.53272 685.18701 430.53223 686.09375 430.125 C 686.3457 429.32446 687.47314 424.93018 687.9375 424.3125 L 688.71875 424.3125 C 689.22656 423.37476 689.08887 422.05737 689.59375 421.0625 L 690.09375 420.75 C 690.37207 419.19776 690.83105 417.3501 691.34375 415.84375 C 691.88525 412.65869 691.73389 410.11255 694.9375 409.09375 C 695.04247 408.8479 695.0796 408.52881 695.125 408.1875 C 696.09765 403.63868 697.3501 399.15356 698.25 394.59375 C 699.19385 394.81518 700.93506 395.04224 701.6875 394.21875 C 702.33594 391.47192 703.24561 388.63843 703.625 385.84375 C 705.35644 386.22242 707.11768 386.66553 708.875 386.90625 C 709.17627 383.18823 708.52881 379.24707 707.9375 375.59375 C 707.65576 373.8518 707.0977 371.72827 707.1875 369.9375 C 707.26709 368.35156 708.28613 366.45557 708.78125 364.9375 C 709.7793 361.87988 709.7749 360.07397 709.5 356.9375 C 709.4531 356.406 709.56595 355.86133 709.46875 355.34375 L 709.34375 355.5 C 707.03223 355.73686 704.65088 355.25415 702.28125 355.46875 C 700.45703 355.63405 698.32812 355.82202 696.5 355.65625 C 693.90821 355.42114 693.62842 354.3269 690.59375 354.8125 C 687.34521 355.33276 686.78467 358.53003 683.46875 359.0625 C 680.03711 359.61304 677.93994 355.34814 676.25 356.5625 C 676.07568 356.6875 675.81205 356.81543 675.78125 357.0625 C 672.16016 355.20191 666.78467 352.99219 663.0625 351.71875 L 662.125 348.25 C 661.50168 345.9492 660.67023 345.20292 659.71875 345.25 z ",
						"santiago":"M 726.625 311.25 L 726.1875 312.375 C 721.73242 322.46191 717.35644 332.58179 712.875 342.65625 C 712.23242 344.10059 713.13623 346.07349 712.65625 347.5 C 711.62012 350.57593 709.8584 351.88428 709.46875 355.34375 C 709.56595 355.86133 709.4531 356.406 709.5 356.9375 C 709.7749 360.07397 709.7793 361.87988 708.78125 364.9375 C 708.28613 366.45557 707.26709 368.35156 707.1875 369.9375 C 707.0977 371.72827 707.65576 373.8518 707.9375 375.59375 C 708.52881 379.24707 709.17627 383.18823 708.875 386.90625 C 707.11768 386.66553 705.35644 386.22242 703.625 385.84375 C 703.24561 388.63843 702.33594 391.47192 701.6875 394.21875 C 700.93506 395.04224 699.19385 394.81518 698.25 394.59375 C 697.3501 399.15356 696.09765 403.63868 695.125 408.1875 C 695.0796 408.52881 695.04247 408.8479 694.9375 409.09375 C 691.73389 410.11255 691.88525 412.65869 691.34375 415.84375 C 690.83105 417.3501 690.37207 419.19776 690.09375 420.75 L 689.59375 421.0625 C 689.08887 422.05737 689.22656 423.37476 688.71875 424.3125 L 687.9375 424.3125 C 687.47314 424.93018 686.3457 429.32446 686.09375 430.125 C 685.18701 430.53223 683.97559 430.53272 683 430.78125 C 681.76074 432.10327 681.06983 433.8252 680.09375 435.125 C 679.2627 436.2312 677.60498 437.18824 676.625 438.25 C 676.23535 438.67188 676.07666 438.97046 675.8125 439.46875 L 675.59375 439.875 L 675.5 440.125 L 675.375 440.375 L 675.28125 440.625 L 678.125 442.15625 C 678.89258 442.56885 680.10449 442.2053 680.9375 442.875 L 681.125 443.40625 C 679.40283 448.77148 676.30176 446.08936 675.40625 447.03125 C 674.8999 448.35547 674.83299 450.83057 675.375 452.0625 C 676.19922 453.93628 677.04883 456.01294 678.09375 457.78125 C 678.5293 458.51855 679.14795 459.25293 679.4375 460.0625 C 679.54883 460.37305 679.56885 460.84912 679.3125 461.09375 C 678.69287 461.56104 677.63281 460.62622 677.09375 461.25 C 677.05075 461.35449 676.95264 461.51368 676.9375 461.625 C 676.61377 463.95215 676.23389 465.64014 675.5 467.875 C 674.56592 470.72021 671.04199 468.36865 669.15625 469.96875 L 669.15625 470.0625 C 670.10937 471.04004 673.35889 489.98681 673.9375 492.40625 C 674.65381 495.39844 674.73633 498.72876 674.84375 501.8125 C 674.94235 504.6626 675.21289 508.93604 673.375 511.28125 C 672.78516 512.03369 671.71289 512.59693 671.3125 513.46875 C 670.93262 514.29761 670.65577 515.69946 670.1875 516.40625 C 669.80518 516.43995 668.75439 516.47286 668.46875 516.8125 C 668.38765 517.34424 668.45314 520.37793 668.625 520.75 C 670.26172 520.90869 672.97265 522.34033 673.46875 524.0625 C 673.75732 525.06445 673.72705 526.03125 673.8125 527.03125 C 674.29834 532.71021 674.79785 538.23535 674.5 543.9375 C 674.4033 545.78369 674.97363 547.02564 675.125 548.78125 C 675.42041 552.21582 675.7207 555.62378 676 559.0625 C 676.16846 561.1377 676.74365 563.33106 677.59375 565.21875 C 678.09912 566.33984 678.4878 567.55176 679 568.6875 C 679.91895 570.72388 681.11182 572.48974 682.03125 574.53125 C 682.66992 575.94824 685.21972 581.09278 686.09375 581.96875 L 687.3125 581.6875 C 698.83594 578.69312 710.33301 575.63721 721.84375 572.59375 C 721.98926 572.55545 734.45899 575.90429 735.53125 576.1875 C 736.21191 577.75293 734.74268 580.08838 735.03125 581.4375 C 735.15576 581.60596 739.91407 582.93701 740.4375 583.09375 C 741.45801 583.39941 741.41895 584.95581 742.1875 585.5 C 742.8833 585.85791 744.9043 585.72022 745.9375 586.03125 C 747.70264 586.56299 747.17041 587.15795 748.375 587.90625 C 750.20898 589.0459 755.84961 588.47265 757.90625 587.9375 C 761.75 586.9375 762.2002 587.35107 766.125 588.96875 C 767.31055 589.45752 767.82666 588.0198 768.65625 587.9375 C 771.69873 588.39648 769.5 591.61767 769.90625 592.59375 L 770.125 592.8125 C 771.11768 593.11672 772.47168 592.65869 773.46875 593.0625 C 774.51221 593.88159 773.76416 595.25268 774 596.34375 C 774.0669 596.37895 774.31397 596.5585 774.375 596.5625 C 781.00244 596.99028 787.39404 597.145 794.03125 597.0625 C 799.15625 596.999 804.45215 596.64649 809.5625 596.8125 C 812.30762 596.9019 815.06641 596.77735 817.8125 596.71875 C 825.54834 596.5542 833.32812 596.67435 841.0625 596.34375 C 841.58301 597.78613 850.82129 622.2959 851.15625 622.65625 C 852.74855 613.08888 854.10059 603.48096 855.65625 593.90625 C 862.01807 554.75293 867.5957 515.48706 873.4375 476.25 C 873.4951 473.92918 873.5073 471.57251 873.5 469.25 C 873.4004 437.24536 873.24414 405.22022 873.46875 373.21875 C 873.51125 367.15161 873.09375 317.40625 873.09375 317.40625 C 872.34619 317.39355 831.76075 317.54834 812.21875 317.53125 C 799.38916 317.51975 786.54931 317.3352 773.71875 317.25 C 771.79199 317.15655 769.86523 317.18625 767.9375 317.15625 L 751.09375 316.90625 C 747.80713 316.85475 745.92774 317.09985 742.65625 316.78125 C 742.50098 316.76615 734.73193 314.10083 734.0625 313.875 C 731.58594 313.03979 729.05859 312.20483 726.625 311.25 z ",
						"salta":"M 742.03125,68.90625 741.75,69.375 c 0.20312,1.69116 -1.00049,2.38843 -0.5625,3.65625 -0.38379,0.44995 -0.2168,1.64478 -0.84375,1.84375 0,0 -0.81055,0.16772 -1.03125,0.28125 l -0.78125,1.8125 c -0.0366,0.2461 0.1362,0.5271 0.125,0.65625 -0.12061,1.33081 -1.15625,3.25 -1.15625,3.25 -0.26172,0.61181 -0.69145,1.94263 -0.71875,2.125 -0.13086,0.33667 -0.375,0.677 -0.625,0.9375 0.1333,0.06958 0.36425,0.21558 0.40625,0.375 l -0.53125,1.0625 c -0.2832,0.04956 -1.40625,-0.21875 -1.40625,-0.21875 -0.0596,0.28833 -1.15625,2.625 -1.15625,2.625 -0.0259,0.26709 -4.5e-4,0.5625 0.0937,0.8125 0,0 -1.44235,2.72974 -1.53125,2.90625 0.13769,0.03589 0.24605,0.22412 0.28125,0.34375 -0.20801,0.42896 -0.47168,0.96777 -0.8125,1.3125 -0.0517,0.30713 -0.15039,2.5188 -0.3125,3 l -0.84375,-0.21875 c -0.24268,0.20215 -0.563,0.57983 -0.625,0.90625 l 0.25,0.65625 c -0.51319,0.4331 -2.125,3.03125 -2.125,3.03125 -0.57861,0.41162 -0.46631,1.22437 -0.78125,1.46875 l -0.71875,-0.0937 c -0.36035,0.30664 -1.5,3.5625 -1.5,3.5625 -0.14942,0.0393 -0.2705,0.67261 -0.3125,0.8125 -2.01807,1.80249 0.2085,4.62622 -0.96875,5.25 -0.18116,0.0427 -0.40967,0.0393 -0.59375,0 -0.6123,0.78564 -0.81934,1.59741 -0.125,2.40625 -0.021,0.35229 -0.29395,0.79321 -0.5,1.0625 0.0303,0.51929 -0.0317,1.02393 -0.125,1.53125 -0.13916,0.75757 0.3291,0.87549 0.46875,1.5625 l -0.53125,0.4375 c -0.2705,0.35156 0.34375,1.90625 0.34375,1.90625 -1.08643,1.20581 -0.23682,1.09985 -0.71875,1.96875 0,0 -0.39555,1.53882 -0.34375,2.1875 0,0 -0.49609,1.52759 -0.90625,2.4375 l -1.25,0.6875 -0.5625,-0.1875 -0.0937,-1.3125 c -0.29785,-0.42896 -0.25244,-1.31299 0.125,-1.65625 l -0.1875,-0.40625 c 0.0361,-0.10156 -0.96875,-0.5 -0.96875,-0.5 0,0 0.0684,-1.10498 0.40625,-1.28125 0.4126,-1.63721 0.43652,-3.37085 -1.0625,-4.5625 -0.63476,0.0513 -2.09375,-0.84375 -2.09375,-0.84375 -0.39552,-0.46606 -0.003,-1.53979 -0.4375,-1.96875 -0.34423,0.0156 -1.07617,-0.0933 -1.25,-0.46875 -0.0445,-0.43091 0.22803,-0.8645 0.0312,-1.28125 -0.37744,-0.39111 -0.30615,-1.62891 -0.28125,-1.78125 -0.47561,-0.26148 -0.26318,-2.69727 0.0625,-3.03125 0,0 0.50635,-0.60596 0.59375,-0.78125 0.1958,-0.66529 -0.0249,-1.77441 0.3125,-2.3125 -0.0957,-0.1748 -2.53125,-2.28125 -2.53125,-2.28125 -0.21338,-0.7832 -1.31738,-1.50293 -1.46875,-2.21875 l 0.0625,-1.03125 c 0,0 -0.70703,-1.14575 -0.9375,-1.375 l -0.1875,-0.09375 c -0.30664,-0.0271 -0.75391,0.38257 -0.9375,0.59375 -0.20752,0.04468 -0.46973,-0.0041 -0.65625,-0.09375 -0.14599,-0.11475 -0.2651,-0.32129 -0.3125,-0.5 0.23584,-0.52734 0.0962,-0.92651 0.5,-1.5 0.008,-1.1643 -1.78125,-1.54761 -2.40625,-2.28125 -0.70459,-0.82715 -0.55322,-2.98828 -0.34375,-4 l 0.21875,-0.1875 0.375,-0.03125 c 0.40722,-0.18994 1.01,-1.47363 1,-1.875 -1.95752,-2.57056 -1.80908,-1.59399 -3.40625,-3.03125 -0.47168,-0.42456 -0.6333,-1.56714 -2.09375,-2.875 -0.24902,-0.22291 -0.52002,-0.45874 -0.8125,-0.625 -0.6875,-0.39156 -1.53857,-0.03296 -2.40625,-0.4375 -1.00098,0.28882 -3.44043,1.05762 -3.8125,-0.375 -0.33399,-0.29836 -0.91504,-0.17187 -1.3125,-0.28125 -0.76123,-0.20923 -4.8125,-3.78857 -6.09375,-4.09375 -0.0933,0.0107 -0.19675,0.0168 -0.28125,0.0625 -0.11231,0.18286 -0.26416,0.37231 -0.4375,0.5 -1.00244,0.20849 -4.95166,-2.05591 -5.5,-2.71875 -2.63672,-0.28004 -5.52295,0.0178 -8.1875,0.0625 -1.27806,0.02161 -2.56445,0.06634 -3.84375,0.09375 -0.5797,1.290785 0.0172,1.528239 -0.21875,2.34375 -0.2832,0.97998 -1.37451,1.89404 -1.78125,2.84375 -0.43409,1.01221 -0.0381,1.80664 -0.28125,2.4375 -0.22461,0.58081 -0.5889,1.10962 -0.625,1.75 -0.10984,1.95385 -0.10937,3.70581 0.0312,5.65625 0.0791,1.09986 -1.63086,3.22095 -2.5,3.96875 l -0.125,0.34375 c -0.27685,1.67041 -0.94092,2.66724 -1.46875,4.21875 -0.0557,0.16406 0.14648,0.97192 0,1.25 -0.58741,1.11646 -1.62256,2.44824 -1.9375,3.65625 -0.37646,1.44311 0.53857,2.18677 0.4375,3 -0.0942,0.75513 -1.23193,2.53491 -0.71875,3.125 0.64697,0.44336 1.25537,-0.31445 1.875,-0.34375 0.88526,0.51538 0.68311,1.28027 1.25,1.90625 0.39062,0.11206 1.31836,0.33008 1.53125,0.75 0.0186,0.40967 -1.26175,2.44458 -1.34375,4.34375 -0.14112,3.27954 1.05225,3.81665 1.25,6.28125 0.0825,1.031 -0.3916,2.01758 -0.3125,3 0.0908,1.12402 0.86768,1.83862 1.125,2.90625 0.26514,1.10058 0.48389,2.23975 0.75,3.34375 0.11426,0.47461 0.17383,1.14355 0.5,1.53125 0.5913,0.7019 1.92285,2.26807 2.875,2.59375 3.12207,1.0691 7.58789,-1.39307 9.5625,2.25 0.20019,0.36963 0.742,1.6709 0.75,2.09375 0.0869,4.57251 -0.96338,8.09424 -2.1875,12.46875 -1.04736,3.7417 4.32764,3.08301 5.25,4.75 0.90381,1.63282 1.39648,2.91553 1.96875,4.71875 0.45899,1.44678 1.8833,3.11353 2.125,4.1875 0.19531,0.86817 0.0781,3.47559 0.375,4 0.13574,0.18237 0.43652,0.28725 0.65625,0.28125 1.29589,-0.69263 2.54736,1.27563 4.1875,0.5 1.36231,-0.64429 2.28174,-2.854 3.46875,-2.8125 0.46386,0.017 2.13379,0.16357 2.5,0.0312 0.20117,-0.42456 0.76807,-0.9792 1.25,-1.0625 0.95655,-0.0276 1.88721,1.75391 2.75,2.25 0.69482,0.39944 1.58594,0.17285 2.3125,0.5 0.77246,0.3479 3.77002,2.40649 4.34375,3.3125 0.47364,0.74805 0.90576,1.49634 1.46875,2.15625 0.75244,0.88159 1.80811,4.05762 3.15625,3.4375 0.41211,-0.5476 1.23535,-0.53442 1.53125,-1.15625 0.59228,-1.24463 0.33008,-2.75928 0.78125,-4 0.24951,-0.6853 1.39307,-0.26929 1.65625,-2.71875 0.88574,0.0217 10.96094,0.36768 11.21875,0.25 4.9e-4,8.0166 0.16162,16.10718 0.40625,24.125 0.21582,7.07006 0.26172,14.00269 0.96875,21 0.35791,3.5415 -2.85498,7.94165 -4.75,10.65625 -1.42822,2.04639 -2.26416,4.3833 -4.5,5.8125 -1.42285,0.90918 -5.88916,-0.22729 -6.625,1.5625 -1.61719,3.93239 -3.19189,1.35937 -5.8125,3.84375 -1.52197,1.44311 -2.44873,2.66431 -3.5,4.46875 -0.48535,0.83325 -0.42969,3.64526 -2.03125,3.75 -0.88428,-0.12232 -2.80713,-2.38989 -3.46875,-3.03125 -1.19727,-1.15918 -2.06641,-2.37378 -3.25,-3.5625 -1.52637,-1.53296 -3.37207,-2.81812 -4.9375,-4.34375 -0.0767,-0.0745 -0.19095,-0.1299 -0.28125,-0.1875 l -0.21875,0 c -2.08642,2.41553 -2.69824,5.45337 -3.875,8.34375 -1.09863,2.69824 -2.19824,1.83496 -4.40625,0.875 -1.73096,-0.75317 -3.51611,-1.16187 -5.0625,-2.21875 -2.16992,-1.48339 -6.12549,-4.0166 -6.5,-6.78125 l -0.21875,-0.21875 c -1.95264,0.10034 -5.25879,5.46167 -9.40625,2.6875 -3.45752,-2.31226 -3.83496,-0.78516 -6.375,-2 -1.0708,-1.35376 -1.02441,-2.55176 -3.0625,-2.78125 -0.15136,-0.0173 -0.72607,-0.12109 -0.875,0 -0.53467,0.43457 -1.19043,1.27734 -1.96875,1.0625 -0.46142,-0.2893 -0.99805,-0.9458 -1.3125,-1.375 -0.49414,-0.19629 -1.125,-0.0791 -1.5625,-0.375 -0.28222,-0.19067 -2.71533,-4.78198 -3.71875,-6.0625 -0.33447,-0.42676 -0.66211,-0.82422 -0.96875,-1.28125 -0.53174,-0.79272 -0.90674,-1.69531 -1.5,-2.46875 -1.34522,-1.75488 -4.30615,-5.04712 -4.40625,-7.4375 -0.0601,-1.42627 0.63085,-2.78467 0.53125,-4.15625 -0.0786,-1.08594 -1.25391,-2.41138 -2.3125,-2.6875 -4.58155,-1.19483 -3.7168,-5.5647 -7.8125,-5.1875 -0.63086,0.5791 -1.43994,2.50562 -2.5,0.75 -0.28369,-0.46973 -0.41162,-0.96289 -0.78125,-1.4375 -0.47656,-0.61133 -1.49705,-1.12695 -1.59375,-2 -0.12305,-1.11035 0.90775,-1.95947 0.84375,-2.625 -0.12158,-0.46704 -0.95068,-0.52563 -1.09375,-1.15625 0.0103,-0.43042 0.36275,-0.76294 0.28125,-1.1875 l -0.15625,-0.25 c -0.30127,0.007 -0.64453,0.20239 -0.875,0.375 l -0.21875,-0.21875 c -0.17338,-0.2771 0.0601,-2.0437 0.0937,-2.4375 0.32276,-3.7854 -0.7832,-4.09058 2.21875,-7.1875 0.0493,-0.0508 0.0717,-0.2439 0.0937,-0.3125 -0.0127,-0.75903 -1.10596,-1.20361 -0.96875,-2.0625 0.14258,-0.89428 0.89825,-1.53931 0.90625,-2.59375 0.008,-0.9961 -0.53125,-1.8042 -0.53125,-2.78125 0,-1.90722 1.37988,-3.95337 -0.1875,-5.5625 -1.06054,-1.08911 -2.00391,-2.00806 -3.21875,-2.84375 -2.24609,-1.54468 -4.55566,-3.09497 -6.9375,-4.40625 -1.79834,-0.99048 -1.86475,1.24365 -4.4375,-1.34375 -0.75684,-0.76123 -1.23926,-0.97388 -2.46875,-0.53125 -0.63769,-0.13552 -4.49023,-3.97461 -5.40625,-0.15625 -2.78711,11.61426 -1.83057,7.58545 0.46875,17.84375 0.86523,3.85913 -0.34961,7.85913 -1.53125,11.46875 -0.9082,2.77514 -1.9043,5.60034 -2.71875,8.4375 -0.51709,1.80127 -3.10986,15.02344 -5.25,14.8125 -1.8335,-0.18091 -2.82666,-1.80713 -3.8125,-2 -0.81982,-0.16015 -1.20752,0.70875 -1.78125,0.71875 -2.0376,0.0347 -4.37549,-1.00098 -6.125,-2 -0.69434,-0.39649 -8.02051,-3.93625 -8.125,-4.03125 -0.79639,-0.72632 -1.12256,-1.82495 -1.8125,-2.59375 -0.64258,-0.71558 -1.354,-1.3772 -2.03125,-2.0625 -0.6792,-0.68701 -0.11523,-2.08081 -0.84375,-2.5625 -0.46289,-0.14477 -0.93799,-0.0911 -1.375,0.125 -1.73243,-0.17407 -1.16162,-2.11914 -2.0625,-3.1875 -0.50537,-0.59961 -1.27246,-0.94165 -1.75,-1.5 -0.69727,-0.81421 -1.1748,-1.8042 -1.8125,-2.65625 -0.10742,-0.14355 -0.54785,-0.57617 -0.6875,-0.6875 -1.70117,-1.35962 -2.84814,-0.35474 -4.28125,-1.25 -0.56396,-0.77343 -0.94336,-1.75439 -1.625,-2.4375 -1.0227,-1.02513 -1.53574,0.1179 -3.28125,-1.78125 -0.90249,3.36692 -3.3836,13.2358 -3.875,14.03125 -0.54882,0.88916 -1.16357,1.80029 -1.65625,2.71875 -0.35401,0.65991 -0.33984,1.60278 -0.6875,2.3125 l -0.21875,0.1875 c -9.25635,4.15967 -18.43115,8.49585 -27.6875,12.65625 -2.32861,1.04687 -25.70508,11.30444 -27.84375,13.3125 -0.63281,0.59448 -0.53467,2.11255 -0.9375,2.8125 -2.62402,4.55981 -4.5332,-1.97559 -6.40625,2.03125 -0.83252,1.78052 0.53906,2.77441 0.1875,3.78125 -0.2959,0.57641 -2.10547,1.90234 -2.96875,3.375 -0.33984,0.58007 -0.45361,2.47095 -1.125,2.84375 -0.25976,-0.0393 -0.75049,-0.12402 -1,0 -0.42334,0.26733 -2.03516,3.05029 -2.25,3.65625 -0.3877,1.09277 -2.3628,3.71045 -2.375,3.8125 L 468,259.28125 c -0.45117,3.71118 2.24463,1.60718 5.09375,5.71875 l 0.15625,0.21875 c 1.8335,2.16919 2.54199,4.2522 3.8125,6.71875 0.3584,0.6958 2.55615,1.28931 3.21875,1.53125 0.0488,1.27075 1.13818,2.81201 1.78125,3.90625 -1.10058,1.14013 -2.52441,1.70825 -3.96875,2.28125 -1.05371,-0.48047 -2.55029,-1.26611 -3.71875,-0.9375 -0.96191,0.72925 -1.51611,1.87549 -2.25,2.8125 -0.0276,0.51992 -0.0303,1.04138 -0.0312,1.5625 2.30225,0.96924 5.00537,1.32349 7.4375,1.8125 l 22.5625,4.53125 c 4.39892,0.88525 6.82959,1.68311 11.28125,2.25 3.13672,0.39941 14.3125,-0.1453 18.0625,-0.1875 18.09961,-0.2041 36.18359,-0.39844 54.28125,-0.78125 l 1.125,0.0312 c 2.74613,1.98731 1.46533,7.82471 2.65625,9.625 2.70996,4.09766 3.54199,3.2522 2.3125,8.03125 -0.21093,0.81934 -0.93359,1.44336 -1.09375,2.34375 -0.646,3.62744 2.32568,2.27588 -3.03125,6.15625 -2.56885,1.86084 -2.20898,0.67993 -4.78125,0.90625 -2.76319,0.24341 -3.13086,0.48779 -6.28125,0.375 -0.0986,-0.003 -0.73779,0.323 -0.84375,0.4375 -0.77588,0.83716 -2.82422,2.28394 -3.375,3.0625 -1.02929,1.4541 -0.47949,6.07617 -0.125,7.6875 0.3999,1.81934 0.98877,3.35327 2.03125,4.90625 0.70849,1.05542 1.72266,1.96631 2.4375,3.03125 1.15722,1.72437 1.94434,3.31665 3.3125,4.84375 1.2251,1.36694 1.24512,2.37061 2.21875,3.625 0.39404,0.50757 1.20166,0.82324 1.34375,1.46875 1.03027,4.68531 2.10791,3.44775 3.375,6.71875 0.61523,1.58862 1.09082,3.54248 2.03125,4.9375 0.92334,1.36939 2.07422,2.5188 3.1875,3.6875 1.27588,1.3396 3.23975,4.55713 5.40625,4.1875 1.19776,-0.69116 1.72559,-2.46216 2.125,-3.71875 0.55469,-1.74341 1.19824,-3.57812 2.0625,-5.1875 1.40332,-2.61475 2.57813,-1.93604 5.21875,-1.8125 1.34717,0.0632 2.68408,-0.1272 4.03125,-0.0625 l 6.21875,1.71875 c 4.42383,0.7915 8.83203,1.5918 13.28125,2.21875 0.87598,0.12354 5.83692,1.55664 6.34375,0.8125 1.23633,-1.81494 1.0996,-1.80615 0.96875,-3.84375 -0.19482,-3.03247 0.38477,-2.56298 0.84375,-5.03125 0.2915,-1.56689 -0.89063,-5.69702 1.125,-6.59375 0.25195,0.0127 3.3916,1.479 4.21875,1.71875 0.35205,0.10205 0.63868,0.12817 0.96875,0.34375 1.80762,-0.80273 6.15723,0.73609 7.8125,1.25 3.09912,0.96167 7.28662,-7.7063 9.28125,-0.34375 l 0.9375,3.46875 c 3.72217,1.27344 9.09766,3.48316 12.71875,5.34375 0.0308,-0.24707 0.29443,-0.375 0.46875,-0.5 1.68994,-1.21436 3.78711,3.05054 7.21875,2.5 3.31592,-0.53247 3.87646,-3.72974 7.125,-4.25 3.03467,-0.4856 3.31446,0.60864 5.90625,0.84375 1.82812,0.16577 3.95703,-0.0222 5.78125,-0.1875 2.36963,-0.2146 4.75098,0.26806 7.0625,0.0312 l 0.125,-0.15625 c 0.38965,-3.45947 2.15137,-4.76782 3.1875,-7.84375 0.47998,-1.42651 -0.42383,-3.39941 0.21875,-4.84375 4.48144,-10.07446 8.85742,-20.19434 13.3125,-30.28125 l 0.4375,-1.125 c 2.43359,0.95483 4.96094,1.78979 7.4375,2.625 0.66943,0.22583 8.43848,2.89115 8.59375,2.90625 3.27149,0.3186 5.15088,0.0735 8.4375,0.125 l 16.84375,0.25 c 1.92773,0.03 3.85449,2.5e-4 5.78125,0.0937 11.99219,-16.16749 53.74121,-73.19507 62.84375,-85.34375 0.31909,-5.66378 -0.0324,-12.64095 -0.25,-18.53125 -0.0107,-0.01 -0.0206,-0.0215 -0.0312,-0.0312 0.15431,-3.39644 0.12207,-110.07422 -0.15625,-113.21875 l -1.5625,-0.5 -0.625,1 c -0.12012,-0.19239 -0.333,-0.54053 -0.3125,-0.78125 -0.17188,-0.28173 -0.51953,-0.47095 -0.78125,-0.625 -2.18164,-1.28442 -0.90967,-0.7771 -2,-2.1875 -0.45947,-0.14112 -0.77393,0.26831 -1.3125,0.09375 0.0269,-0.20703 0.44873,-0.58838 0.59375,-0.78125 -0.32714,-0.24881 -0.81348,0.06641 -1.125,-0.1875 -0.18847,-0.5232 0.0425,-1.45996 0.34375,-1.90625 L 829.25,93.8125 828.96875,93.625 c -0.43799,0.10669 -1.05518,0.64966 -1.34375,0.96875 -0.58838,0.01513 -2.26123,-0.32056 -2.6875,-0.75 l -0.25,-1.25 -0.625,-0.34375 0.3125,-1.28125 -1.25,0.5 -0.28125,-0.125 c -0.14013,-0.29785 -0.32475,-0.78345 -0.28125,-1.125 l -0.25,-0.3125 -0.28125,-0.03125 -0.65625,0.59375 -0.25,-0.09375 c -0.20947,-0.42261 -0.80176,-1.00005 -1.28125,-1.09375 -0.20166,0.0046 -0.37598,0.16919 -0.53125,0.28125 -0.17675,-0.0068 -0.42676,-0.05347 -0.5625,-0.1875 l -0.0312,-0.40625 0.3125,-0.375 0.5625,-0.6875 -0.0312,-0.28125 -0.8125,-0.59375 0,-0.28125 0.375,-0.53125 0,-0.59375 c -0.26318,-0.16995 -0.72021,-0.28345 -1.03125,-0.21875 l -0.125,0.4375 c -1.03808,0.0232 -1.54199,-2.2644 -2.25,-3.0625 -0.39843,-0.0141 -1.45703,0.13794 -1.75,0 -0.36279,-0.77588 -1.27246,-2.93775 -2.28125,-2.96875 L 810.90625,78.75 c -0.0547,0.40381 -0.27441,1.33545 -0.5625,1.65625 l -0.28125,0.03125 c -1.2168,-0.86328 -1.05371,-2.54053 -1.90625,-3.6875 -0.20606,-0.75952 0.99268,-1.8396 1.125,-2.71875 0.15528,-1.03076 -0.51172,-1.90918 -0.8125,-2.84375 -0.22608,-0.70386 0.28564,-1.45947 0.125,-2.15625 -3.2168,0.18185 -6.66309,-0.0476 -9.875,-0.0625 -4.87842,-0.0225 -9.74561,0.0169 -14.625,0 -14.02393,-0.0486 -28.03955,0.0364 -42.0625,-0.0625 z",
						"jujuy":"M 607 53.875 C 606.48291 54.27149 605.26563 54.14575 605.59375 55.125 L 605.84375 55.375 C 605.97803 55.68457 605.95117 57.62622 606.1875 58.59375 C 606.00927 59.21948 604.95654 62.30295 604.75 62.34375 C 604.50776 62.97021 604.74854 63.74487 604.46875 64.3125 C 604.18945 64.2937 603.82475 64.9939 603.78125 65.21875 C 603.90275 65.45484 603.6626 65.90454 603.84375 66.34375 C 603.53564 66.60864 603.74512 67.17285 603.3125 67.5625 L 603.90625 68.53125 C 603.32862 69.11646 603.88916 69.6543 603.5625 70.21875 C 603.37256 70.41162 603.12061 70.5769 602.875 70.6875 L 603.4375 72.09375 C 603.29785 72.23535 603.0156 72.53564 603 72.75 C 603 72.75 603.1064 74.00513 603.0625 74.28125 C 602.98487 74.50073 602.3833 74.81295 602.1875 74.90625 L 601.9375 74.875 L 601.3125 74.40625 L 601.09375 74.53125 C 601.07226 75.23975 601.01221 75.34106 600.6875 75.9375 L 600.71875 76.625 C 600.72119 76.70801 599.53125 77.125 599.53125 77.125 C 597.80469 77.37183 584.7627 81.17944 583.4375 81.8125 L 582.3125 83.5625 L 580.21875 82.59375 C 579.40381 82.72144 577.2793 84.2478 576.4375 84.78125 C 575.77344 88.78222 575.37939 91.53223 574.03125 95.375 C 573.76658 96.12891 573.86425 97.11401 573.84375 97.90625 C 573.15381 98.21631 565.4697 101.56835 565.375 101.65625 C 564.54883 102.42163 563.74658 103.69873 563.03125 104.59375 C 562.97949 104.65893 562.84865 104.73165 562.78125 104.78125 L 559.78125 104.9375 L 559.59375 105.21875 C 559.81983 107.64184 560.09619 110.07031 560.25 112.5 C 559.43848 113.27002 558.44629 113.80518 557.53125 114.4375 C 556.43017 115.19775 554.75293 116.08813 553.8125 117 C 553.62744 117.1792 550.99756 122.54932 550.5625 123.375 C 552.56933 124.89893 559.75244 133.75049 561.75 136.125 C 561.38086 137.2998 555.78125 157.84375 555.78125 157.84375 C 553.14941 167.51074 550.26758 177.13574 547.5625 186.78125 C 547.51809 186.93966 547.37312 187.58636 547.3125 187.8125 C 549.05801 189.71165 549.57105 188.56862 550.59375 189.59375 C 551.27539 190.27686 551.65479 191.25782 552.21875 192.03125 C 553.65186 192.92651 554.79883 191.92163 556.5 193.28125 C 556.63965 193.39258 557.08008 193.8252 557.1875 193.96875 C 557.8252 194.8208 558.30273 195.81079 559 196.625 C 559.47754 197.18335 560.24463 197.52539 560.75 198.125 C 561.65088 199.19336 561.08007 201.13843 562.8125 201.3125 C 563.24951 201.09644 563.72461 201.04273 564.1875 201.1875 C 564.91602 201.66919 564.35205 203.06299 565.03125 203.75 C 565.7085 204.4353 566.41992 205.09692 567.0625 205.8125 C 567.75244 206.5813 568.07861 207.67993 568.875 208.40625 C 568.97949 208.50125 576.30566 212.04101 577 212.4375 C 578.74951 213.43652 581.0874 214.47216 583.125 214.4375 C 583.69873 214.4275 584.08643 213.5586 584.90625 213.71875 C 585.89209 213.91162 586.88525 215.53784 588.71875 215.71875 C 590.85889 215.92969 593.45166 202.70752 593.96875 200.90625 C 594.7832 198.06909 595.7793 195.24389 596.6875 192.46875 C 597.86914 188.85913 599.08398 184.85913 598.21875 181 C 595.91943 170.7417 594.96289 174.77051 597.75 163.15625 C 598.66602 159.33789 602.51856 163.17698 603.15625 163.3125 C 604.38574 162.86987 604.86816 163.08252 605.625 163.84375 C 608.19775 166.43115 608.26416 164.19702 610.0625 165.1875 C 612.44434 166.49878 614.75391 168.04907 617 169.59375 C 618.21484 170.42944 619.15821 171.34839 620.21875 172.4375 C 621.78613 174.04663 620.40625 176.09278 620.40625 178 C 620.40625 178.97705 620.9458 179.78515 620.9375 180.78125 C 620.9295 181.83569 620.17383 182.48072 620.03125 183.375 C 619.89404 184.23389 620.9873 184.67847 621 185.4375 C 620.978 185.5061 620.95555 185.69922 620.90625 185.75 C 617.9043 188.84692 619.01026 189.1521 618.6875 192.9375 C 618.6538 193.3313 618.42037 195.0979 618.59375 195.375 L 618.8125 195.59375 C 619.04297 195.42114 619.38623 195.22607 619.6875 195.21875 L 619.84375 195.46875 C 619.92525 195.89331 619.57275 196.22583 619.5625 196.65625 C 619.70557 197.28687 620.53467 197.34546 620.65625 197.8125 C 620.72025 198.47803 619.68945 199.32715 619.8125 200.4375 C 619.9092 201.31055 620.92969 201.82617 621.40625 202.4375 C 621.77588 202.91211 621.90381 203.40527 622.1875 203.875 C 623.24756 205.63062 624.05664 203.7041 624.6875 203.125 C 628.7832 202.7478 627.91845 207.11767 632.5 208.3125 C 633.55859 208.58862 634.73389 209.91406 634.8125 211 C 634.9121 212.37158 634.22119 213.72998 634.28125 215.15625 C 634.38135 217.54663 637.34228 220.83887 638.6875 222.59375 C 639.28076 223.36719 639.65576 224.26978 640.1875 225.0625 C 640.49414 225.51953 640.82178 225.91699 641.15625 226.34375 C 642.15967 227.62427 644.59278 232.21558 644.875 232.40625 C 645.3125 232.70215 645.94336 232.58496 646.4375 232.78125 C 646.75195 233.21045 647.28858 233.86695 647.75 234.15625 C 648.52832 234.37109 649.18408 233.52832 649.71875 233.09375 C 649.86768 232.97266 650.44239 233.07645 650.59375 233.09375 C 652.63184 233.32324 652.58545 234.52124 653.65625 235.875 C 656.19629 237.08984 656.57373 235.56274 660.03125 237.875 C 664.17871 240.64917 667.48486 235.28784 669.4375 235.1875 L 669.65625 235.40625 C 670.03076 238.1709 673.98633 240.70411 676.15625 242.1875 C 677.70264 243.24438 679.48779 243.65308 681.21875 244.40625 C 683.42676 245.36621 684.52637 246.22949 685.625 243.53125 C 686.80176 240.64087 687.41358 237.60303 689.5 235.1875 L 689.71875 235.1875 C 689.80905 235.2451 689.92334 235.30054 690 235.375 C 691.56543 236.90063 693.41113 238.18579 694.9375 239.71875 C 696.12109 240.90747 696.99023 242.12207 698.1875 243.28125 C 698.84912 243.92261 700.77197 246.19018 701.65625 246.3125 C 703.25781 246.20776 703.20215 243.39575 703.6875 242.5625 C 704.73877 240.75806 705.66553 239.53686 707.1875 238.09375 C 709.80811 235.60937 711.38281 238.18239 713 234.25 C 713.73584 232.46021 718.20215 233.59668 719.625 232.6875 C 721.86084 231.2583 722.69678 228.92139 724.125 226.875 C 726.02002 224.1604 729.23291 219.76025 728.875 216.21875 C 728.16797 209.22144 728.12207 202.28881 727.90625 195.21875 C 727.66162 187.20093 727.50049 179.11035 727.5 171.09375 C 727.24219 171.21143 717.16699 170.86548 716.28125 170.84375 C 716.01807 173.29321 714.87451 172.8772 714.625 173.5625 C 714.17383 174.80322 714.43603 176.31787 713.84375 177.5625 C 713.54785 178.18433 712.72461 178.17115 712.3125 178.71875 C 710.96436 179.33887 709.90869 176.16284 709.15625 175.28125 C 708.59326 174.62134 708.16114 173.87305 707.6875 173.125 C 707.11377 172.21899 704.11621 170.1604 703.34375 169.8125 C 702.61719 169.48535 701.72607 169.71194 701.03125 169.3125 C 700.16846 168.81641 699.2378 167.03491 698.28125 167.0625 C 697.79932 167.1458 697.23242 167.70044 697.03125 168.125 C 696.66504 168.25732 694.99511 168.11075 694.53125 168.09375 C 693.34424 168.05225 692.42481 170.26196 691.0625 170.90625 C 689.42236 171.68188 688.17089 169.71362 686.875 170.40625 C 686.65527 170.41225 686.35449 170.30737 686.21875 170.125 C 685.92187 169.60059 686.03906 166.99317 685.84375 166.125 C 685.60205 165.05103 684.17774 163.38428 683.71875 161.9375 C 683.14648 160.13428 682.65381 158.85157 681.75 157.21875 C 680.82764 155.55176 675.45264 156.21045 676.5 152.46875 C 677.72412 148.09424 678.77442 144.57251 678.6875 140 C 678.6795 139.57715 678.13769 138.27588 677.9375 137.90625 C 675.96289 134.26318 671.49707 136.72535 668.375 135.65625 C 667.42285 135.33057 666.0913 133.7644 665.5 133.0625 C 665.17383 132.6748 665.11426 132.00586 665 131.53125 C 664.73389 130.42725 664.51514 129.28808 664.25 128.1875 C 663.99268 127.11987 663.21582 126.40527 663.125 125.28125 C 663.0459 124.29883 663.52002 123.31225 663.4375 122.28125 C 663.23975 119.81665 662.04638 119.27954 662.1875 116 C 662.2695 114.10083 663.54981 112.06592 663.53125 111.65625 C 663.31836 111.23633 662.39062 111.01831 662 110.90625 C 661.43311 110.28027 661.63526 109.51538 660.75 109 C 660.13037 109.0293 659.52197 109.78711 658.875 109.34375 C 658.36182 108.75366 659.49951 106.97388 659.59375 106.21875 C 659.69482 105.40552 658.77979 104.66186 659.15625 103.21875 C 659.47119 102.01074 660.50634 100.67896 661.09375 99.5625 C 661.24023 99.28442 661.03805 98.47656 661.09375 98.3125 C 661.62158 96.76099 662.28565 95.76416 662.5625 94.09375 L 662.6875 93.75 C 663.55664 93.0022 665.2666 90.88111 665.1875 89.78125 C 665.04688 87.83081 665.04641 86.07885 665.15625 84.125 C 665.19235 83.48462 665.55664 82.95581 665.78125 82.375 C 666.02441 81.74414 665.62841 80.94971 666.0625 79.9375 C 666.46924 78.98779 667.56055 78.07373 667.84375 77.09375 C 668.07966 76.278239 667.4828 76.040785 668.0625 74.75 C 662.47773 74.869653 656.89146 75.001132 651.3125 74.96875 L 650.78125 75.46875 C 648.9209 75.10009 647.06787 74.4668 645.21875 74 L 644.25 75.28125 C 643.91309 75.52393 643.52979 75.25 643.1875 75.25 C 642.69873 75.25 641.13672 75.73364 640.625 75.90625 L 640.375 76.28125 C 638.95557 76.61865 637.24707 75.04834 636.71875 75.40625 C 633.41943 77.64258 633.18555 73.57275 631.15625 73.46875 C 631.23633 73.25635 631.083 72.84644 631 72.65625 C 629.92041 72.13891 626.125 65.55615 624.4375 64.125 C 622.18261 63.729 619.80176 63.1355 617.53125 63.03125 C 617.34912 62.03833 617.93262 61.02344 617.8125 60.0625 C 614.6792 56.35473 615.04053 57.05835 610.71875 55.34375 L 607 53.875 z ",
						"formosa":"M 836.125 100.125 C 836.40332 103.26953 836.43556 209.94731 836.28125 213.34375 C 838.1328 215.03584 841.54395 215.85522 842.8125 216.8125 C 844.19287 217.85449 845.54541 218.34082 847.1875 218.9375 C 850.08643 219.99024 854.2583 218.99243 855.15625 221.78125 C 855.91114 224.12378 856.49316 223.8269 858.46875 224.8125 C 860.06835 225.61059 860.64355 227.66382 862.8125 227.90625 C 864.42822 228.08667 865.81738 228.76025 867.4375 228.90625 L 867.6875 228.90625 C 867.90186 228.88648 868.12061 228.84005 868.34375 228.78125 L 868.625 228.71875 C 868.71337 228.79834 868.81055 228.89111 868.90625 229 C 869.87061 230.09302 870.19385 230.48828 870.59375 230.78125 C 870.97851 231.06275 871.4292 231.24731 872.5625 231.90625 C 872.5903 231.94702 872.5786 231.97534 872.625 232.09375 L 872.9375 232.9375 C 873.60546 234.75366 874.53174 236.88794 875.65625 238.4375 C 876.43262 239.50782 877.31104 239.34155 877.9375 238.65625 C 878.64941 239.12793 879.5 239.12134 880.53125 238.53125 C 880.72852 240.23316 881.05566 240.74878 882.34375 242 C 883.71094 243.32837 884.83643 244.63574 886.09375 246.0625 C 888.79541 249.12866 889.37109 248.72803 892.21875 248.25 C 892.42871 248.31446 892.53076 248.39014 892.71875 248.5 C 895.77441 250.2898 897.52832 249.22339 900.625 250 C 903.5625 250.73682 903.32324 254.27222 905.21875 254.78125 C 904.9751 257.02807 906.78369 259.11914 908.1875 260.71875 C 905.93799 263.9143 911.14209 268.64648 912.8125 266.90625 C 913.31201 267.35327 913.80518 267.81592 914.34375 268.3125 C 915.25342 269.15088 919.0498 271.79443 919.46875 272.4375 L 919.8125 273.03125 C 920.05372 273.40747 920.49805 274.03149 921.15625 274.40625 C 924.13184 276.10132 922.95557 274.56738 925.21875 277.65625 C 926.66748 279.63305 928.71533 278.96631 929.9375 280.375 C 931.01172 281.61352 932.61084 282.31274 934.03125 283.09375 L 934.21875 283.4375 C 935.38281 285.78174 937.52295 285.08496 939.40625 286.09375 C 939.87207 286.53467 940.27686 287.0498 940.84375 287.375 L 941.3125 287.53125 C 942.17578 287.64746 942.46387 287.21851 943.15625 287.09375 C 944.38233 287.39429 945.229 290.78809 946.25 291.96875 L 946.53125 292.3125 C 946.67041 292.48315 946.7813 292.67603 946.875 292.875 L 947.28125 293.78125 C 947.81836 294.92627 950.3457 297.42456 951.8125 297.78125 C 952.14551 298.35717 952.38818 299.00464 952.75 299.5625 C 952.34073 299.958 952.27445 300.59155 952.34375 301.125 L 952.40625 301.375 C 952.75049 302.42774 953.81494 302.92334 954.78125 303.25 L 955.46875 303.46875 C 955.43262 304.13672 955.38086 304.82959 955.625 305.46875 L 955.78125 305.71875 C 956.77588 307.20069 957.81445 306.8621 958.875 306.875 C 958.96338 307.2251 959.2124 307.52637 959.53125 307.8125 C 959.13476 308.07373 958.78125 308.37427 958.78125 309.03125 C 958.78125 310.0437 959.08203 310.40356 959.75 311.09375 C 960.17578 313.61426 959.98193 313.74829 961.96875 315.34375 C 962.24317 316.74097 961.68164 317.79517 963.03125 318.96875 L 963.46875 319.21875 C 964.33985 319.53784 965.26709 319.37964 965.90625 318.84375 C 966.71191 319.45825 967.44971 319.4314 968.40625 319.59375 C 968.96533 320.47315 969.3042 320.8085 970.46875 320.8125 C 970.66943 320.8135 970.89453 320.8085 971.125 320.8125 C 971.06982 321.14917 971.05176 321.56006 971.1875 321.96875 L 971.28125 322.15625 C 972.28076 324.13282 974.02148 323.71094 975.65625 324.25 L 975.75 324.59375 C 976.73291 328.02685 980.56396 327.21289 981.375 328.96875 C 980.82471 330.80664 981.12646 332.14111 983 332.8125 L 983.59375 333.03125 C 985.26514 333.60791 986.00195 335.04468 987.3125 336.09375 C 987.95948 337.23096 988.00488 338.37671 989.125 339.21875 L 989.40625 339.4375 C 990.4292 340.5271 990.51758 342.70015 992.53125 342.71875 C 992.39258 344.23022 993.12158 345.66479 992.75 347.0625 L 992.59375 347.65625 C 992.04932 350.00805 994.20361 351.96851 996.5 350.84375 L 996.8125 350.96875 C 997.14697 351.07572 997.41797 351.1133 997.65625 351.125 L 997.96875 351.125 C 999.35791 353.4441 1000.3745 351.88696 1002.125 352.28125 C 1002.2119 352.31933 1002.3838 352.3931 1002.4688 352.4375 L 1002.875 352.625 C 1005.0879 353.64579 1005.9892 351.94824 1007.7812 353.71875 C 1008.2656 355.32935 1007.7408 358.21338 1009.125 359.5 C 1008.1617 362.29249 1012.1144 365.44751 1014.0938 364.8125 L 1014.4375 364.65625 C 1014.5303 364.59497 1014.6045 364.5083 1014.6875 364.4375 C 1017.5947 366.79077 1017.9253 364.7041 1020.2812 364.25 L 1020.7188 364.1875 C 1021.4546 364.04297 1021.9922 363.75073 1022.5 363.21875 C 1022.9135 362.77735 1023.3223 362.3335 1023.7812 361.9375 C 1024.1407 363.37182 1026.7432 365.15601 1027.9688 365.6875 C 1034.5508 368.54199 1034.0991 366.55859 1038.5625 373.15625 C 1040.8305 376.5083 1041.6449 376.14917 1044.7812 377.71875 C 1046.4018 379.40552 1046.9419 383.01245 1050.1875 382.21875 L 1050.6562 382.09375 C 1050.752 382.21093 1050.9923 382.48804 1051.1562 382.8125 C 1053.46 387.36084 1057.6617 386.28271 1058.8438 390.84375 C 1059.4766 393.28271 1061.523 393.34497 1063.0625 394.90625 C 1063.4434 396.01807 1063.3413 397.36279 1064.5312 398.03125 C 1066.3116 399.031 1067.1568 399.78174 1068.7188 399.15625 C 1068.668 399.69214 1068.8233 400.43457 1069.4062 400.9375 C 1069.8392 400.48175 1070.2421 399.94748 1070.6562 399.34375 C 1071.3543 399.07691 1072.771 400.11621 1073.5 399.25 L 1073.6875 398.71875 C 1073.7124 397.32056 1071.127 396.9585 1071.3125 395.65625 C 1071.4102 395.41797 1071.7211 395.1372 1071.9688 395.0625 C 1074.0033 394.82446 1072.8374 395.6792 1075.4375 394.71875 C 1075.5943 394.58032 1075.7912 394.31958 1075.7812 394.09375 L 1075.0625 392.5 L 1075.125 392.125 L 1075.5625 391.875 L 1077.0625 392.09375 L 1077.75 391.53125 C 1078.4004 390.48731 1077.6204 389.5625 1077.5312 388.5625 C 1077.427 387.38599 1077.6436 385.97681 1077.5938 384.75 C 1077.5887 384.61889 1077.6815 384.32715 1077.7188 384.1875 C 1077.9275 384.22729 1078.2082 384.26835 1078.4062 384.34375 C 1078.9113 384.53541 1079.3963 384.86768 1079.9062 385.03125 C 1080.5104 385.22461 1081.6071 384.35596 1081.3438 383.6875 C 1081.1413 383.4917 1080.405 382.75562 1080.375 382.46875 C 1080.3599 381.95728 1081.4346 381.26709 1081.25 380.34375 C 1080.9063 378.62719 1079.5625 376.97095 1079.5625 376.5625 C 1079.5625 375.61475 1080.4635 374.9978 1080.4375 374.0625 C 1080.3857 373.73023 1079.5125 372.99146 1079.2188 372.5625 L 1079.5 372.09375 C 1080.2798 371.86231 1081.3814 372.31128 1081.9375 371.5 L 1082.0625 371.125 C 1081.0678 368.96191 1079.4873 370.61206 1080.6875 365.84375 C 1080.7983 365.40259 1082.1161 364.9104 1082.4688 364.78125 C 1082.7606 364.50879 1082.9231 363.98926 1083.0312 363.65625 C 1084.1165 360.32348 1082.0703 360.94873 1082.625 358.4375 C 1083.21 357.48608 1085.0863 357.63086 1085.8438 356.4375 C 1085.9652 355.96753 1085.9284 355.30127 1085.7812 354.84375 C 1085.0534 354.2395 1083.6018 353.77905 1083.2188 353 L 1083.3438 352.65625 C 1084.1409 352.41895 1084.8305 352.7842 1085.625 352.75 L 1085.875 352.53125 L 1085.9375 352.1875 C 1085.0029 350.73974 1087.0284 348.26929 1088.4375 347.9375 C 1089.2471 347.74711 1089.9438 348.15088 1090.75 347.84375 C 1091.5849 347.52564 1092.2917 347.02148 1093.0312 346.53125 C 1093.2688 346.37378 1093.6807 346.35327 1093.9062 346.1875 C 1095.4796 345.03247 1096.418 344.0769 1097.6562 342.5625 C 1098.1848 341.91626 1100.5952 341.16357 1101.4375 340.78125 C 1101.5995 340.45728 1101.6751 339.84326 1101.5312 339.5 C 1100.0593 338.77905 1098.8005 338.03149 1099.4062 336.28125 C 1100.1574 335.80835 1101.4509 335.56592 1101.9688 334.96875 C 1102.0875 334.6499 1102.1235 334.24146 1102.0625 333.90625 L 1100.6875 332.375 L 1100.5938 331.5625 L 1101 330.9375 C 1102.1836 330.3374 1104.1224 330.34155 1104.5312 328.8125 C 1104.4197 327.08838 1103.3167 325.81006 1103.5312 324.15625 L 1103.9375 323.8125 C 1104.2393 323.76172 1104.7583 323.86206 1105 324.0625 C 1106.2236 324.08838 1108.2856 322.04468 1108.5625 320.84375 L 1108.3438 320.40625 C 1107.8274 320.47825 1107.2695 320.61035 1106.75 320.5 L 1106.3125 320 C 1106.1163 319.46973 1107.1467 317.36665 1107.4688 317.28125 C 1108.1965 317.37158 1109.1113 317.04028 1109.8125 316.875 C 1110.0957 316.80835 1110.815 317.4995 1111.25 317.5625 L 1111.4688 317.4375 C 1112.4826 316.35352 1111.1472 314.18726 1111.9688 313.3125 C 1112.7322 312.59668 1113.8008 314.42555 1115.625 314.40625 L 1115.9688 314 L 1116.2188 311.5 L 1116.5625 311.34375 L 1117.5938 311.4375 C 1119.2695 310.10253 1117.6507 308.3894 1117.9062 307.59375 C 1118.8555 304.64185 1119.4845 304.04028 1117.7812 301.5 C 1116.9313 300.23169 1115.7107 298.65991 1114.0312 298.4375 C 1113.511 298.01343 1114.017 296.84863 1113.7188 296.1875 C 1111.8999 294.77442 1111.5053 295.37915 1111.8438 292.53125 C 1111.8945 292.1062 1112.197 291.73804 1112.0312 291.1875 C 1109.9835 292.08936 1110.5978 291.44849 1108.9062 290.59375 C 1108.4316 289.64527 1106.5815 287.3728 1106.5625 287.3125 C 1106.0649 285.77808 1107.3401 286.58154 1105.5312 283.875 C 1105.3226 283.56201 1105.4113 283.2749 1105.0312 282.96875 C 1103.9411 282.08887 1102.4692 281.97412 1101.4375 280.71875 C 1100.8779 280.03759 1100.932 278.92651 1100.3438 278.21875 C 1100.016 277.99902 1096.0168 277.4873 1095.8438 277.5625 C 1095.1521 278.31278 1094.8208 277.20386 1093.75 278.25 L 1093.375 278.15625 L 1092.7812 277.46875 C 1092.9699 276.93726 1092.7715 276.40259 1092.4375 275.96875 L 1092.75 275.375 L 1092.5625 275.09375 C 1091.5922 275.45972 1090.752 275.50537 1089.75 275.34375 L 1088.5938 275.40625 C 1088.1662 274.70117 1087.8202 273.3574 1086.8438 273.375 C 1086.5751 273.5603 1086.1805 273.7622 1085.8438 273.75 C 1085.6596 273.51782 1085.1885 273.20065 1084.875 273.21875 C 1084.5937 272.40235 1084.5602 272.04785 1083.9062 271.46875 C 1083.9062 271.46875 1083.2284 270.71387 1083.0938 270.5 C 1082.7093 270.4492 1082.2461 270.42358 1081.875 270.5625 L 1081.5 270.4375 C 1081.5 270.4375 1079.7958 268.90918 1079.5938 268.5625 L 1079.5625 268 C 1079.4229 267.85401 1079.1669 267.74165 1078.9688 267.71875 L 1077.9688 267.96875 C 1076.7889 268.64869 1074.0051 272.66968 1073.2188 272.40625 C 1072.2757 271.62085 1072.8984 270.91162 1070.75 269.71875 C 1069.2432 269.45972 1069.1914 267.51978 1068.4375 267.25 L 1067.75 267.25 C 1067.75 267.25 1068.7802 265.74707 1066.375 264.15625 C 1065.7046 263.71314 1064.9829 263.1016 1064.125 263.125 C 1063.9482 262.89697 1063.344 262.26145 1063.0312 262.21875 C 1062.1058 262.62207 1060.1497 260.99414 1059.0938 260.65625 C 1057.4253 261.1018 1053.1826 262.06592 1052.5 259.90625 L 1051.7188 259.75 C 1050.9509 259.14282 1050.8619 258.01562 1050.0938 257.4375 L 1049.125 257.625 C 1047.5528 257.15186 1046.0367 257.37085 1044.5 256.71875 C 1044.0483 256.00171 1043.4014 255.29224 1042.75 254.75 C 1042.3985 254.88403 1041.8296 254.14966 1041.2812 254.28125 L 1040.8125 254.3125 C 1040.5792 253.28101 1035.2234 249.31372 1034.0312 249.6875 L 1032.9375 249.34375 C 1032.2094 248.43188 1031.1283 248.30078 1030.9062 248 C 1030.7323 247.76318 1030.6535 247.35962 1030.3438 247.25 C 1029.5956 246.98584 1028.9067 246.79199 1028.1875 246.40625 C 1027.9346 246.79446 1027.4835 246.9656 1027.0312 246.875 L 1026.2812 246.59375 C 1025.98 245.54199 1025.0546 246.1748 1024.625 244.84375 C 1024.2617 244.36914 1021.5625 242.60425 1021.0625 242.34375 C 1020.7104 242.16089 1019.9922 242.1355 1019.5625 241.9375 C 1019.128 241.45849 1018.8016 240.97583 1018.5938 240.375 C 1018.0089 239.85526 1017.0815 239.96973 1016.375 239.8125 C 1016.1636 239.76538 1013.6377 238.21436 1013.25 238 C 1012.5122 237.59204 1011.4463 234.38135 1010.9375 233.4375 C 1010.4561 232.54517 1009.231 232.94922 1008.5625 232.59375 C 1008.2578 231.47095 1006.755 230.74731 1006.1562 229.65625 L 1005.375 227.4375 C 1005.0108 227.52978 1004.4892 226.77515 1004.25 226.625 C 993.28323 219.74609 982.46533 212.53027 971.65625 205.375 C 970.20996 205.82812 969.00781 206.8562 967.53125 207.25 C 966.09619 207.63257 963.97705 207.39165 962.40625 207.46875 C 960.11182 207.58106 957.80957 207.85075 955.53125 207.84375 C 954.89258 207.84204 954.22998 207.40137 953.71875 207.09375 C 950.56006 205.1919 952.90918 205.88867 951.375 204.25 C 950.89941 203.74218 950.09033 203.66333 949.46875 203.40625 C 947.1084 202.42993 948.82275 201.79736 945.28125 201.9375 C 944.87256 201.95336 944.25146 201.98657 943.875 202.25 C 942.47559 201.84277 940.97412 202.08789 939.9375 200.8125 C 939.66556 200.3872 939.64505 199.43823 939.71875 198.96875 C 939.49072 198.57226 939.17188 198.19092 938.8125 197.90625 C 936.98877 198.00659 935.62354 198.3916 933.8125 197.78125 C 932.92285 197.48144 932.24512 196.5254 931.3125 196.5 C 931.3125 196.5 930.51367 196.12695 930.3125 196 C 930.3125 196 928.76221 196.1106 928.59375 196.1875 C 928.3916 196.16138 927.16125 195.89478 927.15625 195.53125 C 924.74707 195.88962 926.97461 195.96216 924.375 195.53125 C 923.73242 194.27881 922.24414 193.97852 921.25 193.125 C 920.69092 192.64502 919.94775 191.1616 919 191.25 L 918.75 191.34375 C 918.67431 192.24927 917.00928 191.60156 916.4375 191.75 C 915.13623 190.74854 913.59326 187.27905 913.03125 187.0625 C 912.85888 186.74316 912.84424 186.41431 912.71875 186.09375 C 912.32178 185.07886 910.08005 183.88965 910.15625 182.90625 C 910.15625 182.90625 909.5791 181.92407 909.46875 181.53125 C 909.5918 180.48145 910.06885 180.46631 909.28125 179.375 L 909.375 179.125 L 909.90625 178.8125 C 909.41065 177.67065 907.91309 177.41772 907.125 176.09375 C 906.9585 176.03085 906.74072 175.97895 906.5625 176.03125 C 905.72705 175.5918 905.40283 174.09351 904.9375 173.90625 L 904.46875 174.09375 C 904.46875 174.09375 901.96826 174.13555 901.46875 174.09375 C 901.22607 173.81762 899.23779 172.02295 899.09375 171.96875 L 899.15625 171.40625 L 899.125 171.03125 C 898.83544 170.83938 898.47314 170.97632 898.15625 170.875 C 897.94629 170.64599 897.8252 170.31567 897.71875 170.03125 C 895.97022 168.87842 897.52881 168.98633 894.84375 168.46875 C 894.34522 168.3728 894.61084 167.4895 894.1875 167.125 C 893.58545 167.41898 893.06689 167.65552 892.46875 167.21875 L 892.40625 167.40625 L 892.46875 167.75 C 892.40625 167.86401 892 168.09375 892 168.09375 C 891.69532 167.89428 890.42627 167.05325 890.21875 167.03125 C 888.46045 164.59663 886.22656 166.14648 885.84375 164.625 C 885.92675 164.42261 885.9395 164.11694 885.875 163.90625 L 885.28125 163.75 C 884.98193 162.31299 884.84082 162.91284 884.15625 161.875 C 884.15625 161.875 884.9751 160.74316 885.375 160.4375 C 885.10401 160.23124 882.9375 160.1875 882.9375 160.1875 C 882.38378 159.7063 881.78174 159.12891 881.3125 158.5625 C 881.16063 158.23608 881.4126 157.88525 881.3125 157.53125 C 881.3125 157.53125 879.37354 156.25415 879.25 156 C 878.3667 155.65621 876.56641 155.81519 875.65625 156.0625 L 874.65625 155.40625 L 874.4375 154.375 C 874.00781 154.00635 873.56299 153.69336 873.09375 153.375 C 872.67773 153.46435 872.01953 153.19214 871.71875 152.90625 C 871.37988 150.9292 871.51709 149.11597 869.5 148.03125 C 869.28565 148.10132 868.53855 147.71216 868.46875 147.53125 C 867.88379 147.46899 867.26318 147.69995 866.9375 146.96875 C 866.875 146.53247 866.82373 146.09888 866.65625 145.6875 C 865.83057 144.79053 865.4458 145.11279 864.96875 143.625 C 864.96875 143.625 864.43165 142.95044 864.34375 142.71875 C 863.79199 142.31104 862.45703 142.77124 861.5625 141.625 C 861.15479 141.71753 860.31152 141.64795 860 141.3125 L 859.6875 140.53125 C 858.76416 140.16723 858.49316 139.26318 857.78125 138.65625 C 857.55957 138.46753 857.13818 138.52563 856.90625 138.25 C 856.79248 137.84936 856.33789 136.52808 855.9375 136.3125 L 855.90625 134.53125 C 856.54834 133.42432 855.67334 131.28271 854.125 131.78125 C 854.125 131.78125 854.3276 131.02125 854.3125 130.96875 C 854.09082 130.20362 854.07471 128.77466 853.71875 128.15625 C 853.33398 127.48804 852.76221 127.28931 852.46875 126.46875 L 851.9375 126.625 C 851.583 126.42456 851.63867 124.30765 850.96875 124.34375 C 850.76318 124.38476 850.15332 124.5623 849.96875 124.5 C 849.6919 124.07837 849.58643 122.99268 849.34375 122.8125 C 848.96826 122.75366 848.56152 122.55371 848.25 122.34375 C 848.02586 121.97632 847.91699 121.21875 848.09375 120.8125 L 847.90625 120.625 L 847.09375 120.46875 C 846.82617 120.34229 846.5928 119.90771 846.5625 119.625 L 846.78125 118.78125 L 845.625 117 L 845.28125 116.96875 L 844.75 117.46875 L 844.53125 117.4375 C 844.23514 117.19116 844.22217 115.39624 844.53125 115.0625 C 844.40035 114.52686 844.3628 113.92188 844.4375 113.375 L 844.9375 113.25 L 845.125 112.96875 C 844.35205 112.4978 843.60742 111.65552 843.0625 110.9375 L 841.53125 110.125 L 841.375 109.78125 L 840.53125 109.34375 C 840.70069 108.99268 841.36719 108.6882 841.71875 108.625 C 842.52002 107.53125 842.90869 105.40308 841.4375 104.75 C 841.35254 104.04712 841.23389 103.63501 840.59375 103.25 L 840.375 103.21875 C 840.14355 103.36767 839.89795 103.85742 839.78125 104.09375 L 839.5625 104.125 C 839.19141 103.64991 839.68506 102.14844 839.34375 101.75 C 838.91406 101.43608 837.59229 101.39725 837.09375 101.40625 L 836.625 101.03125 L 836.8125 100.53125 L 836.75 100.34375 L 836.125 100.125 z ",
						"entrerios":"m 1056.5312,622.25 c -2.7098,-0.005 -5.7304,1.54731 -7.75,2.59375 -0.5833,0.30249 -2.3233,1.5391 -2.9374,1.625 -3.2348,0.45166 -4.1193,1.19653 -7.4376,0.78125 -1.2438,-0.15551 -2.4707,-1.14746 -3.7187,-1.25 -5.8267,-0.47876 -3.8515,2.34961 -8.5,3.75 -0.6992,0.21045 -1.0518,2.14258 -1.6875,2.65625 -0.5616,0.45313 -1.2154,0.59131 -1.8125,0.90625 -0.8643,0.45581 -2.6387,1.88696 -3.4687,2.0625 -3.2402,-0.2395 -4.4663,-2.59375 -9.1563,-2.59375 -1.4219,0 -2.4678,0.9126 -3.8125,1.09375 -1.0293,0.13867 -1.0342,-1.0127 -2.5,-0.84375 -1.0293,0.11817 -2.4746,1.09937 -3.4688,1.5 -1.55158,0.625 -2.28898,0.18625 -3.9062,0.15625 0.0791,0.37061 1.86914,3.64306 2.25,4.125 1.9292,1.39966 1.9701,2.28125 2.0938,4.71875 0.038,0.74976 0.1279,1.89551 -0.4688,2.46875 l 0.5312,5.84375 c 0.053,0.5835 -0.4614,1.16431 -0.4374,1.84375 0.018,0.49292 0.066,0.97754 0,1.46875 0.7871,1.0752 0.2436,2.13696 -1.00005,2.09375 -1.38965,2.12524 -2.42725,4.45557 -3.5625,6.71875 -2.34912,4.68311 -6.64892,10.72949 -9.9375,14.625 -1.40576,1.66602 -2.10254,3.90991 -3.1875,5.78125 -0.90674,1.56372 -2.55957,3.58252 -3.03125,5.28125 L 978.65625,690.5 c 0.19141,-0.12354 0.36279,-0.11572 0.4375,-0.125 -2.15576,2.43042 -2.47949,4.23242 -5.375,5.96875 -1.5625,0.93677 -3.64746,8.11524 -4.9375,10.25 -2.82324,4.67334 -5.51221,7.98487 -10.15625,10.75 -0.31348,0.18701 -0.7085,0.47095 -1.59375,2.5625 -1.29053,3.0498 -4.00586,5.65918 -6.40625,7.5 -3.70215,2.83789 -8.65869,0.78564 -12.65625,2.46875 -1.41309,1.13037 -0.40527,3.40723 -0.53125,4.9375 l -0.125,0.9375 c -0.25391,1.72754 -1.0083,3.28711 -1,5.0625 0.0142,3.19385 -2.30517,4.34912 -2.71875,7.0625 1.30029,1.62158 2.83593,1.25195 2.78125,5.5 -0.0205,1.63037 -0.12012,2.29687 -1.125,3.625 l -0.625,0.84375 c -3.0459,3.93896 3.19433,8.60986 1.34375,12.125 -1.06592,2.02393 -3.39941,0.58374 -3.1875,3.5 0.27246,3.74902 0.43116,4.28613 -1.0625,8.125 -0.9541,2.45264 -2.14307,1.78272 -0.71875,5.15625 0.48486,1.14844 1.08496,2.26856 1.4375,3.4375 0.68604,2.27271 1.62158,5.03198 1.625,7.4375 0.0107,6.47803 0.21337,6.61353 4.03125,12.53125 0.74219,1.15015 2.90039,4.26245 3.1875,5.71875 0.57568,2.91821 1.35645,6.39649 4.40625,7.5 2.30762,0.83472 8.19483,3.2976 9.59375,5.1875 0.44922,0.60669 0.81397,1.27514 1.3125,1.84375 l 0.5625,0.625 c 0.36523,0.41284 0.83436,0.97828 0.8125,1.3125 3.74183,1.8269 6.93311,4.90235 9.8125,8.40625 1.09619,1.3335 5.95068,4.94141 7.25,5.40625 1.44287,0.51636 2.39062,1.94434 3.53125,2.3125 3.68457,1.18823 7.53515,2.92187 9.09375,6.78125 0.27344,0.67749 9.1084,5.3252 10.0625,5.625 0.0928,0.029 0.18457,-0.061 0.28125,-0.0625 1.3833,-1.08887 3.5347,-2.43824 5.375,-2.0625 l 0.3438,0.125 c 2.7046,1.43042 3.7554,5.76074 6.625,5.96875 1.4429,0.10498 2.9014,0.0434 4.3437,0.15625 l 0.2187,-0.21875 0.3438,-0.375 c 2.6402,-2.5918 5.122,-0.58179 4.6875,2.5 -0.1221,0.86279 -0.5693,1.604 0.3437,2.03125 1.9511,-0.65503 2.8555,0.0293 3.7813,1.65625 l 0.1875,0.3125 c 7.6299,0.62256 5.8427,-1.60766 13.2188,3.0625 2.4085,1.52515 3.332,4.16358 6.4687,4.3125 1.7749,0.084 2.8998,0.29444 4.0313,1.8125 l 0.3437,0.4375 c 0.4448,0.58594 5.2348,4.93164 6.125,5.3125 4.8257,0.97021 3.5449,-1.65478 7.3125,-2.1875 l 4.4688,-0.65625 0.1874,-0.0625 c 0.2009,-0.54557 0.3423,-1.10184 0.063,-1.65625 -0.1607,-0.31763 -0.5206,-0.42969 -0.7188,-0.71875 -0.1304,-0.34424 -0.01,-5.15747 -0.375,-6.53125 -0.2881,-1.08569 -1.131,-1.26929 -1.7188,-2.0625 -1.2721,-1.71802 -2.9033,-3.91845 -3.4062,-6 -0.2041,-0.84717 0.015,-1.92602 -0.062,-2.8125 -0.072,-0.80542 -0.197,-1.71997 -0.094,-2.53125 0.2648,-2.08301 1.1186,-4.16187 1.3124,-6.21875 0.08,-0.85693 -0.3566,-1.72266 -0.375,-2.59375 -0.039,-1.90479 0.8677,-3.57959 1.1876,-5.375 0.1538,-0.86523 0.092,-1.85962 0.2812,-2.6875 0.1059,-0.4668 0.5599,-0.78027 0.7812,-1.1875 1.1471,-2.11011 1.7511,-3.53662 3.5313,-5.21875 0.5176,-0.48901 1.1763,-0.73657 1.3437,-1.53125 0.2319,-1.09546 -0.9156,-1.98559 -1,-2.96875 -0.1065,-1.25879 1.0538,-8.54908 0.9063,-8.78125 -0.4932,-0.17236 -0.9075,-0.90283 -0.9375,-1.40625 0.1602,-0.35791 0.5796,-0.78369 0.8125,-1.15625 0.7837,-0.54492 6.8457,0.11132 8.1563,0.21875 l 0.1562,1.34375 c 3.3408,-0.51147 6.7544,-1.29736 8.0625,-4.75 0.8023,-2.1167 0.9312,-4.26611 1.4375,-6.46875 0.2066,-0.89624 -0.1919,-1.03101 -0.375,-1.84375 -0.1558,-0.69214 0.1755,-1.41968 0.2188,-2.09375 0.085,-1.34009 -0.3662,-2.8772 -0.5938,-4.1875 -0.1962,-1.12915 -0.716,-2.16357 -0.9062,-3.34375 -0.4387,-2.71484 -0.3467,-6.51978 -0.5938,-9.53125 -0.095,-1.16162 -0.7837,-1.78711 -1.125,-2.84375 -1.2007,-3.71826 -3.3845,-13.05908 1.0312,-15.46875 0.055,-0.0294 0.1882,-0.0253 0.25,-0.0312 1.6853,-1.18945 1.6515,-1.4458 2.4063,-3.21875 1.8526,-4.35401 -1.4726,-4.60962 -1.1875,-6.59375 -0.8222,-1.3086 -3.4554,-3.2854 -3.0938,-5 0.4528,-2.14185 0.6212,-4.79102 2.3438,-6.34375 0.4214,-1.08496 0.1582,-2.45337 -0.25,-3.5 l -1.75,0 c -0,-0.12964 0.9065,-0.63232 1.0938,-0.90625 0.5988,-1.76294 -1.2959,-4.59717 -2.5313,-5.6875 -1.3266,-3.83545 2.5093,-5.76489 5.875,-5.21875 2.7993,-1.12573 5.9194,-13.19629 7.125,-16.71875 0.053,-0.15503 -0.2325,-0.8562 -0.3125,-1 -0.5362,-0.9685 -1.0918,-2.3186 -1.75,-3.1875 -1.1621,-1.53491 -3.8008,-0.99927 -4.1875,-3.28125 0.2461,-2.45459 3.2012,-3.65649 5.125,-4.34375 1.6983,-0.60693 0.514,-2.69141 0.5,-3.15625 -0.026,-0.86132 0.3579,-1.86084 0.5625,-2.6875 0.2363,-0.95605 2.2153,-2.05225 2.5625,-3.15625 0.7061,-2.24414 1.3525,-4.42627 1.875,-6.71875 0.3779,-1.6543 -0.8741,-2.07422 0.1875,-4.03125 l 2.0312,-3.75 c 1.7415,-3.2102 -3.2812,-7.81494 -2.4687,-9.9375 0.4971,-0.58275 1.5949,-0.6687 2.2813,-0.5 0.1769,0.2793 0.5722,0.39014 0.8437,0.53125 1.8208,0.94824 2.0915,-0.84131 2.5937,-2 1.6866,-3.89331 0.272,-3.08789 0.4688,-4.40625 0.1094,-0.73145 0.574,-1.61792 0.5,-2.375 -0.064,-0.64782 -0.237,-1.31432 -0.375,-1.96875 -0.6175,-0.45381 -1.3474,-1.09218 -1.625,-1.3125 -3.7236,-2.9541 -8.4158,-7.26904 -10.6562,-11.4375 -0.6694,-1.24561 -2.2693,-4.47461 -2.2813,-5.71875 -0.042,-4.39575 -0.7954,-4.01465 -4,-6.5625 -1.0317,-0.8208 -4.9619,-4.75195 -5.3125,-5.90625 -0.6094,-3.0669 -1.2082,-4.02661 -4.2188,-5.09375 -1.5031,-0.53321 -3.2446,-1.00049 -4.8437,-1.15625 l -0.25,-0.21875 -2.2813,-0.28125 c -1.0475,-0.12207 -1.6829,-0.95117 -2.5624,-1.25 -1.177,-0.39942 -2.7718,0.39111 -4.0626,0.1875 -1.3497,-0.21337 -1.8566,-1.16162 -2.9374,-1.75 -0.7833,-0.42664 -1.6593,-0.59225 -2.5626,-0.59375 z",				
						"chaco":"M 836.3125 213.375 C 836.53011 219.2653 836.88159 226.24247 836.5625 231.90625 C 827.45996 244.05493 785.71094 301.08251 773.71875 317.25 C 786.54931 317.3352 799.38916 317.51975 812.21875 317.53125 C 831.76075 317.54834 872.34619 317.39355 873.09375 317.40625 C 873.09375 317.40625 873.51125 367.15161 873.46875 373.21875 C 873.24414 405.22022 873.4004 437.24536 873.5 469.25 C 873.5073 471.57251 873.4951 473.92918 873.4375 476.25 C 899.36328 476.42622 1021.0675 476.63379 1043.2812 476.15625 C 1043.2812 476.14648 1043.2813 476.13473 1043.2812 476.125 C 1043.2448 474.9629 1044.2109 473.95166 1043.875 472.71875 L 1043.5938 472.21875 C 1042.8876 469.74804 1042.8123 470.31128 1044.2188 468.59375 C 1045.4896 467.04126 1045.7431 458.3269 1045.5625 456.25 C 1045.4082 454.47998 1044.8274 452.80273 1044.6562 451.0625 C 1044.363 448.07568 1044.7866 446.87891 1043.75 444 C 1043.457 443.18506 1043.41 442.49951 1043.2188 441.71875 C 1043.3118 441.39746 1043.5385 441.06934 1043.9688 440.65625 C 1046.2117 438.49926 1048.7661 435.51978 1051.625 434.4375 C 1054.9922 433.16357 1055.4156 432.43848 1059.1875 429.8125 L 1059.375 428.59375 C 1058.241 428.78249 1057.0208 428.83803 1056.7188 428.34375 C 1056.2396 427.43603 1058.6403 424.66919 1056.8438 422.96875 C 1056.4127 422.56104 1055.5472 422.14014 1055.0312 421.8125 C 1054.2522 421.31689 1053.645 421.31519 1053.375 420.1875 C 1054.3979 413.92554 1059.1391 416.94702 1060 415.21875 C 1059.9013 414.61694 1059.5557 411.50928 1060.1562 411.09375 C 1060.6541 411.07375 1061.2378 410.97437 1061.7188 411.15625 C 1061.946 411.32763 1062.1514 412.05176 1062.2188 412.3125 L 1062.4375 412.5 L 1062.6562 412.40625 C 1063.3958 411.28344 1062.1392 409.41211 1062.5625 408.6875 C 1062.7773 408.43384 1063.6782 408.0593 1064 408.125 L 1064.2812 407.9375 L 1064.4375 407.5625 C 1064.3438 406.50855 1063.1104 404.14136 1063.6875 403.34375 L 1064 403.125 C 1066.3717 403.13211 1067.9898 402.42849 1069.4062 400.9375 C 1068.8236 400.43457 1068.6677 399.69214 1068.7188 399.15625 C 1067.1565 399.78174 1066.3119 399.031 1064.5312 398.03125 C 1063.3416 397.36279 1063.4434 396.01807 1063.0625 394.90625 C 1061.523 393.34497 1059.4763 393.28271 1058.8438 390.84375 C 1057.6617 386.28271 1053.4603 387.36084 1051.1562 382.8125 C 1050.9923 382.48804 1050.7523 382.21093 1050.6562 382.09375 L 1050.1875 382.21875 C 1046.9419 383.01245 1046.4021 379.40552 1044.7812 377.71875 C 1041.6452 376.14917 1040.8305 376.5083 1038.5625 373.15625 C 1034.0991 366.55859 1034.5505 368.54199 1027.9688 365.6875 C 1026.7429 365.15601 1024.1408 363.37182 1023.7812 361.9375 C 1023.3225 362.3335 1022.9135 362.77735 1022.5 363.21875 C 1021.9922 363.75073 1021.4546 364.04297 1020.7188 364.1875 L 1020.2812 364.25 C 1017.9253 364.7041 1017.5947 366.79077 1014.6875 364.4375 C 1014.6045 364.5083 1014.5303 364.59497 1014.4375 364.65625 L 1014.0938 364.8125 C 1012.1144 365.44751 1008.1617 362.29249 1009.125 359.5 C 1007.7408 358.21338 1008.2656 355.32935 1007.7812 353.71875 C 1005.9892 351.94824 1005.0879 353.64579 1002.875 352.625 L 1002.4688 352.4375 C 1002.3836 352.3931 1002.2119 352.31933 1002.125 352.28125 C 1000.3745 351.88696 999.35791 353.4441 997.96875 351.125 L 997.65625 351.125 C 997.41797 351.1133 997.14697 351.07572 996.8125 350.96875 L 996.5 350.84375 C 994.20361 351.96851 992.04932 350.00805 992.59375 347.65625 L 992.75 347.0625 C 993.12158 345.66479 992.39258 344.23022 992.53125 342.71875 C 990.51758 342.70015 990.4292 340.5271 989.40625 339.4375 L 989.125 339.21875 C 988.00488 338.37671 987.95948 337.23096 987.3125 336.09375 C 986.00195 335.04468 985.26514 333.60791 983.59375 333.03125 L 983 332.8125 C 981.12646 332.14111 980.82471 330.80664 981.375 328.96875 C 980.56396 327.21289 976.73291 328.02685 975.75 324.59375 L 975.65625 324.25 C 974.02148 323.71094 972.28076 324.13282 971.28125 322.15625 L 971.1875 321.96875 C 971.05176 321.56006 971.06982 321.14917 971.125 320.8125 C 970.89453 320.8085 970.66943 320.8135 970.46875 320.8125 C 969.3042 320.8085 968.96533 320.47315 968.40625 319.59375 C 967.44971 319.4314 966.71191 319.45825 965.90625 318.84375 C 965.26709 319.37964 964.33985 319.53784 963.46875 319.21875 L 963.03125 318.96875 C 961.68164 317.79517 962.24317 316.74097 961.96875 315.34375 C 959.98193 313.74829 960.17578 313.61426 959.75 311.09375 C 959.08203 310.40356 958.78125 310.0437 958.78125 309.03125 C 958.78125 308.37427 959.13476 308.07373 959.53125 307.8125 C 959.2124 307.52637 958.96338 307.2251 958.875 306.875 C 957.81445 306.8621 956.77588 307.20069 955.78125 305.71875 L 955.625 305.46875 C 955.38086 304.82959 955.43262 304.13672 955.46875 303.46875 L 954.78125 303.25 C 953.81494 302.92334 952.75049 302.42774 952.40625 301.375 L 952.34375 301.125 C 952.27445 300.59155 952.34073 299.958 952.75 299.5625 C 952.38818 299.00464 952.14551 298.35717 951.8125 297.78125 C 950.3457 297.42456 947.81836 294.92627 947.28125 293.78125 L 946.875 292.875 C 946.7813 292.67603 946.67041 292.48315 946.53125 292.3125 L 946.25 291.96875 C 945.229 290.78809 944.38233 287.39429 943.15625 287.09375 C 942.46387 287.21851 942.17578 287.64746 941.3125 287.53125 L 940.84375 287.375 C 940.27686 287.0498 939.87207 286.53467 939.40625 286.09375 C 937.52295 285.08496 935.38281 285.78174 934.21875 283.4375 L 934.03125 283.09375 C 932.61084 282.31274 931.01172 281.61352 929.9375 280.375 C 928.71533 278.96631 926.66748 279.63305 925.21875 277.65625 C 922.95557 274.56738 924.13184 276.10132 921.15625 274.40625 C 920.49805 274.03149 920.05372 273.40747 919.8125 273.03125 L 919.46875 272.4375 C 919.0498 271.79443 915.25342 269.15088 914.34375 268.3125 C 913.80518 267.81592 913.31201 267.35327 912.8125 266.90625 C 911.14209 268.64648 905.93799 263.9143 908.1875 260.71875 C 906.78369 259.11914 904.9751 257.02807 905.21875 254.78125 C 903.32324 254.27222 903.5625 250.73682 900.625 250 C 897.52832 249.22339 895.77441 250.2898 892.71875 248.5 C 892.53076 248.39014 892.42871 248.31446 892.21875 248.25 C 889.37109 248.72803 888.79541 249.12866 886.09375 246.0625 C 884.83643 244.63574 883.71094 243.32837 882.34375 242 C 881.05566 240.74878 880.72852 240.23316 880.53125 238.53125 C 879.5 239.12134 878.64941 239.12793 877.9375 238.65625 C 877.31104 239.34155 876.43262 239.50782 875.65625 238.4375 C 874.53174 236.88794 873.60546 234.75366 872.9375 232.9375 L 872.625 232.09375 C 872.5786 231.97534 872.5903 231.94702 872.5625 231.90625 C 871.4292 231.24731 870.97851 231.06275 870.59375 230.78125 C 870.19385 230.48828 869.87061 230.09302 868.90625 229 C 868.81055 228.89111 868.71337 228.79834 868.625 228.71875 L 868.34375 228.78125 C 868.12061 228.84005 867.90186 228.88648 867.6875 228.90625 L 867.4375 228.90625 C 865.81738 228.76025 864.42822 228.08667 862.8125 227.90625 C 860.64355 227.66382 860.06835 225.61059 858.46875 224.8125 C 856.49316 223.8269 855.91114 224.12378 855.15625 221.78125 C 854.2583 218.99243 850.08643 219.99024 847.1875 218.9375 C 845.54541 218.34082 844.19287 217.85449 842.8125 216.8125 C 841.55123 215.86071 838.1711 215.04746 836.3125 213.375 z ",
						"corrientes":"M 1080.4375 425.125 C 1076.3179 425.06421 1074.0781 426.50928 1070.3125 427.25 C 1069.4365 427.42212 1068.6795 426.97949 1067.8438 426.84375 C 1066.846 426.68165 1066.7095 427.02222 1065.875 427.21875 C 1064.1714 427.61938 1064.6543 425.92505 1061.4375 428.03125 C 1061.1705 428.2059 1060.3017 428.43952 1059.375 428.59375 L 1059.1875 429.8125 C 1055.4156 432.43848 1054.9922 433.16357 1051.625 434.4375 C 1048.7661 435.51978 1046.2118 438.49926 1043.9688 440.65625 C 1043.5385 441.06934 1043.3119 441.39746 1043.2188 441.71875 C 1043.4101 442.49951 1043.457 443.18506 1043.75 444 C 1044.7866 446.87891 1044.3629 448.07568 1044.6562 451.0625 C 1044.8273 452.80273 1045.4082 454.47998 1045.5625 456.25 C 1045.7431 458.3269 1045.4896 467.04126 1044.2188 468.59375 C 1042.8124 470.31128 1042.8877 469.74804 1043.5938 472.21875 L 1043.875 472.71875 C 1044.2109 473.95166 1043.2447 474.9629 1043.2812 476.125 C 1043.3102 479.71092 1040.8819 486.43409 1036.4375 486.15625 C 1033.7959 485.9917 1032.0927 485.52857 1030.7188 488.5625 C 1029.744 490.71289 1031.143 499.24536 1031.3438 502 C 1031.6664 506.43506 1029.9062 510.38428 1029.9062 514.71875 C 1029.9062 519.00903 1030.0332 519.57959 1028.4688 523.84375 C 1026.979 527.9043 1027.0962 532.14014 1025.625 536.15625 C 1023.9771 540.65625 1023.9492 537.66894 1024.0625 542.75 C 1024.1585 547.06885 1019.4117 549.95166 1016.7812 552.875 C 1010.9658 559.33862 1013.832 557.64404 1006.9062 560.125 C 1006.3399 560.32788 1005.9403 560.60889 1005.7812 560.75 C 1004.6459 562.38184 1004.7885 565.2583 1003.3438 567.53125 C 1000.2681 572.37061 1000.1665 571.22486 1000.1875 576.25 C 1000.2185 583.5354 999.88427 589.61035 997.0625 596.59375 C 993.33594 605.81592 998.97797 604.71704 1001.2188 611.4375 C 1001.2838 611.63013 1001.2705 611.93653 1001.1875 612.21875 C 1001.5879 614.86475 999.46093 615.86182 998.90625 618.15625 C 998.4292 620.1311 997.51514 624.84888 997.46875 626.84375 C 997.43065 628.45874 997.14453 629.49219 995.90625 630.5625 L 995.5 630.90625 C 995.22266 631.13354 995.04981 631.29834 994.9375 631.4375 L 994.875 631.46875 L 995.25 632.3125 C 995.55762 633.01123 996.30515 634.4663 996.375 634.6875 C 997.99222 634.7175 998.72952 635.15625 1000.2812 634.53125 C 1001.2754 634.13062 1002.7207 633.14942 1003.75 633.03125 C 1005.2158 632.8623 1005.2207 634.01367 1006.25 633.875 C 1007.5947 633.69385 1008.6406 632.78125 1010.0625 632.78125 C 1014.7525 632.78125 1015.9786 635.1355 1019.2188 635.375 C 1020.0488 635.19946 1021.8232 633.76831 1022.6875 633.3125 C 1023.2846 632.99756 1023.9384 632.85938 1024.5 632.40625 C 1025.1357 631.89258 1025.4883 629.96045 1026.1875 629.75 C 1030.836 628.34961 1028.8608 625.52124 1034.6875 626 C 1035.9355 626.10254 1037.1622 627.09449 1038.4062 627.25 C 1041.7243 627.66528 1042.6092 626.92041 1045.8438 626.46875 C 1046.4579 626.38285 1048.1979 625.14624 1048.7812 624.84375 C 1051.4738 623.44849 1055.9609 621.13721 1059.0938 622.84375 C 1060.1748 623.43213 1060.6813 624.38038 1062.0312 624.59375 C 1063.3219 624.79736 1064.917 624.00683 1066.0938 624.40625 C 1066.9735 624.70508 1067.6085 625.53418 1068.6562 625.65625 L 1070.9375 625.9375 L 1071.1875 626.15625 C 1072.7866 626.31201 1074.5279 626.77929 1076.0312 627.3125 C 1079.0416 628.37964 1079.6406 629.33935 1080.25 632.40625 C 1080.6006 633.56055 1084.5308 637.4917 1085.5625 638.3125 C 1088.7671 640.86035 1089.5205 640.47925 1089.5625 644.875 C 1089.5745 646.11914 1091.1744 649.34814 1091.8438 650.59375 C 1094.0844 654.76221 1098.7764 659.07715 1102.5 662.03125 C 1102.7776 662.25157 1103.5075 662.88994 1104.125 663.34375 C 1104.0316 662.90068 1103.9549 662.46827 1103.9375 662.03125 C 1103.9045 661.21386 1104.0205 660.33936 1103.9375 659.53125 C 1103.8199 658.3789 1102.6608 657.33716 1101.9688 656.5 C 1101.1735 655.53906 1102.0357 654.10327 1101.375 653.53125 C 1100.9561 653.16919 1099.091 651.81909 1099.125 651.25 C 1099.689 649.95752 1099.4937 648.39087 1099.75 647.03125 C 1099.9614 645.90844 1102.0144 643.67676 1102.8438 643.09375 C 1103.4382 642.67529 1104.4613 642.3999 1104.9688 641.90625 C 1106.3724 640.54101 1106.4436 640.37598 1108.2812 639.21875 C 1108.9246 638.81372 1110.1701 637.7017 1110.8438 637.625 C 1111.6482 635.77808 1113.4953 637.83936 1114.8438 632.09375 C 1115.0422 631.24609 1115.3676 629.63232 1115.75 628.90625 C 1115.9599 627.73584 1112.3242 625.68555 1113.6875 624.25 L 1114.125 624.03125 L 1115.0938 624.1875 C 1117.2621 624.36182 1120.049 622.66504 1121.7812 621.75 C 1124.3435 620.39672 1124.3114 618.98413 1125.4688 617.0625 C 1125.9032 616.34106 1126.6924 615.42578 1127.25 614.78125 C 1128.4023 613.44995 1130.3144 613.35913 1131.375 612.125 C 1134.3115 607.23974 1130.4873 604.74756 1134.875 599.96875 C 1140.103 594.2749 1139.0576 598.05518 1142.125 596.84375 C 1145.2158 595.62353 1145.9312 594.57227 1148.25 592.125 C 1149.5103 590.79541 1150.8857 587.34888 1153.25 587.5 C 1153.7225 587.0747 1153.2812 585.90991 1153.2812 585.34375 C 1154.2259 583.53052 1156.1913 582.24902 1157.4688 580.65625 C 1157.851 580.17969 1158.0064 579.302 1158.625 579 C 1158.8721 578.87936 1159.1636 578.79855 1159.4375 578.78125 C 1160.1446 578.00537 1161.3506 577.79785 1162.0625 577 C 1162.8716 576.09253 1163.1616 575.04321 1164.375 573.6875 C 1164.756 572.77564 1164.3293 571.68262 1164.8438 570.78125 C 1166.034 568.69306 1167.8413 569.86084 1168.8125 568.6875 C 1169.481 567.87964 1170.2027 566.83179 1170.75 565.9375 C 1172.4776 563.11816 1171.6785 559.84448 1173.1562 556.90625 C 1173.5403 556.19141 1174.0035 555.65234 1174.375 555.03125 C 1174.7447 554.41357 1174.8587 553.70166 1175.2188 553.09375 C 1175.2981 552.95972 1175.4976 552.57129 1175.625 552.46875 C 1175.8946 552.25122 1176.3028 552.16431 1176.625 552.0625 C 1177.3355 551.83886 1178.0945 551.81567 1178.7812 551.59375 C 1179.6662 551.30737 1180.412 550.53857 1181.3438 550.25 C 1182.5419 549.8789 1183.8089 550.16602 1184.9688 549.5625 C 1185.7757 549.14307 1186.875 546.60254 1186.875 545.71875 C 1186.875 545.21143 1186.5142 544.64209 1186.25 544.21875 C 1186.1631 542.9209 1186.5683 542.10132 1187.625 541.3125 C 1189.1543 540.16992 1190.9988 540.16455 1192.0938 538.40625 C 1194.3552 534.77246 1190.062 530.15088 1196.75 528.96875 C 1197.5898 528.82015 1198.4366 528.9385 1199.2812 528.875 C 1200.9694 527.76319 1201.0806 525.45044 1202.375 524 C 1203.7696 522.43677 1206.3933 519.55957 1208.1562 518.5625 C 1208.6907 518.26049 1209.5552 518.02539 1209.875 517.4375 C 1210.438 516.40063 1209.8335 513.9292 1209.1875 513 C 1209.0957 510.01172 1211.7095 510.17969 1213.875 509.75 C 1214.5552 509.61523 1215.1138 509.0928 1215.75 509 C 1216.2281 508.93017 1216.8316 509.04517 1217.25 508.75 C 1218.4367 507.62597 1214.4016 503.57617 1218.4062 500.4375 C 1219.1067 500.2002 1225.6533 501.55859 1226.375 502.28125 C 1227.0595 502.9668 1226.9618 504.85156 1228.0938 505.25 C 1228.2655 505.26172 1228.4936 505.2085 1228.625 505.09375 C 1229.1538 504.15186 1229.2139 503.00146 1229.5 501.96875 C 1230.6094 497.9646 1230.468 498.63574 1226.9688 496.4375 C 1226.7963 496.3291 1224.595 494.8919 1224.4688 494.875 C 1224.0077 494.4502 1223.8934 493.82861 1223.9062 493.21875 C 1224.3929 491.90747 1227.6284 491.71265 1228.75 491.03125 C 1229.2124 490.75048 1232.957 487.53857 1233.0938 487.1875 L 1233.0938 486.3125 C 1233.0578 486.22228 1233.05 486.12867 1233.0625 486.03125 C 1232.0488 485.33542 1231.2006 484.36625 1230.2188 483.6875 C 1227.8216 482.03101 1225.6464 481.22925 1224.5 478.21875 C 1224.1391 477.27295 1224.5969 475.98901 1224.1562 475.0625 C 1223.1497 472.94287 1220.5784 472.1665 1220.0938 469.90625 C 1219.8035 468.55762 1220.0222 467.10425 1219.9062 465.75 L 1219.5625 461.71875 C 1219.2622 458.20313 1216.1338 452.91211 1214.875 449.34375 C 1214.5493 448.42017 1213.519 447.53443 1213 446.625 C 1210.0571 441.46484 1208.0112 438.16821 1210.8125 432.25 L 1211.5312 431.71875 C 1209.9213 430.88674 1208.3153 429.22411 1207.125 428.96875 C 1205.9976 428.72681 1203.3054 429.06104 1202.1562 429.53125 C 1199.8947 430.45752 1199.1393 433.23535 1197.1562 434.40625 C 1196.1272 435.01441 1194.767 435.0686 1193.9375 436.03125 C 1193.0273 437.08765 1194.2903 439.56274 1193.6562 441.1875 C 1193.2155 442.31762 1191.3686 443.40039 1190.5625 444.28125 C 1188.6914 446.32593 1190.5852 448.79272 1187.9688 449.53125 C 1184.903 450.39624 1185.0944 448.2771 1183.5312 447.8125 C 1182.8849 447.8394 1183.0005 448.24268 1182.2188 447.84375 C 1181.0834 447.26416 1179.9993 439.0708 1175.2812 438.71875 C 1174.6632 438.67261 1172.7065 439.50635 1171.9375 439.65625 C 1171.0273 439.83304 1169.8628 439.25317 1169.0625 439.65625 C 1167.2549 440.56714 1168.6091 442.47559 1168.1562 443.75 C 1166.6521 447.9856 1166.8359 446.24365 1163.75 447.8125 C 1162.6787 448.35791 1161.7725 449.3035 1160.4375 449.3125 C 1157.0406 449.33545 1155.9152 444.75781 1151.5938 442.96875 L 1151.5938 439.875 C 1144.0068 444.64551 1137.2629 434.73755 1128.0938 436.75 C 1125.8016 437.25316 1120.9334 439.2439 1118.7812 437.1875 C 1118.4787 436.89795 1118.2704 436.47852 1117.9688 436.1875 C 1117.2934 435.53662 1114.5729 434.00537 1113.6562 433.34375 C 1112.5393 432.53711 1111.2391 431.76099 1110.0938 430.9375 C 1107.9434 429.39136 1105.3609 431.99146 1103.75 430.59375 C 1098.5449 426.07788 1100.1532 429.16504 1093.3438 426.53125 C 1091.8456 425.95211 1090.3594 426.32642 1088.8125 426.53125 C 1087.8901 426.65332 1083.8521 426.87939 1083.0625 426.40625 C 1082.0967 425.8274 1081.6445 425.1426 1080.4375 425.125 z ",
						"misiones":"M 1322.0625 306.71875 C 1320.9929 306.81584 1319.7353 308.93784 1319.2188 309.4375 C 1318.389 310.24048 1316.667 309.15454 1316.1875 310.125 C 1315.5586 311.39697 1314.7879 312.63354 1314.5938 313.21875 C 1313.4725 314.5 1312.6335 310.8396 1311.7188 310.65625 C 1311.1463 310.90332 1309.8037 311.23193 1309.375 311.65625 C 1308.8921 312.13379 1308.656 313.94067 1307.8438 314.09375 C 1307.2523 314.20507 1306.6518 313.0542 1305.875 313.71875 C 1305.5874 313.96533 1305.8854 315.87842 1304.9062 317 C 1304.6418 317.01953 1303.9603 319.66162 1303.4688 320.34375 C 1302.0578 320.56226 1302.562 318.37256 1302 317.71875 C 1301.4785 317.11206 1300.1456 315.20898 1299.2812 315 C 1298.9259 314.96118 1298.1487 315.5061 1297.9062 315.71875 L 1297.5 315.6875 C 1295.6836 314.64135 1298.6354 312.37939 1293.5312 312.875 C 1293.0271 314.97803 1293.7966 315.44946 1293.9688 317.3125 C 1293.9805 317.44458 1293.9915 317.60205 1293.9062 317.71875 C 1292.9011 318.781 1290.9365 316.74097 1290 318.25 C 1289.1074 319.68799 1291.1138 321.46802 1291.3125 322.8125 C 1291.5445 324.38281 1291.2819 324.39966 1292.0312 326 C 1292.5035 327.00781 1293.7422 328.0022 1293.875 329.09375 C 1294.0357 330.41724 1293.1264 331.74902 1292.625 332.90625 C 1291.8012 334.80542 1291.648 335.30469 1292.5625 337.21875 C 1294.5005 341.27368 1286.7479 336.28857 1288.9688 342.3125 C 1289.4353 343.57861 1290.8125 345.12158 1290.8125 346.5 C 1290.8125 349.1665 1288.4149 349.29175 1288.9688 351.375 C 1289.5564 353.58594 1292.2906 353.58643 1292.125 355.15625 C 1292.0039 356.31079 1289.0581 357.10693 1288.5625 358.6875 C 1288.2417 359.71192 1290.7417 360.53516 1290.375 361.96875 C 1290.3061 362.23804 1287.919 365.47925 1287.5625 366.53125 C 1287.3194 367.2478 1287.5445 368.17114 1287.5625 368.90625 C 1287.6294 371.57422 1285.731 372.51953 1284.0625 374.21875 C 1282.7222 375.04249 1280.6854 377.02563 1280.9688 378.8125 C 1281.0276 379.18824 1282.1749 380.37866 1282.2812 381.40625 C 1282.403 382.57715 1281.2841 386.57565 1279.875 386.65625 C 1278.8398 386.71557 1277.1757 383.92114 1273.9375 386.84375 C 1271.6967 388.86596 1274.5654 395.34351 1269.6875 394.34375 C 1268.6787 394.25074 1267.4765 394.26392 1266.5625 394.75 C 1265.5947 395.26464 1265.3765 396.4126 1264.625 397.15625 C 1263.7935 397.97876 1262.4481 398.35107 1261.7188 399.21875 C 1261.348 399.65869 1260.9035 400.55371 1260.8438 401.125 C 1260.6717 402.75708 1262.1167 404.24634 1261.875 404.6875 C 1261.4746 405.41797 1257.8884 406.66602 1257.0938 406.28125 C 1256.8109 406.14477 1256.2314 405.30176 1255.9375 405 C 1254.2212 403.23804 1253.0433 405.53955 1251.8438 405.875 C 1249.1155 406.63867 1248.6524 405.3772 1246.25 407.1875 C 1245.1758 407.99756 1244.4863 408.55347 1243.6875 409.71875 C 1241.9531 412.25 1243.2615 413.25513 1242.7188 415.21875 C 1241.2107 416.79346 1239.271 414.99683 1237.75 415.65625 C 1235.4326 416.66114 1236.7507 418.7793 1236.2812 419.34375 C 1235.3824 420.42529 1234.2991 418.62939 1233.3438 420.21875 C 1231.6618 423.01465 1235.7193 423.59204 1235.4375 425.40625 C 1235.2691 426.49219 1234.1805 427.37842 1234.1562 428.0625 C 1234.1301 428.79687 1234.7323 429.51709 1234.6562 430.53125 C 1234.5343 432.15942 1230.2304 433.70972 1228.875 434.9375 C 1227.7612 435.94653 1227.2812 438.40063 1225.9062 438.6875 C 1225.3136 438.81152 1223.7749 438.59326 1223.1875 438.46875 C 1217.6201 437.29126 1219.4756 433.45117 1216.9375 431.96875 C 1215.643 431.21317 1214.1354 432.63257 1212.2812 432.03125 C 1212.0298 431.9497 1211.7837 431.84923 1211.5312 431.71875 L 1210.8125 432.25 C 1208.0112 438.16821 1210.0571 441.46484 1213 446.625 C 1213.519 447.53443 1214.5493 448.42017 1214.875 449.34375 C 1216.1338 452.91211 1219.2622 458.20313 1219.5625 461.71875 L 1219.9062 465.75 C 1220.022 467.10425 1219.8037 468.55762 1220.0938 469.90625 C 1220.5785 472.1665 1223.1495 472.94287 1224.1562 475.0625 C 1224.5967 475.98901 1224.1391 477.27295 1224.5 478.21875 C 1225.6464 481.22925 1227.8218 482.03101 1230.2188 483.6875 C 1231.2008 484.36625 1232.0488 485.33542 1233.0625 486.03125 C 1233.0639 486.0203 1233.06 486.01141 1233.0625 486 C 1233.3008 484.9248 1233.8805 484.14722 1235.1562 484.34375 C 1236.1797 484.92774 1235.7659 486.19702 1236.1562 487.09375 C 1236.3546 487.23461 1236.7199 487.42485 1236.9688 487.34375 C 1238.1086 486.38525 1237.6387 484.86987 1238.5 484.34375 C 1238.8066 484.15625 1239.1635 484.2207 1239.4688 484.03125 C 1240.0072 483.33545 1239.8928 482.32373 1240.4062 481.71875 L 1240.7188 481.59375 C 1241.5539 481.62012 1242.0613 482.82593 1242.8438 482.96875 C 1243.6131 483.10913 1244.281 480.95874 1246.0312 479.875 C 1246.9051 479.33422 1247.6164 478.8833 1247.9062 477.84375 C 1247.6466 477.03247 1247.2773 476.44238 1246.875 475.71875 C 1247.208 474.56714 1248.8965 474.76416 1249.5 474.0625 C 1249.8916 473.60742 1249.7232 471.89258 1250.625 471.3125 C 1251.4751 470.76513 1253.3901 471.08374 1254.3125 470.625 C 1255.9667 469.80298 1256.7158 466.42334 1259.375 466.84375 C 1260.5966 467.7727 1260.1926 468.52051 1261.7812 469.09375 L 1262.0938 469 C 1262.5868 468.62403 1262.3075 467.40845 1262.2812 466.875 C 1263.3327 464.09326 1269.0842 468.36157 1268.1562 464.90625 C 1267.3073 463.81641 1265.1164 462.8728 1264.8438 461.84375 C 1265.1628 461.30957 1266.2475 460.53882 1266.9375 460.78125 C 1267.2753 461.15039 1268.1843 462.28271 1268.4688 462.40625 C 1269.3958 462.81054 1269.999 461.30371 1270.6875 461.09375 C 1271.0557 460.98145 1272.2768 461.30245 1272.8125 461.28125 C 1273.4336 460.97265 1273.3322 460.26709 1273.6562 459.78125 C 1274.007 459.25488 1274.6391 458.99829 1275 458.375 C 1275.9301 456.76539 1274.9558 452.87671 1275.5938 451.8125 C 1276.2317 450.74854 1277.9417 451.44434 1278.7188 450.625 C 1279.7639 449.52295 1279.7891 445.29077 1281 444.6875 L 1281.25 444.6875 C 1282.3398 445.3479 1281.652 446.21924 1282.2812 447.15625 C 1282.2169 447.26318 1282.3996 448.15695 1282.9688 448.21875 C 1283.9734 447.99536 1284.2686 446.89795 1285.2188 446.65625 C 1286.1087 446.43017 1287.8042 448.01953 1289.125 447.0625 C 1289.5166 446.41626 1288.5901 444.28442 1288.7188 443.1875 L 1288.9062 443.03125 C 1290.0437 442.5227 1290.2649 445.25757 1291.0312 445.625 C 1293.3732 446.16309 1293.3236 439.94067 1294.7188 439.40625 C 1296.1131 438.87183 1296.7314 442.40918 1297.625 442.71875 C 1298.3027 442.95361 1298.9608 441.34644 1299.4688 441.125 C 1300.368 440.73312 1301.3364 441.13477 1302.1875 440.65625 C 1302.7905 439.75708 1301.6952 438.44409 1300.9688 438.0625 L 1300.8438 437.625 C 1301.1626 437.06617 1302.1388 437.30371 1302.6562 437.15625 C 1303.2721 436.98047 1303.6494 436.44849 1304.25 436.28125 C 1305.8272 435.8418 1306.406 439.07373 1307.2188 439.78125 C 1307.6062 439.89063 1307.9253 440.11185 1308.3438 440.09375 C 1309.8113 439.69604 1307.7853 436.99072 1308.5312 435.96875 L 1308.7188 435.84375 C 1309.6996 435.56909 1310.7524 437.55005 1311.125 438.21875 C 1311.3496 438.38843 1311.7622 438.66645 1312.0625 438.65625 C 1314.0277 438.30029 1311.6535 435.9917 1314.0312 435.125 C 1314.3111 435.02295 1315.023 434.8237 1315.3125 434.875 C 1316.5117 434.27588 1316.0403 432.26709 1316.3438 431.125 C 1316.5388 430.38916 1317.1135 429.61157 1317.4062 428.875 C 1317.6482 428.26685 1317.541 425.39209 1319.0625 425.875 C 1319.9912 426.48511 1318.906 428.15454 1319.7188 428.625 C 1320.2058 428.90695 1320.9153 428.87745 1321.4688 428.96875 C 1325.0325 429.55469 1324.3955 427.0874 1325.625 426.1875 C 1326.3145 425.68238 1327.3288 425.83276 1327.6562 424.84375 C 1327.8983 424.11426 1327.8579 423.21338 1328 422.4375 C 1329.27 421.08959 1330.8789 422.49121 1331.3125 421.84375 C 1331.6113 420.99096 1330.7732 418.82525 1332.4062 418.90625 C 1333.1222 419.14893 1333.6037 420.71021 1334.5312 420.3125 C 1335.6481 419.83326 1335.1523 416.41431 1337.125 417.5 C 1337.6138 417.91406 1337.1087 418.91626 1338.7812 420 C 1338.7812 420 1340.656 419.65601 1340.4688 418.59375 C 1340.281 417.53101 1339.9688 417.28125 1339.8438 416.90625 C 1339.7188 416.53125 1338.906 415.59399 1340.2188 415.90625 C 1341.531 416.21875 1342.344 415.53125 1341.7812 414.53125 C 1341.2184 413.53125 1341.031 412.03125 1341.8438 411.90625 C 1342.656 411.78125 1343.8438 410.78125 1343.5938 410.28125 C 1343.3438 409.78125 1343.0312 409.34399 1343.9062 408.96875 C 1344.7812 408.59399 1345.2188 408.09375 1345.0938 407.59375 C 1344.9688 407.09375 1344.406 406.59399 1345.2188 406.40625 C 1346.031 406.21875 1347.1562 404.84399 1347.5312 404.15625 C 1347.9062 403.46875 1348.844 402.15601 1347.7812 401.59375 C 1346.7195 401.03101 1346.781 399.96875 1347.7188 399.71875 C 1348.656 399.46875 1348.5312 398.53125 1347.5312 397.90625 C 1346.5312 397.28125 1346.4062 396.03101 1346.2812 395.34375 C 1346.1562 394.65601 1345.969 393.71875 1345.4062 393.71875 C 1344.8434 393.71875 1343.9062 393.09399 1344.7812 392.53125 C 1345.6562 391.96875 1345.6562 391.34399 1344.5312 391.21875 C 1343.4062 391.09399 1343.2195 390.34399 1343.2812 389.78125 C 1343.344 389.21875 1343.156 388.28125 1343.9688 387.90625 C 1344.781 387.53125 1345.219 387.15625 1345.4062 386.65625 C 1345.594 386.15625 1345.594 385.71875 1345.0312 385.53125 C 1344.469 385.34399 1343.4062 384.96875 1344.1562 384.03125 C 1344.9062 383.09399 1345.0938 381.59399 1345.0938 381.21875 C 1345.0938 380.84399 1345.406 379.40625 1344.9688 378.71875 C 1344.531 378.03125 1344.6562 377.40625 1344.7812 376.40625 C 1344.9062 375.40625 1345.469 374.71875 1346.0312 374.46875 C 1346.5934 374.21875 1346.719 373.71851 1346.5312 372.84375 C 1346.344 371.96851 1346.469 371.03125 1346.9062 370.71875 C 1347.344 370.40625 1348.719 368.96875 1349.1562 368.21875 C 1349.594 367.46875 1350.406 365.59399 1350.5938 364.78125 C 1350.781 363.96875 1351.5938 362.90625 1351.5938 362.15625 C 1351.5938 361.40625 1351.5312 359.96875 1351.7812 359.65625 C 1352.0312 359.34399 1352.7812 358.53125 1352.7812 358.53125 C 1351.7668 357.26709 1350.8183 355.95581 1349.8125 354.78125 C 1349.4951 354.40991 1349.4521 353.90063 1349.25 353.46875 C 1348.7246 352.34301 1347.6396 351.56372 1346.75 350.75 C 1346.3652 350.39795 1345.2109 349.47046 1345.0625 349 C 1345.0693 348.7146 1345.208 348.50195 1345.25 348.25 C 1345.6616 345.79199 1345.6993 346.35547 1344.75 344.40625 L 1343.625 343.125 C 1343.625 343.125 1342.9375 342.87495 1342.6875 342.78125 C 1342.4375 342.6875 1341.75 341.6875 1341.625 341.46875 C 1341.5 341.25 1341 340.78125 1340.75 340.625 C 1340.5 340.46875 1340.4062 339.9375 1340.2812 339.5625 C 1340.1562 339.1875 1339.4372 338.90625 1338.7188 338.78125 C 1337.9997 338.65625 1338.4062 337.6875 1338.4062 337.6875 C 1338.4062 337.6875 1338.25 336.9375 1338.125 336.65625 C 1338.001 336.375 1338.0005 335.90625 1338.0625 335.6875 C 1338.125 335.46875 1338.5627 335.21875 1338.9062 335.625 C 1339.2499 336.03125 1339.3126 334.40625 1339.3438 334.125 C 1339.3748 333.84399 1339.1252 333.375 1338.9062 333.375 C 1338.6877 333.375 1338.4375 333.3125 1337.875 333.125 C 1337.3125 332.9375 1337.4375 332.71875 1337.4375 332.53125 C 1337.4375 332.34399 1338.406 332.09395 1338.7188 332.03125 C 1339.0313 331.96875 1339.0313 331.71875 1338.8125 331.46875 C 1338.5938 331.21875 1338.4685 330.90625 1338.4062 330.71875 C 1338.344 330.53125 1338.156 330.18726 1337.8438 329.84375 C 1337.531 329.49976 1337.7188 329.1875 1338.0938 328.65625 C 1338.4688 328.125 1338.2813 328.1875 1338.75 328.125 C 1339.2188 328.0625 1339.0316 327.15625 1339.0938 326.65625 C 1339.156 326.15625 1338.25 325.40625 1337.75 325.0625 C 1337.25 324.71875 1337.6875 324.34399 1338.25 323.96875 C 1338.8125 323.59399 1337.5625 323.06255 1337.0625 323.15625 C 1336.5625 323.25 1336.8435 322.43726 1336.9375 322.09375 C 1337.0313 321.74976 1336.5312 321.28125 1336.0312 320.875 C 1335.5312 320.46875 1337.6245 319.93726 1337.7188 319.59375 C 1337.8123 319.24976 1337.625 318.875 1337.4375 318.53125 C 1337.25 318.1875 1336.9688 317.28125 1336.375 317.40625 C 1335.7813 317.53125 1335.094 317.28125 1335.5312 316.78125 C 1336.3472 315.84961 1335.8125 315.875 1335.5 315.3125 C 1335.1875 314.75 1333.9376 314.56226 1332.7812 314.34375 C 1331.6251 314.12476 1332.0412 314.87378 1332.2812 315.40625 C 1332.5212 315.93897 1332.2188 315.90625 1331.875 316.15625 C 1331.5313 316.40625 1331.1875 316.03125 1331.0625 315.5 C 1330.9375 314.96875 1330.5625 313.25 1330.5625 313.25 L 1329.9688 312.625 C 1329.7284 312.18506 1329.4187 311.92822 1329.0938 311.6875 C 1326.8451 310.02271 1327.1503 312.5991 1325.6875 312.5625 C 1325.165 312.54956 1324.8688 315.12842 1322.7812 314.9375 C 1322.4611 314.7063 1322.106 313.63037 1321.9375 313.28125 C 1320.6499 310.61548 1320.8945 311.07153 1322.0625 308.9375 C 1322.373 308.36963 1323.1518 307.4314 1322.5 306.8125 C 1322.3572 306.73312 1322.2153 306.70488 1322.0625 306.71875 z M 1233.0938 486.28125 L 1233.0938 487.1875 C 1233.2893 486.68557 1233.1671 486.47012 1233.0938 486.28125 z ",
						"cordoba":"M 721.84375 572.59375 C 710.33301 575.63721 698.83594 578.69312 687.3125 581.6875 L 686.09375 581.96875 C 684.44336 582.34229 682.74365 582.68897 681.125 583.1875 C 681.36182 585.19897 683.16846 601.96337 683.46875 602.78125 C 679.84082 607.35986 675.55371 611.69531 671.625 616.0625 L 670.53125 617.25 L 660.53125 620.09375 L 659.3125 620.40625 L 655.40625 621.5625 L 650.5 636.09375 L 650.03125 637.21875 L 648.25 639.1875 L 640.09375 666.3125 L 638.875 669.625 L 635.03125 680.8125 L 634.59375 681.9375 L 633.84375 684.125 L 633.875 693.59375 L 633.9375 697.15625 L 633.90625 699.53125 L 633.9375 700.71875 L 634 709 L 634.03125 710.1875 L 634 712.5625 L 634.0625 713.75 L 634.09375 722.03125 L 634.125 723.21875 L 634.125 727.96875 L 634.15625 729.15625 L 634.21875 739.8125 L 634.28125 740.0625 C 635.35938 740.10132 640.52588 739.83154 641.59375 740.46875 C 647.62891 744.07007 653.67871 747.6272 659.71875 751.21875 C 661.4956 752.2749 661.17969 752.53198 662.375 753.90625 C 662.90479 754.51562 663.84814 754.77075 664.3125 755.40625 C 665.70703 757.31665 663.93945 760.40796 666.96875 764.53125 C 667.91162 765.81445 666.47607 768.93066 667.625 770.15625 C 668.52832 770.60571 672.33447 769.6853 673.40625 769.625 C 673.54639 769.6171 673.7041 769.66825 673.84375 769.65625 C 676.34619 769.4419 678.22363 768.61816 680.5625 767.96875 C 686.99902 766.18139 683.40527 774.1853 683.71875 777.78125 C 683.76953 778.36377 685.05371 779.88208 685.375 780.3125 C 685.87059 780.97583 685.66797 782.37012 685.875 783.1875 C 686.05518 783.89648 686.47607 784.37988 686.59375 785.15625 C 686.73975 786.12451 686.1699 786.71655 686.125 787.59375 C 686.05127 789.03784 686.46484 789.09521 685.9375 790.71875 C 685.33496 792.57569 684.49075 792.59082 684.40625 795.0625 C 684.34277 795.56885 684.16504 796.90967 683.71875 797.21875 C 683.11768 797.63526 682.47412 797.92725 682.21875 798.65625 C 682.01657 799.23267 682.56104 800.46533 682.3125 801.34375 C 682.04443 802.28906 681.18896 802.896 680.9375 804.03125 C 680.4873 806.06202 681.65771 805.91919 680.21875 808.59375 L 678.8125 811.21875 C 676.35059 815.79345 681.42383 812.20044 676.65625 819.4375 C 675.75147 820.81128 677.83691 822.43799 677.375 823.65625 C 676.77099 824.69482 674.54443 824.01172 673.75 825.03125 C 673.43604 825.43408 673.30859 825.93481 673.0625 826.375 C 670.5542 830.8706 671.22559 830.25537 671.53125 835.8125 L 671.96875 844.125 C 672.68359 856.45508 673.28516 868.79492 674 881.125 C 674.41354 888.25512 674.12065 895.52075 674.09375 902.65625 C 674.03285 919.01245 674.11765 935.36182 674.03125 951.71875 C 683.70899 951.14845 774.5625 951.75 774.5625 951.75 C 774.6309 944.14794 775.05127 915.88501 774.6875 909.4375 C 778.22656 909.96216 782.33594 909.5715 785.90625 909.5625 C 792.11523 909.5466 805.875 909.625 805.875 909.625 C 808.35254 905.10449 811.55127 900.77564 814.375 896.4375 C 824.46533 880.93652 834.35547 865.31494 844.34375 849.75 C 846.79541 845.9292 861.65918 821.78418 862.34375 821.21875 C 863.76416 822.47266 867.01514 820.46484 867.90625 819.46875 C 870.4082 816.67285 870.40283 816.13331 870.65625 812.5 C 870.75977 811.01562 870.06153 809.62061 870.5 808.0625 C 870.9668 806.40332 873.38916 804.04639 871.375 801.625 C 870.71533 800.83203 869.60694 800.42823 869.0625 799.53125 C 868.05273 797.86865 867.5166 795.29663 866.1875 793.8125 C 865.23389 792.7478 862.78271 793.35107 862.28125 792.625 C 862.31595 792.22656 863.78906 790.68018 864.34375 788.1875 C 864.63184 786.89062 863.42188 786.75561 862.625 786.15625 C 861.88428 785.22119 862.5811 783.63281 862.625 782.5625 C 862.6504 781.95215 861.94775 780.44311 861.75 779.875 C 860.75781 777.02002 857.1875 776.15723 855.4375 774.09375 C 852.60889 770.75952 854.08643 767.86475 852.125 764.9375 C 851.13477 763.45972 849.70899 763.17871 848.1875 762.4375 C 848.10935 762.3997 848.09765 762.3689 848.03125 762.3125 C 847.17822 761.58472 847.00684 760.80664 846.34375 760.0625 C 845.65967 759.29492 844.47754 759.0166 843.8125 758.21875 C 843.2275 757.51636 843.18457 753.69043 843.3125 752.78125 C 843.65283 750.3606 843.90771 749.22583 845.0625 747.15625 C 845.3208 746.69238 845.73047 746.08618 845.625 745.5 C 845.29883 743.68896 843.82666 743.69141 843.46875 740.46875 C 843.32861 739.20532 842.84033 737.47022 843.09375 736.21875 C 843.60986 733.6687 844.08252 732.80127 842.65625 730.59375 C 842.39697 730.19336 841.92383 729.41528 841.8125 728.9375 L 848.53125 723.5625 C 854.2832 702.92529 859.80713 682.19556 865.34375 661.5 C 862.26416 660.45117 859.21729 659.27588 856.1875 658.09375 C 855.92969 657.99316 855.72022 657.52246 855.53125 657.34375 C 853.99316 655.88672 851.98291 654.62158 850.1875 653.5 C 848.50391 652.44775 846.38086 651.41016 844.875 650.125 C 845.08154 647.93848 845.73389 644.98926 845.53125 642.84375 L 848.03125 642.65625 C 848.47412 638.05176 849.49707 633.42871 850.1875 628.84375 C 850.46924 626.9751 851.16695 624.49756 851.15625 622.65625 C 850.82129 622.2959 841.58301 597.78613 841.0625 596.34375 C 833.32812 596.67435 825.54834 596.5542 817.8125 596.71875 C 815.06641 596.77735 812.30762 596.9019 809.5625 596.8125 C 804.45215 596.64649 799.15625 596.999 794.03125 597.0625 C 787.39404 597.145 781.00244 596.99028 774.375 596.5625 C 774.31397 596.5585 774.0669 596.37895 774 596.34375 C 773.76416 595.25268 774.51221 593.88159 773.46875 593.0625 C 772.47168 592.65869 771.11768 593.11672 770.125 592.8125 L 769.90625 592.59375 C 769.5 591.61767 771.69873 588.39648 768.65625 587.9375 C 767.82666 588.0198 767.31055 589.45752 766.125 588.96875 C 762.2002 587.35107 761.75 586.9375 757.90625 587.9375 C 755.84961 588.47265 750.20898 589.0459 748.375 587.90625 C 747.17041 587.15795 747.70264 586.56299 745.9375 586.03125 C 744.9043 585.72022 742.8833 585.85791 742.1875 585.5 C 741.41895 584.95581 741.45801 583.39941 740.4375 583.09375 C 739.91407 582.93701 735.15576 581.60596 735.03125 581.4375 C 734.74268 580.08838 736.21191 577.75293 735.53125 576.1875 C 734.45899 575.90429 721.98926 572.55545 721.84375 572.59375 z M 805.875 909.625 C 815.79414 909.63792 825.72987 909.62274 835.65625 909.59375 C 825.72186 909.628 815.8021 909.63792 805.875 909.625 z M 835.65625 909.59375 C 840.62616 909.57924 845.59312 909.56657 850.5625 909.53125 C 845.59584 909.56851 840.62344 909.57663 835.65625 909.59375 z M 850.5625 909.53125 C 855.53438 909.49592 860.49896 909.43804 865.46875 909.375 C 860.5042 909.43797 855.52916 909.49399 850.5625 909.53125 z ",
						"santafe":"m 1043.2812,476.15625 c -22.2134,0.47754 -143.91792,0.26997 -169.8437,0.0937 -5.8418,39.23706 -11.41943,78.50293 -17.78125,117.65625 -1.55566,9.57471 -2.9077,19.18263 -4.5,28.75 0.0107,1.84131 -0.68701,4.31885 -0.96875,6.1875 -0.69043,4.58496 -1.71338,9.20801 -2.15625,13.8125 l -2.5,0.1875 c 0.20264,2.14551 -0.44971,5.09473 -0.65625,7.28125 1.50586,1.28516 3.62891,2.32275 5.3125,3.375 1.79541,1.12158 3.80566,2.38672 5.34375,3.84375 0.18897,0.17871 0.39844,0.64941 0.65625,0.75 3.02979,1.18213 6.07666,2.35742 9.15625,3.40625 -5.53662,20.69556 -11.06055,41.42529 -16.8125,62.0625 l -6.71875,5.375 c 0.11133,0.47778 0.58447,1.25586 0.84375,1.65625 1.42627,2.20752 0.95361,3.07495 0.4375,5.625 -0.25342,1.25147 0.23486,2.98657 0.375,4.25 0.35791,3.22266 1.83008,3.22021 2.15625,5.03125 0.10547,0.58618 -0.3042,1.19238 -0.5625,1.65625 -1.15479,2.06958 -1.40967,3.20435 -1.75,5.625 -0.12793,0.90918 -0.085,4.73511 0.5,5.4375 0.66504,0.79785 1.84717,1.07617 2.53125,1.84375 0.66309,0.74414 0.83447,1.52222 1.6875,2.25 0.0664,0.0564 0.0781,0.0872 0.15625,0.125 1.52149,0.74121 2.94727,1.02222 3.9375,2.5 1.96143,2.92725 0.48389,5.82202 3.3125,9.15625 1.75,2.06348 5.32031,2.92627 6.3125,5.78125 0.19775,0.56811 0.9004,2.07715 0.875,2.6875 -0.0439,1.07031 -0.74072,2.65869 0,3.59375 0.79688,0.59936 2.00684,0.73437 1.71875,2.03125 -0.55469,2.49268 -2.0278,4.03906 -2.0625,4.4375 0.50146,0.72607 2.95264,0.1228 3.90625,1.1875 1.3291,1.48413 1.86523,4.05615 2.875,5.71875 0.54444,0.89698 1.65283,1.30078 2.3125,2.09375 2.01416,2.42139 -0.4082,4.77832 -0.875,6.4375 -0.43847,1.55811 0.25977,2.95312 0.15625,4.4375 -0.25342,3.63331 -0.24805,4.17285 -2.75,6.96875 -0.89111,0.99609 -4.14209,3.00391 -5.5625,1.75 -0.68457,0.56543 -15.54834,24.71045 -18,28.53125 -9.98828,15.56494 -19.87842,31.18652 -29.96875,46.6875 -2.82373,4.33814 -6.02246,8.66699 -8.5,13.1875 22.5,0.0293 45.03467,0.0212 67.53125,-0.34375 15.53516,-16.48242 30.95996,-33.06591 46.3125,-49.71875 -0.01,-0.82617 -0.35987,-1.68848 -0.59375,-2.46875 -1.01074,-3.37305 4.94238,-4.71337 7.25,-3.4375 0.76709,0.42407 1.76368,1.20605 2.625,1.40625 2.02979,0.47168 4.53272,-0.78467 6.125,0 1.854,0.91357 3.41943,3.49756 5.0625,4.15625 1.33252,0.53394 2.37451,0.13672 3.59375,-0.25 0.72705,-0.23071 1.67236,2.8e-4 2.3125,-0.4375 0.0752,-0.0513 3.09082,-5.90258 3.1875,-6.25 0.47656,-1.71777 0.21337,-3.53833 0.65625,-5.15625 1.01758,-1.36548 3.32764,-1.92774 3.9375,-3.21875 0.51123,-1.08203 -0.54639,-2.4143 0.375,-4.65625 0.67432,-0.95752 1.92334,-0.43969 2.6875,-1.03125 1.55908,-1.20728 0.81103,-1.88037 1.5,-3.46875 l -0.15625,-2.0625 0.0937,-0.125 c -0.13631,-0.0706 -0.26846,-0.15148 -0.40625,-0.21875 0.0219,-0.33422 -0.44727,-0.89966 -0.8125,-1.3125 l -0.5625,-0.625 c -0.49853,-0.56861 -0.86328,-1.23706 -1.3125,-1.84375 -1.39892,-1.8899 -7.28613,-4.35278 -9.59375,-5.1875 -3.0498,-1.10351 -3.83057,-4.58179 -4.40625,-7.5 -0.28711,-1.4563 -2.44531,-4.5686 -3.1875,-5.71875 -3.81788,-5.91772 -4.02055,-6.05322 -4.03125,-12.53125 -0.003,-2.40552 -0.93896,-5.16479 -1.625,-7.4375 -0.35254,-1.16894 -0.95264,-2.28906 -1.4375,-3.4375 -1.42432,-3.37353 -0.23535,-2.70361 0.71875,-5.15625 1.49366,-3.83887 1.33496,-4.37598 1.0625,-8.125 -0.21191,-2.91626 2.12158,-1.47607 3.1875,-3.5 1.85058,-3.51514 -4.38965,-8.18604 -1.34375,-12.125 L 935.25,757 c 1.00488,-1.32813 1.1045,-1.99463 1.125,-3.625 0.0547,-4.24805 -1.48096,-3.87842 -2.78125,-5.5 0.41358,-2.71338 2.73295,-3.86865 2.71875,-7.0625 -0.008,-1.77539 0.74609,-3.33496 1,-5.0625 l 0.125,-0.9375 c 0.12598,-1.53027 -0.88184,-3.80713 0.53125,-4.9375 3.99756,-1.68311 8.9541,0.36914 12.65625,-2.46875 2.40039,-1.84082 5.11572,-4.4502 6.40625,-7.5 0.88525,-2.09155 1.28027,-2.37549 1.59375,-2.5625 4.64404,-2.76513 7.33301,-6.07666 10.15625,-10.75 1.29004,-2.13476 3.375,-9.31323 4.9375,-10.25 2.89551,-1.73633 3.21924,-3.53833 5.375,-5.96875 -0.0747,0.009 -0.24609,0.001 -0.4375,0.125 l 0.96875,-0.84375 c 0.47168,-1.69873 2.12451,-3.71753 3.03125,-5.28125 1.08496,-1.87134 1.78174,-4.11523 3.1875,-5.78125 3.28858,-3.89551 7.58838,-9.94189 9.9375,-14.625 1.13525,-2.26318 2.17285,-4.59351 3.5625,-6.71875 1.24365,0.0432 1.78715,-1.01855 1.00005,-2.09375 0.066,-0.49121 0.018,-0.97583 0,-1.46875 -0.024,-0.67944 0.4905,-1.26025 0.4374,-1.84375 L 1000.25,646 c 0.5967,-0.57324 0.5068,-1.71899 0.4688,-2.46875 -0.1237,-2.4375 -0.1646,-3.31909 -2.0938,-4.71875 -0.38086,-0.48194 -2.1709,-3.75439 -2.25,-4.125 -0.0698,-0.2212 -0.81738,-1.67627 -1.125,-2.375 l -0.375,-0.84375 0.0625,-0.0312 c 0.11231,-0.13916 0.28516,-0.30396 0.5625,-0.53125 l 0.40625,-0.34375 c 1.23828,-1.07031 1.5244,-2.10376 1.5625,-3.71875 0.0464,-1.99487 0.96045,-6.71265 1.4375,-8.6875 0.55468,-2.29443 2.68165,-3.2915 2.28125,-5.9375 0.083,-0.28222 0.096,-0.58862 0.031,-0.78125 -2.24093,-6.72046 -7.88286,-5.62158 -4.1563,-14.84375 2.82177,-6.9834 3.156,-13.05835 3.125,-20.34375 -0.021,-5.02514 0.081,-3.87939 3.1563,-8.71875 1.4447,-2.27295 1.3021,-5.14941 2.4374,-6.78125 0.1591,-0.14111 0.5587,-0.42212 1.125,-0.625 6.9258,-2.48096 4.0596,-0.78638 9.875,-7.25 2.6305,-2.92334 7.3773,-5.80615 7.2813,-10.125 -0.1133,-5.08106 -0.085,-2.09375 1.5625,-6.59375 1.4712,-4.01611 1.3538,-8.25195 2.8438,-12.3125 1.5643,-4.26416 1.4374,-4.83472 1.4374,-9.125 0,-4.33447 1.76,-8.28369 1.4376,-12.71875 -0.201,-2.75464 -1.6,-11.28711 -0.625,-13.4375 1.3737,-3.03393 3.0771,-2.5708 5.7187,-2.40625 4.4323,0.27709 6.8595,-6.40691 6.8437,-10 z",
						"CABA":"m 1064.8125,920.3125 -1.8125,0.75 c -1.1728,1.57715 -2.4951,5.07422 -1.9375,7.09375 l 3.9687,2.25 c 3.1368,-3.71875 3.4474,-1.12207 6.2188,-2.90625 l 0.6875,-1.03125 c -0.5551,-1.31983 -0.7791,-2.79847 -1.2187,-3.125 -0.9875,-0.73245 -2.4112,-0.21997 -3.4063,-0.71875 -0.5758,-0.28833 -0.3958,-0.7793 -0.7813,-1.09375 -0.3361,-0.27441 -0.959,-0.35693 -1.3437,-0.65625 -0.1825,-0.14222 -0.3001,-0.34674 -0.375,-0.5625 z"
					}
				}
			}
		}
	);
})(jQuery);
