/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.esupport.client.eservice;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ResourceHandler {
    protected Locale locale = null;
    protected ResourceBundle bundle = null;
    protected String bundleName = null;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.esupport.client.eservice.ResourceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public ResourceHandler() {
        this.setLocale(Locale.getDefault());
    }

    public ResourceHandler(String bundleName) {
        this.setBundleName(bundleName);
        this.setLocale(Locale.getDefault());
    }

    public ResourceHandler(Locale locale) {
        this.setLocale(locale);
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle(this.getBundleName(), this.getLocale());
            }
            catch (MissingResourceException e) {
                logger.error((Object)("Exception retrieving bundle: " + this.getBundleName() + " using locale: " + this.getLocale().toString()));
                logger.error((Object)"MissingResourceException", (Throwable)e);
            }
        }
        return this.bundle;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public String getMessage(String key) throws MissingResourceException {
        String temp = null;
        try {
            temp = this.getBundle().getString(key);
        }
        catch (MissingResourceException ex) {
            logger.error((Object)"Resource Exception: ", (Throwable)ex);
        }
        return temp;
    }

    public String getMessage(String key, Object[] arg) {
        String temp = null;
        try {
            temp = MessageFormat.format(this.getBundle().getString(key), arg);
        }
        catch (MissingResourceException ex) {
            logger.error((Object)"Resource Exception: ", (Throwable)ex);
        }
        return temp;
    }

    public String getMessage(String key, String arg1) {
        String temp = null;
        try {
            if (arg1 != null) {
                Object[] msgobj = new Object[]{arg1};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            logger.error((Object)"Resource Exception: ", (Throwable)ex);
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null) {
                Object[] msgobj = new Object[]{arg1, arg2};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            logger.error((Object)"Resource Exception: ", (Throwable)ex);
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            logger.error((Object)"Resource Exception: ", (Throwable)ex);
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3, String arg4) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null && arg4 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3, arg4};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            logger.error((Object)"Resource Exception: ", (Throwable)ex);
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3, String arg4, String arg5) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null && arg4 != null && arg5 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3, arg4, arg5};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            logger.error((Object)"Resource Exception: ", (Throwable)ex);
        }
        return temp;
    }

    public void setBundleName(String newBundleName) {
        this.bundleName = newBundleName;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

