/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWTRACE_H
#  define FCWTRACE_H

#if defined FCW_NT
#include <wtypes.h>

#elif defined FCW_AIX || defined FCW_HP
#include <fcntl.h>
#endif

/*-------------------------------------------------------------------------*/
/* TraceFile class                                                         */
/*-------------------------------------------------------------------------*/
class TraceFile
{
  public:

    TraceFile();
    ~TraceFile();

    TraceFile& operator << (const char);
    TraceFile& operator << (const char*);
    TraceFile& operator << (const long);
    TraceFile& operator << (const float);
    TraceFile& operator << (TraceFile& (*f)(TraceFile&));
    TraceFile& operator << (TraceFile& (*f)(TraceFile&, long));

    void       FormatDump  (const long len=0);
    void       SetAppName  ( char* name );               // *ODBC*

    friend TraceFile& hexT (TraceFile& tf);

    int                IsOn();                          // general trace *ODBC*
    int                OdbcOn();                        // internal ODBC trace

  private:

    enum             { prcTrace=1,  callTrace=2,  sqlTrace=4, fileTrace=8,
                       sysTrace=16, timeTrace=32, DsTrace=64, odbcTrace=128 };
    int      traceOption;                                // *ODBC*
    char     appName[9];                                 // *ODBC*

#if defined FCW_OS2
    FILELOCK    filelock;
    int         hFile;

#elif defined FCW_NT
    HANDLE       hFile;

#elif defined FCW_AIX || defined FCW_HP
    struct flock filelock;
    int         hFile;
#endif

    Bool         bOpen;
    Bool         bFileLock;

    Bool         bHexFormat;
    Bool         bDumpFormat;
    Bool         bWithinDump;
    int          DumpLen;

    void         Hold();
    void         Release();

    void        *pImpData;                         // implementation data
};

TraceFile& EXPORT endT (TraceFile& tf);

TraceFile& EXPORT hexT (TraceFile& tf);

TraceFile* EXPORT GetTraceFile();


/*-------------------------------------------------------------------------*/
/* File locking flags                                                      */
/*-------------------------------------------------------------------------*/
#define FILELOCK_ATOMIC 0x0000000000000002
#define FILELOCK_SHARE  0x0000000000000001

//extern int TRACEOPTIONS;
//extern TraceFile* PTRACEFILE;

//#define Trace *PTRACEFILE

/*-------------------------------------------------------------------------*/
/*  Define tracing options flags here...                                   */
/*-------------------------------------------------------------------------*/
//#define VGTRACE_XXX 0x00000000
//#define VGTRACE_YYY 0x00000001

//inline
//int isVgTraceOn()
//{
//  return TRACEOPTIONS;
//}

//inline
//int isVgTraceXXX()
//{
//  return TRACEOPTIONS & VGTRACE_XXX;
//}


#endif
