package com.ibm.vap.Transactions;

/**
 * The LinkCollectionShell signaller has the responsibility for handling events
 * for a LinkCollectionShell
 */

 import java.util.Vector;
 import java.util.Enumeration;

public class VapCollectionShellSignaller {
	protected VapCollectionShell shell;
	protected Vector listenerList = new Vector(5);
/**
 * VapCollectionShellSignaller constructor comment.
 * Store the backpointer to the collection we are the signaller for
 */
public VapCollectionShellSignaller(VapCollectionShell aShell) {
	shell = aShell;
}
/* Add the argument to our collection of action listeners */
public synchronized void addActionListener(VapActionListener listener){
	listenerList.addElement(listener);
}
/*
 * Notify all listeners that have registered interest for
 * notification on this event type.
 */
protected void fireActionPerformed(VapEvent event) {
	// Send all of our listeners this event
	Enumeration e = listenerList.elements();
	while (e.hasMoreElements()) 
		((VapActionListener)e.nextElement()).actionPerformed(event);
}
/**
 * This method was created in VisualAge.
 */
public VapCollectionShell getSource() {

	return shell;
}
/* Remove the argument from our collection of action listeners */
public synchronized void removeActionListener(VapActionListener listener){
	listenerList.removeElement(listener);
}
/**
 * This method was created in VisualAge.
 */
public void signalAddedItemsEvent(Vector objects, Vector indices) {

	Vector eventData = new Vector(2);
	eventData.addElement(objects);
	eventData.addElement(indices);
	fireActionPerformed(new VapTransactionalEvent(shell, "addedItems", eventData));
}
/**
 * This method was created in VisualAge.
 */
public void signalObjectChangedEvent(int index) {


	Integer eventData = new Integer(index);
	
	fireActionPerformed(new VapTransactionalEvent(shell, "objectChanged", eventData));
}
/**
 * This method was created in VisualAge.
 */
public void signalRefreshIndexEvent(Integer index) {

	Vector eventData = new Vector(1);
	eventData.addElement(index);
	fireActionPerformed(new VapEvent(shell, "refreshIndex", eventData));
}
/**
 * This method was created in VisualAge.
 */
public void signalRemovedItemsEvent(Vector objects, Vector indices) {

	Vector eventData = new Vector(2);
	eventData.addElement(objects);
	eventData.addElement(indices);
	fireActionPerformed(new VapTransactionalEvent(shell, "removedItems", eventData));
}
/**
 * This method was created in VisualAge.
 */
public void signalReplacedItemsEvent(Vector objects, Vector indices) {

	Vector eventData = new Vector(2);
	eventData.addElement(objects);
	eventData.addElement(indices);
	fireActionPerformed(new VapTransactionalEvent(shell, "replacedItems", eventData));
}
}