package com.ibm.vap.Transactions;

/**
 * The LinkCollectionShell signaller has the responsibility for handling events
 * for a LinkCollectionShell
 */

 import java.util.Vector;
 import java.util.Enumeration;

public class LinkCollectionShellSignaller extends VapCollectionShellSignaller {
	

/**
 * LinkCollectionShellSignaller constructor comment.
 * Store the backpointer to the linkCollectionShell we are the signaller for
 */
public LinkCollectionShellSignaller(LinkCollectionShell aShell) {
	super(aShell);
}
/**
 * This method was created in VisualAge.
 */
public void signalAddedItemsEvent(Vector objects, Vector indices, Transaction aTransaction) {

	Vector eventData = new Vector(2);
	eventData.addElement(objects);
	eventData.addElement(indices);
	fireActionPerformed(new VapTransactionalEvent(shell, aTransaction, "addedItems", eventData));
}
/**
 * This method was created in VisualAge.
 */
public void signalRemovedItemsEvent(Vector objects, Vector indices, Transaction aTransaction) {

	Vector eventData = new Vector(2);
	eventData.addElement(objects);
	eventData.addElement(indices);
	fireActionPerformed(new VapTransactionalEvent(shell, aTransaction, "removedItems", eventData));
}
}