package com.ibm.vap.Transactions;

/**
 * LinkCollectionShell
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */

import javax.ejb.EntityBean;
import javax.ejb.RemoveException;
import java.util.Vector;
import java.util.Enumeration;
import java.rmi.RemoteException;
import com.ibm.vap.common.VapAccessException;
import com.ibm.vap.common.Association;
import javax.ejb.EJBObject;
import javax.ejb.EJBHome;
import java.beans.PropertyChangeListener;

public class LinkCollectionShell extends AbstractPersistentCollection implements VapEJBObject, VapCollectionShell
{
	private ManyLink sourceLink;
	private BOManager bom;
	private LinkCollectionShellSignaller signaller = new LinkCollectionShellSignaller(this);
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * 
 */
LinkCollectionShell(ManyLink aLink)
{
	TransactionView view;
	VersionState state;
	Version version;
	EntityBean bean;

	this.setBom(new BOManager(this, aLink.getRelationship()));
	setSourceLink(aLink);
	bean = this.getInitialBean();

	state = aLink.getSource().getBom().getState().createNewInstance();
	((LinkCollection)bean).setHasQueried(state.isNew());

	view = Transaction.getCurrentView();
	version = view.createReadOnlyVersion();
	version.initialize(this, bean, state);
	try {view.addVersion (version);} catch (RemoteException e) {}
}
/**
 * The argument aVectorOfAssociation is a collection whose elements are 
 * associations whose key is aBusinessObject and whose value is the integer
 * index of the where the business object was added into.
 * We should collect these as two separate collections and signal them so 
 * any dependents can refresh themselves
 */
public void abtSignalAddsWithIndices(Vector aVectorOfAssociations, Transaction aTransaction) {

	Vector businessObjects, indices;
	Enumeration e;
	Association next;
	
	if ((aVectorOfAssociations != null) && (aVectorOfAssociations.size() != 0)) {
		businessObjects = new Vector(aVectorOfAssociations.size());
		indices = new Vector(aVectorOfAssociations.size());
		e = aVectorOfAssociations.elements();
		while (e.hasMoreElements()) {
			next = (Association) e.nextElement();
			businessObjects.addElement(next.key());
			indices.addElement(next.value());
		}
		this.signalAddedItemsEvent(businessObjects, indices, aTransaction);
	}
}
/**
 * The argument aVectorOfAssociation is a collection whose elements are 
 * associations whose key is aBusinessObject and whose value is the integer
 * index of the where the business object was added into.
 * We should collect these as two separate collections and signal them so 
 * any dependents can refresh themselves
 */
public void abtSignalRemovesWithIndices(Vector aVectorOfAssociations, Transaction aTransaction) {

	Vector businessObjects, indices;
	Enumeration e;
	Association next;
	
	if ((aVectorOfAssociations != null) && (aVectorOfAssociations.size() != 0)) {
		businessObjects = new Vector(aVectorOfAssociations.size());
		indices = new Vector(aVectorOfAssociations.size());
		e = aVectorOfAssociations.elements();
		while (e.hasMoreElements()) {
			next = (Association) e.nextElement();
			businessObjects.addElement(next.key());
			indices.addElement(next.value());
		}
		this.signalRemovedItemsEvent(businessObjects, indices, aTransaction);
	}
}
/* 
 * Forward this method to the signaller
 */
public synchronized void addActionListener(VapActionListener listener){
	signaller.addActionListener(listener);
}
/* 
 * Add ourself as a propertyChangeListener to anObject
 */
private void addAsPropertyChangeListenerTo(VapEJBObject anObject) throws RemoteException {

	if (anObject != null) 
		anObject.addPropertyChangeListener((PropertyChangeListener)this);
		
}
/**
 * Answer newObject having added newObject to the end of
 * receiver.
 */
public void addElement(EJBObject anEjbObject) throws RemoteException
{
	this.connectTo((VapEJBObject)anEjbObject);
	addAsPropertyChangeListenerTo((VapEJBObjectImpl) anEjbObject);
}
/**
 * PRIVATE - Answer a new rootlink after adding it to elements
 */
private RootLink addNewLink() throws RemoteException
{
	Version version;

	version = this.getBom().getUnmarkedVersionForUpdate();
	return((LinkCollection)version.getBean()).addNewLink();
}
/* 
 * Do nothing
 */
public void addPropertyChangeListener(PropertyChangeListener aListener) throws RemoteException {
	
}
/**
 * Test if the versions can be merged
 */
public boolean canMerge(Version aParentVersion, Version aChildVersion)
{
	return false;
}
/**
 * PRIVATE - for a many link, connecTo: means add to the collection.
 * Create a new RootLink and add it to myself. Direct the rootLink to 
 * connect to the BO
 */
public void connectTo(VapEJBObject anEjbObject) throws RemoteException
{
	Version version;
	LinkCollection linkCollection;
	RootLink link;

	version = this.getBom().getUnrealizedVersionForUpdate();
	version.markModified();
	linkCollection = (LinkCollection)version.getBean();

	if (linkCollection.indexOf(anEjbObject) < 0)
	{
		link = linkCollection.createLink();
		link.connectTo(anEjbObject);
		linkCollection.add(link);
	}
}
/**
 * Answer a Boolean which is true if aBO is equivalent to one of the
 *	 receiver's elements and false otherwise.
 */
public boolean contains(EJBObject anEjbObject) throws RemoteException
{
	EJBObject anElement;
	Enumeration links;
	
	links = this.getItems().getItems().elements();
	while (links.hasMoreElements())
	{
		anElement = (EJBObject)((RootLink)links.nextElement()).getValue();
		if (anElement == anEjbObject)
			return true;
	}

	return false;
}
/**
 * Copy the bean for a new version
 */
public EntityBean copyBean(EntityBean anOldBean) throws RemoteException
{
	return ((LinkCollection)anOldBean).createCopy();
}
/**
 * For a many link, to disconnect means to remove the object 
 * from the collection.  Direct the rootLink to disconnect
 * No error if not found
 */
public boolean disconnectFrom(VapEJBObject anEjbObject) throws RemoteException
{
	RootLink link;

	link = this.removeLinkFor(anEjbObject);
	if (link != null)
	{
		this.getBom().markModified();
		link.disconnectFrom(anEjbObject);
		return true;
	}

	return false;
}
/**
 * For a many link, to disconnect means to remove the object 
 * from the collection.  Direct the rootLink to disconnect
 * No error if not found
 */
public void disconnectFromRetrieved(VapEJBObject anEjbObject) throws RemoteException
{
	RootLink link;

	link = this.removeLinkFor(anEjbObject);
	if (link != null)
		link.disconnectFromRetrieved(anEjbObject);
}
/**
 * Answer the target of the element specified by index
 */
public Object elementAt(int index) throws RemoteException
{
	Object result;
	
	result = ((RootLink)this.getItems().elementAt(index)).getValue();
	if (!(result instanceof NullTarget)) {
		this.removeAsPropertyChangeListenerFrom((VapEJBObjectImpl) result);
		this.addAsPropertyChangeListenerTo((VapEJBObjectImpl) result);
	}

	return result;
}
/**
 * Returns an enumeration of the components of this PersistentCollection.
 *
 */
public Enumeration elements() throws RemoteException
{
	return new LinkCollectionShellEnumerator(this);
}
/**
 * This method is sent to all EjbObjects that have version data
 * that can be merged as part of a transaction commit.
 * Specializing this method allows one to do things like fire property change
 * events to notify any listeners of modified attributes
 */
public void firePropertyChanges(javax.ejb.EntityBean originalBean) throws java.rmi.RemoteException {
}
/**
 * 
 */
public Object firstElement() throws RemoteException
{
	return ((RootLink)this.getItems().firstElement()).getValue(); 
}
/**
 * This method was created by a SmartGuide.
 * @return COM.ibm.vap.Transactions.BOManager
 */
public BOManager getBom()
{
	return bom;
}
/**
 * getEJBHome method comment.
 */
public EJBHome getEJBHome() {
	//ERROR - Should never get here!!!
	throw new RuntimeException(); 	
}
/**
 * Answer object's handle
 */
public javax.ejb.Handle getHandle() throws RemoteException
{
	return null;
}
/**
 * Should be overridden by subclasses to return an appropriate initial
 * version data.   By default, the initial BO, acting as the BO shell, will
 * be returned.
 */
public EntityBean getInitialBean()
{
	return (EntityBean)new LinkCollection(this);
}
/**
 * 
 */
public LinkCollection getItems() throws RemoteException
{
	Version version;

	version = this.getBom().getVersionForRead();

	return (LinkCollection)version.getBean();
}
/**
 * 
 */
public Key getKey()
{
	return new TemporaryKey(this.getSourceLink().getSource());
}
/**
 * 
 */
public Key getKeyFor(EntityBean bean){
	return this.getKey(); 	
}
public Vector getLinksFor(EntityBean bean) {

	//ERROR - Should never get here!!!
	throw new RuntimeException(); 	
}
/**
 * 
 */
public Object getPrimaryKey()
{
	return (Object)this.getKey();
}
/**
 * 
 */
public Relationship getRelationship()
{
	return this.getSourceLink().getRelationship(); 
}
/**
 * Answer the source link
 */
public ManyLink getSourceLink()
{
	return sourceLink;
}
/**
 * 
 */
public int indexOf(VapEJBObject anEjbObject) throws RemoteException
{
	return this.getItems().indexOf(anEjbObject);
}
/**
 * 
 */
public boolean isConnected()
{
	if (this.getBom().hasVersion())
		try {
			return !this.getItems().primIsEmpty();}
		catch (RemoteException e) {}

	return false;
}
/**
 * isIdentical method comment.
 */
public boolean isIdentical(EJBObject anEjbObject) throws RemoteException
{
	return false; 
}
/**
 * BOs and NullTargets are not initial targets
 */
public boolean isInitialTarget()
{
	return false; 
}
/**
 * Answer true if I exists in the database.  So the only time
 * this would answer false would be that I am newly created and
 * not yet inserted to the database
 */
public boolean isPersistent()
{
	Version version;
	
	try
	{
		version = this.getBom().getVersionForRead();
		return ((version != null) && (version.isOld())); 
	}
	catch (RemoteException e) {}

	return false;
}
/**
 * 
 */
public Object lastElement() throws RemoteException
{
	return ((RootLink)this.getItems().lastElement()).getValue(); 
}
/**
 * Merge the parent version with the child version. The default behavior is to
 * copy the data from the child as is
 * Record the changes from the child versino that is merging into us and make sure that we signal the
 * collection changes ( the recorded adds and removes ) up to the UI.
 * For the removes we use the indicies that the parent transaction had and for adds we use the indices in the child version
 */
public void merge(Version aParentVersion, Version aChildVersion)
{
	LinkCollectionChanges oldParentChangedLinks, childLinks;
	LinkCollection parentCollection = null;
	Vector removeIndices, addIndices;
	CollectionChangesSignaller changesSignaller = null;

	oldParentChangedLinks = childLinks = null;
	removeIndices = addIndices = null;	
	
	parentCollection = (LinkCollection) aParentVersion.getBean();
	
	if (parentCollection != null)
		oldParentChangedLinks = (parentCollection.primChangedLinks());
	if (aChildVersion.getBean() != null)
		childLinks = ((LinkCollection)aChildVersion.getBean()).primChangedLinks();

	/*Find the index in the parent of all the removed items in the child.
	This is the parent link collection shell can broadcast the activity 
	with respect to adds and removes from its perspective, that is the items that
	were removed from it ( hence the parentVersion data ) and the items that were added to
	it ( hence the childVersion data ) */

	if (childLinks != null) {
		removeIndices = childLinks.removedIndicesForData(parentCollection);
		addIndices = childLinks.addedIndicesForData((LinkCollection)aChildVersion.getBean());
	}

	aParentVersion.setBean(aChildVersion.getBean());

	/* After the data is merged ( which is the whole LinkCollection ) we must merge the child
	links with the original parent links.  We must always remember our links ( with respect to
	add and remove ) because we may want to signal it to a parent of our later.  The signalling
	into the SharedVersion will clear out the links */

	if (parentCollection != null) {
		parentCollection.originalParentLinkChanges(oldParentChangedLinks);

		LinkCollectionShell aShell = (LinkCollectionShell) parentCollection.getShell()	;
		changesSignaller = new CollectionChangesSignaller(aShell, aParentVersion.getTransaction(), addIndices, removeIndices);
		
		aParentVersion.getView().getTransaction().addLinkCollectionDeferredSignaller(changesSignaller);
	}
}
/**
 * The argument has changed itself.
 * Tell the elements ( the link collection ) that the change has happened.
 * Be careful to not hydrate the collection if it is not already hydrated
 * We must tell the elements ( the link collection ) that the object has been modified
 */
public void modified(Object anObject) throws RemoteException {

	if (getItems().hasQueried())
		getItems().modified(anObject);
}
/**
* The Business Object is about to be written to the data store,
* write any required changed back down to the data object
 */
public void preStore()
{
}
/**
 * Method to handle events for the PropertyChangeListener interface.
 * @param evt java.beans.PropertyChangeEvent
 */

public void propertyChange(java.beans.PropertyChangeEvent evt) {

	try {
		int index = this.indexOf((VapEJBObject)evt.getSource());
		this.signalObjectChangedEvent(index);
	} catch (RemoteException e) { }
}
/**
 * Remove the object
 */
public void remove() throws RemoteException, RemoveException
{
	this.secondaryRemove();
}
/* 
 * Forward this method to the signaller
 */
public synchronized void removeActionListener(VapActionListener listener){
	signaller.removeActionListener(listener);
}
/* 
 * Remove ourself as a propertyChangeListener to anObject
 */
private void removeAsPropertyChangeListenerFrom(VapEJBObject anObject) throws RemoteException {

	if (anObject != null) 
		anObject.removePropertyChangeListener((PropertyChangeListener)this);
		
}
/* 
 * Remove ourself as a propertyChangeListener for all elements.
 * This method should only be called if the elements have already
 * been quiered to avoid hydrating.
 */
public void removeAsPropertyChangeListenerFromAll() {

	try {
		Enumeration e = elements();
		while (e.hasMoreElements()) {
			VapEJBObject next = (VapEJBObject) e.nextElement();
			this.removeAsPropertyChangeListenerFrom(next);
		}
	} catch (RemoteException ex) { }
		
}
/**
 * No error if not found
 * This differs from Smalltalk implementation in that it
 * answers true/false rather than a Bo/nil
 */
public boolean removeElement(EJBObject anEjbObject) throws RemoteException
{
	boolean result;
	
	result = this.disconnectFrom((VapEJBObject)anEjbObject);
	removeAsPropertyChangeListenerFrom((VapEJBObject)anEjbObject);
	return result;
}
/**
 * PRIVATE - Remove and answer the link connected to aBO.  If none exists
 * then answer nil
 */
private RootLink removeLinkFor(VapEJBObject aBo) throws RemoteException
{
	Version version;
	LinkCollection linkCollection;
	int i;

	version = this.getBom().getUnrealizedVersionForUpdate();
	linkCollection = (LinkCollection)version.getBean();

	if ((i = linkCollection.indexOf(aBo)) < 0)
		return null;
	else
		return (linkCollection.removeAtIndex(i));
}
/* 
 * Do nothing
 */
public void removePropertyChangeListener(PropertyChangeListener aListener) throws RemoteException {
	
}
/**
 * Create and add a new rootLink to myself.  Direct the rootlink
 * to connect to the BO.
 */
public void secondaryConnectTo(VapEJBObject anEjbObject) throws RemoteException
{
	Version version;
	LinkCollection linkCollection;
	RootLink link;

	version = this.getBom().getUnrealizedVersionForUpdate();
	version.markModified();
	linkCollection = (LinkCollection)version.getBean();

	if (linkCollection.indexOf(anEjbObject) < 0)
	{
		link = linkCollection.createLink();
		link.secondaryConnectTo(anEjbObject);
		linkCollection.add(link);
	}
}
/**
 * Create and add a new rootLink to myself.  Direct the rootlink
 * to connect to the BO.
 */
public void secondaryConnectToRetrieved(VapEJBObject anEjbObject) throws RemoteException
{
	Version version;
	LinkCollection linkCollection;
	RootLink link;

	version = this.getBom().getUnrealizedVersionForRead();
	linkCollection = (LinkCollection)version.getBean();

	if (linkCollection.indexOf(anEjbObject) < 0)
	{
		link = linkCollection.createLink();
		link.secondaryConnectTo(anEjbObject);
		linkCollection.add(link);
	}
}
/**
 * PRIVATE - No error if not found
 * For a many link, to disconnect means to remove the object 
 * from the collection.  Direct the rootLink to disconnect
 */
public void secondaryDisconnectFrom(VapEJBObject anEjbObject) throws RemoteException
{
	RootLink link;

	link = this.removeLinkFor(anEjbObject);
	if (link != null)
	{
		this.getBom().markModified();
		link.secondaryDisconnectFrom(anEjbObject);
	}
}
/**
 * PRIVATE - No error if not found
 * For a many link, to disconnect means to remove the object 
 * from the collection.  Direct the rootLink to disconnect
 */
public void secondaryDisconnectFromRetrieved(VapEJBObject anEjbObject) throws RemoteException
{
	RootLink link;

	link = this.removeLinkFor(anEjbObject);
	if (link != null)
		link.secondaryDisconnectFrom(anEjbObject);
}
/**
 * Remove the object 
 */
public void secondaryRemove() throws RemoteException, RemoveException
{
	this.getBom().markLocallyRemoved();
}
/**
* Set the business object manager
*/
public void setBom(BOManager aBom)
{
	bom = aBom;
}
/**
 * Set the source link
 */
public void setSourceLink(ManyLink aLink)
{
	sourceLink = aLink;
}
/**
 * Forward signal to the signaller
 */
public void signalAddedItemsEvent(Vector objects, Vector indices) {

	signaller.signalAddedItemsEvent(objects, indices);
}
/**
 * Forward signal to the signaller
 */
public void signalAddedItemsEvent(Vector objects, Vector indices, Transaction aTransaction) {

	signaller.signalAddedItemsEvent(objects, indices, aTransaction);
}
/**
 * Do nothing.
 * This is applicable for business objects that when they are modified need to 
 * inform any of their links that they were modified
 */
public void signalChangeAcrossLinks()
{
	
}
/**
 * Forward signal to the signaller
 */
public void signalObjectChangedEvent(int index) {

	signaller.signalObjectChangedEvent(index);
}
/**
 * Forward signal to the signaller
 */
public void signalRefreshIndexEvent(Integer index) {

	signaller.signalRefreshIndexEvent(index);
}
/**
 * Forward signal to the signaller
 */
public void signalRemovedItemsEvent(Vector objects, Vector indices) {

	signaller.signalRemovedItemsEvent(objects, indices);
}
/**
 * Forward signal to the signaller
 */
public void signalRemovedItemsEvent(Vector objects, Vector indices, Transaction aTransaction) {

	signaller.signalRemovedItemsEvent(objects, indices, aTransaction);
}
/**
 * Forward signal to the signaller
 */
public void signalReplacedItemsEvent(Vector objects, Vector indices) {

	signaller.signalReplacedItemsEvent(objects, indices);
}
}