package com.ibm.vap.Transactions;

/**
 * This type was created in VisualAge.
 */

 import java.util.Vector;
 import java.rmi.RemoteException;
 
public class LinkCollectionChanges {

	private CollectionAdd addedLinks;
	private CollectionRemove removedLinks;
/**
 * LinkCollectionChanges constructor comment.
 */
public LinkCollectionChanges() {
	super();
}
/**
 * Forward this to our added links
 */
public void added(Object anObject, LinkCollectionShell aShell) throws RemoteException {

	if (!getAddedLinks().includes(anObject))
		getAddedLinks().added(anObject, aShell);
	
}
/**
 * Forward this to our removed links
 */
public Vector addedIndicesForData(LinkCollection aLinkCollection) {

 	return (hasNoAddedLinks() == false) ? getAddedLinks().indicesForData(aLinkCollection) : new Vector();
	
}
/**
 * Forward this to our changed links.
 * Do not do any signalling if we have recorded the fact that the object has been removed
 */
public void changed(Object anObject, int index0, LinkCollectionShell aShell) {

	Vector objects, indices;
	
	if (!getRemovedLinks().includes(anObject)) {
		objects = new Vector(1);
		objects.addElement(anObject);
		Integer index = new Integer(index0);
		indices = new Vector(1);
		indices.addElement(index);
		aShell.signalReplacedItemsEvent(objects, indices);
		aShell.signalRefreshIndexEvent(index);
	}
}
/**
 * 
 */
public CollectionAdd getAddedLinks() {

	if (addedLinks == null)
		addedLinks = new CollectionAdd();
	return addedLinks;
	
}
/**
 * 
 */
public CollectionRemove getRemovedLinks() {

	if (removedLinks == null)
		removedLinks = new CollectionRemove();
	return removedLinks;
	
}
/**
 * 
 */
public boolean hasNoAddedLinks() {

	return (getAddedLinks().size() == 0);
	
}
/**
 * 
 */
public boolean hasNoRemovedLinks() {

	return (getRemovedLinks().size() == 0);
	
}
/**
 * Merge our recorded with changes with those of the argument
 */
public void merge(LinkCollectionChanges changes) {

 	this.mergeRemovedLinks(changes);
 	this.mergeAddedLinks(changes);
	
}
/**
 * Put any added links from the argument into our added links
 */
public void mergeAddedLinks(LinkCollectionChanges changes) {

 	if (hasNoAddedLinks() && (changes.hasNoAddedLinks()))
 		return ;

 	getAddedLinks().merge(changes.getAddedLinks());
	
}
/**
 * Put any removed links from the argument into our removed links
 */
public void mergeRemovedLinks(LinkCollectionChanges changes) {

 	if (hasNoRemovedLinks() && (changes.hasNoRemovedLinks()))
 		return ;

 	getRemovedLinks().merge(changes.getRemovedLinks());
	
}
/**
 * Forward this to our changed links
 */
public void modified(Object anObject, LinkCollectionShell aShell) throws RemoteException {

	if (!getRemovedLinks().includes(anObject)) {
		int i;
		i = aShell.indexOf((VapEJBObject)anObject);
		this.changed(anObject, i, aShell);
	}
}
/**
 * Forward this to our removed links.
 * Make sure that if we have recorded the object being added or changed
 * then remove it from these links
 */
public void removed(Object anObject, int index, LinkCollectionShell aShell) {

	getRemovedLinks().removed(anObject, index, aShell);
	getAddedLinks().remove(anObject);
	
}
/**
 * Forward this to our removed links
 */
public Vector removedIndicesForData(LinkCollection aLinkCollection) {
	
	if (aLinkCollection != null) {
	 	if (hasNoRemovedLinks() == false) 
		 	return getRemovedLinks().indicesForData(aLinkCollection);
	}
	return new Vector();
}
}