package com.ibm.ulc.vaedit;

import java.util.*;
import java.awt.*;

/**
 * This is the widget that is used when the display widget at 
 * edit time is not known.
 */
public class UlcUnknownWidget extends javax.swing.JLabel {
/**
 * UlcUnknownWidget constructor comment.
 */
public UlcUnknownWidget() {
	super("", CENTER);
	setBorder(new javax.swing.border.LineBorder(Color.cyan, 3));
	setForeground(null);
	setOpaque(true);
}
/**
 * UlcUnknownWidget set background. Just queue up a repaint so we see the change in color
 * without having to refresh on the smalltalk side.
 */
public void setBackground(Color c) {
	super.setBackground(c);
	repaint();
}
/**
 * UlcUnknownWidget set foreground. If set to null, use blue instead. We want UnknownWidget
 * to be default of blue.
 */
public void setForeground(Color c) {
	super.setForeground(c == null ? Color.blue : c);
	repaint();
}
}
