package com.ibm.ulc.util;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import java.io.*;

/**
 * An unbounded buffer. Taking an item from an empty buffer blocks the caller until it
 * is non-empty. Putting an item never blocks the caller.
 */
public class UnboundedBuffer implements Serializable {
	protected Vector fArray;
	/**
	 * Constructs an unbounded buffer with the given capacity.
	 */
	public UnboundedBuffer() {
		fArray= new Vector();
	}
	/**
	 * Length of queue.
	 */
	public synchronized
	int length() {
		return fArray.size();
	}
	/**
	 * Puts an object into the buffer with the given capacity.
	 */
	public synchronized
	void put(Object x) {
		Assert.isNotNull(x);

		fArray.addElement(x);

		notifyAll();
	}
	/**
	 * Takes an object from the queue. When empty the caller is blocked until it is non-empty or a timeout accured.
	 * @args timeout the maximum number of milliseconds to wait. A timeout of 0 means to wait undefinitely.
	 */
	public synchronized
	Object take(long timeout) {

		while (fArray.size() <= 0) {
			try {
				wait(timeout);
				if (timeout > 0 && fArray.size() <= 0)	// HACK: we have to assume that this was a timeout
					return null;
			} catch (InterruptedException e) {
				// We've been interrupted.  Make sure we're still interrupted.
				Thread.currentThread().interrupt();
			}
		}
		
		Object x= null;
		try {
			x= fArray.elementAt(0);
			fArray.removeElementAt(0);
		} catch (ArrayIndexOutOfBoundsException e) {
		}
		notifyAll();
		return x;
	}
}
