package com.ibm.ulc.util;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */
import java.util.Enumeration;
/**
 * Subclass of Hashtable to handle null values
 */
public class UlcHashtable extends java.util.Hashtable implements ITableRow {
	public static final String NULL = "-1";
/**
 * UlcHashtable constructor comment.
 */
public UlcHashtable() {
	super(17);
}
/**
 * UlcHashtable constructor comment.
 * @param arg1 int
 */
public UlcHashtable(int arg1) {
	super(arg1);
}
/**
 * UlcHashtable constructor comment.
 * @param arg1 int
 * @param arg2 float
 */
public UlcHashtable(int arg1, float arg2) {
	super(arg1, arg2);
}
public boolean contains(Object searchValue) {
	Object value = null;
	if (searchValue == null)
		value = NULL;
	else
		value = searchValue;
	return super.contains(value);
}
/**
 * Returns an enumeration of the values in this hashtable.
 * Use the Enumeration methods on the returned object to fetch the elements
 * sequentially.
 *
 * @return  an enumeration of the values in this hashtable.
 * @see     java.util.Enumeration
 * @see     java.util.Hashtable#keys()
 */
public Enumeration elements() {
	return new UlcHashtableEnumerator(this, false);
}
public Object get(Object key) {
	Object value = super.get(key);
	if (value == NULL)
		return null;
	return value;
}
public Object get(Object key, Object defaultAnswer) {
	if (!containsKey(key))
		return defaultAnswer;
	return get(key);
}
public Object getValueAt(String attributeName) {
	return get(attributeName);
}
/**
 * Returns an enumeration of the keys in this hashtable.
 *
 * @return  an enumeration of the keys in this hashtable.
 * @see     java.util.Enumeration
 * @see     java.util.Hashtable#elements()

 */
public Enumeration keys() {
	return new UlcHashtableEnumerator(this, true);
}
public Object put(Object key, Object value) {
	if (value == null)
		return super.put(key, NULL);
	else
		return super.put(key, value);
}
public void setValueAt(Object value, String attributeName) {
	put(attributeName, value);
}
public Enumeration superElements() {
	return super.elements();
}
public Enumeration superKeys() {
	return super.keys();
}
}
