package com.ibm.ulc.util;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.io.*;
import java.awt.Point;
public abstract class UlcConsole {
	static protected UlcConsole fgConsole = null;
	// should really use a PrintWriter but System.out still uses
	// the deprecated PrintStream ...
	static protected PrintStream fgOut = System.out;
	static public UlcConsole createConsole(String title, Point topLeft) {
		if (fgConsole == null) {
			Class cl = null;
			try {
				cl = Class.forName("com.ibm.ulc.ui.base.SwingConsole");
				if (cl == null)
					return null;
				fgConsole = (UlcConsole) cl.newInstance();
			} catch (ClassNotFoundException e) {
				return null;
			}
	        catch (InstantiationException e) {
	            return null;
	        }
	        catch (IllegalAccessException e) {
	            return null;
	        }
	        catch (ClassCastException e) {
	            return null;
	        }
			fgConsole.setTitle(title);
			fgConsole.setTopLeft(topLeft);
			if (fgConsole == null)
				return null;
			PrintStream writer = fgConsole.getWriter();
			if (writer == null)
				return null;
			fgOut = writer;
			System.setOut(fgOut);
			fgConsole.start();
		}
		return fgConsole;
	}
	static public UlcConsole getConsole() {
		return fgConsole;
	}
	static public PrintStream getOut() {
		return fgOut;
	}
	public abstract PrintStream getWriter();
	public abstract void setTitle(String title);
	public abstract void setTopLeft(Point topLeft);
	public abstract int start();
}
