package com.ibm.ulc.ui.lists;

import javax.swing.table.AbstractTableModel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;

public class UiTreeTableModelWrapper extends UiTableModelWrapper {
	JTree fTree;
	UiTreeModelWrapper fTreeModelWrapper;
/**
 * Add a listener to the list that's notified each time a change
 * to the data model occurs.
 * @param l the ListDataListener
 */
public UiTreeTableModelWrapper(UIHierarchicalItemList itemList) {
	super(itemList);
}
public int getRowCount() {
	if (fTree != null)
		return fTree.getRowCount();
	return 0;
}
public UiTreeModelWrapper getTreeModelWrapper() {
	return fTreeModelWrapper;
}
public Object getValueAt(int row, int column) {
	String colId = getColumnName(column);
	return fTreeModelWrapper.getValueAt(nodeForRow(row), colId);
}
/*
 * Answer the treeNode at the given row index
 */
protected int indexToOid(int index) {
	return nodeForRow(index).getId();
}
/**
 * Check if a node with the given id already exists.
 * If not, answer null.
 */
public UiDefaultMutableTreeNode locateNodeWithId(int nodeId) {
	return fTreeModelWrapper.locateNodeWithId(nodeId);
}
public void nodeCollapsed(TreeExpansionEvent event) {
	fireTableDataChanged();
}
protected void nodeExpanded(TreeExpansionEvent event) {
	fireTableDataChanged();
}
/*
 * Answer the treeNode at the given row index
 */
protected UiDefaultMutableTreeNode nodeForRow(int row) {
	TreePath treePath = fTree.getPathForRow(row);
	return (UiDefaultMutableTreeNode) treePath.getLastPathComponent();
}
/*
 * Answer the treeNode at the given row index
 */
protected int oidToIndex(int oid) {
	UiDefaultMutableTreeNode node = fTreeModelWrapper.locateNodeWithId(oid);
	if (node == null)
		
		// meaning the node is not visible in the receiver's widget
		return -1;
	else
		return rowForNode(node);
}
/*
 * Answer the current index for the given node
 */
protected int rowForNode(UiDefaultMutableTreeNode node) {
	return fTree.getRowForPath(new TreePath(node.getPath()));
}
public void setTree(JTree tree) {
	fTree = tree;
	tree.addTreeExpansionListener(new TreeExpansionListener() {
		// Don't use fireTableRowsInserted() here; 
		// the selection model would get  updated twice. 
		public void treeExpanded(TreeExpansionEvent event) {
			nodeExpanded(event);
		}
		public void treeCollapsed(TreeExpansionEvent event) {
			nodeCollapsed(event);
		}
	});
}
public void setTreeModelWrapper(UiTreeModelWrapper treeModelWrapper) {
	fTreeModelWrapper= treeModelWrapper;
}
public void setValueAt(Object value, int row, int column) {
	fTreeModelWrapper.setValueAt(value, nodeForRow(row), getColumnName(column), getNotificationPolicy());
}
}
