package com.ibm.ulc.ui.lists;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.util.EventObject;

/**
 * (c) Object Technology International 1997,1998,1999.
 *
 * This class is used for editing cells of a treeTable. It also
 * transfers mouse-clicks performed on the tree column of the table, 
 * onto the tree for expand-collapse processing etc.
 *
 */
public class UiTreeTableCellEditor extends UiCellEditor {
	protected UiTreeTableCellRenderer fTreeRenderer;
	protected boolean fShouldEditTreeCell;
/**
 * Construct a UiTreeTableCellEditor with the given tree as the
 * renderer of the treeTable.
 */
public UiTreeTableCellEditor(UiTreeTableCellRenderer tree) {
	super(new JTextField() {
		public boolean isManagingFocus() {
			return true;
		}
	});
	fTreeRenderer = tree;
}
/**
 * Pass on the given mouse event onto the underlying tree widget.
 * This is necessary because the tree needs to perform expand/collapse
 * etc. actions based on the mouse-clicks done on the tree column of the
 * treeTable.
 */
protected void dispatchEventToTable(MouseEvent me) {
	MouseEvent newME = new MouseEvent(
		fTreeRenderer, 
		me.getID(), 
		me.getWhen(), 
		me.getModifiers(), 
		me.getX() - fTable.getCellRect(0, fColumn, true).x, 
		me.getY(), 
		me.getClickCount(), 
		me.isPopupTrigger());
	fTreeRenderer.dispatchEvent(newME);
}
/**
 * Answer the component which will perform editing for the table, at the given location.
 * If the given cell ought to be edited, answer the receiver. If not, answer the tree, which
 * can perform the necessary actions.
 */
public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
	fTable = table;
	Object v = value;
	fRow = row;
	fColumn = column;
	String s = null;
	if ((fDocument != null) && ((s = getLastInput()) != null)) {
		v = s;
	}
	if (fShouldEditTreeCell)
		return super.getTableCellEditorComponent(table, value, isSelected, row, column);
	else
		return fTreeRenderer;
}
/**
 * Overridden to return false, and if the event is a mouse event
 * it is forwarded to the tree.<p>
 * The behavior for this is debatable, and should really be offered
 * as a property. By returning false, all keyboard actions are
 * implemented in terms of the table. By returning true, the
 * tree would get a chance to do something with the keyboard
 * events. For the most part this is ok. But for certain keys,
 * such as left/right, the tree will expand/collapse where as
 * the table focus should really move to a different column. Page
 * up/down should also be implemented in terms of the table.
 * By returning false this also has the added benefit that clicking
 * outside of the bounds of the tree node, but still in the tree
 * column will select the row, whereas if this returned true
 * that wouldn't be the case.
 * <p>By returning false we are also enforcing the policy that
 * the tree will never be editable (at least by a key sequence).
 */

public boolean isCellEditable(EventObject e) {
	boolean isMouseEvent = e instanceof MouseEvent;
	if (ulcIsCellEditable(-1, fColumn)) { //The given column has to be editable
		if ((e == null) //programmatically entering edit mode, or a <Space> pressed
			|| (isMouseEvent && ((MouseEvent) e).getClickCount() > 1)) { //double-click
			fShouldEditTreeCell = true;
			return true;
		}
	}
	if (isMouseEvent) {
		fShouldEditTreeCell = false;
		dispatchEventToTable((MouseEvent) e);
	}
	return false;
}
/**
 * Answer boolean whether the given cell of the treeTable
 * is editable.
 * This ulc-specific method is added (to the existing isCellEditable(..)
 * method, in order to distinguish two separate scenarios for the cell-
 * editable check. For example, it is possible to have a tree-column whose 
 * cells should not be edited, but this column itself has to be defined as 
 * editable in order that the tree receives mouse-clicks from the table.
 */
public boolean ulcIsCellEditable(int row, int column) {
	return (((UiJTreeTable) fTable).ulcIsCellEditable(row, column));
}
}
