package com.ibm.ulc.ui.lists;

import java.util.*;
import javax.swing.table.AbstractTableModel;
import javax.swing.JTree;
import javax.swing.tree.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import com.ibm.ulc.util.*;
import com.ibm.ulc.base.IDefaults;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.lists.UiTableModelWrapper;
import com.ibm.ulc.ui.lists.UiDefaultMutableTreeNode;

public class UiTreeModelWrapper extends DefaultTreeModel implements IItemListListener {
	public UiTreeTableModelWrapper fTableModelWrapper;
	protected UIHierarchicalItemList fItemList = null;
public UiTreeModelWrapper(UiDefaultMutableTreeNode root) {
	super(root);
}
public UiTreeModelWrapper(UIHierarchicalItemList itemList) {
	super(itemList.getRoot());
	setItemList(itemList);
}
/**
 * Ensure that the given parent has children at (and hence upto) the given
 * index. Insert dummy nodes if necessary to do so.
 */
protected Object ensureChildAt(UiDefaultMutableTreeNode parentNode, int index) {
	if (index < 0)
		return null;
	Object child = null;
	try {
		child = super.getChild(parentNode, index);
	} catch (ArrayIndexOutOfBoundsException e) {
		int startIndex = Math.min(index, parentNode.getChildCount());
		insertDummyNodesFor(parentNode, startIndex, index);
	}
	return child;
}
/**
 * This method is required as part of the TreeModel interface.
 * We use the childCount information known to each childNode, in order
 * to insert that many 'dummy' nodes into the respectice childNode. 
 */
public Object getChild(Object parent, int childIndex) {
	UiDefaultMutableTreeNode parentNode = (UiDefaultMutableTreeNode) parent;
	Object child = null;
	try {
		child = super.getChild(parentNode, childIndex);
	} catch (ArrayIndexOutOfBoundsException e) {
		int startIndex = Math.min(childIndex, parentNode.getChildCount());
		insertDummyNodesFor(parentNode, startIndex, parentNode.getExpectedChildCount());
		child = super.getChild(parentNode, childIndex);
	}
	return child;
}
/**
 * This method is required as part of the TreeModel interface.
 */
public int getChildCount(Object parent) {
	return ((UiDefaultMutableTreeNode) parent).getExpectedChildCount();
}
protected UiDefaultMutableTreeNode getRootNode() {
	return (UiDefaultMutableTreeNode) getRoot();
}
/**
 * Insert the method's description here.
 * Creation date: (11/15/99 2:56:14 PM)
 * @return com.ibm.ulc.ui.lists.UiTreeTableModelWrapper
 */
protected UiTreeTableModelWrapper getTableModelWrapper() {
	return fTableModelWrapper;
}
public Object getValueAt(UiDefaultMutableTreeNode node, String attributeName) {
	return fItemList.getValueAt(node, attributeName);
}
/**
 * For the given vector (ITreeNode elements),
 * insert the appropriate number of DummyNode objects into each element.
 */
protected void insertDummyNodesFor(UiDefaultMutableTreeNode parentNode, int startIndex, int stopIndex) {
	for (int i = startIndex; i < stopIndex; i++) {
		UiDefaultMutableTreeNode newNode = UiDefaultMutableTreeNode.newDummyNode(fItemList.getItemCache());
		parentNode.insert(newNode, i);
	}
}
/**
 * This method is required as part of the TreeModel interface.
 * Use the fChildCount state already available in each node,
 * to decide whether the node is a leaf or not.
 */
public boolean isLeaf(Object parent) {
	return ((ITreeChildHandler) parent).getExpectedChildCount() == 0;
}
/**
 * Check if a node with the given id already exists.
 * If not, answer null.
 */
public  UiDefaultMutableTreeNode locateNodeWithId(int nodeId) {
	return getRootNode().locateNodeWithId(nodeId);
}
public void nodesChanged(IRow[] changedRows, String[] attributeNames) {
	int[] tableIndices = new int[changedRows.length];
	for (int i = 0; i < changedRows.length; i++) {
		int oid = changedRows[i].getOid();
		nodeChanged(locateNodeWithId(oid));
		//int index = fTableModelWrapper.oidToIndex(oid);
		//fTableModelWrapper.notify(IDefaults.TABLE_MODEL_CELL_CHANGED, new String[0], index, index);
		//fTableModelWrapper.notify(IDefaults.TABLE_MODEL_ROWS_CHANGED, new String[0], index, index);
	}
}
/**
  * Invoke this method after you've inserted some TreeNodes into
  * node.  childIndices should be the index of the new elements and
  * must be sorted in ascending order.
  */
public void nodesWereInserted(TreeNode node, int[] childIndices) {
	super.nodesWereInserted(node, childIndices);
	for (int i = 0; i < childIndices.length; i++) {
		UiDefaultMutableTreeNode child = (UiDefaultMutableTreeNode) getChild(node, childIndices[i]);
		int tableIndex = fTableModelWrapper.oidToIndex(child.getId());
		if (tableIndex > -1) //visible node
			fTableModelWrapper.notify(IDefaults.TABLE_MODEL_ROWS_ADDED, new String[0], tableIndex, tableIndex);
	}
	int index = fTableModelWrapper.oidToIndex(((UiDefaultMutableTreeNode) node).getId());
	fTableModelWrapper.notify(IDefaults.TABLE_MODEL_ROWS_CHANGED, new String[0], index, index);
}
public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
	super.nodesWereRemoved(node, childIndices, removedChildren);
	for (int i = 0; i < removedChildren.length; i++) {
		UiDefaultMutableTreeNode child = (UiDefaultMutableTreeNode) removedChildren[i];
		if (child.isValidNode()) {
			int tableIndex = fTableModelWrapper.oidToIndex(child.getId());
			//if (tableIndex > -1)	//node visible
			fTableModelWrapper.notify(IDefaults.TABLE_MODEL_ROWS_REMOVED, new String[0], tableIndex, tableIndex);
		}
	}
	int index = fTableModelWrapper.oidToIndex(((UiDefaultMutableTreeNode) node).getId());
	fTableModelWrapper.notify(IDefaults.TABLE_MODEL_ROWS_CHANGED, new String[0], index, index);
}
protected void notify(int type, String[] attributeNames, int[] oids) {
	int[] tableIndices = new int[oids.length];
	for (int i = 0; i < oids.length; i++) {
		int index = fTableModelWrapper.oidToIndex(oids[i]);
		if (index > -1)
			tableIndices[i] = index;
	}
	Vector ranges = com.ibm.ulc.util.UlcRange.createFromIntArray(tableIndices);
	for (int i = 0; i < ranges.size(); i++) {
		UlcRange range = (UlcRange) ranges.elementAt(i);
		fTableModelWrapper.notify(type, attributeNames, range.fStartIndex, range.fEndIndex);
	}
}
public void notify(int type, String[] attributeNames, int start, int end) {
	System.out.println("NewUiTreeModelWrapper.notify: " + type + ", " + attributeNames + ", " + start + ", " + end);
}
/**
 * Implement this method to satisfy the abstract implementation of the receiver's superclass.
 * this message should never be sent to the receiver
 */
protected void setItemList(UIHierarchicalItemList itemList) {
	//LATER add listeners...
	if (fItemList != null)
		fItemList.removeTreeModel(this);
	fItemList = itemList;
	if (fItemList != null)
		fItemList.addTreeModel(this);
}
public void setTableModelWrapper(UiTableModelWrapper tmw) {
	fTableModelWrapper = (UiTreeTableModelWrapper) tmw;
}
/**
 * Insert the method's description here.
 * Creation date: (11/15/99 2:56:14 PM)
 * @param newTableModelWrapper com.ibm.ulc.ui.lists.UiTreeTableModelWrapper
 */
protected void setTableModelWrapper(UiTreeTableModelWrapper newTableModelWrapper) {
	fTableModelWrapper = newTableModelWrapper;
}
public void setValueAt(Object value, UiDefaultMutableTreeNode node, String attributeName, int notificationPolicy) {
	fItemList.setValueAt(attributeName, value, node, notificationPolicy);
	//nodeChanged(node);
}
}
