package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import javax.swing.*;
import javax.swing.event.ListDataListener;
import com.ibm.ulc.base.*;
import com.ibm.ulc.ui.base.*;

/**
 * Adapter
 */

class UiListModelWrapper extends AbstractListModel implements IDefaults, IItemListListener {
	private UIItemList fItemList = null;
	private String fAttributeName = null;
/**
 * Add a listener to the list that's notified each time a change
 * to the data model occurs.
 * @param l the ListDataListener
 */
public UiListModelWrapper(UIItemList itemList, String attributeName) {
	fAttributeName = attributeName;
	setItemList(itemList);
}
/**
 * Implement this method to satisfy the abstract implementation of the receiver's superclass.
 * this message should never be sent to the receiver
 */
public void free() {
}
/**
 * Implement this method to satisfy the abstract implementation of the receiver's superclass.
 * this message should never be sent to the receiver
 */
protected String getAttributeName() {
	return fAttributeName;
}
/**
 * Implement this method to satisfy the abstract implementation of the receiver's superclass.
 * this message should never be sent to the receiver
 */
public Object getElementAt(int rowIndex) {
	Object answer = getItemList().getValueAt(rowIndex, fAttributeName);
	if (answer == null)
		return "";
	else
		return answer;
}
/**
 * Answer the receiver's current itemList.
 *
 * The receiver's <code>UIItemList</code> is responsible for the order in which
 * the receiver's rows are displayed.
 *
 * @see UIItemList
 *
 */
protected UIItemList getItemList() {
	return fItemList;
}
/**
 * Implement this method to satisfy the abstract implementation of the receiver's superclass.
 * this message should never be sent to the receiver
 */
public int getSize() {
	return getItemList().getSize();
}
// ITableModelListener interface
public void notify(int type, String[] attributeNames, int start, int end) {
	switch (type) {
		case TABLE_MODEL_CELL_CHANGED :
		case TABLE_MODEL_CONTENTS_CHANGED :
		case TABLE_MODEL_ROWS_CHANGED :
			fireContentsChanged(this, start, end);
			break;
		case TABLE_MODEL_ROWS_ADDED :
			fireIntervalAdded(this, start, end);
			break;
		case TABLE_MODEL_ROWS_REMOVED :
		case 99 : //TABLE_MODEL_CONTENTS_CLEARED
			fireIntervalRemoved(this, start, end);
			break;
	}
}
/**
 * Implement this method to satisfy the abstract implementation of the receiver's superclass.
 * this message should never be sent to the receiver
 */
protected void setItemList(UIItemList itemList) {
	if (fItemList != null)
		fItemList.removeListener(this);
	fItemList = itemList;
	fItemList.addModelListener(this);
}
}
