package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.base.IDefaults;
import com.ibm.ulc.comm.ORBConnection;
public class UiJTable extends JTable implements com.ibm.ulc.base.IDefaults, IItemListListener, IJTable {
	protected UITable fList = null;
	// This class is needed to ignore the selections when the JTable is disabled
	// Sun bugid: 4220171 supposedly fixed in the JDK1.3 Kestrel release
	private class ImmutableSelectionModel extends DefaultListSelectionModel {
		public void clearSelection() {
			if (isEnabled())
				super.clearSelection();
		}
		public void addSelectionInterval(int a, int b) {
			if (isEnabled())
				super.addSelectionInterval(a, b);
		}
		public void insertIndexInterval(int a, int b, boolean before) {
			if (isEnabled())
				super.insertIndexInterval(a, b, before);
		}
		public void removeIndexInterval(int a, int b) {
			if (isEnabled())
				super.removeIndexInterval(a, b);
		}
		public void setSelectionInterval(int a, int b) {
			if (isEnabled())
				super.setSelectionInterval(a, b);
		}
		public void setAnchorSelectionIndex(int a) {
			if (isEnabled())
				super.setAnchorSelectionIndex(a);
		}
		public void setLeadSelectionIndex(int a) {
			if (isEnabled())
				super.setLeadSelectionIndex(a);
		}
	}
UiJTable(AbstractTableModel model, UITable list) {
	super(model);
	//model.addItemListListener(this);
	registerKeyboardActions();
	fList = list;
}
/**
 * Returns the default selection model object which is
 * a DefaultListSelectionModel.  Subclass can override this
 * method to return a different selection model object.
 *
 * @return the default selection model object
 */
protected ListSelectionModel createDefaultSelectionModel() {
	return new ImmutableSelectionModel();
}
	/**
	 * Returns the default table header object which is
	 * a JTableHeader.  Subclass can override this
	 * method to return a different table header object
	 *
	 * @return the default table header object
	 */
	protected JTableHeader createDefaultTableHeader() {
		return new UiJTableHeader(columnModel);
	}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
/**
 * Register the keyboard actions. 
 * Creation date: (20/10/1999 11:36:09)
 */
static Object[] editingKeyStrokesAndActionsFor(UICellEditorKeyPolicy aPolicy) {

	final UICellEditorKeyPolicy policy= aPolicy;
	
	// These are the actions we want to assign to key strokes
	//
	AbstractAction alDown = new AbstractAction() {
		  	public void actionPerformed(ActionEvent e) {
				UiJTable table = policy.getTableComponent();
				int row = Math.max(table.getEditingRow(),0);
				int numRows = table.getRowCount();
				int col = Math.max(table.getEditingColumn(),0);
				int numCols = table.getColumnCount();
			  	policy.editCellAtPoint(policy.nextEditPointDown(row,numRows,col,numCols));
		  	}
	  	};
	AbstractAction alUp = new AbstractAction() {
		  	public void actionPerformed(ActionEvent e) {
				UiJTable table = policy.getTableComponent();
				int row = Math.max(table.getEditingRow(),0);
				int numRows = table.getRowCount();
				int col = Math.max(table.getEditingColumn(),0);
				int numCols = table.getColumnCount();
			  	policy.editCellAtPoint(policy.nextEditPointUp(row,numRows,col,numCols));
		  	}
	  	};
	AbstractAction alRight= new AbstractAction() {
		  	public void actionPerformed(ActionEvent e) {
				UiJTable table = policy.getTableComponent();
				int row = Math.max(table.getEditingRow(),0);
				int numRows = table.getRowCount();
				int col = Math.max(table.getEditingColumn(),0);
				int numCols = table.getColumnCount();
			  	policy.editCellAtPoint(policy.nextEditPointRight(row,numRows,col,numCols));
		  	}
	  	};
	AbstractAction alLeft = new AbstractAction() {
		  	public void actionPerformed(ActionEvent e) {
				UiJTable table = policy.getTableComponent();
				int row = Math.max(table.getEditingRow(),0);
				int numRows = table.getRowCount();
				int col = Math.max(table.getEditingColumn(),0);
				int numCols = table.getColumnCount();
			  	policy.editCellAtPoint(policy.nextEditPointLeft(row,numRows,col,numCols));
		  	}
	  	};

	// These are the key strokes we want to bind
	//
	KeyStroke enter = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, false);
	KeyStroke shEnter = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, InputEvent.SHIFT_MASK, false);
	KeyStroke tab = KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0, false);
	KeyStroke shTab = KeyStroke.getKeyStroke(KeyEvent.VK_TAB, InputEvent.SHIFT_MASK, false);
	
	// The condition, under which the action is to be performed
	int condition = JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT;

	// And now comes the registration
	//
	Object[] keyStrokesAndActions= new Object[8];
	keyStrokesAndActions[0]= enter;
	keyStrokesAndActions[1]= alDown;
	keyStrokesAndActions[2]= shEnter;
	keyStrokesAndActions[3]= alUp;
	keyStrokesAndActions[4]= tab;
	keyStrokesAndActions[5]= alRight;
	keyStrokesAndActions[6]= shTab;
	keyStrokesAndActions[7]= alLeft;
	return keyStrokesAndActions;
}
public void ensureIndexIsVisible(int index) {
	if (index < 0)
		return;
	Rectangle r = getCellRect(index, 0, false); // left most cell in row
	scrollRectToVisible(r);
}
public void free() {
	setVisible(false);
	setCellSelectionEnabled(false);
	setColumnSelectionAllowed(false);
	setRowSelectionAllowed(false);
	setTableHeader(null);
	//		setSelectionModel(null);
	setCellEditor(null);
	setUI(null);
}
public ORBConnection getConnection() {
	return fList.getConnection();
}
public int getPreferredHeight() {
	return getPreferredScrollableViewportSize().height;
}
public int[] getSelectedIndices() {
	return getSelectedRows();
}
public UIColumn getUiColumnFor(int column) {
	int index = convertColumnIndexToModel(column);
	return ((UiTableModelWrapper) getModel()).getUiColumn(index);
}
private boolean isCurrentSelection(int[] indices) {
	int[] currentSelection = getSelectedIndices();
	if (currentSelection.length != indices.length)
		return false;
	for (int i = 0; i < indices.length; i++) {
		boolean contained = false;
		for (int j = 0; j < currentSelection.length; j++) {
			if (contained || indices[i] == currentSelection[j])
				contained = true;
		}
		if (!contained)
			return false;
	}
	return true;
}
// IItemListListener interface
public void notify(int type, String[] attributeNames, int start, int end) {
	switch (type) {
		case TABLE_MODEL_CONTENTS_CHANGED :
			notifyCellEditorRowsRemoved(attributeNames, -1, -1);
			validate();
			repaint();
			break;
		case TABLE_MODEL_ROWS_CHANGED :
			notifyCellEditorRowsRemoved(attributeNames, start, end);
		case TABLE_MODEL_CELL_CHANGED :
			//invalidate();
			validate();
			repaint();
			break;
		case TABLE_MODEL_ROWS_ADDED :
			//int[] listSelection = fList.getSelectedIndices();
			//if (listSelection.length > 0) {
			//	boolean before = listSelection[0] >= start;
			//	getSelectionModel().insertIndexInterval(start, (end - start + 1), before);
			//}
			validate();
			repaint();
			break;
		case 99 : //TABLE_MODEL_CONTENTS_CLEARED
		case TABLE_MODEL_ROWS_REMOVED :
			notifyCellEditorRowsRemoved(attributeNames, start, end);
			validate();
			repaint();
			break;
	};
}
private void notifyCellEditorRowsRemoved(String[] attributeNames, int start, int end) {
	TableColumnModel cm = getColumnModel();
	for (int i = 0; i < cm.getColumnCount(); i++) {
		TableColumn col = cm.getColumn(i);
		if (col != null) {
			TableCellEditor cellEditor = col.getCellEditor();
			if ((cellEditor != null) && (cellEditor instanceof UiCellEditor)) {
				((UiCellEditor) cellEditor).rowsRemoved(start, end);
			}
		}
	}
}
public void paint(Graphics g) {
	fList.getItemList().startRequest();
	super.paint(g);
	fList.getItemList().stopRequest();
}
/**
 * Over-ridden in order that the UITable knows which cell is
 * being edited right now. No 'startEditing' event comes frm
 * the editor, unfortunately. And cannot use the setEditingRow(aRow)
 * method since that is called with (-1) parameters unexpectedly...
 */
public Component prepareEditor(TableCellEditor editor, int row, int column) {
	fList.getItemList().setRowToBeEdited(row);
	Object value = getValueAt(row, column);
	if (value instanceof UILabel)
		value = ((UILabel) value).getText();
	boolean isSelected = isCellSelected(row, column);
	Component comp = editor.getTableCellEditorComponent(this, value, isSelected, row, column);
	if ((comp != null) && (comp.getFont() == null)) {
		comp.setFont(getFont());
	}
	return comp;
}
/**
 * Register the keyboard actions. 
 * Creation date: (20/10/1999 11:36:09)
 */
protected void registerKeyboardActions() {

	// The condition, under which the action is to be performed
	int condition = JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT;

	final UICellEditorKeyPolicy policy= new UICellEditorClosedSpiralsKeyPolicy(this);
	Object[] keyStrokesAndActions= editingKeyStrokesAndActionsFor(policy);

	for (int i = 0 ; i <= keyStrokesAndActions.length-2 ; i+=2) {
		KeyStroke ks= (KeyStroke) keyStrokesAndActions[i];
		ActionListener al= (ActionListener) keyStrokesAndActions[i+1];
		registerKeyboardAction(al,ks,condition);
	}
}
public void requestString(int rowIndex, int columnIndex) {
	requestValue(rowIndex, getColumnName(columnIndex));
}
public Object requestValue(int row, String colId) {
	if (fList != null)
		return fList.getItemList().getValueAt(row, colId);
	else
		return null;
}
public void setAutoResize(int ar) {
	int autoResize;
	switch (ar) {
		case TABLE_AUTO_RESIZE_OFF :
			autoResize = AUTO_RESIZE_OFF;
			break;
		case TABLE_AUTO_RESIZE_LAST_COLUMN :
			autoResize = AUTO_RESIZE_LAST_COLUMN;
			break;
		case TABLE_AUTO_RESIZE_ALL_COLUMNS :
			autoResize = AUTO_RESIZE_ALL_COLUMNS;
			break;
		default :
			autoResize = AUTO_RESIZE_OFF;
			break;
	}
	super.setAutoResizeMode(autoResize);
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	int count = getColumnCount();
	for (int index = 0; index < count; index++) {
		UiTableColumn targetCol = (UiTableColumn) getColumnModel().getColumn(index);
		UIColumn c = targetCol.getUIColumn();
		c.setEnabled(state);
	}
	super.setEnabled(state);
	repaint();
}
public void setFont(Font font) {
	int count = getColumnCount();
	if (getTableHeader() != null)
		getTableHeader().setFont(font);
	for (int index = 0; index < count; index++) {
		UiTableColumn targetCol = (UiTableColumn) getColumnModel().getColumn(index);
		UIColumn c = targetCol.getUIColumn();
		c.setFont(font);
	}
	super.setFont(font);
	repaint();
}
public void setSelectionInvervals(int[][] intervals, int[] indices) {
	if (isCurrentSelection(indices))
		return;
	super.clearSelection(); // clear out everything first.
	if (intervals.length == 0)
		return;
	if (getSelectionModel().getSelectionMode() == getSelectionModel().SINGLE_INTERVAL_SELECTION) {
		int[] interval = intervals[intervals.length - 1];
		setRowSelectionInterval(interval[0], interval[1]);
		ensureIndexIsVisible(interval[1]);
	}
	else {
		if (getSelectionModel().getSelectionMode() == getSelectionModel().SINGLE_SELECTION) {
			int[] interval = intervals[intervals.length - 1];
			setRowSelectionInterval(interval[1], interval[1]);
			ensureIndexIsVisible(interval[1]);
		}
		else {
			for (int i = 0; i < intervals.length; i++) {
				int[] interval = intervals[i];
				if (i == 0) {
					setRowSelectionInterval(interval[0], interval[1]);
				}
				else {
					addRowSelectionInterval(interval[0], interval[1]);
				}
			}
			ensureIndexIsVisible(intervals[0][0]);
		}
	}
	validate();
	repaint();
}
public void setSelectionMode(int mode) {
	if (getSelectionModel() != null) {
		if (mode != -1) {
			if (getSelectionModel().getSelectionMode() != mode) {
				getSelectionModel().setSelectionMode(mode);
				super.clearSelection();
			}
		}
		else {
			setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		}
	}
}
public void setVisibleRowCount(int count) {
}
public boolean ulcIsCellEditable(int row, int column) {
	return isCellEditable(row, column);
}
public void updateUI() {
	super.updateUI();
	setUI(UiJBasicTableUI.createUI(this));
	resizeAndRepaint();
	invalidate();
	// Update the UIs of the cell renderers, cell editors and header renderers.

	TableColumnModel cm = getColumnModel();
	for (int column = 0; column < cm.getColumnCount(); column++) {
		TableColumn aColumn = cm.getColumn(column);
		TableCellRenderer cell = aColumn.getHeaderRenderer();
		if (cell instanceof UiJDefaultTableCellRenderer)
			 ((UiJDefaultTableCellRenderer) cell).updateUI();
		cell = aColumn.getCellRenderer();
		if (cell instanceof UiTableCellRenderer)
			 ((UiTableCellRenderer) cell).updateUI();
	}
}
public void valueChanged(javax.swing.event.ListSelectionEvent e) {
	super.valueChanged(e);
	if (getSelectedRows().length > 0)
		fList.selectionChanged("select");
}
}
