package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import javax.swing.event.ListDataListener;
import javax.swing.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.base.IDefaults;
public class UiJList extends JList implements IJList, IItemListListener, IDefaults {
	protected UIAbstractList fList = null;
	private boolean fSettingCellRenderer = false;
UiJList(AbstractListModel model, UIList list) {
	super(model);
	//model.addItemListListener(this);
	fList = list;
}
// IItemListListener interface
public void clearSelection() {
	super.clearSelection();
	validate();
	repaint();
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
/**
 * If this JList is being displayed within a JViewport and the
 * specified cell isn't completely visible, scroll the viewport.
 *
 * @param an int -- the index of the cell to make visible
 * @see JComponent#scrollRectToVisible
 * @see #getVisibleRect
 */
public void ensureIndexIsVisible(int index) {
	super.ensureIndexIsVisible(index);
}
public int getPreferredHeight() {
	return getPreferredScrollableViewportSize().height;
}
private boolean isCurrentSelection(int[] indices) {
	int[] currentSelection = getSelectedIndices();
	if (currentSelection.length != indices.length)
		return false;
	for (int i = 0; i < indices.length; i++) {
		boolean contained = false;
		for (int j = 0; j < currentSelection.length; j++) {
			if (contained || indices[i] == currentSelection[j])
				contained = true;
		}
		if (!contained)
			return false;
	}
	return true;
}
// IItemListListener interface
public void notify(int type, String[] attributeNames, int start, int end) {
	switch (type) {
		case TABLE_MODEL_CONTENTS_CHANGED :
		case TABLE_MODEL_ROWS_CHANGED :
		case TABLE_MODEL_CELL_CHANGED :
			validate();
			repaint();
			break;
		case TABLE_MODEL_ROWS_ADDED :
			//int[] listSelection = fList.getSelectedIndices();
			//if (listSelection.length > 0) {
			//	boolean before = listSelection[0] >= start;
			//	getSelectionModel().insertIndexInterval(start, (end - start + 1), before);
			//}
			//validate();
			//repaint();
			break;
		case TABLE_MODEL_ROWS_REMOVED :
			//getSelectionModel().removeIndexInterval(start, end);
			//fList.selectionChanged("action");
			break;
		case 99 : //TABLE_MODEL_CONTENTS_CLEARED
			//clearSelection();
	}
}
public void paint(Graphics g) {
	fList.getItemList().startRequest();
	super.paint(g);
	fList.getItemList().stopRequest();
}
public void processKeyEvent(KeyEvent e) {
	super.processKeyEvent(e);
	int code = e.getKeyCode();
	if (code == KeyEvent.VK_DOWN || code == KeyEvent.VK_UP) {
		fList.selectionChanged("select");
	}
}
public Object requestValue(int row, String colId) {
	if (fSettingCellRenderer) {
		return "Index 1234567890";
	}
	if (fList != null)
		return fList.getItemList().getValueAt(row, colId);
	else
		return null;
}
public void setCellRenderer(ListCellRenderer cellRenderer) {
	fSettingCellRenderer = true;
	super.setCellRenderer(cellRenderer);
	fSettingCellRenderer = false;
}
public void setRowHeight(int height) {
	if (height >= 1) {
		setFixedCellHeight(height);
		repaint();
	}
}
public void setSelectionInvervals(int[][] intervals, int[] indices) {
	if (isCurrentSelection(indices))
		return;
	super.clearSelection(); // clear out everything first.
	if (intervals.length == 0)
		return;
	if (getSelectionMode() == getSelectionModel().SINGLE_INTERVAL_SELECTION) {
		int[] interval = intervals[intervals.length - 1];
		setSelectionInterval(interval[0], interval[1]);
		ensureIndexIsVisible(interval[1]);
	}
	else {
		if (getSelectionMode() == getSelectionModel().SINGLE_SELECTION) {
			int[] interval = intervals[intervals.length - 1];
			setSelectionInterval(interval[1], interval[1]);
			ensureIndexIsVisible(interval[1]);
		}
		else {
			for (int i = 0; i < intervals.length; i++) {
				int[] interval = intervals[i];
				if (i == 0) {
					setSelectionInterval(interval[0], interval[1]);
				}
				else {
					addSelectionInterval(interval[0], interval[1]);
				}
			}
			ensureIndexIsVisible(intervals[0][0]);
		}
	}
	validate();
	repaint();
}
public void setSelectionMode(int mode) {
	if (getSelectionModel() != null) {
		if (mode != -1) {
			if (getSelectionMode() != mode) {
				getSelectionModel().setSelectionMode(mode);
				super.clearSelection();
			}
		}
		else {
			setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		}
	}
}
}
