package com.ibm.ulc.ui.lists;

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class UiJContainerIconUI extends javax.swing.plaf.basic.BasicLabelUI {
	private final static UiJContainerIconUI fContainerIconUI = new UiJContainerIconUI();
	private static Rectangle paintIconR = new Rectangle();
	private static Rectangle paintTextR = new Rectangle();
	private static Rectangle paintViewR = new Rectangle();
	private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
/**
 * This class implements the UI LAF for the
 * UiJContainerIcon widget.
 *
 * It adds visual feedback if the icon is selected
 * i.e. the text is highlighted using the system
 * caption colors and the selected icon of the
 * widget is displayed (if the component is enabled). 
 */
public UiJContainerIconUI() {
}
// ********************************
//        Create PLAF 
// ********************************
public static ComponentUI createUI(JComponent b) {
	return fContainerIconUI;
}
	/** 
	 * Paint the label text in the foreground color, if the label
	 * is opaque then paint the entire background with the background
	 * color.  The Label text is drawn by paintEnabledText() or
	 * paintDisabledText().  The locations of the label parts are computed
	 * by layoutCL.
	 *
	 * The difference between this and the super method is that the
	 * selected icon is used if the widget is selected and enabled.
	 * 
	 * @see #paintEnabledText
	 * @see #paintDisabledText
	 * @see #layoutCL
	 */
	public void paint(Graphics g, JComponent c) 
	{
		UiJContainerIcon label = (UiJContainerIcon) c;
		String text = label.getText();
		Icon icon= null;
		if (label.isEnabled()) {
			if (label.isSelected())
				icon= label.getSelectedIcon();
			else
				icon= label.getIcon();
		}
		else
			icon= label.getDisabledIcon();
		if ((icon == null) && (text == null)) {
			return;
		}

		FontMetrics fm = g.getFontMetrics();
		paintViewInsets = c.getInsets(paintViewInsets);

		paintViewR.x = paintViewInsets.left;
		paintViewR.y = paintViewInsets.top;
		paintViewR.width = c.getWidth() - (paintViewInsets.left + paintViewInsets.right);
		paintViewR.height = c.getHeight() - (paintViewInsets.top + paintViewInsets.bottom);

		paintIconR.x = paintIconR.y = paintIconR.width = paintIconR.height = 0;
		paintTextR.x = paintTextR.y = paintTextR.width = paintTextR.height = 0;

		String clippedText = 
			layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);

		if (icon != null) {
			icon.paintIcon(c, g, paintIconR.x, paintIconR.y);
		}

		if (text != null) {
			int textX = paintTextR.x;
			int textY = paintTextR.y + fm.getAscent();

			if (label.isEnabled()) {
				paintEnabledText(label, g, clippedText, textX, textY);
			}
			else {
				paintDisabledText(label, g, clippedText, textX, textY);
			}
		}
		if (c.hasFocus()) {
			// paint UI specific focus
			paintFocus(g, label, paintViewR, paintTextR, paintIconR);
		}
	}
/**
 * Handle the drawing of the disabled container's
 * text.
 * If the component is not selected it behaves like
 * a JLabel. If it is selected we draw the background
 * in the active caption color.
 *
 * Note: In order to provide only one class for all
 *       the LAFs we have to handle the special
 *       case that the Metal LAF implements
 *
 * @see #paint
 * @see #paintEnabledText
 * @see #paintDisabledTextForMetalLAF
 * @see javax.swing.plaf.basic.BasicLabelUI#paintDisabledText
 */
protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
	if (((UiJContainerIcon) l).isSelected()) {
		// Draw the background for the text
		g.setColor(SystemColor.inactiveCaption);
		g.fillRect((int) paintTextR.getBounds().x - 2, (int) (paintTextR.getBounds().y), (int) paintTextR.getBounds().width + 4, (int) paintTextR.getBounds().height);
	}
	if (UIManager.getLookAndFeel().getName().equals("Metal"))
		paintDisabledTextForMetalLAF(l, g, s, textX, textY);
	else
		super.paintDisabledText(l, g, s, textX, textY);
}
/**
 * Just paint the text gray (Label.disabledForeground) rather than 
 * in the labels foreground color.
 *
 * @see #paint
 * @see #paintEnabledText
 */
private void paintDisabledTextForMetalLAF(JLabel l, Graphics g, String s, int textX, int textY) {
	int accChar = l.getDisplayedMnemonic();
	g.setColor(UIManager.getColor("Label.disabledForeground"));
	BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
}
/**
 * Paint clippedText at textX, textY with the labels foreground color
 * and highlight the text if the icon is selected.
 * 
 * @see #paint
 * @see #paintDisabledText
 */
protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY)
{
	int accChar = l.getDisplayedMnemonic();
	if (((UiJContainerIcon) l).isSelected()) {
		// Draw the background for the text
	    g.setColor(SystemColor.activeCaption);
	    g.fillRect((int) paintTextR.getBounds().x - 2, (int) (paintTextR.getBounds().y), (int) paintTextR.getBounds().width + 4 , (int) paintTextR.getBounds().height);
	    // Now use foreground color for selected text
		g.setColor(SystemColor.activeCaptionText);
	}
	else
		g.setColor(l.getForeground());
	BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
}
protected void paintFocus(Graphics g, UiJContainerIcon containerIcon,
			      Rectangle viewRect, Rectangle textRect, Rectangle iconRect){

	Rectangle focusRect = new Rectangle();
	String text = containerIcon.getText();
	boolean hasIcon = containerIcon.getIcon() != null;

	// If there is text ==> only mark text
	if (text != null && !text.equals("")) {
		focusRect.setBounds(textRect);
		g.setColor(SystemColor.inactiveCaption);		
//		g.setColor(SystemColor.activeCaptionBorder);
	}
	else if (!hasIcon) {
		// If there is an icon and no text
 	    focusRect.setBounds(iconRect);
	}
	else
		// Nothing to focus
		return;
	if (containerIcon.isSelected())
		g.setColor(SystemColor.activeCaptionText);
	else
		g.setColor(containerIcon.getForeground());

	if (focusRect.x >= 2) {
		focusRect.x -= 2;
		focusRect.width += 4;}
		
	BasicGraphicsUtils.drawDashedRect(g, focusRect.x , focusRect.y  ,
					  focusRect.width,
					  focusRect.height);
}
}
