package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.util.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.dataTypes.*;
import javax.swing.Timer;
public class UITableModel extends UIProxy implements IEnableListener {
	protected UiItemCache fData = null;
	protected boolean fVetoChanges = false;
	protected int fNotificationPolicy = TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE;
	protected Vector fEmptyStateListeners = new Vector();
	protected UIItemList fItemList = null;
	protected boolean fNotifiedUlcOfChanges = false;
public UITableModel() {
	fData = new UiItemCache(this);
}
/**
 * Add the given component as listener, who will be informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void addEnableListener(IEnableListenerTarget component) {
	fEmptyStateListeners.addElement(component);
	component.setEnabled(shouldEnableListener());
}
public void free() {
	fData.free();
	super.free();
}
public UiItemCache getItemCache() {
	return fData;
}
/**
 * Answer the receiver's current itemList.
 *
 * The receiver's <code>UIItemList</code> is responsible for the order in which
 * the receiver's rows are displayed.
 *
 * @see UIItemList
 *
 */
public UIItemList getItemList() {
	return fItemList;
}
public int getNotificationPolicy() {
	return fNotificationPolicy;
}
public int getRowCount() {
	return getItemList().getRowCount();
}
/*
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("sendRange")) {
		getItemList().handleRequest(conn, request, args);
		return;
	}
	// The command below seems to be dead i.e. no longer sent - but we leave it for now
	if (request.equals("setOids")) {
		getItemList().handleRequest(conn, request, args);
		return;
	}
	if (request.equals("setVeto")) {
		fVetoChanges = args.asBoolean(false);
		return;
	}
	if (request.equals("setNotificationPolicy")) {
		fNotificationPolicy = args.asInt(TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE);
		return;
	}
	if (getItemCache().handleRequest(conn, request, args))
		return;
	super.handleRequest(conn, request, args);
}
/**
 * Add the given component as listener, who will be informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void removeEnableListener(IEnableListenerTarget component) {
	fEmptyStateListeners.removeElement(component);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fVetoChanges = args.get("veto", false);
	fNotificationPolicy = args.get("notificationPolicy", TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE);
	fData = new UiItemCache(this);
	fData.startRequest();
	fData.restoreState(args);
	fId = args.get("oid", 0);
	super.restoreState(conn, args);
	setItemList(conn, args);
	fData.stopRequest();
}
protected void setItemList(ORBConnection conn, Anything args) {
	UIItemList itemList = (UIItemList) getManaged(UIItemList.class, conn, args.get("iil"));
	if (itemList == null) {
		itemList = new UIItemList();
		itemList.setCache(getItemCache());
		itemList.setConnection(conn);
		itemList.restoreState(conn, args);
		fItemList = itemList;
	} else {
		itemList.setCache(getItemCache());
	}
	fItemList = itemList;
}
/**
 * Return true if the component for which I am an enabler should be enabled.
 *
 */
public boolean shouldEnableListener() {
	return getItemCache().hasChanges();
}
void updateEmptyStateListeners(boolean hasChanges) {
	for (int i = 0; i < fEmptyStateListeners.size(); i++) {
		IEnableListenerTarget c = (IEnableListenerTarget) fEmptyStateListeners.elementAt(i);
		c.setEnabled(hasChanges);
	}
	boolean enable = shouldEnableListener();
	if (enable != fNotifiedUlcOfChanges) {
		fNotifiedUlcOfChanges = enable;
		Anything a = new Anything();
		a.put("c", new Anything(enable));
		sendOptionalEventULC("hasChanges", a);
	}
}
}
