package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.table.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.*;
public class UITable extends UIAbstractList {
	public static final int HEADER_HEIGHT = 26;
	public static final int ROW_HEIGHT = 18;
	protected UiTableModelWrapper fTableModel = null;
	protected UIColumn fLastColumnSorted = null;
public void add(UIComponent c) {
	UIColumn column = (UIColumn) c;
	if (column != null) {
		UiTableColumn col = column.getTableColumn();
		if (col != null) {
			// adding UIColumn instead of TableColumn
			//Also, add to the modelWrapper first, since the
			//adding to the table will ask for the name of
			//this column !
			fTableModel.addColumn(column);
			getTable().addColumn(col);
			col.setTable(this);
			((JTable) getBasicComponent()).sizeColumnsToFit(-1);
		}
	}
}
protected UiTableModelWrapper createTableModelWrapper() {
	return new UiTableModelWrapper(fItemList);
}
protected IJList createWidget() {
	return (IJList) new UiJTable(fTableModel, this);
}
protected int getDefaultRowHeight() {
	double d= 1.5 * getComponent().getFont().getSize();
	int height=  Math.round(new Double(d).floatValue());
	return height;
}
protected UiJTable getTable() {
	return (UiJTable) getWidget();
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setAutoResize")) {
		getTable().setAutoResize(args.asInt(0));
		return;
	}
	if (request.equals("setTableModel")) {
		setItemList(conn, args, true);
		return;
	}
	if (request.equals("setHeaderForeground")) {
		setHeaderForegroundColor(args.get("r", -1), args.get("g", -1), args.get("b", -1), true);
		return;
	}
	if (request.equals("setHeaderBackground")) {
		setHeaderBackgroundColor(args.get("r", -1), args.get("g", -1), args.get("b", -1), true);
		return;
	}
	super.handleRequest(conn, request, args);
}
public void registerHeaderMouseListener() {
	class AMouseAdapter extends MouseAdapter {
		UITable uiTable = null;
		public AMouseAdapter(UITable table) {
			uiTable = table;
		}
		public void mouseClicked(MouseEvent e) {
		uiTable.tableHeaderMouseClicked(e);
		}
	}
	((JTable)fWidget).getTableHeader().addMouseListener(new AMouseAdapter(this));
}
public void remove(UIComponent c) {
	UIColumn column = (UIColumn) c;
	if (column != null) {
		TableColumn col = column.getTableColumn();
		if (col != null) {
			getTable().removeColumn(col);
			//We can *not* remove the column from the
			//model of the Table. This is because the
			//JTable *assumes* that the indices of objects
			//in the model is *unchanged* by any column
			//re-positioning, deletion etc.
			//fTableModel.removeColumn(column); //commented out.
		 	((JTable) getBasicComponent()).sizeColumnsToFit(-1);
		}
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	final Anything a = args;
	DeferredRequest r = new DeferredRequest(conn) {
		public void safeDispatch() {
			Anything hbc = a.get("hbc");
			Anything hfc = a.get("hfc");
			if (hbc != null)
				setHeaderBackgroundColor(hbc.get("r", -1), hbc.get("g", -1), hbc.get("b", -1), false);
			if (hfc != null)
				setHeaderForegroundColor(hfc.get("r", -1), hfc.get("g", -1), hfc.get("b", -1), false);
			//
			// when the table is disabled on creation the state is not correctly displayed in swing
			// PR: 1FPAB0Q
			// This causes the state to be explicitly set after creation. needs to be reviewed in JRE 1.3
			setEnabled(a.get("enabled", true));
			//
			// 1FLBRJ1 when autoResizeTABLE_AUTO_RESIZE_OFF the last column was not 
			// being painted properly till a resize was forced.
			//

			UiJTable table = (UiJTable) getBasicComponent();
			if ((table != null) && (table.getAutoResizeMode() == TABLE_AUTO_RESIZE_OFF)) {
				table.sizeColumnsToFit(0);
				table.revalidate();
				table.repaint();
			}
			// end fix
		}
	};
	conn.postRequest(r);
}
public void selectionChanged(String event) {
	if (fItemList == null)
		return;
	int[] ix = getSelectedRowIds();
	if ((ix != null) && (fItemList.getRowCount() == 0) && (ix.length > 0))
		return; //On restore state I get a selection of row 0 even when I have no rows
	super.selectionChanged(event);
}
protected void setComponent(ORBConnection conn, Anything args) {
	fTableModel = createTableModelWrapper();
	fWidget = createWidget();
	UiJTable widget = getTable();
	widget.setAutoResize(args.get("autoResize", TABLE_AUTO_RESIZE_ALL_COLUMNS));
	widget.addMouseListener(this);
	widget.setAutoCreateColumnsFromModel(false);
	widget.setColumnSelectionAllowed(false);
	widget.setRowSelectionAllowed(true);
	setSelectionMode(args.get("selectionMode", -1)); // Single or multi-select*/
	registerHeaderMouseListener();
}
/**
 * Set the color and font decorations of the receiver to the colors / fonts defined
 * as Anythings in <code>args</code>.
 * <br>By default, UIComponents support fore- and background colors, and a font.
 * In addition, the receiver supports selection and header colors.
 * <br>update the receiver's UI exactly once if both <code>refresh</code> and any decoration
 * has been reset
 * <br>Answer true if the component color should be refreshed. If refresh is true, the answer
 * is invariably false, because the refresh is done if needed in this method
 * 
 * @param args Anything holds the anything specifications of all decorations
 * @param refresh boolean indicates whether the receiver should refresh its UI
 */
protected boolean setDecoration(Anything args, boolean refreshLocal) {
	Anything ob = args.get("obc");
	Anything of = args.get("ofc");
	Anything hf = args.get("hfc");
	Anything hb = args.get("hbc");
	boolean localRefresh = (ob != null || of != null || hf != null || hb != null);
	boolean refreshNeeded = super.setDecoration(args, !localRefresh);
	if (localRefresh) {
		if (of != null) {
			setSelectionForegroundColor(of.get("r", -1), of.get("g", -1), of.get("b", -1), (refreshLocal && (ob == null) && (hf == null) && (hb == null)));
		}
		if (ob != null) {
			setSelectionBackgroundColor(ob.get("r", -1), ob.get("g", -1), ob.get("b", -1), (refreshLocal && (hf == null) && (hb == null)));
		}
		if (hf != null) {
			setHeaderForegroundColor(hf.get("r", -1), hf.get("g", -1), hf.get("b", -1), (refreshLocal && (hb == null)));
		}
		if (hb != null) {
			setHeaderBackgroundColor(hb.get("r", -1), hb.get("g", -1), hb.get("b", -1), refreshLocal);
		}
	}
	return (localRefresh && !refreshLocal);
}
protected void setDimensions(Anything args) {
	// since we want to have discrete scrolling we cannot use
	// the following convenience method

	fScrollPane = new UiJScrollPane(getTable());

	// calculate the size of the scrollpane based on rows and header height
	// (this code should really go into JTable.createScrollPaneForTable)
	int rowHeight = args.get("rowHeight", -1);
	if (rowHeight == -1)
		rowHeight = getDefaultRowHeight();
	getTable().setRowHeight(rowHeight);
	Dimension size = new Dimension(0, 0);
	int rowsVisible = args.get("rows", 10) + 1;
	size.height = args.get("h", (rowsVisible * rowHeight) + HEADER_HEIGHT);
	size.width = args.get("w", 100);
	fScrollPane.setPreferredSize(size);
	fScrollPane.setBorder(new BevelBorder(BevelBorder.LOWERED));
	if (args.isDefined("bc")) {
		Anything bc = args.get("bc");
		if (bc != null)
			setBackgroundColor(bc.get("r", -1), bc.get("g", -1), bc.get("b", -1), false);
	}
	if (args.isDefined("fc")) {
		Anything fc = args.get("fc");
		if (fc != null)
			setForegroundColor(fc.get("r", -1), fc.get("g", -1), fc.get("b", -1), false);
	};
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	getBasicComponent().setEnabled(state);
}
/**
 * Set the background of headers in the receiver 
 * to the color defined by the RGB int values <code>red, green,
 * and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setHeaderBackgroundColor(int red, int green, int blue, boolean refresh) {
	Color col = null;
	if (red != -1 || green != -1 || blue != -1) {
		col = new Color(red, green, blue);
	}
	JScrollPane sp = (JScrollPane) getComponent();
	if (sp != null) {
		JViewport vp = (JViewport) sp.getColumnHeader();
		if (vp != null) {
			JTableHeader th = (JTableHeader) vp.getView();
			if (th != null) {
				th.setBackground(col);
				if (refresh)
					refreshComponentColor(sp);
			}
		}
	}
}
/**
 * Set the foreground of all heders in the receiver 
 * to the color defined by the RGB int values <code>red, green,
 * and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setHeaderForegroundColor(int red, int green, int blue, boolean refresh) {
	Color col = null;
	if (red != -1 || green != -1 || blue != -1) {
		col = new Color(red, green, blue);
	}
	JScrollPane sp = (JScrollPane) getComponent();
	if (sp != null) {
		JViewport vp = (JViewport) sp.getColumnHeader();
		if (vp != null) {
			JTableHeader th = (JTableHeader) vp.getView();
			if (th != null) {
				th.setForeground(col);
				if (refresh)
					refreshComponentColor(sp);
			}
		}
	}
}
protected void setItemList(ORBConnection conn, Anything args, boolean notify) {
	super.setItemList(conn, args, notify);
	if (fTableModel != null)
		fTableModel.setItemList(fItemList);
}
public void tableHeaderMouseClicked(MouseEvent e) {
	JTable table = (JTable) fWidget;
	int index = table.getTableHeader().columnAtPoint(e.getPoint());
	if (index < 0)
		return;
	UiTableColumn targetCol = (UiTableColumn) table.getColumnModel().getColumn(index);
	if (isOptionalEventEnabled("sort")) {
		Anything sortEvent = new Anything();
		sortEvent.put("col", targetCol.fUIColumn.getId());
		if (fLastColumnSorted != null)
			sortEvent.put("lastcol", fLastColumnSorted.getId());
		sendEventULC("sort", sortEvent);
	}
	fLastColumnSorted = targetCol.fUIColumn;
}
}
