package com.ibm.ulc.ui.lists;

/**
 * Instances of this class handle the keystrokes in a table cell:
 * with (ENTER, SHIFT-ENTER) and (TAB, SHIFT-TAB) the user can
 * move the edit cell like on a torus.
 * I.e. when he strikes ENTER at the bottom, the edit cell goes to the top 
 * of the same column and,
 * on the TAB axis, when the rightmost column is reached, the edit cell goes back
 * to the first column on the same row.
 * The SHIFT- variants have a symmeric behavior.
 */
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.Icon;

public class UICellEditorTorusKeyPolicy extends UICellEditorKeyPolicy {

	/**
	 * The name of the keymap to be used (and installed in JTextComponent
	 */
	protected static final String KEYMAP_NAME = "UICellEditorKeymap";
/** 
 * Initialize the instance to have its fTableComponent field pointing at table.
 */

UICellEditorTorusKeyPolicy(UiJTable table) {
	super(table);
}
/**
 * Answer the next editable point searching down and starting at the currently edited cell.
 */
Point nextEditPointDown(int row, int numRows, int col, int numCols) {
	int r = nextEditableRowDown(row,numRows,col);
	if (r!=INVALID_INDEX) {
		return new Point(col,r);
	}
	else {
		return null;
	}
}
/**
 * Answer the next editable point searching to the left and starting at the currently edited cell.
 */
Point nextEditPointLeft(int row, int numRows, int col, int numCols) {
	int c = nextEditableColumnLeft(col,numCols,row);
	if (c!=INVALID_INDEX) {
		return new Point(c,row);
	}
	else {
		return null;
	}
}
/**
 * Answer the next editable point searching to the left and starting at the currently edited cell.
 */
Point nextEditPointRight(int row, int numRows, int col, int numCols) {
	int c = nextEditableColumnRight(col,numCols,row);
	if (c!=INVALID_INDEX) {
		return new Point(c,row);
	}
	else {
		return null;
	}
}
/**
 * Answer the next editable point searching up and starting at the currently edited cell.
 */
Point nextEditPointUp(int row, int numRows, int col, int numCols) {
	int r = nextEditableRowUp(row,numRows,col);
	if (r!=INVALID_INDEX) {
		return new Point(col,r);
	}
	else {
		return null;
	}

}
}
