package com.ibm.ulc.ui.lists;

/**
 * Instances of this class handle the keystrokes in a table cell:
 * with (ENTER, SHIFT-ENTER) the cell moves to the neighbour in the
 * lexicographic (y,x) order, and with (TAB, SHIFT-TAB) in the 
 * lexicographic (x,y) order.
 * Once an extremum is reached, we carry on from the opposite.
 * of the same column and,
 *
 * PICTURE:
 * TAB (SHIFT-TAB goes the other way around)
 *                 1  2  3
 *                 4  5  6
 *                 7  8  9   (10=1)
 *
 * ENTER (SHIFT-ENTER opposite)
 *                 1  4  7
 *                 2  5  8
 *                 3  6  9   (10=1)
 */
import java.awt.Point;

public class UICellEditorClosedSpiralsKeyPolicy extends UICellEditorTorusKeyPolicy {
/** 
 * Initialize the instance to have its fTableComponent field pointing at table.
 */

UICellEditorClosedSpiralsKeyPolicy(UiJTable table) {
	super(table);
}
/**
 * Answer the next edit point moving down from the current position.
 * If no editable point exists in col, search to the right.
 */
Point nextEditPointDown(int row, int numRows, int col, int numCols) {
	int r= nextEditableRowDown(row,numRows,col);
	if (r!=INVALID_INDEX && r>row) {
		return new Point(col,r);
	}
	else {
		int otherCols= numCols-1;
		int c= col+1;
		for (int i=0; i<otherCols; i++) {
			if (c>=numCols) c= 0;
			r= nextEditableRowDown(-1,numRows,c);
			if (r!=INVALID_INDEX) return new Point(c,r);
			c++;
		}
		return null;
	}
}
/**
 * Answer the next edit point moving left from the current position.
 * If no editable point exists in row, search above.
 */
Point nextEditPointLeft(int row, int numRows, int col, int numCols) {
	int c= nextEditableColumnLeft(col,numCols,row);
	if (c!=INVALID_INDEX && c<col) {
		return new Point(c,row);
	}
	else {
		int otherRows= numRows-1;
		int r= row-1;
		for (int i=0; i<otherRows; i++) {
			if (r<0) r= numRows-1;
			c= nextEditableColumnLeft(numCols,numCols,r);
			if (c!=INVALID_INDEX) return new Point(c,r);
			r--;
		}
		return null;
	}
}
/**
 * Answer the next edit point moving right from the current position.
 * If no editable point exists in row, search below.
 */
Point nextEditPointRight(int row, int numRows, int col, int numCols) {
	int c= nextEditableColumnRight(col,numCols,row);
	if (c!=INVALID_INDEX && c>col) {
		return new Point(c,row);
	}
	else {
		int otherRows= numRows-1;
		int r= row+1;
		for (int i=0; i<otherRows; i++) {
			if (r>=numRows) r= 0;
			c= nextEditableColumnRight(-1,numCols,r);
			if (c!=INVALID_INDEX) return new Point(c,r);
			r++;
		}
		return null;
	}
}
/**
 * Answer the next edit point moving upwards from the current position.
 * If no editable point exists in col, search to the left.
 */
Point nextEditPointUp(int row, int numRows, int col, int numCols) {
	int r= nextEditableRowUp(row,numRows,col);
	if (r!=INVALID_INDEX && r<row) {
		return new Point(col,r);
	}
	else {
		int otherCols= numCols-1;
		int c= col-1;
		for (int i=0; i<otherCols; i++) {
			if (c<0) c= numCols-1;
			r= nextEditableRowUp(numRows,numRows,c);
			if (r!=INVALID_INDEX) return new Point(c,r);
			c--;
		}
		return null;
	}
}
}
