package com.ibm.ulc.ui.lists;

import java.awt.*;
import java.awt.image.*;

class SelectedImageFilter extends RGBImageFilter {
	private boolean brighter;
	private int percent;
/**
 * ImageSelectedFilter constructor comment.
 */
public SelectedImageFilter() {
	super();
}
/**
 * @param b  a boolean -- true if the pixels should be brightened
 * @param p  an int in the range 0..100 that determines the percentage
 *           of gray, where 100 is the darkest gray, and 0 is the lightest
 */
public SelectedImageFilter(boolean b, int p) {
	brighter= b;
	percent= p;

	// canFilterIndexColorModel indicates whether or not it is acceptable
	// to apply the color filtering of the filterRGB method to the color
	// table entries of an IndexColorModel object in lieu of pixel by pixel
 	// filtering.
	canFilterIndexColorModel = true;
}
/**
 * Creates a selected image
 */
public static Image createSelectedImage (Image i) {
	SelectedImageFilter filter= new SelectedImageFilter(true, 50);
	ImageProducer prod= new FilteredImageSource(i.getSource(), filter);
	Image selectedImage= Toolkit.getDefaultToolkit().createImage(prod);
	return selectedImage;
}
/**
 * Modify the color of each pixel
 *
 * ATTENTION: Color is hard coded to add blue shading
 *			  We should use SystemColor.activeCaption
 *            but this is not so easy.
 *
 *
 */
public int filterRGB(int x, int y, int rgb) {
	int selectedRed= SystemColor.activeCaption.getRed();
	int selectedGreen= SystemColor.activeCaption.getGreen();
	int selectedBlue= SystemColor.activeCaption.getBlue();
	int sum= selectedRed + selectedGreen + selectedBlue;
	if (sum == 0)
		sum= 1;
	int redWeight= selectedRed / sum;
	int greenWeight= selectedGreen / sum;
	int blueWeight= selectedBlue / sum;

	int red= ((rgb >> 16) & 0xff) * (50 + 40 * redWeight) / 100;
	int green= ((rgb >> 8) & 0xff) * (50 + 40 * greenWeight) / 100;
	int blue= (rgb & 0xff) * (50 + 40 * blueWeight) / 100;

	return (0xff000000) | (red << 16) | (green << 8) | (blue << 0);
}
}
