package com.ibm.ulc.ui.lists;

/**
 * This interface enables a widget to be client of a <code>UITableModel</code>. 
 *
 */
public interface IList {
/**
 * Add a given listener to the receiver's list of objects notified of changes in the
 * the receiver's current selection
 */
void addSelectionListener(ISelectionListener listener);
/**
 * Answer the receiver's current itemList.
 *
 * The receiver's <code>UIItemList</code> is responsible for the order in which
 * the receiver's rows are displayed.
 *
 * @see UIItemList
 *
 */
UIItemList getItemList();
/**
 * Answer the array of indices of the receiver's current selection.
 */
int[] getSelectedIndices();
/**
 * Remove a given listener from the receiver's listener list.
 */
void removeSelectionListener(ISelectionListener listener);
/**
 * The receiver's current selection has been modified.
 *
 * @param	event	the event that triggered the message, normally <code>action</code> or <code>select</code>
 */
void selectionChanged(String event);
/**
 * Set the selected item to row and update the UI.
 *
 * @param	row		 the row object to be selected
 */
void setSelectedItem(IRow row);
/**
 * Change the receiver's selection mode.
 *
 * @param selectionMode	The selection mode which can be one of:
 * <pre>
 *  					IDefaults.LIST_SINGLE_SELECTION
 *  					IDefaults.LIST_SINGLE_INTERVAL_SELECTION
 *  					IDefaults.LIST_MULTIPLE_INTERVAL_SELECTION
 * </pre>
 */
void setSelectionMode(int selectionMode);
}
