package com.ibm.ulc.ui.lists;

/**
 * This interface defines unified protocol for JList and JTable.
 *
 * Because JList and JTable have much protocol in common, but do not share a useful ancestor,
 * this interface allows for the UI list hierarchy talk to the swing widget regardless of its type.
 */
import java.util.Vector;
public interface IJList {
void clearSelection();
void ensureIndexIsVisible(int index);
int getPreferredHeight();
int[] getSelectedIndices();
/**
 * The UI proxy may update the receiver using this method.
 *
 * @param 	type				one of
  <pre>
 					TABLE_MODEL_CONTENTS_CHANGED
					TABLE_MODEL_ROWS_CHANGED
					TABLE_MODEL_ROWS_ADDED
					TABLE_MODEL_CELL_CHANGED
					TABLE_MODEL_ROWS_REMOVED
  </pre>
 * @param 	attributeNames		the attributes changed, empty if not specified / specifiable
 * @param 	start				start of change range
 * @param 	end					end of change range
 */
 
void notify(int type, String[] attributeNames, int start, int end);
/**
 * 
 */
void requestFocus();
/**
 * Convenience method to access a certain cell from the current ItemCache. 
 *
 * This message may cause a request to ULC
 */
public Object requestValue(int row, String colId);
void setRowHeight(int rowHeight);
void setSelectionBackground(java.awt.Color color);
void setSelectionForeground(java.awt.Color color);
void setSelectionInvervals(int[][] intervals, int[] indices);
void setSelectionMode(int rowCount);
void setVisibleRowCount(int rowCount);
void validate();
}
