package com.ibm.ulc.ui.io;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */
import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.ui.*;
import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.io.*;
public class UIFileChooser extends UIComponent {
	protected JFileChooser fFileChooser = null;
	protected int fDialogType = FILE_OPEN_DIALOG;
	protected Component fParent = null;
	protected Anything fArgs = null;
	protected static Object fgLock = new Object();
	protected static boolean fgBusy = false;
/**
 * Answer the component being handled by the receiver.
 *
 * This method returns the (swing) widget associated with the receiver, 
 * <i>except</i> in cases where there are containers within which the 
 * basic widget is located. In such a case, this method answers the 
 * container, while the basic widget itself can be accessed using the 
 * getBasicComponent() method.
 *
 * @see getBasicComponent()
 */
public Component getComponent() {
	return fFileChooser;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request write a message out on the console.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("showDialog")) {
		if (fgBusy) {
			final ORBConnection c = conn;
			final String req = request;
			final Anything a = args;
			DeferredRequest r = new DeferredRequest(conn) {
				public void safeDispatch() {
					handleRequest(c, req, a);
				}
			};
			conn.postRequest(r);
		}
		else
			synchronized (fgLock) {
			fgBusy = true;
			showDialog(conn, args);
			fgBusy = false;
		}
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request write a message out on the console.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void initializeFromArguments(ORBConnection conn, Anything args) {
	if (args.isDefined("useFileHiding")) {
		fFileChooser.setFileHidingEnabled(args.get("useFileHiding", false));
	}
	if (args.isDefined("fileSelectionMode")) {
		fFileChooser.setFileSelectionMode(args.get("fileSelectionMode", FILE_FILES_ONLY));
	}
	if (args.isDefined("multiSelectionEnabled")) {
		fFileChooser.setMultiSelectionEnabled(args.get("multiSelectionEnabled", false));
	}
	if (args.isDefined("dialogTitle")) {
		fFileChooser.setDialogTitle(args.get("dialogTitle", ""));
	}
	if (args.isDefined("approveButtonText")) {
		fFileChooser.setApproveButtonText(args.get("approveButtonText", "OK"));
	}
	if (args.isDefined("approveButtonToolTipText")) {
		fFileChooser.setApproveButtonToolTipText(args.get("approveButtonToolTipText", (String) null));
	}
	/*!!! swing 1.1 only
	    if (args.isDefined("approveButtonMnemonic")) {
	        fFileChooser.setApproveButtonMnemonic(args.get("approveButtonMnemonic", 0));
	    }
	*/
	if (args.isDefined("currentDirectory")) {
		fFileChooser.setCurrentDirectory(new File(args.get("currentDirectory", (String) null)));
	}
	if (args.isDefined("selectedFile")) {
		fFileChooser.setSelectedFile(new File(args.get("selectedFile", (String) null)));
	}
	if (args.isDefined("selectedFiles")) {
		String filenames[] = (String[]) args.get("selectedFiles", (Serializable) null);
		if (filenames != null) {
			File files[] = new File[filenames.length];
			for (int i = 0; i < filenames.length; i++) {
				files[i] = new File(filenames[i]);
			}
			fFileChooser.setSelectedFiles(files);
		}
	}
	if (args.isDefined("filters")) {
		UlcFileFilter filters[] = (UlcFileFilter[]) args.get("filters", (Serializable) null);
		if (filters != null) {
			fFileChooser.resetChoosableFileFilters();
			for (int i = 0; i < filters.length; i++) {
				fFileChooser.addChoosableFileFilter(new FileFilterAdapter(filters[i]));
			}
		}
	}
	if (args.isDefined("filter")) {
		fFileChooser.setFileFilter(new FileFilterAdapter((UlcFileFilter) args.get("filter", (Serializable) null)));
	}
	if (args.isDefined("parentShell")) {
		UIShell sh = (UIShell) getManaged(UIShell.class, conn, args.get("parentShell"));
		if (sh != null) {
			fParent = sh.getComponent();
		}
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	if (args.isDefined("currentDirectoryPath")) {
		fFileChooser = new JFileChooser(args.get("currentDirectoryPath", "")) {
			public JToolTip createToolTip() {
				return new UiJMultiLineToolTip();
			}
		};
	} else {
		fFileChooser = new JFileChooser() {
			public JToolTip createToolTip() {
				return new UiJMultiLineToolTip();
			}
		};
	}
	initializeFromArguments(conn, args);
	fArgs = args;
	if (args.get("visible", true))
		showDialog();
}
/**
 * Set the component to be visible or hidden.
 * 
 */
public void setVisible(boolean visible) {
	if (visible)
		showDialog();
}
/**
 * Show the dialog based on the arguments supplied and send the result to the ULC application.
 */
public void showDialog() {
	int returnValue=0;
	fDialogType=fArgs.get("dialogType", FILE_OPEN_DIALOG);
	switch (fDialogType) {
		case FILE_OPEN_DIALOG :
			returnValue = fFileChooser.showOpenDialog(fParent);
			break;
		case FILE_SAVE_DIALOG :
			returnValue = fFileChooser.showSaveDialog(fParent);
			break;
		case FILE_CUSTOM_DIALOG :
			returnValue = fFileChooser.showDialog(fParent, fArgs.get("approveButtonText", "OK"));
			break;
		default :
			System.out.println("Error: Invalid JFileChooser dialogType");
	}
	Anything reply = new Anything();
	reply.put("returnValue", returnValue);
	if (fFileChooser.isMultiSelectionEnabled()) {
		File files[] = fFileChooser.getSelectedFiles();
		if (files != null) {
			String filenames[] = new String[files.length];
			for (int i = 0; i < files.length; i++) {
				filenames[i] = files[i].getAbsolutePath();
			}
			reply.put("selectedFiles", filenames);
		}
	} else {
		if (fFileChooser.getSelectedFile() != null) {
			reply.put("selectedFile", fFileChooser.getSelectedFile().getAbsolutePath());
		}
	}
	reply.put("currentDirectory", fFileChooser.getCurrentDirectory().getAbsolutePath());
	sendULC("reply", reply);
}
/**
 * Show the dialog based on the arguments supplied and send the result to the ULC application.
 */
public void showDialog(ORBConnection conn, Anything args) {
	fArgs= args;
	initializeFromArguments(conn, args);
	showDialog();
}
}
