package com.ibm.ulc.ui.dataTypes;

/**
 * This date format differs from the superclass only in one respect:
 * the missing date fields (day, month, year, hours,...) are not taken
 * from the time origin Thu Jan 01 00:00:00 GMT+01:00 1970,
 * which is, IMMO a silly thing to do,
 * but from the current Date.
 *
 * Creation date: (19-Nov-99 3:20:56 PM)
 * @author: Markus Marzetta (CS-ZRH)
 */
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Locale;
import java.util.Date;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

import java.text.ParsePosition;

public class UISimpleDateFormat extends SimpleDateFormat {

	protected static int[] defaultingFields = 
		{Calendar.YEAR, Calendar.MONTH, Calendar.DAY_OF_MONTH};
/**
 * UiSimpleDateFormat constructor comment.
 */
public UISimpleDateFormat() {
	super();
}
/**
 * UiSimpleDateFormat constructor comment.
 * @param pattern java.lang.String
 */
public UISimpleDateFormat(String pattern) {
	super(pattern);
}
/**
 * UiSimpleDateFormat constructor comment.
 * @param pattern java.lang.String
 * @param formatData java.text.DateFormatSymbols
 */
public UISimpleDateFormat(String pattern, java.text.DateFormatSymbols formatData) {
	super(pattern, formatData);
}
/**
 * UiSimpleDateFormat constructor comment.
 * @param pattern java.lang.String
 * @param loc java.util.Locale
 */
public UISimpleDateFormat(String pattern, java.util.Locale loc) {
	super(pattern, loc);
}
	/**
	 * Parse a date/time string. (see superclass)
	 * 
	 * We take the calendar field as left from the super method,
	 * and change the "defaulting" (=DAY_OF_MONTH,MONTH,YEAR) fields,
	 * that are not set, to be the same as in the current date.
	 *
	 * To do these changes we use the same technique used in super 
	 * for the defaultCenturyStart.
	 *
	 * Note: We do not reconstruct the complex defaultCenturyStart behavior
	 * for the first part of the defaultCenturyStart year.
	 * I.e. if today is 22 Nov 1999,
	 * Input = '01.01.00'  ----> ReturnedDate = 01.01.2000
	 * ...
	 * Input = '31.12.18'  ----> ReturnedDate = 31.12.2018
	 * Input = '01.01.19'  ----> ReturnedDate = 01.01.1919 <<< super returns 01.01.2019
	 * Input = '22.11.19'  ----> ReturnedDate = 22.11.1919 <<< super returns 22.11.2019
	 * Input = '23.11.19'  ----> ReturnedDate = 23.11.1919	 
	 * Input = '31.12.19'  ----> ReturnedDate = 31.12.1919
	 *
	 * I.e. something slightly more than the last 80 years are the default.
	 */

public Date parse(String text, ParsePosition pos) {
	
	super.parse(text, pos);
	
	Calendar nowCalendar = new GregorianCalendar(); //all fields are taken from NOW
	Calendar savedCalendar = (Calendar)calendar.clone();
	
	for (int i=0; i<defaultingFields.length; i++) {
		int field = defaultingFields[i];
		if (!savedCalendar.isSet(field)) {
			savedCalendar.set(field,nowCalendar.get(field));
			}
	}
	
	Date theDate = null;
	try {
		theDate = savedCalendar.getTime();
	} catch (IllegalArgumentException e) {
		pos.setIndex(0);
	}
	return theDate;
}
}
