package com.ibm.ulc.ui.dataTypes;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 *
 * This class is used for ensuring that the input to a text field
 * matches the criteria specified by the regular expression associated
 * with the receiver.
 */
import com.ibm.ulc.ui.UIFormComponent;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;

/*
 * To replace the Regexpression package used in this sample with your own package
 * change the method createRegularExpression to return a regular expression object 
 * which implements IRegularExpression.
 */
public class UIRegularExpressionValidator extends UIDataType {
	/**
	 * The expression that is checked when the field looses its focus.
	 * @serial	 
	 */
	public IRegularExpression fValidateExpression;
	/**
	 * The expression that is checked as each character is typed.
	 * Usually the input expression is more lenient than the validate
	 * expression to reduce the amount of checks that take place during
	 * each keystroke.
	 * @serial	 
	 */
	public IRegularExpression fInputFilterExpression;
/**
 * UIRegularExpressionValidator constructor comment.
 */
public UIRegularExpressionValidator() {
	super();
}
/**
 * Check if the input string conforms to the regular expression. Throw an exception on error.
 *
 * @param phase int	The current validation phase.
 * The phase can be one of the following:
 * <pre>
 *	FORM_NOTIFICATION_IMMEADIATE : Typically no validation is performed in this case the input string is returned as is.
 *	FORM_NOTIFICATION_ON_FOCUS_CHANGE 	 
 * 	FORM_NOTIFICATION_ON_REQUEST
 *	</pre>
 * @param newString The String to convert.
 * @return An object representing the converted String or null.
 *
 * @see IDataType#convertToObject(int, String, Object)
 */
public Object convertToObject(int phase, String newString, Object previousValue) throws DataTypeConversionException {
	if (phase == FORM_NOTIFICATION_IMMEDIATE)
		return newString; // no checking
	if (matchPattern(fValidateExpression, newString))
		return newString;
	throw new DataTypeConversionException("illegal input", previousValue);
}
/**
 * @return com.ibm.ulc.ui.regexp.IRegularExpression
 * @param expression java.lang.String
 */
protected IRegularExpression createRegularExpression(String expression) {
	return new DummyRegularExpression(expression);
}
/**
 * The default implementation returns original string without modification.
 *
 * @see IDataType#filterInput(String)
 */
public String filterInput(String newString) {
	if (newString.length() == 0)
		return newString;
	if (fInputFilterExpression != null) {
		//System.out.println("filterInput <" + newString + ">");
		if (matchPattern(fInputFilterExpression, newString))
			return newString;
	}
	return null;
}
/**
 * Return true if the string matches the regExpPattern otherwise false.
 */
public boolean matchPattern(IRegularExpression regExpPattern, String matchString) {
	regExpPattern.matchAt(matchString, 0);
	return regExpPattern.stringMatched() != null;
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	String expression = args.get("regExp", ".");
	fValidateExpression = createRegularExpression(expression);
	expression = args.get("inputExp", null);
	if (expression != null) {
		fInputFilterExpression = createRegularExpression(expression);
	}
}
}
