package com.ibm.ulc.ui.dataTypes;

/**
 * Insert the type's description here.
 * Creation date: (23-Nov-99 1:13:44 PM)
 * @author: Markus Marzetta (CS-ZRH)
 */
import java.text.NumberFormat;

public class UIDoubleNumberFormatConverter extends UINumberFormatConverter {

	/**
	 * The number of decimal digits per binary digits
	 */
	 protected static double DECIMAL_DIGITS_PER_BINARY_DIGIT;
	/**
	 * The number of significant decimal digits
	 * (computed from the 52 IEEE754 binary decimal digits)
	 */
	 protected static double SIGNIFICANT_DECIMAL_DIGITS;

	 static {
		 DECIMAL_DIGITS_PER_BINARY_DIGIT = Math.log(2.0D) / Math.log(10.0D);
		 SIGNIFICANT_DECIMAL_DIGITS = 52.0D * DECIMAL_DIGITS_PER_BINARY_DIGIT;
	 }
/**
 * UIDoubleNumberFormatConverter constructor comment.
 */
public UIDoubleNumberFormatConverter() {
	super();
}
/**
 * Answer a String  representation of the parameter suitable for editing
 * (e.g. increased precision).
 */
public String convertToEditString(Object object) {
	if (object instanceof Double) {
		Double value= (Double) object;
		double log= Math.abs(Math.log(value.doubleValue()));
		int sigFractDigits= (int)(SIGNIFICANT_DECIMAL_DIGITS-log);
		int maxDigits = Math.max(sigFractDigits,fFormat.getMaximumFractionDigits());
		
		NumberFormat numFormat= (NumberFormat)fFormat.clone();
		numFormat.setMaximumFractionDigits(maxDigits);
		return numFormat.format(object);
	}
	return fFormat.format(object);
}
/**
 * convertToObject using NumberFormat
 *
 * If the numberformat does not answer a Long or Double,
 * as promised in the comment of 
 *   NumberFormat :: Number parse(String, ParsePosition),
 * throw an exception. 
 */
 
public Object convertToObject(String string) throws DataTypeConversionException {
	Object object = super.convertToObject(string);
	Double dobj = null;

	if (object instanceof Double) {
		dobj = (Double) object;
	} else if (object instanceof Long) {
		dobj = new Double(((Long) object).doubleValue());
	} else {
		throw new DataTypeConversionException("Could not be converted to Long or Double");
	}

	return dobj;
}
}
