package com.ibm.ulc.ui.dataTypes;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 *
 * This class is used for ensuring that the input to a text field
 * a valid Date.
 */
import java.util.*;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.UIFormComponent;
public class UIDateValidator extends UIDataType {
	/**
	 * The DateFormat objects stored in fInputDateFormats will try
	 * to perform the validation/formatting of input until one is successful.
	 * @serial
	 */
	protected Vector fInputDateFormats = null;
	/**
	 * The current DateFormat object that will perform formatting of output.
	 * @serial
	 */
	protected SimpleDateFormat fOutputDateFormat = null;
	/**
	 * The list of valid characters allowed as input.
	 * @serial
	 * @deprecated	As of ULC R3.1, input is no longer filtered
	 *				therefore this field is no longer used.
	 */
	protected static final String validChars = "0123456789.-/ ";
	/**
	 * The list of valid characters allowed as input.
	 * @serial
	 * @deprecated	As of ULC R3.1, input is no longer filtered
	 *				therefore this field is no longer used.
	 */
	protected String fAllValidChars= null;
	/**
	 * Constant definition for '|'.
	 * @serial
	 */
	protected static final char OR_CHAR = '|';
/**
 * Default constructor for the receiver
 */
public UIDateValidator() {
	super();
}
/**
 * Break the format string into a collection of formats 
 * where an unquoted OR_CHAR ('|') occurs.
 *
 * We iterate through the string with a finite automaton
 * whose state is held by the 2 boolean variables inQuote and inChunk
 */
 
protected Vector alternativeFormatsFrom(String format) {
	StringCharacterIterator iter = new StringCharacterIterator(format);
	Vector subFormats = new Vector();
	StringBuffer chunkBuff = new StringBuffer(format.length());
	boolean inQuote = false;
	boolean inChunk = false;

	for(char currChar = iter.first(); currChar != iter.DONE; currChar = iter.next()) {
		switch (currChar) {
			case '\'': 
				inQuote = inQuote ? false : true;
				inChunk = true;
				chunkBuff.append(currChar);
				break;
			case OR_CHAR:
				if (!inQuote) {
					inChunk = false;
					subFormats.addElement(chunkBuff.toString());
					chunkBuff = new StringBuffer(format.length());
				} else {
					chunkBuff.append(currChar);
				}
				break;
			default:
				inChunk = true;
				chunkBuff.append(currChar);
		}
	}

	if (inChunk) {
		subFormats.addElement(chunkBuff.toString());
	}

	return subFormats;
}
/**
 * Convert the input string to a date. Throw an exception on error.
 *
 * @param phase int	The current validation phase.
 * The phase can be one of the following:
 * <pre>
 *	FORM_NOTIFICATION_IMMEADIATE : Typically no validation is performed in this case the input string is returned as is.
 *	FORM_NOTIFICATION_ON_FOCUS_CHANGE 	 
 * 	FORM_NOTIFICATION_ON_REQUEST
 *	</pre>
 * @param newString The String to convert.
 * @return An object representing the converted String or null.
 *
 * @see IDataType#convertToObject(int, String, Object)
 */
public Object convertToObject(int phase, String newString, Object previousValue) throws DataTypeConversionException {
	if (phase == FORM_NOTIFICATION_IMMEDIATE)
		return newString; // no checking

	if (newString != null && newString.length() > 0) {
		Object theDate = null;
		int i = 0;
		while (theDate == null) {
			try {
				theDate = ((DateFormat)fInputDateFormats.elementAt(i)).parse(newString);
			} catch (ParseException e) {
			}
			if (i<fInputDateFormats.size()-1) {
				i++;
			} else if (theDate == null) {
				throw new DataTypeConversionException("bad date format", previousValue);
			}
		}
		return theDate;
	}
	return null;
}
/**
 * Return the String represenation of the object or the empty string if object is null.
 * The default implementation calls the toString() to return a string representation of the object.
 * Subclasses should override this method to return the formatted data type as a String.
 *
 * @see IDataType#convertToString(Object, boolean)
 */
public String convertToString(Object object, boolean forEditing) {
	if ((object != null) && (object instanceof Date))
		return fOutputDateFormat.format((Date) object);
	return "";
}
/**
 * The default implementation returns original string without modification.
 *
 * @see			IDataType#filterInput(String)
 * @deprecated	As of ULC R3.1, input is no longer filtered
 *				therefore this method is no longer used and will
 *				be removed in a later release.
 *				NOTE: The current implementation lets exisiting subclasses
 *					  work as before. Exisiting subclasses should change their
 *					  implementation and new ones should not call super for the
 *					  time being (copy the method from <code>UIDataType</code>).
 *					  	
 */
public String filterInput(String newString) {
	/*
	 * This method should no longer be here, but
	 * is not deleted because a subclass could
	 * rely on it
	 */
	if (getClass() == UIDateValidator.class)
		return super.filterInput(newString);

	if (hasValidCharacters(newString))
		return newString;
	return null;
}
/**
 * The receiver is being destroyed. Release all the 
 * associated resources.
 */
public void free() {
	fInputDateFormats = null;
	fOutputDateFormat = null;
	super.free();
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setFormatString")) {
		setFormatString(args.asString("dd.MM.yy"));
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Answer if the <code>String</code> only contains valid characters
 *
 * @param		s	the <code>String</code> which is tested
 * @return		<boolean> desicribing if s consists of valid characters
 * @deprecated	As of ULC R3.1, input is no longer filtered
 *				therefore this method is no longer used and will
 *				be removed in a later release.
 */
public boolean hasValidCharacters(String s) {
	for (int i = 0; i < s.length(); i++)
		if (fAllValidChars.indexOf(s.charAt(i)) < 0)
			return false;
	return true;
}
/**
 * Initialize the valid characters specific for the receiver:
 * all characters of the formatString except aA..zZ 
 * are added to the standard valid characters
 * (we do not take into account quoted letters).
 *
 * @param		formatString java.lang.String
 * @deprecated	As of ULC R3.1, input is no longer filtered
 *				therefore this method is no longer used and will
 *				be removed in a later release.
 */
protected void initializeValidCharacters(String formatString) {
	StringBuffer buffer= new StringBuffer(validChars);

	for (int i=0; i<formatString.length(); i++) {
		char ch= formatString.charAt(i);
		if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch=='|'))
			buffer.append(ch);
	}
	fAllValidChars= buffer.toString();
}
/**
 * Answer the input format (with abbreviated year) corresponding to the given output format
 * @return String
 * @param outputFormatString String 
 */
protected String  inputFormatFor(String outputFormatString) {
	StringBuffer writeStream = new StringBuffer(outputFormatString.length());

	int i = 0;
	int readYs = 0;
	int ysToWrite = 0;
	while (i<outputFormatString.length()) {
		char ch = outputFormatString.charAt(i);
		if (ch == 'y') { // while reading ys, do not write, just count
			readYs++;
			}
		else {
			if (readYs > 0) { // ch is the first character after the y-sequence: write the ys first
				writeYsOn(readYs, writeStream);
				readYs = 0;
			}
			writeStream.append(ch);
		}
		i++;
	}
	if (readYs > 0) { // the ys came at the end of outputFormatString
		writeYsOn(readYs, writeStream);
	}
	return writeStream.toString();
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	setFormatString(args.get("fs", "dd.MM.yy")); //case is important
}
/**
 * Set the formatters according to outputFormatString.
 *
 * outputFormatString is cut in several alternative format strings;
 * for output the first format is chosen;
 * for input we store the whole collection, and take the first that
 * does not cause a parse exception.
 *
 * Note: Case *does* matter.
 */


public void setFormatString(String outputFormatString) {
	initializeValidCharacters(outputFormatString);
	TimeZone tz = new SimpleTimeZone(0, "GMT");	
	Vector altFormatStrings = alternativeFormatsFrom(outputFormatString);
	if (altFormatStrings.isEmpty()) {
		trouble("setFormatString", "Illegal format String[" + outputFormatString + "] Specified defaulting to dd.MM.yy");
		altFormatStrings.addElement("dd.MM.yy");
	}
	fOutputDateFormat = (SimpleDateFormat) new UISimpleDateFormat().getInstance();
	fOutputDateFormat.setTimeZone(tz); // to avoid dst/time zone issues
	fOutputDateFormat.applyPattern((String) altFormatStrings.firstElement()); //case is important
	fOutputDateFormat.setLenient(false); // to prevent the rolling of dates (RUM 10.06.98)

	Vector altFormats = new Vector(altFormatStrings.size());
	for (int i = 0; i < altFormatStrings.size(); i++) {
		String ithFormStr = (String) altFormatStrings.elementAt(i);
		SimpleDateFormat ithFormat = (SimpleDateFormat) new UISimpleDateFormat().getInstance();
		ithFormat.applyPattern(inputFormatFor(ithFormStr));
		ithFormat.setTimeZone(tz); // to avoid dst/time zone issues		
		ithFormat.setLenient(false); // to prevent the rolling of dates (RUM 10.06.98)
		altFormats.addElement(ithFormat);
	}
	fInputDateFormats = altFormats;
}
/**
 * Write a suitable number of ys to the input format writeStream, given the fact that readYs are present in the output format.
 * @param readYs int
 * @param writeStream StringBuffer
 */
protected void writeYsOn(int readYs, StringBuffer writeStream) {
	int ysToWrite;
	
	if (readYs == 4) {
		ysToWrite = 2;
	}
	else {
		ysToWrite = readYs;
	}
	for (int j = 0; j<ysToWrite; j++) {writeStream.append('y');}
}
}
