package com.ibm.ulc.ui.base;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import com.ibm.ulc.util.Anything;


public
class Attr {
	static public GridBagConstraints createConstraints(Anything args) {

		GridBagConstraints constraints= new GridBagConstraints();

		constraints.gridx= args.get("x", GridBagConstraints.RELATIVE);
		constraints.gridy= args.get("y", GridBagConstraints.RELATIVE);

		constraints.weightx= 0.0;
		constraints.weighty= 0.0;

		constraints.gridwidth= args.get("hs", 1);
		constraints.gridheight= args.get("vs", 1);

		String attr= args.get("a", "lc");

		int i= 0;
		switch (attr.charAt(0)) {
		case 'e':
		case 'f':
			i= 0;
			constraints.weightx= 1.0;
			break;
		case 'l':
			i= 1;
			break;
		case 'c':
			i= 2;
			break;
		case 'r':
			i= 3;
			break;
		}
		switch (attr.charAt(1)) {
		case 'e':
		case 'f':
			i= i*4 + 0;
			constraints.weighty= 1.0;
			break;
		case 't':
			i= i*4 + 1;
			break;
		case 'c':
		case 'B':
			i= i*4 + 2;
			break;
		case 'b':
			i= i*4 + 3;
			break;
		}

		switch (i) {
		case 0:		//ee
			constraints.fill= GridBagConstraints.BOTH;
			break;
		case 1:		//et
			constraints.fill= GridBagConstraints.HORIZONTAL;
			constraints.anchor= GridBagConstraints.NORTH;
			break;
		case 2:		//ec
			constraints.fill= GridBagConstraints.HORIZONTAL;
			break;
		case 3:		//eb
			constraints.fill= GridBagConstraints.HORIZONTAL;
			constraints.anchor= GridBagConstraints.SOUTH;
			break;
		case 4:		//le
			constraints.fill= GridBagConstraints.VERTICAL;
			constraints.anchor= GridBagConstraints.WEST;
			break;
		case 5:		//lt
			constraints.anchor= GridBagConstraints.NORTHWEST;
			break;
		case 6:		//lc
			constraints.anchor= GridBagConstraints.WEST;
			break;
		case 7:		//lb
			constraints.anchor= GridBagConstraints.SOUTHWEST;
			break;
		case 8:		//ce
			constraints.fill= GridBagConstraints.VERTICAL;
			break;
		case 9:		//ct
			constraints.anchor= GridBagConstraints.NORTH;
			break;
		case 10:	//cc
			break;
		case 11:	//cb
			constraints.anchor= GridBagConstraints.SOUTH;
			break;
		case 12:	//re
			constraints.fill= GridBagConstraints.VERTICAL;
			constraints.anchor= GridBagConstraints.EAST;
			break;
		case 13:	//rt
			constraints.anchor= GridBagConstraints.NORTHEAST;
			break;
		case 14:	//rc
			constraints.anchor= GridBagConstraints.EAST;
			break;
		case 15:	//rb
			constraints.anchor= GridBagConstraints.SOUTHEAST;
			break;
		}
		return constraints;
	}
}
