package com.ibm.ulc.ui;

import java.awt.*;
import javax.swing.*;

public class UiJViewport extends javax.swing.JViewport {
/**
 * UiJViewport constructor comment.
 */
public UiJViewport() {
	super();
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
public void setCursor(Cursor cursor) {
	super.setCursor(cursor);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setCursor(cursor);
	}
}
public void setEnabled(boolean state) {
	super.setEnabled(state);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setEnabled(state);
	}
	Component parent = getParent();
	if (parent != null) {
		parent.repaint();
	}
}
public void setToolTipText(String text) {
	super.setToolTipText(text);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		if (c instanceof JComponent)
			((JComponent)c).setToolTipText(text);
	}
}
}
