package com.ibm.ulc.ui;

import java.awt.event.*;
import javax.swing.*;
public class UiJRadioButtonMenuItem extends JRadioButtonMenuItem {
/**
 * UiJRadioButtonMenuItem constructor comment.
 */
public UiJRadioButtonMenuItem() {
	super();
}
/**
 * UiJRadioButtonMenuItem constructor comment.
 * @param text java.lang.String
 */
public UiJRadioButtonMenuItem(String text) {
	super(text);
}
/**
 * UiJRadioButtonMenuItem constructor comment.
 * @param text java.lang.String
 * @param icon javax.swing.Icon
 */
public UiJRadioButtonMenuItem(String text, javax.swing.Icon icon) {
	super(text, icon);
}
/**
 * UiJRadioButtonMenuItem constructor comment.
 * @param icon javax.swing.Icon
 */
public UiJRadioButtonMenuItem(javax.swing.Icon icon) {
	super(icon);
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
private int lower(int ascii) {
	if (ascii >= 'A' && ascii <= 'Z')
		return ascii + 'a' - 'A';
	else
		return ascii;
}
/**
 * Implemented to fix a swing bug where mnemonics do not work on toggle menuItems.
 * 1F9QZH1 swing 1.0.3, jdk1.1.7b
 * since ULC R1.5
 */
public void processKeyEvent(KeyEvent e, MenuElement path[], MenuSelectionManager manager) {
	int key = getMnemonic();
	if (key == 0)
		super.processKeyEvent(e, path, manager);
	if (e.getID() == KeyEvent.KEY_PRESSED) {
		if (lower(key) == lower((int) (e.getKeyChar()))) {
			manager.clearSelectedPath();
			doClick(0);
			e.consume();
		}
	}
}
}
