package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
public class UiJLabel extends JLabel implements IRenderer {
	protected IAboutToPaintListener fListener = null;
	protected static Font fgFont = null;
	protected boolean fInit = false;
	protected boolean fLastSelected = false;
public UiJLabel() {
	super("", null, LEFT);
}
UiJLabel(String label) {
	super(label, null, LEFT);
}
UiJLabel(Icon icon) {
	super("", icon, LEFT);
}
public void configureAsRenderer(JList list, IAboutToPaintListener listener, Object o, boolean isSelected) {
	fListener = listener;
	if (!fInit) {
		fInit = true;
		fLastSelected = !isSelected;
	}
	if (isSelected) {
		setOpaque(true);
		setForeground(list.getSelectionForeground());
		setBackground(list.getSelectionBackground());
	}
	else {
		setOpaque(false);
		setForeground(list.getForeground());
		setBackground(list.getBackground());
	}
	if (o != null) {
		if (o instanceof UIIcon) {
			UIIcon icon = (UIIcon) o;
			Image image = icon.getImage(list, null);
			if (image != null) {
				ImageIcon imageIcon = new ImageIcon(image);
				setIcon(imageIcon);
				setText("");
			}
			else {
				setText("error");
			}
		}
		else
			if (o instanceof UILabel) {
				setIcon(((UILabel) o).getIcon());
				setText(((UILabel) o).getText());
			}
			else {
				setIcon(null);
				setText(o.toString());
			}
	}
	else {
		setIcon(null);
		setText("<null>");
	}
}
public void configureAsRenderer(JTable table, IAboutToPaintListener listener, Object o, boolean isSelected) {
	fListener = listener;
	if (!fInit) {
		fInit = true;
		fLastSelected = !isSelected;
	}
	if (isSelected) {
		setOpaque(true);
		setForeground(table.getSelectionForeground());
		setBackground(table.getSelectionBackground());
	}
	if (o != null) {
		if (o instanceof UIIcon) {
			UIIcon icon = (UIIcon) o;
			Image image = icon.getImage(table, null);
			if (image != null) {
				ImageIcon imageIcon = new ImageIcon(image);
				setIcon(imageIcon);
				setText("");
			}
			else {
				setText("error");
			}
		}
		else
			if (o instanceof UILabel) {
				setIcon(((UILabel) o).getIcon());
				setText(((UILabel) o).getText());
			}
			else {
				setIcon(null);
				setText(o.toString());
			}
	}
	else {
		setIcon(null);
		setText("<null>");
	}
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
	public void free() {
		setIcon(null);
		setFont(null);
		setText("");
		Container con= getParent();
		if (con != null)
			con.remove(this);
		
		fListener= null;
	}
/**
 * Gets the alignment of the label's contents along the X axis.
 * We implemented this method here to be more safe: in JRE1.2.2
 * bogus values can come back (probably if JLabel is invalid).
 */
public int getHorizontalAlignment() {
	int align= super.getHorizontalAlignment();
	if (align != LEFT && align!= CENTER && align != RIGHT)
		// JRE1.2.2 bug: might return bogus values
		align= LEFT;
	return align;
}
//1PQRDLK: ULC:WINNT - JUI: Animated Gif cause CPU + memory usage
public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
	boolean ret = super.imageUpdate(img, flags, x, y, w, h);
	return isShowing();
}
	public void paint(Graphics g) {
		if (fListener != null)
			fListener.aboutToPaint();
		super.paint(g);
	}
public void setEnabled(boolean state) {
	super.setEnabled(state);
	repaint();
}
	public String toString() {
		return getText();
	}
public void updateUI() {
	setUI(UiJMultiLineLabelUI.createUI(this));
}
}
