package com.ibm.ulc.ui;

import java.awt.event.*;
import javax.swing.*;
public class UiJCheckBoxMenuItem extends JCheckBoxMenuItem {
/**
 * UiJCheckBoxMenuItem constructor comment.
 */
public UiJCheckBoxMenuItem() {
	super();
}
/**
 * UiJCheckBoxMenuItem constructor comment.
 * @param text java.lang.String
 */
public UiJCheckBoxMenuItem(String text) {
	super(text);
}
/**
 * UiJCheckBoxMenuItem constructor comment.
 * @param text java.lang.String
 * @param icon javax.swing.Icon
 */
public UiJCheckBoxMenuItem(String text, javax.swing.Icon icon) {
	super(text, icon);
}
/**
 * UiJCheckBoxMenuItem constructor comment.
 * @param text java.lang.String
 * @param icon javax.swing.Icon
 * @param b boolean
 */
public UiJCheckBoxMenuItem(String text, javax.swing.Icon icon, boolean b) {
	super(text, icon, b);
}
/**
 * UiJCheckBoxMenuItem constructor comment.
 * @param text java.lang.String
 * @param b boolean
 */
public UiJCheckBoxMenuItem(String text, boolean b) {
	super(text, b);
}
/**
 * UiJCheckBoxMenuItem constructor comment.
 * @param icon javax.swing.Icon
 */
public UiJCheckBoxMenuItem(javax.swing.Icon icon) {
	super(icon);
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
private int lower(int ascii) {
	if (ascii >= 'A' && ascii <= 'Z')
		return ascii + 'a' - 'A';
	else
		return ascii;
}
/**
 * Implemented to fix a swing bug where mnemonics do not work on toggle menuItems.
 * 1F9QZH1 swing 1.0.3, jdk1.1.7b
 * since ULC R1.5
 */
public void processKeyEvent(KeyEvent e, MenuElement path[], MenuSelectionManager manager) {
	int key = getMnemonic();
	if (key == 0)
		super.processKeyEvent(e, path, manager);
	if (e.getID() == KeyEvent.KEY_PRESSED) {
		if (lower(key) == lower((int) (e.getKeyChar()))) {
			manager.clearSelectedPath();
			doClick(0);
			e.consume();
		}
	}
}
}
