package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;


class UiBorderLayout extends UiLayoutManager {
	protected String fAlign= "cc";
	protected int fMargin= 0;
	public UiBorderLayout(int margin) {
		fMargin= margin;
	}
	public UiBorderLayout(int margin, String align) {
		fMargin= margin;
		fAlign= align;
	}
	public void addLayoutComponent(String attr, Component comp) {
	}
	public void layoutContainer(Container parent) {
 		Dimension parentSize= parent.getSize();

 		if (parent.getComponentCount() > 0) {
			Component c= parent.getComponent(0);
			Insets i= parent.getInsets();

			positionInCell(fAlign, c, i.left+fMargin, i.top+fMargin,
				parentSize.width-(i.left + i.right + 2*fMargin),
				parentSize.height-(i.top + i.bottom + 2*fMargin));
  		}
	}
	public Dimension layoutSize(Container parent, boolean minimum) {
  		Insets insets= parent.getInsets();
  		Dimension dim= new Dimension(insets.left + insets.right + 2*fMargin,
		   							 insets.top + insets.bottom + 2*fMargin);
		if (parent.getComponentCount() > 0) {
			Component c= parent.getComponent(0);
  			Dimension d= minimum ? c.getMinimumSize()
							 	 : c.getPreferredSize();
			dim.width+= d.width;
			dim.height+= d.height;
		}
		return dim;
	}
	public void removeLayoutComponent(Component comp) {
 	}  
 	public void setMargin(int margin) {
		fMargin= margin;
 	}  
}
