package com.ibm.ulc.ui;

import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
public abstract class UITrigger extends UIProxy {
/**
 * UITriggerAbstract constructor comment.
 */
public UITrigger() {
	super();
}
/**
 * Generic method to add a UIProxy widget to this widget.
 * Subclasses that support child widgets must override this method
 *
 * @param proxy 		the UI proxy widget that is being added as a child
 */
public void add(UIProxy proxy) {
	internalAddToChildren(proxy);
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request write a message out on the console.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("reset")) {
		reset(conn, args);
		return;
	}
	if (request.equals("trigger")) {
		trigger(fConnection, TRIGGER_ON_ACTION_AND_SELECTION, this, null);
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Generic method to remove a UIProxy widget from this widget.
 * Subclasses that support child widgets must override this method
 *
 * @param proxy 		the UI proxy widget that is being added as a child
 */
public void remove(UIProxy proxy) {
	internalRemoveFromChildren(proxy);
}
public abstract void reset(ORBConnection conn, Anything args);
public abstract void trigger(ORBConnection conn, int triggerOn, UIProxy sourceWidget, Object userData);
}
