package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.*;

public class UITest extends UIComponent {
	protected Component fTester = null;
	Component create(String name) {
		try {
			Class cl= Class.forName(name);
			if (cl != null)
				return (Component) cl.newInstance();
			trouble("create", "couldn't find " + name);
		}
		catch (ClassNotFoundException e) {
			trouble("create", "got ClassNotFoundException");
		}
		catch (InstantiationException e) {
			trouble("create", "got InstantiationException");
		}
		catch (IllegalAccessException e) {
			trouble("create", "got IllegalAccessException");
		}
		catch (ClassCastException e) {
			trouble("create", "can't cast object to Component");
		}
		return null;
	}
	public Component getComponent() {
		if (fTester == null)
			fTester= new Label("Error");
	    return fTester;
	}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	String className = args.get("className", null);
	if (className != null)
		fTester = create(className);
	super.restoreState(conn, args);
}
	public void setLabel(String label) {
	    fTester.setName(label);
	}
}
