package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
public abstract class UIStandardFormModel extends UIProxy implements IFormModel, IFormModelListener {
	protected Vector fModelListener;
	protected Anything fAttrNames = null;
	public static final boolean DEBUG = true;
public UIStandardFormModel() {
	fAttrNames = new Anything();
	fModelListener = new Vector();
}
/**
 * Add a listener to the list that's notified each time a
 * change to the data model occurs.
 */
public void addModelListener(String key, IFormModelListener l) {
	fModelListener.addElement(l);
	if (key != null)
		fAttrNames.put(key, new Anything());
}
/**
 * The application may set my value to be an invalid value for the configured Validator.
 * Detect this condition and if so update the application with the new value.
 */
public void checkForInvalidFormValueUpdate() {
	if (fModelListener != null) {
		Enumeration e = fModelListener.elements();
		while (e.hasMoreElements()) {
			IFormModelListener iml = (IFormModelListener) e.nextElement();
			iml.checkForInvalidFormValueUpdate();
		}
	}
}
public void focusGained(FocusEvent event) {
}
public void focusLost(FocusEvent event) {
}
public void free() {
	fModelListener = null;
	fAttrNames = null;
	super.free();
}
public void notify(int type, String key) {
	notify(type, key, this);
}
protected void notify(int type, String key, IFormModelListener except) {
		//if (DEBUG)
  		//	System.out.println("notify: " + key);
		if (fModelListener != null) {
			Enumeration e= fModelListener.elements();
			while (e.hasMoreElements()) {
				IFormModelListener iml= (IFormModelListener) e.nextElement();
				if (iml != except)
					iml.notify(type, key);
			}
	    }
	}
/**
 * Remove a listener from the list that's notified each time
 * a change to the data model occurs.
 */
public void removeModelListener(IFormModelListener l) {
	if (fModelListener != null)
		fModelListener.removeElement(l);
}
}
