package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.base.*;
public class UISlider extends UIFormComponent implements ChangeListener {
	protected JSlider fSlider = null;
	protected int fMultiplier = 1;
protected void correctLabelTable(int min, int max, int majorTickSpacing) {
	if (fMultiplier == 1)
		return;
	UlcHashtable ht = new UlcHashtable();
	int i = min;
	while (i <= max) {
		ht.put(new Integer(i), new JLabel(Integer.toString(i / fMultiplier), JLabel.CENTER));
		i = i + majorTickSpacing;
	}
	fSlider.setLabelTable(ht);
}
public void free() {
	if (fSlider != null) {
		fSlider.removeChangeListener(this);
		fSlider = null;
	}
	super.free();
}
public Component getComponent() {
	return fSlider;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setValue")) {
		setValue(args.asInt(0) * fMultiplier);
		return;
	}
	if (request.equals("setPaintTicks")) {
		fSlider.setPaintTicks(args.asBoolean(false));
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	boolean horizontal = args.get("horizontal", true);
	int minValue = args.get("minValue", 0);
	int maxValue = args.get("maxValue", 100);
	if (maxValue < minValue)
		maxValue = minValue + 100; // FIXME
	if ((maxValue - minValue) < 10)
		//1ET0TVA maxValue - minValue < 10 does not work so we shift the scale
		fMultiplier = 10;
	minValue = minValue * fMultiplier;
	maxValue = maxValue * fMultiplier;
	if (fFormModel != null) {
		fSlider = new JSlider(horizontal ? 0 : 1, minValue, maxValue, minValue) {
			public JToolTip createToolTip() {
				return new UiJMultiLineToolTip();
			}
		};
		updateFromModel();
	} else {
		int value = args.get("value", 0);
		value = value * fMultiplier;
		if (value < minValue)
			value = minValue;
		else
			if (value > maxValue)
				value = maxValue;
		fSlider = new JSlider(horizontal ? 0 : 1, minValue, maxValue, value) {
			public JToolTip createToolTip() {
				return new UiJMultiLineToolTip();
			}
		};
		fSlider.setPaintTicks(args.get("paintTicks", false));
		fSlider.setPaintLabels(args.get("paintLabels", false));
		int majorTickSpacing = args.get("majorts", 10) * fMultiplier;
		fSlider.setMajorTickSpacing(majorTickSpacing);
		fSlider.setMinorTickSpacing(args.get("minorts", 5) * fMultiplier);
		correctLabelTable(minValue, maxValue, majorTickSpacing);
	}
	super.restoreState(conn, args);
	fSlider.addChangeListener(this);
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	super.setEnabled(state);
	fSlider.repaint();
}
public void setValue(int v) {
	if (v < fSlider.getMinimum())
		v = fSlider.getMinimum();
	else
		if (v > fSlider.getMaximum())
			v = fSlider.getMaximum();
	if (fSlider.getValue() != v) {
		fSlider.removeChangeListener(this);
		fSlider.setValue(v);
		fSlider.addChangeListener(this);
	}
}
public void stateChanged(ChangeEvent e) {
	int value = fSlider.getValue();
	value = value / fMultiplier;
	if (fFormModel != null) {
		fFormModel.setValueAt(new Integer(value), fKey, this, FORM_NOTIFICATION_ON_FOCUS_CHANGE);
	} else {
		sendEventULC("change", "value", new Anything(value));
	}
}
public void updateFromModel() {
	if (fFormModel != null) {
		boolean ok = false;
		int value = 0;
		Object o = fFormModel.getValueAt(fKey);
		if (o instanceof PendingCell)
			o = null;
		if (o != null) {
			if (o instanceof String) {
				try {
					Double d = new Double((String) o);
					value = d.intValue();
				} catch (NumberFormatException e) {
				}
				ok = true;
			} else
				if (o instanceof Number) {
					Number n = (Number) o;
					value = n.intValue();
					ok = true;
				}
		}
		setEnabled(ok);
		setValue(value * fMultiplier);
	}
}
}
