package com.ibm.ulc.ui;

import java.awt.image.BufferedImage;
/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.awt.print.*;
import javax.swing.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.UIApplet.UIApplet;
public class UIShell extends UIComponent implements ComponentListener, WindowListener, Runnable {
	protected Window fWindow = null;
	protected Container fInner = null;
	protected Frame fParent = null;
	protected UIShell fParentShell = null;
	protected Container fContentPane = null;
	protected boolean fModal = false;
	protected boolean fVeto = false;
	protected boolean fPack = true;
	protected boolean fDestroyOnClose = false;
	protected Dimension fMinimumSize = null;
	protected JButton fDefaultButton = null;

	private MouseAdapter fMouseAdapter = new MouseAdapter() {
		public void mousePressed(MouseEvent e) {
		}
	};
	private KeyAdapter fKeyAdapter = new KeyAdapter() {
		public void keyPressed(KeyEvent e) {
			e.consume();
		}
	};
public void add(Component c) {
	if (c instanceof Window) {
		c = new Button("cannot set Shell contents to another Shell window");
	}
	Assert.isNotNull(fInner);
	fInner.add(c);
}
public void componentHidden(ComponentEvent e) {
	if (fModal)
		sendEventULC("windowHidden"); // Must be sent because ULC ST expects it if window is modal
	else
		sendOptionalEventULC("windowHidden");
	if (fDestroyOnClose)
		destroy();
}
public void componentMoved(ComponentEvent e) {
	if (fWindow != null) {
		Anything a = new Anything();
		Point pos = fWindow.getLocation();
		a.put("x", pos.x);
		a.put("y", pos.y);
		sendOptionalEventULC("moved", a);
	}
}
public void componentResized(ComponentEvent e) {
	if (fWindow != null) {
		Anything a = new Anything();
		Dimension size = fWindow.getSize();
		a.put("w", size.width);
		a.put("h", size.height);
		sendOptionalEventULC("resized", a);
	}
}
public void componentShown(ComponentEvent e) {
	if (fModal) {
		sendEventULC("windowShown");
	} else {
		sendOptionalEventULC("windowShown");
	}
}
protected void destroy() {
	release();
}
public void free() {
	if (fInner != null) {
		fInner.removeAll();
		fInner.setLayout(null);
		fInner = null;
	}
	if (fWindow != null) {
		fWindow.removeWindowListener(this);
		fWindow.removeComponentListener(this);
		fWindow.removeAll();
		fWindow.dispose();
		fWindow = null;
	}
	if (fContentPane != null) {
		fContentPane.removeAll();
		fContentPane = null;
	}
	if (fParent != null) {
		fParent = null;
	}
	fParentShell = null;
	super.free();
}
public Component getBasicComponent() {
	return fWindow;
}
public Component getComponent() {
	return null;
}
/**
 * Internal method.
 * Look for the first available shell and return it.
 * If no shells are available create a hidden shell and return it.
 */
protected UIShell getDefaultShell(ORBConnection conn) {
	java.util.Enumeration c = conn.getRegistry().getRegistry().elements();
	while (c.hasMoreElements()) {
		try {
			UIShell s = (UIShell) c.nextElement();
			return s;
		} catch (ClassCastException e) {
		}
	}
	UIShell sh = new UIShell();
	sh.restoreState(conn, new Anything());
	return sh;
}
public Frame getFrame() {
	if (fWindow instanceof Frame)
		return (Frame) fWindow;
	if (fContentPane != null)
		try {
		Frame f = JOptionPane.getFrameForComponent(fContentPane);
		return f;
	} catch (Exception e) {
	}
	return null;
}
public Component getGlassPane() {
	Component glassPane = null;
	if (fWindow instanceof JFrame)
		glassPane = ((JFrame) fWindow).getGlassPane();
	else
		if (fWindow instanceof JWindow)
			glassPane = ((JWindow) fWindow).getGlassPane();
		else {
			Object applet = getUI().getApplet();
			if (applet != null)
				glassPane = ((JApplet) applet).getGlassPane();
		}
	return glassPane;
}
public Component getInnerComponent() {
	return fInner;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setVisible")) {
		boolean visible = args.asBoolean(true);
		if (visible) {
			if (fPack && fWindow != null)
				fWindow.pack();
			show();
		} else
			hide();
		return;
	}
	if (request.equals("move")) {
		setLocation(args.get("x", 0), args.get("y", 0));
		return;
	}
	if (request.equals("resize")) {
		setSize(args.get("w", 0), args.get("h", 0));
		return;
	}
	if (request.equals("setResizable")) {
		setResizable(args.asBoolean(true));
		return;
	}
	if (request.equals("setVeto")) {
		setVeto(args.asBoolean(false));
		return;
	}
	if (request.equals("setMenuBar")) {
		setMenuBar(conn, args);
		return;
	}
	if (request.equals("setIcon")) {
		UIIcon icon = null;
		if (!args.isNull())
			icon = (UIIcon) getManaged(UIIcon.class, conn, args);
		setIcon(icon);
		return;
	}
	if (request.equals("setDefaultButton")) {
		setDefaultButton(conn, args);
		return;
	}
	if (request.equals("printScreen")) {
		printScreen(args.get("printDialog", true), args.get("pageDialog", true));
		return;
	}
	super.handleRequest(conn, request, args);
}
void hide() {
	if ((fParentShell != null) && fModal && fWindow.isVisible())
		fParentShell.setGlassPaneVisibleForApplet(false);
	if (fWindow != null)
		fWindow.setVisible(false);
	else
		// just to be sure - normally setVisible(f) triggers componentHidden which calls destroy()
		if (fDestroyOnClose)
			destroy();
}
public boolean isShowing() {
	if (fWindow != null)
		return fWindow.isShowing();
	return false;
}
/**
 * Print this shell on a printer
 * 
 * @param	showPrintDialog		Show dialog to select printer and other print properties
 * @param	showPageDialog		Show dialog to select page properties
 * @since	R3.1
 */
public void printScreen(final boolean showPrintDialog, final boolean showPageDialog) {
	Image img= getFrame().createImage(getFrame().getWidth(), getFrame().getHeight());
	if (img != null && img instanceof BufferedImage) {
		img= (BufferedImage) img;
		getFrame().paintAll(img.getGraphics());
		final UiBufferedImagePrinter ip= new UiBufferedImagePrinter((BufferedImage) img);
		// This can take quite a while (e.g. dialogs)
		new Thread() {
			public void run() {
				ip.print(showPrintDialog, showPageDialog);
			}
		}.start();
	}
	else
		troubleErr("printScreen(boolean, boolean)", "Shell is not drawn yet");
}
/**
 * Reset the default button of the component to the original one.
 */
public void resetDefaultButton() {
	if (fDefaultButton != null) {
		// Swing does not allow to set the default button to null
		Component c = getBasicComponent();
		if (c != null) {
			if (c instanceof JFrame)
				 ((JFrame) c).getRootPane().setDefaultButton(fDefaultButton);
			else
				if (c instanceof JDialog)
					 ((JDialog) c).getRootPane().setDefaultButton(fDefaultButton);
		} else {
			UI ui = getUI();
			if (ui != null) {
				UIApplet applet = (UIApplet) ui.getApplet();
				if (applet != null)
					applet.getRootPane().setDefaultButton(fDefaultButton);
			}
		}
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fModal = args.get("modal", false);
	fVeto = args.get("closeBoxVeto", false);
	fDestroyOnClose = args.get("destroyOnClose", fDestroyOnClose);
	fParentShell = (UIShell) getManaged(UIShell.class, conn, args.get("parent"));
	if (fParentShell != null)
		fParent = fParentShell.getFrame();
	String label = args.get("label", "Shell");
	UI ui = getUI();
	boolean setContentPane = false;
	UIApplet uiApplet = null;
	if (ui.getApplet() != null)
		uiApplet = (UIApplet) ui.getApplet();
	if ((uiApplet != null) && (uiApplet.getUIShell() == null) && uiApplet.isInPlace()) { // FIXME: This should not be necessary
		fContentPane = uiApplet.getContentPane();
		setContentPane = true;
	} else {
		if (fModal && fParent == null)
			fParent = getDefaultShell(conn).getFrame();
		if (fModal) {
			UiJDialog dialog = new UiJDialog(fParent, label, true, this);
			dialog.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
			fContentPane = dialog.getContentPane();
			fWindow = dialog;
		} else {
			UiJFrame frame = new UiJFrame(label, this);
			frame.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
			fContentPane = frame.getContentPane();
			fWindow = frame;
		}
		//fWindow.setBackground(Color.lightGray); // FIXME:
	}
	fContentPane.setLayout(new BorderLayout());
	fInner = new UiJPanel(ui.getDoubleBuffering());
	fInner.setLayout(new UiBorderLayout(args.get("m", 5), args.get("a", "ee")));
	fContentPane.add("Center", fInner);
	super.restoreState(conn, args);
	if (args.isDefined("defaultButton")) {
		setDefaultButton(conn, args.get("defaultButton"));
	}
	setMenuBar(conn, args.get("menubar"));
	UIIcon icon = (UIIcon) getManaged(UIIcon.class, conn, args.get("icon"));
	if (icon != null)
		setIcon(icon);
	setResizable(args.get("resizable", true));
	Anything size = args.get("size");
	if (size == null) {
		size = new Anything();
	} else {
		if (fWindow != null)
			fWindow.pack();
		fPack = false;
		setSize(size.get("w", 0), size.get("h", 0));
	}
	if (fWindow != null) {
		int x = size.get("x", -1);
		int y = size.get("y", -1);
		if (x == -1 || y == -1) { // not set
			// position window via global window positioning strategy
			Point p = ui.getNextWindowPosition();
			if (x == -1)
				x = p.x;
			if (y == -1)
				y = p.y;
		}
		fWindow.setLocation(x, y);
		fWindow.addWindowListener(this);
		fWindow.addComponentListener(this);
	}
	if (args.get("visible", true)) {
		if (fPack)
			if (fWindow != null)
				fWindow.pack();
		show();
	}
	if (setContentPane && (ui.getApplet() != null)) {
		UIApplet applet = (UIApplet) ui.getApplet();
		applet.setContentPane(fContentPane);
		applet.setUIShell(this);
	}
	getManaged(UIComponent.class, conn, args.get("alert"));
}
public void run() {
	if (fModal) {
		// BUG in swing?
		// we don't get a componentShown event; so fake one....
		componentShown(null);
		if ((fParentShell != null) && !fWindow.isVisible())
			fParentShell.setGlassPaneVisibleForApplet(true);
	}
	if (fWindow != null) {
		fWindow.setVisible(true);
	}
}
/**
 * Set the background of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setBackgroundColor(int red, int green, int blue, boolean refresh) {
	Color color = null;
	Frame c = getFrame();
	if (c != null) {
		if (red == -1 || green == -1 || blue == -1) {
		} else {
			color = new Color(red, green, blue);
		}
		c.setBackground(color);
		if (refresh)
			c.repaint();
	}
}
/**
 * Set the cursor prescribed by the given id.
 * For valid values of id,
 * @see java.awt.Cursor.
 */
public void setCursor(int id) {
	Component c = getBasicComponent();
	Cursor cursor = Cursor.getPredefinedCursor(id);
	if (c != null)
		c.setCursor(cursor);
	c = getInnerComponent();
	if (c != null)
		c.setCursor(cursor);
	if ((fWindow != null) && (fWindow instanceof JFrame)) {
		JFrame frame = (JFrame) fWindow;
		JMenuBar mb= frame.getJMenuBar();
		if (mb != null) mb.setCursor(cursor);
	}
	if ((fWindow != null) && (fWindow instanceof JDialog)) {
		JDialog dialog = (JDialog) fWindow;
		JMenuBar mb= dialog.getJMenuBar();
		if (mb != null) mb.setCursor(cursor);

	}

	//	fContentPane.setCursor(Cursor.getPredefinedCursor(id));
}
/**
 * Set the default button for the receiver.
 * We remove and add/create a new  focus listener once again to all child components
 * since the existing focus listener has a reference to the old default button.
 */
public void setDefaultButton(ORBConnection conn, Anything args) {
	setDefaultButton((UIButton) getManaged(UIButton.class, conn, args));
}
/**
 * Set the default button for the receiver.
 * We remove and add/create a new  focus listener once again to all child components
 * since the existing focus listener has a reference to the old default button.
 */
public void setDefaultButton(UIButton uiButton) {
	fDefaultButton = (JButton) uiButton.getComponent();
	Component bComp = getBasicComponent();
	if (bComp instanceof JFrame) {
		JFrame frame = (JFrame) bComp;
		frame.getRootPane().setDefaultButton(fDefaultButton);
	} else
		if (bComp instanceof JDialog) {
			JDialog dialog = (JDialog) bComp;
			dialog.getRootPane().setDefaultButton(fDefaultButton);
		}
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	super.setEnabled(state);
	getBasicComponent().setEnabled(state);
	Component comps[] = fInner.getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setEnabled(state);
	}
}
/**
 * Set the foreground of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setForegroundColor(int red, int green, int blue, boolean refresh) {
	Color color = null;
	Frame c = getFrame();
	if (c != null) {
		if (red == -1 || green == -1 || blue == -1) {
		} else {
			color = new Color(red, green, blue);
		}
		c.setForeground(color);
		if (refresh)
			c.repaint();
	}
}
public void setGlassPaneVisible(boolean visible) {
	Component glassPane = getGlassPane();
	if (glassPane != null) {
		if (visible) {
			((JComponent) glassPane).setOpaque(false);
			glassPane.addMouseListener(fMouseAdapter);
			glassPane.addKeyListener(fKeyAdapter);
		} else {
			glassPane.removeMouseListener(fMouseAdapter);
			glassPane.removeKeyListener(fKeyAdapter);
		}
		glassPane.setVisible(visible);
		if (visible)
			glassPane.requestFocus();
	}
}
/*
 * When running as an applet with the parent being embedded in the browser window
 * modal windows do not disable events on their parent. 
 * (swing bugid:  4256028), ULC Bugid: 1FLN5HJ 
 * This is a workaround which uses a glassPane to block all events on its parent
 * if the parent of this modal window is the applet.
 * This method will be called from UIAlert and internally within modal UIShells.
 */
public void setGlassPaneVisibleForApplet(boolean visible) {
	UI ui= getUI();
	if (ui == null)
		return;
	Object o= ui.getApplet();
	if (o == null)
		return;
	UIApplet uiApplet = (UIApplet) o;
	if (fContentPane != uiApplet.getContentPane())
		return;
	Component glassPane = uiApplet.getGlassPane();
	if (glassPane != null) {
		if (visible) {
			((JComponent) glassPane).setOpaque(false);
			glassPane.addMouseListener(fMouseAdapter);
			glassPane.addKeyListener(fKeyAdapter);
		} else {
			glassPane.removeMouseListener(fMouseAdapter);
			glassPane.removeKeyListener(fKeyAdapter);
		}
		glassPane.setVisible(visible);
		if (visible)
			glassPane.requestFocus();
	}
}
void setIcon(UIIcon uiicon) {
	if (fWindow instanceof Frame) {
		Frame frame = (Frame) fWindow;
		if (uiicon != null) {
			Image image = uiicon.getImage(this, "setIcon");
			if (image != null) {
				frame.setIconImage(image);
			}
		} else {
			frame.setIconImage(null);
		}
	}
}
public void setLabel(String label) {
	if (fWindow instanceof Frame) {
		Frame f = (Frame) fWindow;
		f.setTitle(label);
		return;
	}
	if (fWindow instanceof JDialog) {
		JDialog d = (JDialog) fWindow;
		d.setTitle(label);
		return;
	}
}
void setLocation(int x, int y) {
	if (fWindow != null)
		fWindow.setLocation(x, y);
}
void setMenuBar(ORBConnection conn, Anything args) {
	if (args != null) {
		UIMenuBar uimb = (UIMenuBar) getManaged(UIMenuBar.class, conn, args);
		if (uimb != null) {
			uimb.setProxyParent(this);
			JMenuBar mb = (JMenuBar) uimb.getComponent();
			if (mb != null) {
				if (fWindow == null) {
					fContentPane.add("North", mb);
				}
				if (fWindow instanceof JFrame) {
					JFrame frame = (JFrame) fWindow;
					frame.setJMenuBar(mb);
					//Container contentPane= ((JFrame)fWindow).getContentPane();
					//contentPane.add("North", mb);
				}
				if (fWindow instanceof JDialog) {
					JDialog dialog = (JDialog) fWindow;
					dialog.setJMenuBar(mb);
					//Container contentPane= ((JFrame)fWindow).getContentPane();
					//contentPane.add("North", mb);
				}
			}
		}
	}
}
/**
 * Sets the resizable flag, which determines whether this shell is resizable.
 * By default, all shells are initially resizable. 
 */
void setResizable(boolean resizable) {
	if (fWindow instanceof Frame) {
		Frame f = (Frame) fWindow;
		f.setResizable(resizable);
	} else
		if (fWindow instanceof Dialog) {
			Dialog f = (Dialog) fWindow;
			f.setResizable(resizable);
		}
}
void setSize(int w, int h) {
	if (fWindow != null) {
		Dimension d = fWindow.getSize();
		if (w <= 0)
			w = d.width;
		if (h <= 0)
			h = d.height;
		if (w != d.width || h != d.height)
			fWindow.setSize(w, h);
	}
}
/**
 * Sets the veto flag, which determines whether windowClosing confimations
 * are requested. By default, all shells initially have veto=false.
 */
void setVeto(boolean veto) {
	fVeto = veto;
}
/**
 * Do nothing for the shell use the show & hide API.
 * 
 */
public void setVisible(boolean visible) {
}
void show() {
	if (false && fModal) {
		Thread t = new Thread(this);
		t.start();
	} else {
		run();
	}
}
public void updateCachedResource(String methodName, ICachedResource resource, Object userData) {
	if (methodName.equals("setIcon")) {
		UIIcon icon = (UIIcon) resource;
		setIcon(icon);
		return;
	}
	super.updateCachedResource(methodName, resource, userData);
}
public void windowActivated(WindowEvent e) {
	sendOptionalEventULC("windowActivated");
}
public void windowClosed(WindowEvent e) {
	// After R3.0 we do no longer create JFrames with
	// DISPOSE_ON_CLOSE hence this method will never be
	// called.
	// The ULC windowClosed event will be directly
	// produced on the ULC side
}
public void windowClosing(WindowEvent e) {
	sendEventULC("windowClosing");
	if (!fVeto)
		hide();
}
public void windowDeactivated(WindowEvent e) {
	sendOptionalEventULC("windowDeactivated");
}
public void windowDeiconified(WindowEvent e) {
	sendOptionalEventULC("windowDeiconified");
}
public void windowIconified(WindowEvent e) {
	sendOptionalEventULC("windowIconified");
}
public void windowOpened(WindowEvent e) {
	sendEventULC("windowOpened");
}
}
