package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1999 Object Technology International Inc.
 */
import java.awt.*;
import java.io.*;
import java.io.FileOutputStream;
import java.util.Vector;
import java.util.Enumeration;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.UlcHashtable;
import com.ibm.ulc.comm.ORBConnection;
public abstract class UIResourceCacheAbstract extends UIProxy {
	protected String fCacheNameSeparator = "_";
	protected UlcHashtable fInterestedParties = new UlcHashtable();
public void add(ICachedResource resource) {
	String key = getCacheKey(resource);
	if (key != null) {
		retrieveCacheFor(resource);
	}
	else {
		trouble("add cached resource", "no valid key defined for " + resource.toString());
	}
}
public void addUpdate(UIProxy proxy, CachedResourceUpdate update) {
	if (update == null) {
		return;
	}
	if (notWaitingForReply((ICachedResource) proxy)) {
		fInterestedParties.put(proxy, new Vector());
	}
	Vector parties = (Vector) fInterestedParties.get(proxy);
	if (!findExisting(parties, update)) {
		parties.addElement(update);
	}
	else {
		/*trouble("add update not done", "because update " + proxy.toString() + "already defined");*/
	}
}
protected abstract void basicRetrieveCacheFor(ICachedResource cachedResource, String cacheName);
protected abstract void createCacheFor(ICachedResource cachedResource);
protected String createCacheNameFrom(String cacheKey) {
	char c = fCacheNameSeparator.charAt(0);
	String key = cacheKey.replace('/', c);
	key = key.replace('\\', c);
	return key;
}
private boolean findExisting(Vector parties, CachedResourceUpdate update) {
	for (int i = 0; i < parties.size(); i++) {
		if (update.sameAs((CachedResourceUpdate) parties.elementAt(i))) {
			return true;
		}
	}
	return false;
}
protected String getCacheKey(ICachedResource resource) {
	if (resource.getCacheKey() != null) {
		return resource.getCacheKey();
	}
	else {
		String d = fCacheNameSeparator;
		resource.setCacheKey(
				resource.getHostName() + d + 
				resource.getApplicationName() + d + 
				resource.getTimestamp() + d + 
				resource.getFileSize() + d + 
				resource.getPathString());
		return resource.getCacheKey();
	}
}
protected boolean notWaitingForReply(ICachedResource proxy) {
	if (fInterestedParties.containsKey(proxy)) {
		return false;
	}
	else {
		return true;
	}
}
protected void retrieveCacheFor(ICachedResource cachedResource) {
	String key = getCacheKey(cachedResource);
	String cacheName = createCacheNameFrom(key);
	if (testCacheContainer(cacheName)) {
		basicRetrieveCacheFor(cachedResource,cacheName);
	}
	else {
		if (notWaitingForReply(cachedResource)) {
			cachedResource.getResourceFromUlc();
		}
	}
}
public void setCacheNameSeparator(String separator) {
	fCacheNameSeparator = separator;
}
public void setResource(ICachedResource resource) {
	createCacheFor(resource);
	Enumeration parties = updatesFor((UIProxy) resource).elements();
	while (parties.hasMoreElements()) {
		CachedResourceUpdate update = (CachedResourceUpdate) parties.nextElement();
		update.updateWith(resource);
	}
	fInterestedParties.remove((UIProxy) resource);
}
protected abstract boolean testCacheContainer();
protected abstract boolean testCacheContainer(String fullPathName);
private Vector updatesFor(UIProxy proxy) {
	Vector vector = new Vector();
	if (fInterestedParties.containsKey(proxy)) {
		vector = (Vector) fInterestedParties.get(proxy);
	}
	return vector;
}
}
