package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.*;

public class UIProgressBar extends UIComponent {
	protected JProgressBar fProgressBar = new JProgressBar();;
	public void free() {
		fProgressBar= null;
		super.free();
	}
	public Component getComponent() {
	    return fProgressBar;
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setValue")) {
		setValue(args.asInt(0));
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	int minValue = args.get("minValue", 0);
	int maxValue = args.get("maxValue", 100);
	if (maxValue < minValue)
		maxValue = minValue + 100; // FIXME
	fProgressBar.setMinimum(minValue);
	fProgressBar.setMaximum(maxValue);
	fProgressBar.setValue(args.get("value", minValue));
}
/**
 * Set the foreground of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setForegroundColor(int red, int green, int blue, boolean refresh) {
	Color color = null;
	JComponent c = (JComponent) getBasicComponent();
	if (c != null) {
		if (areValidRGBColorValues(red, green, blue)) {
			color = new Color(red, green, blue);
		}
		else {
			color = UIManager.getColor("ProgressBar.foreground");
		}
		c.setForeground(color);
		if (refresh)
			refreshComponentColor(c);
	}
}
	public void setValue(int v) {
		if (v < fProgressBar.getMinimum())
			v= fProgressBar.getMinimum();
		else if (v > fProgressBar.getMaximum())
			v= fProgressBar.getMaximum();
		if (fProgressBar.getValue() != v) {
			fProgressBar.setValue(v);
		}
	}
}
