package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.base.*;
public class UIPage extends UIComponent {
	protected UIIcon fIcon = null;
	protected String fLabel = null;
	protected UiJLazyPage fPage = null;
	protected boolean fLoaded = false;
	protected boolean fVisible = true;
	protected boolean fEnabled = true;
	protected int fPageIndex = -1;
	protected JTabbedPane fNotebook = null;
public void free() {
	fLabel = null;
	if (fPage != null) {
		fPage.free();
		fPage = null;
	}
	super.free();
}
public Component getComponent() {
	return fPage;
}
public UIIcon getIcon() {
	return fIcon;
}
public String getTitle() {
	return fLabel;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setContents")) {
		setContents(conn, args);
		forceParentRepaint();
		return;
	}
	if (request.equals("setIcon")) {
		if (!args.isNull())
			setIcon((UIIcon) getManaged(UIIcon.class, conn, args));
		forceParentRepaint();
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Return enabled/disabled.
 */
public boolean isEnabled() {
	return fEnabled;
}
public boolean isVisible() {
	return fVisible;
}
public void load() {
	if (!fLoaded) {
		sendULC("getContents");
		fLoaded = true;
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fLabel = args.get("label", "Page");
	UI ui = (UI) conn.find(Common.FACTORY_ID);
	setIcon((UIIcon) getManaged(UIIcon.class, conn, args.get("icon")));
	Component content = null;
	UIComponent ic = (UIComponent) getManaged(UIComponent.class, conn, args.get("content"));
	if (ic != null) {
		internalAddToChildren(ic);
		content = ic.getComponent();
	}
	if (content == null) {
		content = new UiJLabel(ui.getResourceString("LblWaitingForTab") + " \"" + fLabel + "\"");
	} else
		fLoaded = true;
	fPage = new UiJLazyPage(this);
	fPage.setLayout(new UiBorderLayout(args.get("m", 10), args.get("a", "ee")));
	fPage.add(content);
	super.restoreState(conn, args);
}
/**
 * Set the background of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setBackgroundColor(int red, int green, int blue, boolean refresh) {
	setBackgroundColorWithOpaque(red, green, blue, refresh);
}
void setContents(ORBConnection conn, Anything args) {
	UIComponent uic = null;
	if ((args != null) && (!args.isNull()))
		uic = (UIComponent) getManaged(UIComponent.class, conn, args);
	if (uic != null) {
		internalAddToChildren(uic);
		Component c = (Component) uic.getComponent();
		if (c != null) {
			fPage.removeAll();
			fPage.add(c, 0);
			if (!fVisible)
				setVisible(fVisible);
			if (!fEnabled)
				setEnabled(fEnabled);
			Component p = fPage.getParent();
			if (p != null)
				p = p.getParent();
			if (p != null) {
				p.invalidate();
				p.validate();
				p.repaint();
			}
		}
	} else {
		fPage.removeAll();
		fPage.invalidate();
		fPage.validate();
		fPage.repaint();
	}
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	fEnabled = state;
	super.setEnabled(state);
}
public void setFont(UIFont font) {
	Component c = this.getBasicComponent();
	if (c != null) {
		if (font == null)
			c.setFont(null);
		else
			c.setFont(font.getFont());
		c.invalidate();
		c.repaint();
	}
	forceParentRepaint();
}
void setIcon(UIIcon uiIcon) {
	fIcon = uiIcon;
	if (fPageIndex >= 0) {
		Icon icon = null;
		Image image = fIcon.getImage(this, "setIcon");
		if (image != null)
			icon = new ImageIcon(image);
		fNotebook.setIconAt(fPageIndex, icon);
	}
}
public void setLabel(String label) {
	fLabel = label;
	if (fPageIndex >= 0) {
		fNotebook.setTitleAt(fPageIndex, fLabel);
	}
	forceParentRepaint();
}
void setNotebook(JTabbedPane notebook) {
	fNotebook = notebook;
}
void setPageIndex(int pageIndex) {
	fPageIndex = pageIndex;
}
/**
 * Set the component to be visible or hidden.
 * 
 */
public void setVisible(boolean visible) {
	super.setVisible(visible);
	fVisible = visible;
}
public void updateCachedResource(String methodName, ICachedResource resource, Object userData) {
	if (methodName.equals("setIcon")) {
		setIcon((UIIcon) resource);
		forceParentRepaint();
		return;
	}
	super.updateCachedResource(methodName, resource, userData);
}
}
