package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
public class UINotebook extends UIComponent {
	protected UiJTabbedPane fTabbedPane = null;
	protected UiNotebookModel fModel = null;
	protected boolean fEnabled = true;
	protected boolean fVisible = true;
public void add(UIComponent cc) {
	UIPage page = (UIPage) cc;
	if (page != null) {
		Component c = (Component) page.getComponent();
		UIIcon uiIcon = page.getIcon();
		Icon icon = null;
		if (uiIcon != null) {
			Image image = uiIcon.getImage(page, "setIcon");
			if (image != null) {
				icon = new ImageIcon(image);
			}
		}
		fTabbedPane.addTab(page.getTitle(), icon, c);
		page.setPageIndex(fTabbedPane.getTabCount()-1);
		page.setNotebook(fTabbedPane);
		if (!fVisible)
			page.setVisible(fVisible);
		if (!fEnabled)
			page.setEnabled(fEnabled);
		forceParentRepaint();
	}
	if (!fEnabled)
		setEnabled(fEnabled);
}
	public void free() {
		if (fModel != null) {
			fModel.free();
			fModel= null;
		}	
		if (fTabbedPane != null) {
			fTabbedPane.setRequestFocusEnabled(false);
			fTabbedPane.setVisible(false);
			for (int i= 0; i < fTabbedPane.getTabCount(); i++) {
				Component c= fTabbedPane.getComponentAt(i);
				((Container) c).removeAll();
			}	
//			fTabbedPane.removeAll(); //this is causing index out of bound exceptions
//			fTabbedPane.setModel(null);
			fTabbedPane= null;
		}	
		super.free();
	}
	public Component getComponent() {
	    return fTabbedPane;
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("showTab")) {
		setSelection(args.asInt(-1));
		return;
	}
	if (request.equals("setVeto")) {
		if (fModel != null)
			fModel.setVeto(args.asBoolean(false));
		return;
	}
	if (request.equals("setTabPlacement")) {
		fTabbedPane.setTabPlacement(args.asInt(BOX_TOP));
		fTabbedPane.validate();
		return;
	}
	super.handleRequest(conn, request, args);
}
	public void remove(UIComponent cc) {
		UIPage page= (UIPage) cc;
		if (page != null) {
			Component c= (Component) page.getComponent();
			fTabbedPane.remove(c);
			forceParentRepaint();			
		}
	}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fModel = new UiNotebookModel(this, args.get("veto", false));
	int tabPosition = args.get("tabPlacement", BOX_TOP);
	fTabbedPane = new UiJTabbedPane(tabPosition);
	if (args.isDefined("w") || args.isDefined("h"))
		fTabbedPane.setPreferredSize(new Dimension(args.get("w", 200), args.get("h", 150)));
	fTabbedPane.setModel(fModel);
	super.restoreState(conn, args);
	setSelection(args.get("tab", -1));
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	super.setEnabled(state);
	fEnabled= state;
}
	void setSelection(int ix) {
		if (ix >= 0)
			fModel.setSelectedIndex2(ix);
	}
/**
 * Set the component to be visible or hidden.
 * 
 */
public void setVisible(boolean visible) {
	super.setVisible(visible);
	fVisible = visible;
}
}
