package com.ibm.ulc.ui;

import java.util.*;
import java.awt.Component;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.Assert;
public class UINotEnabler extends UIEnabler {
	protected IEnableListener fEnabler = null;
/**
 * This method was created in VisualAge.
 */
public UINotEnabler() {
}
public void free() {
	fEnabler = null;
	super.free();
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	if (args.isDefined("enabler"))
		setEnabler(conn, args.get("enabler"));
}
/**
 * Set the enabler object for the receiver, based on the
 * given arguments.
 */
public void setEnabler(ORBConnection conn, Anything args) {
	if (fEnabler != null) {
		fEnabler.removeEnableListener(this);
		fEnabler = null;
	}
	IEnableListener el = (IEnableListener) getManaged(IEnableListener.class, conn, args);
	if (el != null) {
		fEnabler = el;
		el.addEnableListener(this);
	}
}
/**
 * Return false if the component for which I am an enabler should be enabled.
 *
 */
public boolean shouldEnableListener() {
	return !fEnabler.shouldEnableListener();
}
}
