package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.util.Vector;
import javax.swing.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.comm.ORBConnection;
public class UIMenuBar extends UIComponent {
	protected UiJMenuBar fMenuBar = null;
	protected Vector fMenus = new Vector();
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void add(UIComponent component) {
	fMenus.addElement(component);
	UIMenu menu = (UIMenu) component;
	menu.insertIn(this, (fMenus.size() - 1));
	if (menu.fVisible)
		super.add(component);
}
public void add(Component c) {
	if (c != null) {
		fMenuBar.add(c);
		if (fMenuBar.getComponents().length == 1)
			forceFrameRepaint();
		else
			forceParentRepaint();
	}
}
/*
 * make sure to free all the receiver's menus as well
 */
public void free() {
	if (fMenuBar != null) {
		for (int i = 0; i < fMenus.size(); i++) {
			((UIComponent) fMenus.elementAt(i)).free();
		}
		fMenuBar.removeAll();
		fMenuBar = null;
	}
	super.free();
}
	public Component getComponent() {
	    return fMenuBar;
	}
/*
 * The receiver should set the visiblity of the specified menuComponent to aBoolean.
 *
 */
void rebuildMenuBar() {
	fMenuBar.removeAll();
	for (int i = 0; i < fMenus.size(); i++) {
		UIMenu menu = (UIMenu) fMenus.elementAt(i);
		if (menu.fVisible)
			add(menu.getComponent());
	}
}
/**
 * Remove the  <code>UIComponent</code> from the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void remove(UIComponent component) {
	fMenus.removeElement(component);
	((IMenuComponent) component).configureAsMenuBarItem(false);
	super.remove(component);
}
public void remove(Component c) {
	if (c != null) {
		fMenuBar.remove(c);
		forceParentRepaint();
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fMenuBar = new UiJMenuBar();
	super.restoreState(conn, args);
}
/*
 * The receiver should set the visiblity of the specified menuComponent to aBoolean.
 *
 */
public void setVisible(IMenuComponent menuComponent, boolean visible) {
	if (!visible) {
		remove(((UIComponent) menuComponent).getComponent());
	}
	else {
		rebuildMenuBar();
	}
}
}
